use strict;
use warnings;
use Test::More tests => 68;
use Digest::BLAKE qw(blake_384 blake_384_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::BLAKE->new(384)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            blake_384_hex($data), $digest,
            "blake_384_hex: $len bits of $msg"
        );
        ok(
            blake_384($data) eq pack('H*', $digest),
            "blake_384: $len bits of $msg"
        );
    }

    my $md = Digest::BLAKE->new(384)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $msg");
}
continue { $len++ }

__DATA__
00|E0820C066F522138D5CB3A5773DEA16DB434AFA95E1C48E060DE466928BB7044391B3EE77E2BBFF6C0CF1E07A8295100
00|E6F0D009F2D1A12B1ACC35C5C7C5F5926C6E8DD14C4C35C10C0DE41143241FB64AD65A5CA7DEC53E64C5210FC1DE77BF
C0|4EA4C23F093FDE8EE87AAA715A90E24D130EA186FDC452A0A391871DE05B9B4E31EEAEE47D0AE8D5A16A4E9A9D56E3F2
C0|EBF87E1A2014118DC18BFCD3322582623B6C9F42C16C1C84702C8BB71FA538E5E79435672442CB13BB130D7D86EDF807
80|11A35492F5A5A119935AF838AF9C03CB08DEA556BBAF837E16D6CD46841F82D64BADE103F02C7092EBE2E72A7211AE0C
48|FD4C387AD1AE2F0DF0C1DFDF20D48136A4E6A105B89A9CECC82B46DB0D14E595655E54A7A1C253E4418E8BF2C80445D4
50|D28458D8DE6E044007EF1C804C116D34C34AC412AD5A4207EA467502922DFA11840E9837C1720B3ED16B15ACB42C27D0
98|FF6FB9A3160CD83B1D824299E8D4B7D87B8187DBD9505936CFB481EC1CBEB6BEAD73598B353E9BCED893192A06EBF946
CC|ECF0858046F314D830A9C1BCE93E5E12B36B90181580DF17772034683059F74CE04699B3DCC576465DD13A965A00DE0B
9800|FD397D5BE06B95228FE766581FF59B8795934061D42997315B5E39473501BDCFC7B4E74D36D4E1290CFA97BD7AEF4D3A
9D40|9092E6AD33E2AA83AAD067436DEADA129F7803354EA7E84CCC1577A8A29DFB46DBCF5334ACE4963A0B9F1DFC08BE042F
AA80|5E74403DEE9B5E0C7A60BA7071D6C9A4EE6F5A59C8720DD64CEEC9631456FC66E3CF086F140A40F7DE767EA6E511F3F3
9830|DA983D2C19B5B8253FCA2CBB51689BE40C192AD686CF3A40696872AD66E9923A2CFDB48B539A3794F10B6F92E3289371
5030|DA234857E6874E196DE623CDEA250E27C3781391E95F73AA00FA9852679FC3D06D7D070E2D8B6B4223D2A422ABE0C16C
4D24|801E671ACDA0DF98316336003A1C6977F217F85458E7926EA41CBF81AE9EE1B81DB2077FA13FF7CE1FE9A44F13A93C9C
CBDE|4E7248CF16366493C5F3C744052EABE725935DB5DD7319FA3C32956101BDD0151CF76545C466F59295B47844EF4AEDC9
41FB|CB692359D469ED8DA6BBB87433EA2337EFD00F2AD245EA9F88BE9CC6D6DC952E2756A229DE9CB5DBDFB84726DAC6590D
4FF400|2BB7D05332453DB260F08CDB09DCA102726B5621F8F62AE2449F141F5B92383E4F5686751E1CDD53537713DDD081C11A
FD0440|5EB3184BE41BCE2379DFB351E928AD1206DFCE744FE2310ACC6EADECA3FB4CE3B7515D9D9BA642AF2FC3E39EAB8BD7BC
424D00|E5BA4CE6CB4CF9A8633E93069E3394CF63E4295DAB60364841DEFC826F72A71D30A469893A1B0C36767613E39A280AD5
3FDEE0|6B29158B991F224FE746AA0EEAC6238A28435E8D80B63B51616D50154790F799D256C23AA0F2374B8BB021397C564830
335768|5E54029E31DC058D250014DE01771DB4496E10B358B5BBA05DA479229DFCD6F29057F41BAEFFB3A5D846323A079E472E
051E7C|9B6F68597A079C236F112EEAFF45B83735C3FE7DDAAF638F35ACBEB6E5BD6CBCB4345ED6753593A436365D472CB79F3C
717F8C|D9E4CDA36B93C310B648E0916485C48D9CCE0AD7756A24FFC3E3EE70A3D9C7EB9F560B6711FC6A32E5433228967B393A
1F877C|7E4CFEF6798514CAC20EEAE6BBD03B9EB2330999B17C2244C89D8FB1D5C062EC0F75CA675BC3D8EB3A99726964EAAD75
EB35CF80|FCC824CEB95B1D625241E9F4F6CBD2261C5A522729ECE8B3AD99EA818FD1E211647F691217279E2213FAF14D6E30A383
B406C480|4809D7AA804296B5BE7F93D96AA8FD76AFC919960F029AE90E60BDD4D8186F7936B997F6E809E65D4B0A187B44B5839E
CEE88040|F71E3366E9111817834098DAAECA6FC0ED384CC86A4B33735C4E98443EEF95541D9C7B14F5008728DC5D4E9EC508BDE5
C584DB70|C68BEC0C83BE33AAB2F3272B6B88B63E9685B79DEE1F5BE012B53BB91A4406FC7C1F0768F7B13C09A596ACFD9B4B9B27
53587BC8|146B51E2D17ABC2D4C2453BEFC28008BF8855F59C1D7BBDBF4ADA4FAB4E737BA4E4308A9DC5ECD68F5CFE90EF820DA7C
69A305B0|1D958F0BEF7120FF5D043D3D2ED4980B1CDF872C1646E77A8414E690AA4909441D4CAFD7CA517868A783F1E569D2E5F7
C9375ECE|11CCBF6AFF7ECA377220BB14AD4D40D1AFBABB2FE95017D3B5A1B44CDBF2A9DCAAF3633E886114B6BAFC90D3DB88C69E
C1ECFDFC|DB2E15ACC5F5F7BAB7294F24C6E14044BBC790942C8225054B338EB648F267449FC625737F40631ED8DDFA225916776C
8D73E8A280|8FDE430FFB626DB473E3DD1A2712828A34ABFB346DA26590A8C3DCBAFBDC21085E5B580212C82E3DECCE133AFBE331BE
06F2522080|4CFEF0BF50984A373444F08C976647822719CBFF5EAC78D6F168F311F003F74E874D864F84C8B3FB8BE32BAC491826BC
3EF6C36F20|1998A2EC43AF8F4C82D02817BA2F15766B30F75621EC967CD5F33F5927C4483155A14ED59470D5997287329ED326A311
0127A1D340|2522DBD379E2808624A25AB993B49FB1125BB9DF16F01B27CF7B2A261D1AB304D0AB94840B6FF1AF729B48ADE0BF8949
6A6AB6C210|3BA75D4C21B0BA6B095A97FB9BC56FDC51AACAB22B7ADF979455C4D6388B40500AF66258B9B40D7AE5D45D158C09F09F
AF3175E160|19B41310A2B3DC2821E72FFC54F08E4C2680EB3C433488154DAFB6C8B924CA0B0B24425D690A095D6BC940405EDDFA4B
B66609ED86|4F12E3F91C9791C76A2F1FA2DF69C9FA649D57EDACB8012AADEAE31EE5F26C3FD552595723482D8C2D8D7D5A64FB7A27
21F134AC57|D9D97E3BF8E9766E57B36EE01D7D243F3D25B185305CCE89F2471D55D8D74D1AF5C7D54B0BCB691588E0D16BE681116E
3DC2AADFFC80|06EF75CB214AFF0D28081C22BCD0A9671AD42D50A939D2DCD16D7D8B21E6C7919C6BE1DFE8ABFB0FC80B8340EF007A0F
9202736D2240|D18212FF8E04286270FF07146ED35B1AD2ABA752A5BFCB23C39153A65DEADE2208242E31AA1BD1359630A4BCD7761159
F219BD629820|A518052BCA7F641A96727363A6C3535B0EB7BAE35DD06440CDDBAFB0027A1BB470C69BC287129493B4E443FE8ABCFD89
F3511EE2C4B0|A1574D58F3DD8AE323743ECD13F5B9087C3B15D03C436774521F39C868C94A51D62B1F7D03A2327A03641669CD85B398
3ECAB6BF7720|854FCD7D22B56EADDBF2087D9F624CB63F640AE32EAE7BC09FF1B76B90E7D1D8F5EFE4E142409CF48B0DA54C25B6CFD8
CD62F688F498|76614B6F99BEE399C3F25335CA92232A9214934FA4A544CF389549C003334749B89A45C54343AB356A6F8D4F46CCAAC8
C2CBAA33A9F8|2C33DA9527CD266CCF68F2EA6268F0821B1EF64547915D9D48CC437F9258EF0DAAAE0BD98C450B04D44E72C677C4C0B0
C6F50BB74E29|838FB50EC46914529BCFBE76F75C8672BBC6ACE5D8320BE37028E56D79FC35B1EBD1203A29FDC96F51BA1E7910EC6244
79F1B4CCC62A00|4811C5ECD88E0DD3498724A763A9A0572BEB28939FAB1949A99A9AD1C2EFD6E87E78A0875A259835B7DFC3BA6D18D739
