#include <qwidget.h>

suicidal virtual class QWidget : virtual QObject, QPaintDevice {
    enum BackgroundMode { FixedColor, FixedPixmap, NoBackground,
                          PaletteForeground, PaletteButton, PaletteLight,
                          PaletteMidlight, PaletteDark, PaletteMid,
                          PaletteText, PaletteBrightText, PaletteBase,
                          PaletteBackground, PaletteShadow, PaletteHighlight,
                          PaletteHighlightedText };
    enum PropagationMode { NoChildren, AllChildren,
                           SameFont, SamePalette };
    enum FocusPolicy {
        NoFocus,
        TabFocus,
        ClickFocus,
        StrongFocus,
        WheelFocus
    };

    QWidget(QWidget * = 0, const char * = 0, Qt::WFlags = 0);
    virtual ~QWidget();
    virtual void adjustSize();
    bool acceptDrops() const;
    bool autoMask() const;
    const QColor &backgroundColor() const;
    QWidget::BackgroundMode backgroundMode() const;
    QSize baseSize() const;
    const char *caption() const;
    QRect childrenRect() const;
    QRegion childrenRegion() const;
    void clearFocus();
    void clearMask();
    bool close() slot;
    virtual bool close(bool);
    const QColorGroup &colorGroup() const;
    const QCursor &cursor() const;
    virtual bool customWhatsThis() const;
    void drawText(const QPoint &, const char *);
    void drawText(int, int, const char *);
    void erase();
    void erase(const QRect &);
    void erase(const QRegion &);
    void erase(int, int, int, int);
    static QWidget *find(WId);
    QWidget::FocusPolicy focusPolicy() const;
    QWidget *focusProxy() const;
    QWidget *focusWidget() const;
    const QFont &font() const;
    QFontInfo fontInfo() const;
    QFontMetrics fontMetrics() const;
    QWidget::PropagationMode fontPropagation() const;
    const QColor &foregroundColor() const;
    const QRect &frameGeometry() const;
    QSize frameSize() const;
    const QRect &geometry() const;
    void grabKeyboard();
    void grabMouse();
    void grabMouse(const QCursor &);
    bool hasFocus() const;
    bool hasMouseTracking() const;
    int height() const;
    virtual int heightForWidth(int) const;
    virtual void hide() slot;
    const QPixmap *icon() const;
    const char *iconText() const;
    bool isActiveWindow() const;
    bool isDesktop() const;
    bool isEnabled() const;
    bool isEnabledTo(QWidget *) const;
    bool isEnabledToTLW() const;
    bool isFocusEnabled() const;
    bool isMinimized() const;
    bool isModal() const;
    bool isPopup() const;
    bool isTopLevel() const;
    bool isUpdatesEnabled() const;
    bool isVisible() const;
    bool isVisibleTo(QWidget *) const;
    bool isVisibleToTLW() const;
    static QWidget *keyboardGrabber();
    QLayout *layout() const;
    void lower() slot;
    QPoint mapFromGlobal(const QPoint &) const;
    QPoint mapFromParent(const QPoint &) const;
    QPoint mapToGlobal(const QPoint &) const;
    QPoint mapToParent(const QPoint &) const;
    int maximumHeight() const;
    QSize maximumSize() const;
    int maximumWidth() const;
    int minimumHeight() const;
    QSize minimumSize() const;
    virtual QSize minimumSizeHint() const;
    int minimumWidth() const;
    static QWidget *mouseGrabber();
    void move(const QPoint &) slot;
    virtual void move(int, int) slot;
    const QPalette &palette() const;
    QWidget::PropagationMode palettePropagation() const;
    QWidget *parentWidget() const;
    virtual void polish() slot;
    QPoint pos() const;
    void raise() slot;
    QRect rect() const;
    void releaseKeyboard();
    void releaseMouse();
    void repaint() slot;
    void repaint(bool) slot;
    void repaint(const QRect &, bool = TRUE) slot;
    void repaint(const QRegion &, bool = TRUE) slot;
    void repaint(int, int, int, int, bool = TRUE) slot;
    virtual void reparent(QWidget *, Qt::WFlags, const QPoint &, bool = FALSE);
    void resize(const QSize &) slot;
    virtual void resize(int, int) slot;
    void scroll(int, int);
    void scroll(int, int, const QRect &);
    void setAcceptDrops(bool);
    virtual void setActiveWindow();
    virtual void setAutoMask(bool);
    virtual void setBackgroundColor(const QColor &);
    void setBackgroundMode(QWidget::BackgroundMode);
    virtual void setBackgroundPixmap(const QPixmap &);
    void setBaseSize(const QSize &);
    void setBaseSize(int, int);
    virtual void setCaption(const QString &) slot;
    virtual void setCursor(const QCursor &);
    virtual void setEnabled(bool) slot;
    void setFixedHeight(int);
    void setFixedSize(const QSize &);
    void setFixedSize(int, int);
    void setFixedWidth(int);
    virtual void setFocus() slot;
    virtual void setFocusPolicy(QWidget::FocusPolicy);
    virtual void setFocusProxy(QWidget *);
    virtual void setFont(const QFont &);
    void setFont(const QFont &, bool);
    void setFontPropagation(QWidget::PropagationMode);
    void setGeometry(const QRect &) slot;
    virtual void setGeometry(int, int, int, int) slot;
    virtual void setIcon(const QPixmap &) slot;
    virtual void setIconText(const QString &) slot;
    virtual void setMask(const QBitmap &);
    virtual void setMask(const QRegion &);
    void setMaximumHeight(int);
    void setMaximumSize(const QSize &);
    virtual void setMaximumSize(int, int);
    void setMaximumWidth(int);
    void setMinimumHeight(int);
    void setMinimumSize(const QSize &);
    virtual void setMinimumSize(int, int);
    void setMinimumWidth(int);
    virtual void setMouseTracking(bool) slot;
    virtual void setName(const char *);
    virtual void setPalette(const QPalette &);
    void setPalette(const QPalette &, bool);
    void setPalettePropagation(QWidget::PropagationMode);
    void setSizeIncrement(const QSize &);
    virtual void setSizeIncrement(int, int);
    void setStyle(QStyle *);
    static void setTabOrder(QWidget *, QWidget *);
    virtual void setUpdatesEnabled(bool) slot;
    virtual void show() slot;
    virtual void showMaximized() slot;
    virtual void showMinimized() slot;
    virtual void showNormal() slot;
    QSize size() const;
    virtual QSize sizeHint() const;
    QSize sizeIncrement() const;
    virtual QSizePolicy sizePolicy() const;
    QStyle &style() const;
    bool testWFlags(Qt::WFlags) const;
    bool testWState(uint) const;
    QWidget *topLevelWidget() const;
    virtual void unsetCursor();
    void update();
    void update(const QRect &) slot;
    void update(int, int, int, int) slot;
    void updateGeometry();
    QRect visibleRect() const;
    WId winId() const;
    int width() const;
    int x() const;
    int y() const;
protected:
    virtual void backgroundColorChange(const QColor &);
    virtual void backgroundPixmapChange(const QPixmap &);
    void clearWFlags(Qt::WFlags);
    virtual void closeEvent(QCloseEvent *);
    virtual void create(WId = 0, bool = TRUE, bool = TRUE);
    virtual void customEvent(QCustomEvent *);
    virtual void destroy(bool = TRUE, bool = TRUE);
    virtual void dragEnterEvent(QDragEnterEvent *);
    virtual void dragLeaveEvent(QDragLeaveEvent *);
    virtual void dragMoveEvent(QDragMoveEvent *);
    virtual void dropEvent(QDropEvent *);
    virtual void enabledChange(bool);
    virtual void enterEvent(QEvent *);
    virtual bool event(QEvent *);
    QFocusData *focusData();
    virtual void focusInEvent(QFocusEvent *);
    virtual bool focusNextPrevChild(bool);
    virtual void focusOutEvent(QFocusEvent *);
    virtual void fontChange(const QFont &);
    Qt::WFlags getWFlags() const;
    uint getWState() const;
    virtual void hideEvent(QHideEvent *);
    virtual void keyPressEvent(QKeyEvent *);
    virtual void keyReleaseEvent(QKeyEvent *);
    virtual void leaveEvent(QEvent *);
    int metric(int) const;
    virtual void mouseDoubleClickEvent(QMouseEvent *);
    virtual void mousePressEvent(QMouseEvent *);
    virtual void mouseReleaseEvent(QMouseEvent *);
    virtual void mouseMoveEvent(QMouseEvent *);
    virtual void moveEvent(QMoveEvent *);
    virtual void paintEvent(QPaintEvent *);
    virtual void paletteChange(const QPalette &);
    virtual void resizeEvent(QResizeEvent *);
    virtual void setCRect(const QRect &);
    virtual void setFRect(const QRect &);
    virtual void setKeyCompression(bool);
    virtual void setMicroFocusHint(int, int, int, int, bool = TRUE);
    virtual void setWFlags(Qt::WFlags);
    virtual void setWState(uint);
    virtual void showEvent(QShowEvent *);
    virtual void styleChange(QStyle &);
    virtual void updateMask();
    virtual void wheelEvent(QWheelEvent *);
} Qt::Widget;
