use Modern::Perl;
package Renard::Curie::Setup;
# ABSTRACT: Packages that can be imported into every module
$Renard::Curie::Setup::VERSION = '0.001_01'; # TRIAL

$Renard::Curie::Setup::VERSION = '0.00101';use autodie;

use Import::Into;

use Function::Parameters ();
use Return::Type ();
use MooX::TypeTiny ();

use Try::Tiny ();
use Renard::Curie::Error ();

use Path::Tiny ();


sub import {
	my ($class) = @_;

	my $target = caller;

	Modern::Perl->import::into( $target );
	autodie->import::into( $target );

	my %type_tiny_fp_check = ( reify_type => sub { Type::Utils::dwim_type($_[0]) }, );
	Function::Parameters->import::into( $target,
		{
			fun         => { defaults => 'function_strict'   , %type_tiny_fp_check },
			classmethod => { defaults => 'classmethod_strict', %type_tiny_fp_check },
			method      => { defaults => 'method_strict'     , %type_tiny_fp_check },
		}
	);
	Return::Type->import::into( $target );

	Try::Tiny->import::into( $target );
	Renard::Curie::Error->import::into( $target );

	Path::Tiny->import::into( $target );

	return;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Renard::Curie::Setup - Packages that can be imported into every module

=head1 VERSION

version 0.001_01

=head1 AUTHOR

Project Renard

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Project Renard.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
