package Chart::Plotly::Trace::Surface;
use Moose;

our $VERSION = '0.002';    # VERSION

=encoding utf-8

=head1 NAME 

Chart::Plotly::Trace::Surface

=head1 SYNOPSIS

	use HTML::Show;
	use Chart::Plotly;
	use Chart::Plotly::Trace::Surface;
	my $surface = Chart::Plotly::Trace::Surface->new(x => [1 .. 5], y => [1 .. 5]);
	
	HTML::Show::show(Chart::Plotly::render_full_html(data => [$surface]));


=head1 DESCRIPTION

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#surface>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=cut

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=cut

sub TO_JSON {
    my $self = shift;
    my %hash = %$self;
    $hash{type} = $self->type();
    return \%hash;
}

=head2 type

Trace type.

=cut

sub type {
    my @components = split( /::/, __PACKAGE__ );
    return lc( $components[-1] );
}

=head1 ATTRIBUTES

=over

=cut

=item * x

Sets the x coordinates.

=cut

has x => ( is            => 'rw',
           documentation => "Sets the x coordinates.", );

=item * cmin

Sets the lower bound of color domain.

=cut

has cmin => ( is            => 'rw',
              documentation => "Sets the lower bound of color domain.", );

=item * contours


=cut

has contours => ( is => 'rw', );

=item * cauto

Determines the whether or not the color domain is computed with respect to the input data.

=cut

has cauto => (
          is            => 'rw',
          documentation => "Determines the whether or not the color domain is computed with respect to the input data.",
);

=item * lightposition


=cut

has lightposition => ( is => 'rw', );

=item * opacity

Sets the opacity of the surface.

=cut

has opacity => ( is            => 'rw',
                 documentation => "Sets the opacity of the surface.", );

=item * surfacecolor

Sets the surface color values, used for setting a color scale independent of `z`.

=cut

has surfacecolor => (
                   is            => 'rw',
                   documentation => "Sets the surface color values, used for setting a color scale independent of `z`.",
);

=item * cmax

Sets the upper bound of color domain.

=cut

has cmax => ( is            => 'rw',
              documentation => "Sets the upper bound of color domain.", );

=item * showscale

Determines whether or not a colorbar is displayed for this trace.

=cut

has showscale => ( is            => 'rw',
                   documentation => "Determines whether or not a colorbar is displayed for this trace.", );

=item * y

Sets the y coordinates.

=cut

has y => ( is            => 'rw',
           documentation => "Sets the y coordinates.", );

=item * text

Sets the text elements associated with each z value.

=cut

has text => ( is            => 'rw',
              documentation => "Sets the text elements associated with each z value.", );

=item * colorscale

Sets the colorscale. The colorscale must be an array containing arrays mapping a normalized value to an rgb, rgba, hex, hsl, hsv, or named color string. At minimum, a mapping for the lowest (0) and highest (1) values are required. For example, `[[0, 'rgb(0,0,255)', [1, 'rgb(255,0,0)']]`. To control the bounds of the colorscale in z space, use zmin and zmax

=cut

has colorscale => (
    is => 'rw',
    documentation =>
      "Sets the colorscale. The colorscale must be an array containing arrays mapping a normalized value to an rgb, rgba, hex, hsl, hsv, or named color string. At minimum, a mapping for the lowest (0) and highest (1) values are required. For example, `[[0, 'rgb(0,0,255)', [1, 'rgb(255,0,0)']]`. To control the bounds of the colorscale in z space, use zmin and zmax",
);

=item * _nestedModules


=cut

has _nestedModules => ( is => 'rw', );

=item * reversescale

Reverses the colorscale.

=cut

has reversescale => ( is            => 'rw',
                      documentation => "Reverses the colorscale.", );

=item * z

Sets the z coordinates.

=cut

has z => ( is            => 'rw',
           documentation => "Sets the z coordinates.", );

=item * lighting


=cut

has lighting => ( is => 'rw', );

=item * autocolorscale

Determines whether or not the colorscale is picked using the sign of the input z values.

=cut

has autocolorscale => (
            is            => 'rw',
            documentation => "Determines whether or not the colorscale is picked using the sign of the input z values.",
);

=item * _deprecated


=cut

has _deprecated => ( is => 'rw', );

=item * hidesurface

Determines whether or not a surface is drawn. For example, set `hidesurface` to *false* `contours.x.show` to *true* and `contours.y.show` to *true* to draw a wire frame plot.

=cut

has hidesurface => (
    is => 'rw',
    documentation =>
      "Determines whether or not a surface is drawn. For example, set `hidesurface` to *false* `contours.x.show` to *true* and `contours.y.show` to *true* to draw a wire frame plot.",
);

=pod

=back

=cut

__PACKAGE__->meta->make_immutable();
1;
