#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::More;
use Test::Deep qw(cmp_deeply);
use XML::TreePP;

use FusionInventory::Agent::SNMP::Mock;
use FusionInventory::Agent::Task::NetDiscovery::Dictionary;
use FusionInventory::Agent::Tools::Hardware;

my %tests = (
    'cisco/888.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C880 Software (C880DATA-UNIVERSALK9-M), Version 12.4(20)T6, RELEASE SOFTWARE (fc2)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Fri 03-Sep-10 18:37 by prod_rel_team',
            SNMPHOSTNAME => 'A7309-00011-001',
            MAC          => '30:f7:0d:17:a6:24',
            MODEL        => '888',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C880 Software (C880DATA-UNIVERSALK9-M), Version 12.4(20)T6, RELEASE SOFTWARE (fc2)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Fri 03-Sep-10 18:37 by prod_rel_team',
            SNMPHOSTNAME => 'A7309-00011-001',
            MAC          => '30:f7:0d:17:a6:24',
            MODEL        => '888',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => '888',
                COMMENTS     => 'Cisco IOS Software, C880 Software (C880DATA-UNIVERSALK9-M), Version 12.4(20)T6, RELEASE SOFTWARE (fc2)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Fri 03-Sep-10 18:37 by prod_rel_team',
                NAME         => 'A7309-00011-001',
                MEMORY       => '162',
                SERIAL       => 'FCZ1631911E',
                IPS          => {
                    IP => [
                        '10.229.132.57',
                        '172.31.1.72',
                        '198.18.58.2',
                    ],
                },
                UPTIME       => '(1025110975) 118 days, 15:31:49.75',
                CPU          => '11',
                RAM          => '244',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'BR0',
                        IFDESCR          => 'BRI0',
                        IFTYPE           => '77',
                        IFSPEED          => '16000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'BR0:1',
                        IFDESCR          => 'BRI0:1',
                        IFTYPE           => '22',
                        IFSPEED          => '64000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'BR0:2',
                        IFDESCR          => 'BRI0:2',
                        IFTYPE           => '22',
                        IFSPEED          => '64000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFALIAS          => '*** DATA ***',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '30:f7:0d:17:a6:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2958) 0:00:29.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '65569088',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1293423622',
                        IFOUTERRORS      => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DATA',
                                    NUMBER => '105',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Fa1',
                        IFDESCR          => 'FastEthernet1',
                        IFALIAS          => '*** DATA ***',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '30:f7:0d:17:a6:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2958) 0:00:29.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1017028642',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3194998529',
                        IFOUTERRORS      => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DATA',
                                    NUMBER => '105',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Fa2',
                        IFDESCR          => 'FastEthernet2',
                        IFALIAS          => '*** DATA ***',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '30:f7:0d:17:a6:26',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2958) 0:00:29.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DATA',
                                    NUMBER => '105',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Fa3',
                        IFDESCR          => 'FastEthernet3',
                        IFALIAS          => '*** DATA ***',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '30:f7:0d:17:a6:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2958) 0:00:29.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DATA',
                                    NUMBER => '105',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '30:f7:0d:17:a6:24',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2095) 0:00:20.95',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'AT0',
                        IFDESCR          => 'ATM0',
                        IFALIAS          => '*** INTERFACE WAN ATM ***',
                        IFTYPE           => '169',
                        IFSPEED          => '4096000',
                        IFMTU            => '4470',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984539) 87 days, 6:24:05.39',
                        IFINOCTETS       => '4096882627',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2404557257',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'ATM0-atm layer',
                        IFDESCR          => 'ATM0-atm layer',
                        IFTYPE           => '37',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984239) 87 days, 6:24:02.39',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'ATM0.0-atm subif',
                        IFDESCR          => 'ATM0.0-atm subif',
                        IFALIAS          => '*** INTERFACE WAN ATM ***',
                        IFTYPE           => '134',
                        IFSPEED          => '4096000',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984239) 87 days, 6:24:02.39',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => 'ATM0-aal5 layer',
                        IFDESCR          => 'ATM0-aal5 layer',
                        IFTYPE           => '49',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984239) 87 days, 6:24:02.39',
                        IFINOCTETS       => '4153638515',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2404535305',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => 'ATM0.0-aal5 layer',
                        IFDESCR          => 'ATM0.0-aal5 layer',
                        IFALIAS          => '*** INTERFACE WAN ATM ***',
                        IFTYPE           => '49',
                        IFSPEED          => '4096000',
                        IFMTU            => '4470',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984239) 87 days, 6:24:02.39',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => 'Lo26',
                        IFDESCR          => 'Loopback26',
                        IFALIAS          => '*** loopback de supervision ***',
                        IFTYPE           => '24',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1514',
                        IP               => '198.18.58.2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2455) 0:00:24.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => 'ATM0.835-atm subif',
                        IFDESCR          => 'ATM0.835-atm subif',
                        IFALIAS          => '*** INTERFACE WAN ATM ***',
                        IFTYPE           => '134',
                        IFSPEED          => '4096000',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984239) 87 days, 6:24:02.39',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => 'ATM0.835-aal5 layer',
                        IFDESCR          => 'ATM0.835-aal5 layer',
                        IFALIAS          => '*** INTERFACE WAN ATM ***',
                        IFTYPE           => '49',
                        IFSPEED          => '4096000',
                        IFMTU            => '4470',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984239) 87 days, 6:24:02.39',
                        IFINOCTETS       => '4153638515',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2404535305',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => 'Di1',
                        IFDESCR          => 'Dialer1',
                        IFTYPE           => '23',
                        IFSPEED          => '4096000',
                        IFMTU            => '1460',
                        IP               => '172.31.1.72',
                        IFSTATUS         => '5',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984928) 87 days, 6:24:09.28',
                        IFINOCTETS       => '3361531054',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '565389820',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => 'SS0',
                        IFDESCR          => 'SSLVPN-VIF0',
                        IFALIAS          => '***Internally created by SSLVPN context Default_context***',
                        IFTYPE           => '1',
                        IFSPEED          => '56000',
                        IFMTU            => '1406',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2849) 0:00:28.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => 'BR0',
                        IFDESCR          => 'BRI0-Physical',
                        IFTYPE           => '75',
                        IFSPEED          => '144000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => 'BR0',
                        IFDESCR          => 'BRI0-Signaling',
                        IFTYPE           => '63',
                        IFSPEED          => '16000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => 'BR0:1',
                        IFDESCR          => 'BRI0:1-Bearer Channel',
                        IFTYPE           => '81',
                        IFSPEED          => '64000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => 'BR0:2',
                        IFDESCR          => 'BRI0:2-Bearer Channel',
                        IFTYPE           => '81',
                        IFSPEED          => '64000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => 'Vi1',
                        IFDESCR          => 'Virtual-Access1',
                        IFTYPE           => '23',
                        IFSPEED          => '4096000',
                        IFMTU            => '1460',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753985025) 87 days, 6:24:10.25',
                        IFINOCTETS       => '2161018736',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4139492181',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => 'Vl105',
                        IFDESCR          => 'Vlan105',
                        IFALIAS          => '*** DATA ***',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        IP               => '10.229.132.57',
                        MAC              => '30:f7:0d:17:a6:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2958) 0:00:29.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3177710451',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '696762742',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => '888',
                COMMENTS     => 'Cisco IOS Software, C880 Software (C880DATA-UNIVERSALK9-M), Version 12.4(20)T6, RELEASE SOFTWARE (fc2)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2010 by Cisco Systems, Inc.
Compiled Fri 03-Sep-10 18:37 by prod_rel_team',
                NAME         => 'A7309-00011-001',
                MEMORY       => '162',
                SERIAL       => 'FCZ1631911E',
                IPS          => {
                    IP => [
                        '10.229.132.57',
                        '172.31.1.72',
                        '198.18.58.2',
                    ],
                },
                UPTIME       => '(1025110975) 118 days, 15:31:49.75',
                CPU          => '11',
                RAM          => '244',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'BR0',
                        IFDESCR          => 'BRI0',
                        IFTYPE           => '77',
                        IFSPEED          => '16000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'BR0:1',
                        IFDESCR          => 'BRI0:1',
                        IFTYPE           => '22',
                        IFSPEED          => '64000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'BR0:2',
                        IFDESCR          => 'BRI0:2',
                        IFTYPE           => '22',
                        IFSPEED          => '64000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFALIAS          => '*** DATA ***',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '30:f7:0d:17:a6:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2958) 0:00:29.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '65569088',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1293423622',
                        IFOUTERRORS      => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DATA',
                                    NUMBER => '105',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Fa1',
                        IFDESCR          => 'FastEthernet1',
                        IFALIAS          => '*** DATA ***',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '30:f7:0d:17:a6:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2958) 0:00:29.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1017028642',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3194998529',
                        IFOUTERRORS      => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DATA',
                                    NUMBER => '105',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Fa2',
                        IFDESCR          => 'FastEthernet2',
                        IFALIAS          => '*** DATA ***',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '30:f7:0d:17:a6:26',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2958) 0:00:29.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DATA',
                                    NUMBER => '105',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Fa3',
                        IFDESCR          => 'FastEthernet3',
                        IFALIAS          => '*** DATA ***',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '30:f7:0d:17:a6:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2958) 0:00:29.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DATA',
                                    NUMBER => '105',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '30:f7:0d:17:a6:24',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2095) 0:00:20.95',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'AT0',
                        IFDESCR          => 'ATM0',
                        IFALIAS          => '*** INTERFACE WAN ATM ***',
                        IFTYPE           => '169',
                        IFSPEED          => '4096000',
                        IFMTU            => '4470',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984539) 87 days, 6:24:05.39',
                        IFINOCTETS       => '4096882627',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2404557257',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'ATM0-atm layer',
                        IFDESCR          => 'ATM0-atm layer',
                        IFTYPE           => '37',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984239) 87 days, 6:24:02.39',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'ATM0.0-atm subif',
                        IFDESCR          => 'ATM0.0-atm subif',
                        IFALIAS          => '*** INTERFACE WAN ATM ***',
                        IFTYPE           => '134',
                        IFSPEED          => '4096000',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984239) 87 days, 6:24:02.39',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => 'ATM0-aal5 layer',
                        IFDESCR          => 'ATM0-aal5 layer',
                        IFTYPE           => '49',
                        IFSPEED          => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984239) 87 days, 6:24:02.39',
                        IFINOCTETS       => '4153638515',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2404535305',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => 'ATM0.0-aal5 layer',
                        IFDESCR          => 'ATM0.0-aal5 layer',
                        IFALIAS          => '*** INTERFACE WAN ATM ***',
                        IFTYPE           => '49',
                        IFSPEED          => '4096000',
                        IFMTU            => '4470',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984239) 87 days, 6:24:02.39',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => 'Lo26',
                        IFDESCR          => 'Loopback26',
                        IFALIAS          => '*** loopback de supervision ***',
                        IFTYPE           => '24',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1514',
                        IP               => '198.18.58.2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2455) 0:00:24.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => 'ATM0.835-atm subif',
                        IFDESCR          => 'ATM0.835-atm subif',
                        IFALIAS          => '*** INTERFACE WAN ATM ***',
                        IFTYPE           => '134',
                        IFSPEED          => '4096000',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984239) 87 days, 6:24:02.39',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => 'ATM0.835-aal5 layer',
                        IFDESCR          => 'ATM0.835-aal5 layer',
                        IFALIAS          => '*** INTERFACE WAN ATM ***',
                        IFTYPE           => '49',
                        IFSPEED          => '4096000',
                        IFMTU            => '4470',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984239) 87 days, 6:24:02.39',
                        IFINOCTETS       => '4153638515',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2404535305',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => 'Di1',
                        IFDESCR          => 'Dialer1',
                        IFTYPE           => '23',
                        IFSPEED          => '4096000',
                        IFMTU            => '1460',
                        IP               => '172.31.1.72',
                        IFSTATUS         => '5',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753984928) 87 days, 6:24:09.28',
                        IFINOCTETS       => '3361531054',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '565389820',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => 'SS0',
                        IFDESCR          => 'SSLVPN-VIF0',
                        IFALIAS          => '***Internally created by SSLVPN context Default_context***',
                        IFTYPE           => '1',
                        IFSPEED          => '56000',
                        IFMTU            => '1406',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2849) 0:00:28.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => 'BR0',
                        IFDESCR          => 'BRI0-Physical',
                        IFTYPE           => '75',
                        IFSPEED          => '144000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => 'BR0',
                        IFDESCR          => 'BRI0-Signaling',
                        IFTYPE           => '63',
                        IFSPEED          => '16000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => 'BR0:1',
                        IFDESCR          => 'BRI0:1-Bearer Channel',
                        IFTYPE           => '81',
                        IFSPEED          => '64000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => 'BR0:2',
                        IFDESCR          => 'BRI0:2-Bearer Channel',
                        IFTYPE           => '81',
                        IFSPEED          => '64000',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2348) 0:00:23.48',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => 'Vi1',
                        IFDESCR          => 'Virtual-Access1',
                        IFTYPE           => '23',
                        IFSPEED          => '4096000',
                        IFMTU            => '1460',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(753985025) 87 days, 6:24:10.25',
                        IFINOCTETS       => '2161018736',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4139492181',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => 'Vl105',
                        IFDESCR          => 'Vlan105',
                        IFALIAS          => '*** DATA ***',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        IP               => '10.229.132.57',
                        MAC              => '30:f7:0d:17:a6:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2958) 0:00:29.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3177710451',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '696762742',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C1040.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1040 Software (C1140-K9W7-M), Version 12.4(25d)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 11-Aug-11 02:58 by prod_rel_team',
            SNMPHOSTNAME => 'WIFI-IPJ-etage2-82.wifi-mngt.dauphine.fr',
            MAC          => 'a4:18:75:a5:27:00',
            MODEL        => 'Aironet 1040 series',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1040 Software (C1140-K9W7-M), Version 12.4(25d)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 11-Aug-11 02:58 by prod_rel_team',
            SNMPHOSTNAME => 'WIFI-IPJ-etage2-82.wifi-mngt.dauphine.fr',
            MAC          => 'a4:18:75:c2:67:00',
            MODELSNMP    => 'Networking2178',
            MODEL        => 'Aironet 1040 series',
            FIRMWARE     => undef,
            SERIAL       => 'FCZ1623Z2XQ',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1040 series',
                COMMENTS     => 'Cisco IOS Software, C1040 Software (C1140-K9W7-M), Version 12.4(25d)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 11-Aug-11 02:58 by prod_rel_team',
                NAME         => 'WIFI-IPJ-etage2-82.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ1623Z2XQ',
                IPS          => {
                    IP => [
                        '192.168.55.82',
                    ],
                },
                UPTIME       => '(829014147) 95 days, 22:49:01.47',
                CPU          => '96',
                RAM          => '95',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:c2:67:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(767607999) 88 days, 20:14:39.99',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2545707486',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2562804791',
                        IFOUTERRORS      => '7309',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:a5:27:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1620) 0:00:16.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Gi0',
                        IFDESCR          => 'GigabitEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1559) 0:00:15.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1203274941',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2425186262',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:c2:67:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(767607999) 88 days, 20:14:39.99',
                        IFINOCTETS       => '1696380185',
                        IFOUTOCTETS      => '3114577963',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:bb:15:dd:9f',
                                    '00:26:bb:1b:ad:65',
                                    '8c:7b:9d:d5:c5:82',
                                    'bc:52:b7:25:17:c9',
                                    'c8:bc:c8:bc:e7:28',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:c2:67:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(767607999) 88 days, 20:14:39.99',
                        IFINOCTETS       => '154557539',
                        IFOUTOCTETS      => '2680413485',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:c2:67:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(767607999) 88 days, 20:14:39.99',
                        IFINOCTETS       => '116190244',
                        IFOUTOCTETS      => '2076205012',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Gi0.7',
                        IFDESCR          => 'GigabitEthernet0.7',
                        IFALIAS          => 'eduspot',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1527) 0:00:15.27',
                        IFINOCTETS       => '1679633303',
                        IFOUTOCTETS      => '1704767676',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Gi0.18',
                        IFDESCR          => 'GigabitEthernet0.18',
                        IFALIAS          => 'eduroam',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1531) 0:00:15.31',
                        IFINOCTETS       => '2795453458',
                        IFOUTOCTETS      => '154132236',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Gi0.40',
                        IFDESCR          => 'GigabitEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1531) 0:00:15.31',
                        IFINOCTETS       => '2883284913',
                        IFOUTOCTETS      => '111865705',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        IP               => '192.168.55.82',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1634) 0:00:16.34',
                        IFINOCTETS       => '607347610',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '419789539',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1040 series',
                COMMENTS     => 'Cisco IOS Software, C1040 Software (C1140-K9W7-M), Version 12.4(25d)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 11-Aug-11 02:58 by prod_rel_team',
                NAME         => 'WIFI-IPJ-etage2-82.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ1623Z2XQ',
                FIRMWARE     => 'CW_VERSION$12.4(25d)JA1$',
                IPS          => {
                    IP => [
                        '192.168.55.82',
                    ],
                },
                MAC          => 'a4:18:75:c2:67:00',
                UPTIME       => '(829014147) 95 days, 22:49:01.47',
                CPU          => '96',
                RAM          => '95',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:c2:67:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(767607999) 88 days, 20:14:39.99',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2545707486',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2562804791',
                        IFOUTERRORS      => '7309',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:a5:27:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1620) 0:00:16.20',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Gi0',
                        IFDESCR          => 'GigabitEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1559) 0:00:15.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1203274941',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2425186262',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:c2:67:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(767607999) 88 days, 20:14:39.99',
                        IFINOCTETS       => '1696380185',
                        IFOUTOCTETS      => '3114577963',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:bb:15:dd:9f',
                                    '00:26:bb:1b:ad:65',
                                    '8c:7b:9d:d5:c5:82',
                                    'bc:52:b7:25:17:c9',
                                    'c8:bc:c8:bc:e7:28',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:c2:67:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(767607999) 88 days, 20:14:39.99',
                        IFINOCTETS       => '154557539',
                        IFOUTOCTETS      => '2680413485',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:18:75:c2:67:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(767607999) 88 days, 20:14:39.99',
                        IFINOCTETS       => '116190244',
                        IFOUTOCTETS      => '2076205012',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Gi0.7',
                        IFDESCR          => 'GigabitEthernet0.7',
                        IFALIAS          => 'eduspot',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1527) 0:00:15.27',
                        IFINOCTETS       => '1679633303',
                        IFOUTOCTETS      => '1704767676',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Gi0.18',
                        IFDESCR          => 'GigabitEthernet0.18',
                        IFALIAS          => 'eduroam',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1531) 0:00:15.31',
                        IFINOCTETS       => '2795453458',
                        IFOUTOCTETS      => '154132236',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Gi0.40',
                        IFDESCR          => 'GigabitEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1531) 0:00:15.31',
                        IFINOCTETS       => '2883284913',
                        IFOUTOCTETS      => '111865705',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        IP               => '192.168.55.82',
                        MAC              => 'a4:93:4c:93:a1:b5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1634) 0:00:16.34',
                        IFINOCTETS       => '607347610',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '419789539',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C1130.1.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
            SNMPHOSTNAME => 'ap-CP6-BU-161.wifi-mngt.dauphine.fr',
            MAC          => '00:13:5f:fa:f2:50',
            MODEL        => 'Aironet 1130 series',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
            SNMPHOSTNAME => 'ap-CP6-BU-161.wifi-mngt.dauphine.fr',
            MAC          => '00:13:5f:fa:f2:50',
            MODELSNMP    => 'Networking2176',
            MODEL        => 'Aironet 1130 series',
            FIRMWARE     => undef,
            SERIAL       => 'FCZ0930Q00Z',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1130 series',
                COMMENTS     => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
                NAME         => 'ap-CP6-BU-161.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ0930Q00Z',
                CPU          => '97',
                RAM          => '23',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f2:50',
                        IFLASTCHANGE     => '(7701) 0:01:17.01',
                        IFINOCTETS       => '2723745631',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2002017105',
                        IFOUTERRORS      => '91561',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f2:30',
                        IFLASTCHANGE     => '(1204) 0:00:12.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1142) 0:00:11.42',
                        IFINOCTETS       => '1922539881',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3697487330',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f2:50',
                        IFLASTCHANGE     => '(7607) 0:01:16.07',
                        IFINOCTETS       => '2687372679',
                        IFOUTOCTETS      => '1195595259',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f2:50',
                        IFLASTCHANGE     => '(7607) 0:01:16.07',
                        IFINOCTETS       => '23434868',
                        IFOUTOCTETS      => '822989071',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f2:50',
                        IFLASTCHANGE     => '(7607) 0:01:16.07',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '540',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Do1.40',
                        IFDESCR          => 'Dot11Radio1.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f2:30',
                        IFLASTCHANGE     => '(1096) 0:00:10.96',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0.7',
                        IFDESCR          => 'FastEthernet0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1107) 0:00:11.07',
                        IFINOCTETS       => '3495668832',
                        IFOUTOCTETS      => '2702597576',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0.18',
                        IFDESCR          => 'FastEthernet0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1108) 0:00:11.08',
                        IFINOCTETS       => '843457950',
                        IFOUTOCTETS      => '23050498',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0.40',
                        IFDESCR          => 'FastEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1109) 0:00:11.09',
                        IFINOCTETS       => '1016603638',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1210) 0:00:12.10',
                        IFINOCTETS       => '410354460',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10537521',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1130 series',
                COMMENTS     => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
                NAME         => 'ap-CP6-BU-161.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ0930Q00Z',
                FIRMWARE     => 'CW_VERSION$12.4(10b)JA3$',
                MAC          => '00:13:5f:fa:f2:50',
                CPU          => '97',
                RAM          => '23',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f2:50',
                        IFLASTCHANGE     => '(7701) 0:01:17.01',
                        IFINOCTETS       => '2723745631',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2002017105',
                        IFOUTERRORS      => '91561',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f2:30',
                        IFLASTCHANGE     => '(1204) 0:00:12.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1142) 0:00:11.42',
                        IFINOCTETS       => '1922539881',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3697487330',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f2:50',
                        IFLASTCHANGE     => '(7607) 0:01:16.07',
                        IFINOCTETS       => '2687372679',
                        IFOUTOCTETS      => '1195595259',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f2:50',
                        IFLASTCHANGE     => '(7607) 0:01:16.07',
                        IFINOCTETS       => '23434868',
                        IFOUTOCTETS      => '822989071',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f2:50',
                        IFLASTCHANGE     => '(7607) 0:01:16.07',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '540',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Do1.40',
                        IFDESCR          => 'Dot11Radio1.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f2:30',
                        IFLASTCHANGE     => '(1096) 0:00:10.96',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0.7',
                        IFDESCR          => 'FastEthernet0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1107) 0:00:11.07',
                        IFINOCTETS       => '3495668832',
                        IFOUTOCTETS      => '2702597576',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0.18',
                        IFDESCR          => 'FastEthernet0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1108) 0:00:11.08',
                        IFINOCTETS       => '843457950',
                        IFOUTOCTETS      => '23050498',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0.40',
                        IFDESCR          => 'FastEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1109) 0:00:11.09',
                        IFINOCTETS       => '1016603638',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b1:ce',
                        IFLASTCHANGE     => '(1210) 0:00:12.10',
                        IFINOCTETS       => '410354460',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10537521',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C1130.2.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
            SNMPHOSTNAME => 'ap-P405-45.wifi-mngt.dauphine.fr',
            MAC          => '00:13:5f:fa:fa:50',
            MODEL        => 'Aironet 1130 series',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
            SNMPHOSTNAME => 'ap-P405-45.wifi-mngt.dauphine.fr',
            MAC          => '00:13:5f:fa:fa:50',
            MODELSNMP    => 'Networking2176',
            MODEL        => 'Aironet 1130 series',
            FIRMWARE     => undef,
            SERIAL       => 'FCZ0930Q01A',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1130 series',
                COMMENTS     => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
                NAME         => 'ap-P405-45.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ0930Q01A',
                IPS          => {
                    IP => [
                        '192.168.55.45',
                    ],
                },
                UPTIME       => '(34865419) 4 days, 0:50:54.19',
                CPU          => '98',
                RAM          => '23',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:fa:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7532) 0:01:15.32',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1847463852',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '782166020',
                        IFOUTERRORS      => '86765',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:fa:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1198) 0:00:11.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1136) 0:00:11.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3855516427',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2786837221',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:fa:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7438) 0:01:14.38',
                        IFINOCTETS       => '1833237924',
                        IFOUTOCTETS      => '3508924423',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:fa:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7438) 0:01:14.38',
                        IFINOCTETS       => '396827',
                        IFOUTOCTETS      => '694399025',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:fa:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7438) 0:01:14.38',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '6940608',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Do1.40',
                        IFDESCR          => 'Dot11Radio1.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:fa:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1089) 0:00:10.89',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0.7',
                        IFDESCR          => 'FastEthernet0.7',
                        IFALIAS          => 'eduspot',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1100) 0:00:11.00',
                        IFINOCTETS       => '1143594822',
                        IFOUTOCTETS      => '1841662240',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0.18',
                        IFDESCR          => 'FastEthernet0.18',
                        IFALIAS          => 'eduroam',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1102) 0:00:11.02',
                        IFINOCTETS       => '714789539',
                        IFOUTOCTETS      => '306665',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0.40',
                        IFDESCR          => 'FastEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1103) 0:00:11.03',
                        IFINOCTETS       => '970211324',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        IP               => '192.168.55.45',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1204) 0:00:12.04',
                        IFINOCTETS       => '411852720',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8408247',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1130 series',
                COMMENTS     => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(10b)JA3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2008 by Cisco Systems, Inc.
Compiled Wed 19-Mar-08 18:08 by prod_rel_team',
                NAME         => 'ap-P405-45.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ0930Q01A',
                FIRMWARE     => 'CW_VERSION$12.4(10b)JA3$',
                IPS          => {
                    IP => [
                        '192.168.55.45',
                    ],
                },
                MAC          => '00:13:5f:fa:fa:50',
                UPTIME       => '(34865419) 4 days, 0:50:54.19',
                CPU          => '98',
                RAM          => '23',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:fa:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7532) 0:01:15.32',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1847463852',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '782166020',
                        IFOUTERRORS      => '86765',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:fa:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1198) 0:00:11.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1136) 0:00:11.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3855516427',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2786837221',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:fa:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7438) 0:01:14.38',
                        IFINOCTETS       => '1833237924',
                        IFOUTOCTETS      => '3508924423',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:fa:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7438) 0:01:14.38',
                        IFINOCTETS       => '396827',
                        IFOUTOCTETS      => '694399025',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:fa:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7438) 0:01:14.38',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '6940608',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Do1.40',
                        IFDESCR          => 'Dot11Radio1.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:fa:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1089) 0:00:10.89',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0.7',
                        IFDESCR          => 'FastEthernet0.7',
                        IFALIAS          => 'eduspot',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1100) 0:00:11.00',
                        IFINOCTETS       => '1143594822',
                        IFOUTOCTETS      => '1841662240',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0.18',
                        IFDESCR          => 'FastEthernet0.18',
                        IFALIAS          => 'eduroam',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1102) 0:00:11.02',
                        IFINOCTETS       => '714789539',
                        IFOUTOCTETS      => '306665',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0.40',
                        IFDESCR          => 'FastEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1103) 0:00:11.03',
                        IFINOCTETS       => '970211324',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        IP               => '192.168.55.45',
                        MAC              => '00:14:6a:d6:b2:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1204) 0:00:12.04',
                        IFINOCTETS       => '411852720',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8408247',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C1130.3.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
            SNMPHOSTNAME => 'ap-D416-141.wifi-mngt.dauphine.fr',
            MAC          => '00:13:5f:fa:f9:a0',
            MODEL        => 'Aironet 1130 series',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
            SNMPHOSTNAME => 'ap-D416-141.wifi-mngt.dauphine.fr',
            MAC          => '00:13:5f:fa:f9:a0',
            MODELSNMP    => 'Networking2191',
            MODEL        => 'Aironet 1130 series',
            FIRMWARE     => undef,
            SERIAL       => 'FCZ0930Q01N',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1130 series',
                COMMENTS     => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
                NAME         => 'ap-D416-141.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ0930Q01N',
                IPS          => {
                    IP => [
                        '192.168.55.141',
                    ],
                },
                UPTIME       => '(131654419) 15 days, 5:42:24.19',
                CPU          => '97',
                RAM          => '23',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1986250540',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4034040569',
                        IFOUTERRORS      => '15496',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f9:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1388) 0:00:13.88',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1333) 0:00:13.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3182552204',
                        IFINERRORS       => '1817884',
                        IFOUTOCTETS      => '2589712033',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0b:5f:cc:d8:80',
                                    '00:16:76:cf:94:62',
                                    '00:20:a6:49:7e:fb',
                                    '00:26:b6:15:20:23',
                                    '00:26:08:f9:3d:c4',
                                    '68:a8:6d:51:65:da',
                                    '7c:d1:c3:f4:e7:89',
                                    '10:9a:dd:a5:32:33',
                                    'bc:52:b7:38:91:13',
                                    'e0:b9:ba:af:ad:4f',
                                    'e0:f8:47:34:4c:b4',
                                    'e0:06:e6:96:d4:a1',
                                    'e8:06:88:57:6d:7d',
                                    '18:a9:05:e3:0c:f5',
                                    'fc:25:3f:7b:7d:f6',
                                    '28:6a:ba:59:82:44',
                                    '34:15:9e:94:10:71',
                                    '40:6c:8f:1d:c0:7f',
                                    '4c:0f:6e:d5:3c:02',
                                    '54:04:a6:96:01:e1',
                                    '5c:96:9d:76:78:9d',
                                    '5c:ac:4c:1a:0f:00',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '1525293600',
                        IFOUTOCTETS      => '902858571',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '8650226',
                        IFOUTOCTETS      => '827133541',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '46832680',
                        IFOUTOCTETS      => '39829396',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Do1.40',
                        IFDESCR          => 'Dot11Radio1.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f9:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1288) 0:00:12.88',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0.7',
                        IFDESCR          => 'FastEthernet0.7',
                        IFALIAS          => 'eduspot',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1298) 0:00:12.98',
                        IFINOCTETS       => '3827474904',
                        IFOUTOCTETS      => '1534007354',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0.18',
                        IFDESCR          => 'FastEthernet0.18',
                        IFALIAS          => 'eduroam',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1299) 0:00:12.99',
                        IFINOCTETS       => '871447532',
                        IFOUTOCTETS      => '8082038',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0.40',
                        IFDESCR          => 'FastEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFINOCTETS       => '1834903826',
                        IFOUTOCTETS      => '46294714',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        IP               => '192.168.55.141',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402) 0:00:14.02',
                        IFINOCTETS       => '476038021',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '22916493',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1130 series',
                COMMENTS     => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
                NAME         => 'ap-D416-141.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ0930Q01N',
                FIRMWARE     => 'CW_VERSION$12.4(21a)JA1$',
                IPS          => {
                    IP => [
                        '192.168.55.141',
                    ],
                },
                MAC          => '00:13:5f:fa:f9:a0',
                UPTIME       => '(131654419) 15 days, 5:42:24.19',
                CPU          => '97',
                RAM          => '23',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1986250540',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4034040569',
                        IFOUTERRORS      => '15496',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f9:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1388) 0:00:13.88',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1333) 0:00:13.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3182552204',
                        IFINERRORS       => '1817884',
                        IFOUTOCTETS      => '2589712033',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0b:5f:cc:d8:80',
                                    '00:16:76:cf:94:62',
                                    '00:20:a6:49:7e:fb',
                                    '00:26:b6:15:20:23',
                                    '00:26:08:f9:3d:c4',
                                    '68:a8:6d:51:65:da',
                                    '7c:d1:c3:f4:e7:89',
                                    '10:9a:dd:a5:32:33',
                                    'bc:52:b7:38:91:13',
                                    'e0:b9:ba:af:ad:4f',
                                    'e0:f8:47:34:4c:b4',
                                    'e0:06:e6:96:d4:a1',
                                    'e8:06:88:57:6d:7d',
                                    '18:a9:05:e3:0c:f5',
                                    'fc:25:3f:7b:7d:f6',
                                    '28:6a:ba:59:82:44',
                                    '34:15:9e:94:10:71',
                                    '40:6c:8f:1d:c0:7f',
                                    '4c:0f:6e:d5:3c:02',
                                    '54:04:a6:96:01:e1',
                                    '5c:96:9d:76:78:9d',
                                    '5c:ac:4c:1a:0f:00',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '1525293600',
                        IFOUTOCTETS      => '902858571',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '8650226',
                        IFOUTOCTETS      => '827133541',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '46832680',
                        IFOUTOCTETS      => '39829396',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Do1.40',
                        IFDESCR          => 'Dot11Radio1.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f9:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1288) 0:00:12.88',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0.7',
                        IFDESCR          => 'FastEthernet0.7',
                        IFALIAS          => 'eduspot',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1298) 0:00:12.98',
                        IFINOCTETS       => '3827474904',
                        IFOUTOCTETS      => '1534007354',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0.18',
                        IFDESCR          => 'FastEthernet0.18',
                        IFALIAS          => 'eduroam',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1299) 0:00:12.99',
                        IFINOCTETS       => '871447532',
                        IFOUTOCTETS      => '8082038',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0.40',
                        IFDESCR          => 'FastEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFINOCTETS       => '1834903826',
                        IFOUTOCTETS      => '46294714',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        IP               => '192.168.55.141',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402) 0:00:14.02',
                        IFINOCTETS       => '476038021',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '22916493',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C1130.4.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
            SNMPHOSTNAME => 'ap-D416-141.wifi-mngt.dauphine.fr',
            MAC          => '00:13:5f:fa:f9:a0',
            MODEL        => 'Aironet 1130 series',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
            SNMPHOSTNAME => 'ap-D416-141.wifi-mngt.dauphine.fr',
            MAC          => '00:13:5f:fa:f9:a0',
            MODELSNMP    => 'Networking2191',
            MODEL        => 'Aironet 1130 series',
            FIRMWARE     => undef,
            SERIAL       => 'FCZ0930Q01N',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1130 series',
                COMMENTS     => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
                NAME         => 'ap-D416-141.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ0930Q01N',
                IPS          => {
                    IP => [
                        '192.168.55.141',
                    ],
                },
                UPTIME       => '(131936738) 15 days, 6:29:27.38',
                CPU          => '98',
                RAM          => '23',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2008650512',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4262978259',
                        IFOUTERRORS      => '15567',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f9:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1388) 0:00:13.88',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1333) 0:00:13.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3482914011',
                        IFINERRORS       => '1817884',
                        IFOUTOCTETS      => '2611425256',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0b:5f:cc:d8:80',
                                    '00:16:76:cf:94:62',
                                    '00:20:a6:49:7e:fb',
                                    '00:26:b6:15:20:23',
                                    '00:26:08:f9:3d:c4',
                                    '68:a8:6d:51:65:da',
                                    '7c:d1:c3:f4:e7:89',
                                    '10:9a:dd:a5:32:33',
                                    'bc:52:b7:38:91:13',
                                    'e0:b9:ba:af:ad:4f',
                                    'e0:f8:47:34:4c:b4',
                                    'e0:06:e6:96:d4:a1',
                                    'e8:06:88:57:6d:7d',
                                    '18:a9:05:e3:0c:f5',
                                    'fc:25:3f:7b:7d:f6',
                                    '28:6a:ba:59:82:44',
                                    '34:15:9e:94:10:71',
                                    '40:6c:8f:1d:c0:7f',
                                    '4c:0f:6e:d5:3c:02',
                                    '54:04:a6:96:01:e1',
                                    '5c:96:9d:76:78:9d',
                                    '5c:ac:4c:1a:0f:00',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '1545983180',
                        IFOUTOCTETS      => '1194767553',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '8650226',
                        IFOUTOCTETS      => '828451237',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '46832680',
                        IFOUTOCTETS      => '39829396',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Do1.40',
                        IFDESCR          => 'Dot11Radio1.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f9:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1288) 0:00:12.88',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0.7',
                        IFDESCR          => 'FastEthernet0.7',
                        IFALIAS          => 'eduspot',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1298) 0:00:12.98',
                        IFINOCTETS       => '4128177048',
                        IFOUTOCTETS      => '1554773976',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0.18',
                        IFDESCR          => 'FastEthernet0.18',
                        IFALIAS          => 'eduroam',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1299) 0:00:12.99',
                        IFINOCTETS       => '872932219',
                        IFOUTOCTETS      => '8082038',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0.40',
                        IFDESCR          => 'FastEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFINOCTETS       => '1835337081',
                        IFOUTOCTETS      => '46294714',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        IP               => '192.168.55.141',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402) 0:00:14.02',
                        IFINOCTETS       => '476739635',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '23738876',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Aironet 1130 series',
                COMMENTS     => 'Cisco IOS Software, C1130 Software (C1130-K9W7-M), Version 12.4(21a)JA1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Wed 16-Sep-09 18:36 by prod_rel_team',
                NAME         => 'ap-D416-141.wifi-mngt.dauphine.fr',
                SERIAL       => 'FCZ0930Q01N',
                FIRMWARE     => 'CW_VERSION$12.4(21a)JA1$',
                IPS          => {
                    IP => [
                        '192.168.55.141',
                    ],
                },
                MAC          => '00:13:5f:fa:f9:a0',
                UPTIME       => '(131936738) 15 days, 6:29:27.38',
                CPU          => '98',
                RAM          => '23',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Do0',
                        IFDESCR          => 'Dot11Radio0',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2008650512',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4262978259',
                        IFOUTERRORS      => '15567',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Do1',
                        IFDESCR          => 'Dot11Radio1',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f9:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1388) 0:00:13.88',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0',
                        IFDESCR          => 'FastEthernet0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1333) 0:00:13.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3482914011',
                        IFINERRORS       => '1817884',
                        IFOUTOCTETS      => '2611425256',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0b:5f:cc:d8:80',
                                    '00:16:76:cf:94:62',
                                    '00:20:a6:49:7e:fb',
                                    '00:26:b6:15:20:23',
                                    '00:26:08:f9:3d:c4',
                                    '68:a8:6d:51:65:da',
                                    '7c:d1:c3:f4:e7:89',
                                    '10:9a:dd:a5:32:33',
                                    'bc:52:b7:38:91:13',
                                    'e0:b9:ba:af:ad:4f',
                                    'e0:f8:47:34:4c:b4',
                                    'e0:06:e6:96:d4:a1',
                                    'e8:06:88:57:6d:7d',
                                    '18:a9:05:e3:0c:f5',
                                    'fc:25:3f:7b:7d:f6',
                                    '28:6a:ba:59:82:44',
                                    '34:15:9e:94:10:71',
                                    '40:6c:8f:1d:c0:7f',
                                    '4c:0f:6e:d5:3c:02',
                                    '54:04:a6:96:01:e1',
                                    '5c:96:9d:76:78:9d',
                                    '5c:ac:4c:1a:0f:00',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Do0.7',
                        IFDESCR          => 'Dot11Radio0.7',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '1545983180',
                        IFOUTOCTETS      => '1194767553',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Do0.18',
                        IFDESCR          => 'Dot11Radio0.18',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '8650226',
                        IFOUTOCTETS      => '828451237',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Do0.40',
                        IFDESCR          => 'Dot11Radio0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fa:f9:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(79949565) 9 days, 6:04:55.65',
                        IFINOCTETS       => '46832680',
                        IFOUTOCTETS      => '39829396',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Do1.40',
                        IFDESCR          => 'Dot11Radio1.40',
                        IFTYPE           => '135',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        MAC              => '00:13:5f:fe:f9:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1288) 0:00:12.88',
                        IFINOCTETS       => '0',
                        IFOUTOCTETS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0.7',
                        IFDESCR          => 'FastEthernet0.7',
                        IFALIAS          => 'eduspot',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1298) 0:00:12.98',
                        IFINOCTETS       => '4128177048',
                        IFOUTOCTETS      => '1554773976',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0.18',
                        IFDESCR          => 'FastEthernet0.18',
                        IFALIAS          => 'eduroam',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1299) 0:00:12.99',
                        IFINOCTETS       => '872932219',
                        IFOUTOCTETS      => '8082038',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0.40',
                        IFDESCR          => 'FastEthernet0.40',
                        IFTYPE           => '135',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFINOCTETS       => '1835337081',
                        IFOUTOCTETS      => '46294714',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'BV1',
                        IFDESCR          => 'BVI1',
                        IFTYPE           => '209',
                        IFSPEED          => '54000000',
                        IFMTU            => '1500',
                        IP               => '192.168.55.141',
                        MAC              => '00:14:6a:d6:b2:b8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402) 0:00:14.02',
                        IFINOCTETS       => '476739635',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '23738876',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C2924.1.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco Internetwork Operating System Software 
IOS (tm) C2900XL Software (C2900XL-C3H2S-M), Version 12.0(5)WC17, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2007 by cisco Systems, Inc.
Compiled Tue 13-Feb-07 15:27 by antonino',
            MAC          => '00:01:96:38:57:40',
            MODEL        => 'Catalyst 2924 XLv',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco Internetwork Operating System Software 
IOS (tm) C2900XL Software (C2900XL-C3H2S-M), Version 12.0(5)WC17, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2007 by cisco Systems, Inc.
Compiled Tue 13-Feb-07 15:27 by antonino',
            MAC          => '00:01:96:38:57:40',
            MODELSNMP    => 'Networking1921',
            MODEL        => 'Catalyst 2924 XLv',
            FIRMWARE     => undef,
            SERIAL       => 'FAB0411S1FB',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2924 XLv',
                COMMENTS     => 'Cisco Internetwork Operating System Software 
IOS (tm) C2900XL Software (C2900XL-C3H2S-M), Version 12.0(5)WC17, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2007 by cisco Systems, Inc.
Compiled Tue 13-Feb-07 15:27 by antonino',
                CONTACT      => 'Service Informatique',
                SERIAL       => 'FAB0411S1FB',
                MAC          => '00:01:96:38:57:40',
                UPTIME       => '(284153455) 32 days, 21:18:54.55',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3560) 0:00:35.60',
                        IFINOCTETS       => '2068559518',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '239046073',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:41',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3768) 0:00:37.68',
                        IFINOCTETS       => '4145041811',
                        IFINERRORS       => '287',
                        IFOUTOCTETS      => '2773240205',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1b:21:2c:75:79',
                                    '00:1b:21:2c:75:7d',
                                    '00:1b:21:2c:76:65',
                                    '00:1b:21:2c:76:61',
                                    '00:1e:f7:0d:8f:c5',
                                    'c4:64:13:11:31:81',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:2b:f2:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:42',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4316) 0:00:43.16',
                        IFINOCTETS       => '313882495',
                        IFINERRORS       => '670',
                        IFOUTOCTETS      => '3165765220',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(278322224) 32 days, 5:07:02.24',
                        IFINOCTETS       => '82051036',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2297881053',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:44',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(280583541) 32 days, 11:23:55.41',
                        IFINOCTETS       => '2615405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '769622527',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:45',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1156003) 3:12:40.03',
                        IFINOCTETS       => '337662308',
                        IFINERRORS       => '635',
                        IFOUTOCTETS      => '3188808108',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFALIAS          => '\"PC Badge doublon\\',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:46',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(278469857) 32 days, 5:31:38.57',
                        IFINOCTETS       => '69655815',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1528986873',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:47',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3083) 0:00:30.83',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:48',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3113) 0:00:31.13',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:49',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(283443490) 32 days, 19:20:34.90',
                        IFINOCTETS       => '757175979',
                        IFINERRORS       => '7',
                        IFOUTOCTETS      => '3427157577',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(283444792) 32 days, 19:20:47.92',
                        IFINOCTETS       => '268866403',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2095387873',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(283442119) 32 days, 19:20:21.19',
                        IFINOCTETS       => '911545598',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1184611073',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(282306267) 32 days, 16:11:02.67',
                        IFINOCTETS       => '2634719610',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3752721734',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'J142A-Amphi',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(279224229) 32 days, 7:37:22.29',
                        IFINOCTETS       => '2492870',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '85878063',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3297) 0:00:32.97',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'F13-J11B',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(277924858) 32 days, 4:00:48.58',
                        IFINOCTETS       => '41476203',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '568386769',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(102521827) 11 days, 20:46:58.27',
                        IFINOCTETS       => '399066298',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2515430057',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:51',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3390) 0:00:33.90',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:52',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3419) 0:00:34.19',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:53',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(120755527) 13 days, 23:25:55.27',
                        IFINOCTETS       => '13226590',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2768247810',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFALIAS          => 'F113-J095A',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:54',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3481) 0:00:34.81',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:55',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3513) 0:00:35.13',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:56',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3557) 0:00:35.57',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:57',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3571) 0:00:35.71',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:58',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3922) 0:00:39.22',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2594458902',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '0',
                        MAC              => '00:01:96:38:57:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2924 XLv',
                COMMENTS     => 'Cisco Internetwork Operating System Software 
IOS (tm) C2900XL Software (C2900XL-C3H2S-M), Version 12.0(5)WC17, RELEASE SOFTWARE (fc1)
Copyright (c) 1986-2007 by cisco Systems, Inc.
Compiled Tue 13-Feb-07 15:27 by antonino',
                CONTACT      => 'Service Informatique',
                SERIAL       => 'FAB0411S1FB',
                MAC          => '00:01:96:38:57:40',
                UPTIME       => '(284153455) 32 days, 21:18:54.55',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3560) 0:00:35.60',
                        IFINOCTETS       => '2068559518',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '239046073',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:41',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3768) 0:00:37.68',
                        IFINOCTETS       => '4145041811',
                        IFINERRORS       => '287',
                        IFOUTOCTETS      => '2773240205',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1b:21:2c:75:79',
                                    '00:1b:21:2c:75:7d',
                                    '00:1b:21:2c:76:65',
                                    '00:1b:21:2c:76:61',
                                    '00:1e:f7:0d:8f:c5',
                                    'c4:64:13:11:31:81',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:2b:f2:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:42',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4316) 0:00:43.16',
                        IFINOCTETS       => '313882495',
                        IFINERRORS       => '670',
                        IFOUTOCTETS      => '3165765220',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(278322224) 32 days, 5:07:02.24',
                        IFINOCTETS       => '82051036',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2297881053',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:44',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(280583541) 32 days, 11:23:55.41',
                        IFINOCTETS       => '2615405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '769622527',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:45',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1156003) 3:12:40.03',
                        IFINOCTETS       => '337662308',
                        IFINERRORS       => '635',
                        IFOUTOCTETS      => '3188808108',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFALIAS          => '\"PC Badge doublon\\',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:46',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(278469857) 32 days, 5:31:38.57',
                        IFINOCTETS       => '69655815',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1528986873',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:47',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3083) 0:00:30.83',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:48',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3113) 0:00:31.13',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:49',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(283443490) 32 days, 19:20:34.90',
                        IFINOCTETS       => '757175979',
                        IFINERRORS       => '7',
                        IFOUTOCTETS      => '3427157577',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(283444792) 32 days, 19:20:47.92',
                        IFINOCTETS       => '268866403',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2095387873',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(283442119) 32 days, 19:20:21.19',
                        IFINOCTETS       => '911545598',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1184611073',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(282306267) 32 days, 16:11:02.67',
                        IFINOCTETS       => '2634719610',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3752721734',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'J142A-Amphi',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(279224229) 32 days, 7:37:22.29',
                        IFINOCTETS       => '2492870',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '85878063',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3297) 0:00:32.97',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'F13-J11B',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:4f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(277924858) 32 days, 4:00:48.58',
                        IFINOCTETS       => '41476203',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '568386769',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(102521827) 11 days, 20:46:58.27',
                        IFINOCTETS       => '399066298',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2515430057',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:51',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3390) 0:00:33.90',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:52',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3419) 0:00:34.19',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:53',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(120755527) 13 days, 23:25:55.27',
                        IFINOCTETS       => '13226590',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2768247810',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFALIAS          => 'F113-J095A',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:54',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3481) 0:00:34.81',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:55',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3513) 0:00:35.13',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:56',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3557) 0:00:35.57',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:57',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3571) 0:00:35.71',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:96:38:57:58',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3922) 0:00:39.22',
                        IFINOCTETS       => '64',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2594458902',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '0',
                        MAC              => '00:01:96:38:57:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                    },
                ]
            },
        },
    ],
    'cisco/C2951.1.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco Internetwork Operating System Software 
IOS (tm) C2950 Software (C2950-I6K2L2Q4-M), Version 12.1(22)EA13, RELEASE SOFTWARE (fc2)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by cisco Systems, Inc.
Compiled Fri 27-F',
            MAC          => '00:0c:30:50:bb:c0',
            MODEL        => 'Catalyst 2950-24',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco Internetwork Operating System Software 
IOS (tm) C2950 Software (C2950-I6K2L2Q4-M), Version 12.1(22)EA13, RELEASE SOFTWARE (fc2)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by cisco Systems, Inc.
Compiled Fri 27-F',
            MAC          => '00:0c:30:50:bb:c0',
            MODELSNMP    => 'Networking1876',
            MODEL        => 'Catalyst 2950-24',
            FIRMWARE     => undef,
            SERIAL       => 'FOC0707Y03C',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2950-24',
                COMMENTS     => 'Cisco Internetwork Operating System Software 
IOS (tm) C2950 Software (C2950-I6K2L2Q4-M), Version 12.1(22)EA13, RELEASE SOFTWARE (fc2)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by cisco Systems, Inc.
Compiled Fri 27-F',
                CONTACT      => 'Service Informatique',
                LOCATION     => 'Recherche1-loctecN',
                SERIAL       => 'FOC0707Y03C',
                MAC          => '00:0c:30:50:bb:c0',
                UPTIME       => '(308499405) 35 days, 16:56:34.05',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'C088A-R176',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303016795) 35 days, 1:42:47.95',
                        IFINOCTETS       => '60889216',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '651190139',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFALIAS          => 'C089A-R176',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2249) 0:00:22.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'C090A-R177',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303078788) 35 days, 1:53:07.88',
                        IFINOCTETS       => '179672391',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1131240344',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFALIAS          => 'C091A-R177',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303160160) 35 days, 2:06:41.60',
                        IFINOCTETS       => '109243242',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1359788681',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(304189272) 35 days, 4:58:12.72',
                        IFINOCTETS       => '292026344',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '62877405',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(258602564) 29 days, 22:20:25.64',
                        IFINOCTETS       => '2521214202',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2918189544',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFALIAS          => 'C094A-R179',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301712259) 34 days, 22:05:22.59',
                        IFINOCTETS       => '481054008',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '184708223',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFALIAS          => 'C095A-R179',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(305717982) 35 days, 9:12:59.82',
                        IFINOCTETS       => '2825764704',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3441235419',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFALIAS          => 'C096A-R180-Imprimante',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(305648793) 35 days, 9:01:27.93',
                        IFINOCTETS       => '2292422171',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '2489738042',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFALIAS          => 'C085B-R175',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:ca',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(274619951) 31 days, 18:49:59.51',
                        IFINOCTETS       => '28986718',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '293541492',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:cb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2250) 0:00:22.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFALIAS          => 'C087B-R175',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302864335) 35 days, 1:17:23.35',
                        IFINOCTETS       => '557354284',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1221356798',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'C088B-R176',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:cd',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(308490907) 35 days, 16:55:09.07',
                        IFINOCTETS       => '52929160',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2426562181',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFALIAS          => 'C096B-R180-Imprimante',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2250) 0:00:22.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'C097A-R180-Imprimante',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:cf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2250) 0:00:22.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFALIAS          => 'C098A-R181-S.Heiden',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(251528055) 29 days, 2:41:20.55',
                        IFINOCTETS       => '563162',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1629466',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFALIAS          => 'C099A-R181-S.Heiden',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303537660) 35 days, 3:09:36.60',
                        IFINOCTETS       => '1792523887',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2064844937',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFALIAS          => 'C101A-R182-Jayez-L005151',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301768979) 34 days, 22:14:49.79',
                        IFINOCTETS       => '32917425',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '95390358',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2251) 0:00:22.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFALIAS          => 'C030B-R194',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(215399437) 24 days, 22:19:54.37',
                        IFINOCTETS       => '1729564485',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1203073578',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2251) 0:00:22.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2251) 0:00:22.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => 'A8524-01L1-253',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2251) 0:00:22.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFALIAS          => 'C2950-01L1-105',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3980) 0:00:39.80',
                        IFINOCTETS       => '3672798189',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2215441865',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:96:33:58:57',
                                    '00:1b:21:2c:75:79',
                                    '00:1b:21:2c:75:7d',
                                    '00:1b:21:2c:76:65',
                                    '00:1b:21:2c:76:61',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:2b:f2:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2290) 0:00:22.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => 'Vl615',
                        IFDESCR          => 'Vlan615',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2870) 0:00:28.70',
                        IFINOCTETS       => '526252508',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3161575802',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2950-24',
                COMMENTS     => 'Cisco Internetwork Operating System Software 
IOS (tm) C2950 Software (C2950-I6K2L2Q4-M), Version 12.1(22)EA13, RELEASE SOFTWARE (fc2)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2009 by cisco Systems, Inc.
Compiled Fri 27-F',
                CONTACT      => 'Service Informatique',
                LOCATION     => 'Recherche1-loctecN',
                SERIAL       => 'FOC0707Y03C',
                MAC          => '00:0c:30:50:bb:c0',
                UPTIME       => '(308499405) 35 days, 16:56:34.05',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'C088A-R176',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303016795) 35 days, 1:42:47.95',
                        IFINOCTETS       => '60889216',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '651190139',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFALIAS          => 'C089A-R176',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2249) 0:00:22.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'C090A-R177',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303078788) 35 days, 1:53:07.88',
                        IFINOCTETS       => '179672391',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1131240344',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFALIAS          => 'C091A-R177',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303160160) 35 days, 2:06:41.60',
                        IFINOCTETS       => '109243242',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1359788681',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(304189272) 35 days, 4:58:12.72',
                        IFINOCTETS       => '292026344',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '62877405',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(258602564) 29 days, 22:20:25.64',
                        IFINOCTETS       => '2521214202',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2918189544',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFALIAS          => 'C094A-R179',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301712259) 34 days, 22:05:22.59',
                        IFINOCTETS       => '481054008',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '184708223',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFALIAS          => 'C095A-R179',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(305717982) 35 days, 9:12:59.82',
                        IFINOCTETS       => '2825764704',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3441235419',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFALIAS          => 'C096A-R180-Imprimante',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(305648793) 35 days, 9:01:27.93',
                        IFINOCTETS       => '2292422171',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '2489738042',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFALIAS          => 'C085B-R175',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:ca',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(274619951) 31 days, 18:49:59.51',
                        IFINOCTETS       => '28986718',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '293541492',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:cb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2250) 0:00:22.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFALIAS          => 'C087B-R175',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302864335) 35 days, 1:17:23.35',
                        IFINOCTETS       => '557354284',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1221356798',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'C088B-R176',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:cd',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(308490907) 35 days, 16:55:09.07',
                        IFINOCTETS       => '52929160',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2426562181',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFALIAS          => 'C096B-R180-Imprimante',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2250) 0:00:22.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'C097A-R180-Imprimante',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:cf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2250) 0:00:22.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFALIAS          => 'C098A-R181-S.Heiden',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(251528055) 29 days, 2:41:20.55',
                        IFINOCTETS       => '563162',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1629466',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFALIAS          => 'C099A-R181-S.Heiden',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303537660) 35 days, 3:09:36.60',
                        IFINOCTETS       => '1792523887',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2064844937',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFALIAS          => 'C101A-R182-Jayez-L005151',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301768979) 34 days, 22:14:49.79',
                        IFINOCTETS       => '32917425',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '95390358',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2251) 0:00:22.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFALIAS          => 'C030B-R194',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(215399437) 24 days, 22:19:54.37',
                        IFINOCTETS       => '1729564485',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1203073578',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2251) 0:00:22.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2251) 0:00:22.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => 'A8524-01L1-253',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2251) 0:00:22.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFALIAS          => 'C2950-01L1-105',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3980) 0:00:39.80',
                        IFINOCTETS       => '3672798189',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2215441865',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:96:33:58:57',
                                    '00:1b:21:2c:75:79',
                                    '00:1b:21:2c:75:7d',
                                    '00:1b:21:2c:76:65',
                                    '00:1b:21:2c:76:61',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:2b:f2:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(2290) 0:00:22.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => 'Vl615',
                        IFDESCR          => 'Vlan615',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:0c:30:50:bb:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2870) 0:00:28.70',
                        IFINOCTETS       => '526252508',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3161575802',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C2960.01.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
            SNMPHOSTNAME => 'CB-27.example.com',
            MAC          => '00:24:13:ea:a7:00',
            MODEL        => 'Catalyst 2960-24TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
            SNMPHOSTNAME => 'CB-27.example.com',
            MAC          => '00:24:13:ea:a7:00',
            MODELSNMP    => 'Networking2177',
            MODEL        => 'Catalyst 2960-24TC',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1247X5DX',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-24TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
                NAME         => 'CB-27.example.com',
                SERIAL       => 'FOC1247X5DX',
                IPS          => {
                    IP => [
                        '192.168.1.27',
                    ],
                },
                MAC          => '00:24:13:ea:a7:00',
                UPTIME       => '(329794199) 38 days, 4:05:41.99',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFALIAS          => 'MNGT',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.27',
                        MAC              => '00:24:13:ea:a7:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4607) 0:00:46.07',
                        IFINOCTETS       => '1955878377',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2756311186',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'pixin-int1-inside',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(35962354) 4 days, 3:53:43.54',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '3059673658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2957789612',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'MEDIA9-vers-CBI4061',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(45145198) 5 days, 5:24:11.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '106446611',
                        IFINERRORS       => '41',
                        IFOUTOCTETS      => '6780515',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFALIAS          => 'PIX-int0-outside-i',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3688819692) 426 days, 22:43:16.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '55117404',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1951371841',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(45289939) 5 days, 5:48:19.39',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '779472584',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '137886525',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(449117911) 51 days, 23:32:59.11',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3564203230',
                        IFINERRORS       => '86328',
                        IFOUTOCTETS      => '2567343375',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFALIAS          => 'Snort',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4259630157) 493 days, 0:18:21.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4193136023',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '274037618',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:07:e9:06:a6:be',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'Juniper-mgt',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(711110280) 82 days, 7:18:22.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2204612361',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1967389962',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:21:59:92:fb:7f',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'VPN-ASA-outside',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3688824604) 426 days, 22:44:06.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3669484140',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3228371931',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFALIAS          => 'VPN-ASA-inside',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3688836292) 426 days, 22:46:02.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1619195842',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1395113604',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:12',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:14',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:15',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFALIAS          => 'codec regie video pr CB1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:18',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(180206948) 20 days, 20:34:29.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '62439235',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '929961356',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFALIAS          => 'vers 3550',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:19',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(310281198) 35 days, 21:53:31.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1780492746',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3781185060',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0a:b8:92:56:40',
                                    '00:64:40:a6:58:c0',
                                    '00:64:40:a7:82:c0',
                                    '00:0b:fd:94:09:80',
                                    '00:0b:fd:9b:52:00',
                                    '00:0b:fd:ae:54:40',
                                    '00:0b:fd:15:ba:40',
                                    '00:0b:fd:15:bb:c0',
                                    '00:0b:5f:cc:d8:80',
                                    '00:0b:5f:cc:d8:8c',
                                    '00:0d:65:9e:18:40',
                                    '00:0d:bc:bd:66:c0',
                                    '00:0d:bd:92:3b:00',
                                    '00:0d:bd:92:4b:80',
                                    '00:0f:8f:47:91:c0',
                                    '00:d0:95:17:51:a3',
                                    '00:d0:95:3e:96:80',
                                    '00:d0:95:3e:96:83',
                                    '00:18:b9:92:08:40',
                                    '00:18:b9:b0:74:40',
                                    '00:18:b9:cc:27:c0',
                                    '00:18:b9:e3:75:c0',
                                    '00:18:b9:e3:7a:c0',
                                    '00:18:b9:e3:7e:40',
                                    '00:18:b9:e3:7f:40',
                                    '00:18:b9:e3:8e:40',
                                    '00:18:b9:e3:90:c0',
                                    '00:18:b9:e3:4d:40',
                                    '00:1a:6d:6c:f6:40',
                                    '00:1a:6d:b7:b8:40',
                                    '00:1a:6d:4f:6f:c0',
                                    '00:1a:6d:4f:74:c0',
                                    '00:1b:53:fd:d5:c0',
                                    '00:1b:54:d6:39:40',
                                    '00:1b:54:d6:3d:c0',
                                    '00:1b:54:db:6c:40',
                                    '00:1b:54:db:ec:c0',
                                    '00:1b:54:07:3c:c0',
                                    '00:1d:71:7c:77:c0',
                                    '00:21:59:94:bc:3f',
                                    '00:23:ab:dd:5d:c0',
                                    '00:24:13:a4:92:40',
                                    '00:24:13:ce:7d:40',
                                    '00:24:13:ce:d7:40',
                                    '00:24:50:06:4e:40',
                                    '00:04:dd:f9:93:00',
                                    '00:09:43:ec:d8:c0',
                                    '00:09:43:08:ea:c0',
                                    '00:09:43:09:04:00',
                                    '00:09:43:09:04:18',
                                    '00:09:43:09:08:40',
                                    '64:87:88:b0:79:41',
                                    '64:87:88:b0:7d:81',
                                    '64:87:88:b0:39:c1',
                                    '64:87:88:b0:3a:81',
                                    '64:87:88:b0:44:81',
                                    '64:87:88:b0:45:41',
                                    '6c:50:4d:f1:f7:40',
                                    '78:fe:3d:d4:b0:00',
                                    '78:fe:3d:d5:0e:ff',
                                    '78:fe:3d:df:1c:81',
                                    '78:fe:3d:df:20:01',
                                    '78:fe:3d:df:20:c1',
                                    '78:fe:3d:37:a8:c0',
                                    '78:fe:3d:37:5e:c0',
                                    'a8:d0:e5:b2:a0:c1',
                                    'a8:d0:e5:b2:ad:01',
                                    'a8:d0:e5:b2:ae:81',
                                    'a8:d0:e5:b2:be:41',
                                    'b4:a4:e3:eb:01:c0',
                                    'b4:14:89:32:00:40',
                                    'b4:14:89:38:19:c0',
                                    'b4:14:89:38:1d:40',
                                    'b4:14:89:38:22:40',
                                    'b4:14:89:38:28:c0',
                                    'b4:14:89:38:35:c0',
                                    'b4:14:89:38:38:40',
                                    'b4:14:89:38:3b:c0',
                                    'b8:ac:6f:94:57:ed',
                                    'b8:be:bf:af:f7:c0',
                                    'c4:0a:cb:ba:6d:c0',
                                    'c4:0a:cb:ba:6e:c0',
                                    'c4:0a:cb:cd:83:40',
                                    'c4:0a:cb:cd:86:40',
                                    'c4:0a:cb:cd:88:40',
                                    'c4:0a:cb:cd:8b:c0',
                                    'e8:e7:32:27:23:5f',
                                    'e8:e7:32:27:31:02',
                                    'e8:e7:32:27:38:30',
                                    'e8:e7:32:27:63:a0',
                                    'e8:e7:32:27:63:f4',
                                    'e8:e7:32:2a:e0:9e',
                                    'e8:e7:32:2a:e0:b6',
                                    'e8:e7:32:2a:e8:a4',
                                    'e8:e7:32:2a:e8:bc',
                                    'e8:e7:32:2b:c1:e2',
                                    'e8:e7:32:2b:c1:fb',
                                    'e8:e7:32:2b:cc:e7',
                                    'e8:e7:32:4b:78:f8',
                                    'e8:e7:32:4b:79:13',
                                    'e8:e7:32:4b:7b:b4',
                                    'e8:e7:32:4b:86:db',
                                    'e8:e7:32:4b:8a:cc',
                                    'e8:e7:32:4b:9b:d8',
                                    'e8:e7:32:5c:be:d3',
                                    'e8:04:62:1e:a3:c0',
                                    'e8:40:40:09:6a:40',
                                    'f4:7f:35:8a:2c:40',
                                    'f8:c0:01:c7:85:01',
                                    '2c:36:f8:7d:06:c0',
                                    '40:f4:ec:d6:80:40',
                                    '58:bc:27:78:54:40',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFALIAS          => 'LX250',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:1a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4259602380) 493 days, 0:13:43.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1622468503',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2698146544',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:19:d1:92:0c:4c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-24TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
                NAME         => 'CB-27.example.com',
                SERIAL       => 'FOC1247X5DX',
                IPS          => {
                    IP => [
                        '192.168.1.27',
                    ],
                },
                MAC          => '00:24:13:ea:a7:00',
                UPTIME       => '(329794199) 38 days, 4:05:41.99',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFALIAS          => 'MNGT',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.27',
                        MAC              => '00:24:13:ea:a7:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4607) 0:00:46.07',
                        IFINOCTETS       => '1955878377',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2756311186',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'pixin-int1-inside',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(35962354) 4 days, 3:53:43.54',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '3059673658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2957789612',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'MEDIA9-vers-CBI4061',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(45145198) 5 days, 5:24:11.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '106446611',
                        IFINERRORS       => '41',
                        IFOUTOCTETS      => '6780515',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFALIAS          => 'PIX-int0-outside-i',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3688819692) 426 days, 22:43:16.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '55117404',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1951371841',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(45289939) 5 days, 5:48:19.39',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '779472584',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '137886525',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(449117911) 51 days, 23:32:59.11',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3564203230',
                        IFINERRORS       => '86328',
                        IFOUTOCTETS      => '2567343375',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFALIAS          => 'Snort',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4259630157) 493 days, 0:18:21.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4193136023',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '274037618',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:07:e9:06:a6:be',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'Juniper-mgt',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(711110280) 82 days, 7:18:22.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2204612361',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1967389962',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:21:59:92:fb:7f',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4156) 0:00:41.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'VPN-ASA-outside',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:0f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3688824604) 426 days, 22:44:06.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3669484140',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3228371931',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFALIAS          => 'VPN-ASA-inside',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3688836292) 426 days, 22:46:02.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1619195842',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1395113604',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:12',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:14',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:15',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4157) 0:00:41.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFALIAS          => 'codec regie video pr CB1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:18',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(180206948) 20 days, 20:34:29.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '62439235',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '929961356',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFALIAS          => 'vers 3550',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:19',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(310281198) 35 days, 21:53:31.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1780492746',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3781185060',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0a:b8:92:56:40',
                                    '00:64:40:a6:58:c0',
                                    '00:64:40:a7:82:c0',
                                    '00:0b:fd:94:09:80',
                                    '00:0b:fd:9b:52:00',
                                    '00:0b:fd:ae:54:40',
                                    '00:0b:fd:15:ba:40',
                                    '00:0b:fd:15:bb:c0',
                                    '00:0b:5f:cc:d8:80',
                                    '00:0b:5f:cc:d8:8c',
                                    '00:0d:65:9e:18:40',
                                    '00:0d:bc:bd:66:c0',
                                    '00:0d:bd:92:3b:00',
                                    '00:0d:bd:92:4b:80',
                                    '00:0f:8f:47:91:c0',
                                    '00:d0:95:17:51:a3',
                                    '00:d0:95:3e:96:80',
                                    '00:d0:95:3e:96:83',
                                    '00:18:b9:92:08:40',
                                    '00:18:b9:b0:74:40',
                                    '00:18:b9:cc:27:c0',
                                    '00:18:b9:e3:75:c0',
                                    '00:18:b9:e3:7a:c0',
                                    '00:18:b9:e3:7e:40',
                                    '00:18:b9:e3:7f:40',
                                    '00:18:b9:e3:8e:40',
                                    '00:18:b9:e3:90:c0',
                                    '00:18:b9:e3:4d:40',
                                    '00:1a:6d:6c:f6:40',
                                    '00:1a:6d:b7:b8:40',
                                    '00:1a:6d:4f:6f:c0',
                                    '00:1a:6d:4f:74:c0',
                                    '00:1b:53:fd:d5:c0',
                                    '00:1b:54:d6:39:40',
                                    '00:1b:54:d6:3d:c0',
                                    '00:1b:54:db:6c:40',
                                    '00:1b:54:db:ec:c0',
                                    '00:1b:54:07:3c:c0',
                                    '00:1d:71:7c:77:c0',
                                    '00:21:59:94:bc:3f',
                                    '00:23:ab:dd:5d:c0',
                                    '00:24:13:a4:92:40',
                                    '00:24:13:ce:7d:40',
                                    '00:24:13:ce:d7:40',
                                    '00:24:50:06:4e:40',
                                    '00:04:dd:f9:93:00',
                                    '00:09:43:ec:d8:c0',
                                    '00:09:43:08:ea:c0',
                                    '00:09:43:09:04:00',
                                    '00:09:43:09:04:18',
                                    '00:09:43:09:08:40',
                                    '64:87:88:b0:79:41',
                                    '64:87:88:b0:7d:81',
                                    '64:87:88:b0:39:c1',
                                    '64:87:88:b0:3a:81',
                                    '64:87:88:b0:44:81',
                                    '64:87:88:b0:45:41',
                                    '6c:50:4d:f1:f7:40',
                                    '78:fe:3d:d4:b0:00',
                                    '78:fe:3d:d5:0e:ff',
                                    '78:fe:3d:df:1c:81',
                                    '78:fe:3d:df:20:01',
                                    '78:fe:3d:df:20:c1',
                                    '78:fe:3d:37:a8:c0',
                                    '78:fe:3d:37:5e:c0',
                                    'a8:d0:e5:b2:a0:c1',
                                    'a8:d0:e5:b2:ad:01',
                                    'a8:d0:e5:b2:ae:81',
                                    'a8:d0:e5:b2:be:41',
                                    'b4:a4:e3:eb:01:c0',
                                    'b4:14:89:32:00:40',
                                    'b4:14:89:38:19:c0',
                                    'b4:14:89:38:1d:40',
                                    'b4:14:89:38:22:40',
                                    'b4:14:89:38:28:c0',
                                    'b4:14:89:38:35:c0',
                                    'b4:14:89:38:38:40',
                                    'b4:14:89:38:3b:c0',
                                    'b8:ac:6f:94:57:ed',
                                    'b8:be:bf:af:f7:c0',
                                    'c4:0a:cb:ba:6d:c0',
                                    'c4:0a:cb:ba:6e:c0',
                                    'c4:0a:cb:cd:83:40',
                                    'c4:0a:cb:cd:86:40',
                                    'c4:0a:cb:cd:88:40',
                                    'c4:0a:cb:cd:8b:c0',
                                    'e8:e7:32:27:23:5f',
                                    'e8:e7:32:27:31:02',
                                    'e8:e7:32:27:38:30',
                                    'e8:e7:32:27:63:a0',
                                    'e8:e7:32:27:63:f4',
                                    'e8:e7:32:2a:e0:9e',
                                    'e8:e7:32:2a:e0:b6',
                                    'e8:e7:32:2a:e8:a4',
                                    'e8:e7:32:2a:e8:bc',
                                    'e8:e7:32:2b:c1:e2',
                                    'e8:e7:32:2b:c1:fb',
                                    'e8:e7:32:2b:cc:e7',
                                    'e8:e7:32:4b:78:f8',
                                    'e8:e7:32:4b:79:13',
                                    'e8:e7:32:4b:7b:b4',
                                    'e8:e7:32:4b:86:db',
                                    'e8:e7:32:4b:8a:cc',
                                    'e8:e7:32:4b:9b:d8',
                                    'e8:e7:32:5c:be:d3',
                                    'e8:04:62:1e:a3:c0',
                                    'e8:40:40:09:6a:40',
                                    'f4:7f:35:8a:2c:40',
                                    'f8:c0:01:c7:85:01',
                                    '2c:36:f8:7d:06:c0',
                                    '40:f4:ec:d6:80:40',
                                    '58:bc:27:78:54:40',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFALIAS          => 'LX250',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ea:a7:1a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4259602380) 493 days, 0:13:43.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1622468503',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2698146544',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:19:d1:92:0c:4c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C2960.02.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
            SNMPHOSTNAME => 'AP-P101-59.example.com',
            MAC          => '00:24:13:ce:d7:00',
            MODEL        => 'Catalyst 2960-24TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
            SNMPHOSTNAME => 'AP-P101-59.example.com',
            MAC          => '00:24:13:ce:d7:00',
            MODELSNMP    => 'Networking2177',
            MODEL        => 'Catalyst 2960-24TC',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1247X5D4',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-24TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
                NAME         => 'AP-P101-59.example.com',
                MEMORY       => '4',
                SERIAL       => 'FOC1247X5D4',
                MAC          => '00:24:13:ce:d7:00',
                CPU          => '81',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:40',
                        IFLASTCHANGE     => '(448584218) 51 days, 22:04:02.18',
                        IFINOCTETS       => '1969699486',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1143740170',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:01',
                        IFLASTCHANGE     => '(1666698681) 192 days, 21:43:06.81',
                        IFINOCTETS       => '160360322',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2520427958',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:02',
                        IFLASTCHANGE     => '(1288669773) 149 days, 3:38:17.73',
                        IFINOCTETS       => '1354978920',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1444296343',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:03',
                        IFLASTCHANGE     => '(1667811201) 193 days, 0:48:32.01',
                        IFINOCTETS       => '1418474807',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3697736928',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:04',
                        IFLASTCHANGE     => '(361575212) 41 days, 20:22:32.12',
                        IFINOCTETS       => '972898572',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2874278107',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:05',
                        IFLASTCHANGE     => '(361564184) 41 days, 20:20:41.84',
                        IFINOCTETS       => '842225921',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2097721511',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:06',
                        IFLASTCHANGE     => '(1460643496) 169 days, 1:20:34.96',
                        IFINOCTETS       => '612658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7517632',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:07',
                        IFLASTCHANGE     => '(1545691195) 178 days, 21:35:11.95',
                        IFINOCTETS       => '860540279',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '356275802',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:08',
                        IFLASTCHANGE     => '(1669007485) 193 days, 4:07:54.85',
                        IFINOCTETS       => '59734207',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1849411001',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:09',
                        IFLASTCHANGE     => '(1599428965) 185 days, 2:51:29.65',
                        IFINOCTETS       => '2469094479',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4060044107',
                        IFOUTERRORS      => '5',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0a',
                        IFLASTCHANGE     => '(1399544874) 161 days, 23:37:28.74',
                        IFINOCTETS       => '102950896',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '650135037',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0b',
                        IFLASTCHANGE     => '(4167) 0:00:41.67',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0c',
                        IFLASTCHANGE     => '(1666029375) 192 days, 19:51:33.75',
                        IFINOCTETS       => '43235636',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '680136759',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0d',
                        IFLASTCHANGE     => '(1286978674) 148 days, 22:56:26.74',
                        IFINOCTETS       => '239329601',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '828899275',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0e',
                        IFLASTCHANGE     => '(1668531324) 193 days, 2:48:33.24',
                        IFINOCTETS       => '330810944',
                        IFINERRORS       => '16887',
                        IFOUTOCTETS      => '1855427971',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0f',
                        IFLASTCHANGE     => '(1667075555) 192 days, 22:45:55.55',
                        IFINOCTETS       => '107079056',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1133282038',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:10',
                        IFLASTCHANGE     => '(1332165044) 154 days, 4:27:30.44',
                        IFINOCTETS       => '75627900',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '857357031',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:11',
                        IFLASTCHANGE     => '(1399546606) 161 days, 23:37:46.06',
                        IFINOCTETS       => '1569285360',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '209932792',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:12',
                        IFLASTCHANGE     => '(1659597753) 192 days, 1:59:37.53',
                        IFINOCTETS       => '62683816',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1032329852',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:13',
                        IFLASTCHANGE     => '(1660563317) 192 days, 4:40:33.17',
                        IFINOCTETS       => '148292480',
                        IFINERRORS       => '252',
                        IFOUTOCTETS      => '1865203761',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:14',
                        IFLASTCHANGE     => '(1286973610) 148 days, 22:55:36.10',
                        IFINOCTETS       => '1414423',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '37991943',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:15',
                        IFLASTCHANGE     => '(1666644488) 192 days, 21:34:04.88',
                        IFINOCTETS       => '470135831',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2845209002',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:16',
                        IFLASTCHANGE     => '(1539355445) 178 days, 3:59:14.45',
                        IFINOCTETS       => '383001306',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2428516158',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:17',
                        IFLASTCHANGE     => '(4168) 0:00:41.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:18',
                        IFLASTCHANGE     => '(4168) 0:00:41.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:19',
                        IFLASTCHANGE     => '(4168) 0:00:41.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:1a',
                        IFLASTCHANGE     => '(448584503) 51 days, 22:04:05.03',
                        IFINOCTETS       => '3449371397',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2995445287',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/5',
                                SYSNAME  => 'AP-Switch-51.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.51',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-24TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
                NAME         => 'AP-P101-59.example.com',
                MEMORY       => '4',
                SERIAL       => 'FOC1247X5D4',
                MAC          => '00:24:13:ce:d7:00',
                CPU          => '81',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:40',
                        IFLASTCHANGE     => '(448584218) 51 days, 22:04:02.18',
                        IFINOCTETS       => '1969699486',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1143740170',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:01',
                        IFLASTCHANGE     => '(1666698681) 192 days, 21:43:06.81',
                        IFINOCTETS       => '160360322',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2520427958',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:02',
                        IFLASTCHANGE     => '(1288669773) 149 days, 3:38:17.73',
                        IFINOCTETS       => '1354978920',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1444296343',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:03',
                        IFLASTCHANGE     => '(1667811201) 193 days, 0:48:32.01',
                        IFINOCTETS       => '1418474807',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3697736928',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:04',
                        IFLASTCHANGE     => '(361575212) 41 days, 20:22:32.12',
                        IFINOCTETS       => '972898572',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2874278107',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:05',
                        IFLASTCHANGE     => '(361564184) 41 days, 20:20:41.84',
                        IFINOCTETS       => '842225921',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2097721511',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:06',
                        IFLASTCHANGE     => '(1460643496) 169 days, 1:20:34.96',
                        IFINOCTETS       => '612658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7517632',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:07',
                        IFLASTCHANGE     => '(1545691195) 178 days, 21:35:11.95',
                        IFINOCTETS       => '860540279',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '356275802',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:08',
                        IFLASTCHANGE     => '(1669007485) 193 days, 4:07:54.85',
                        IFINOCTETS       => '59734207',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1849411001',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:09',
                        IFLASTCHANGE     => '(1599428965) 185 days, 2:51:29.65',
                        IFINOCTETS       => '2469094479',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4060044107',
                        IFOUTERRORS      => '5',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0a',
                        IFLASTCHANGE     => '(1399544874) 161 days, 23:37:28.74',
                        IFINOCTETS       => '102950896',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '650135037',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0b',
                        IFLASTCHANGE     => '(4167) 0:00:41.67',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0c',
                        IFLASTCHANGE     => '(1666029375) 192 days, 19:51:33.75',
                        IFINOCTETS       => '43235636',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '680136759',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0d',
                        IFLASTCHANGE     => '(1286978674) 148 days, 22:56:26.74',
                        IFINOCTETS       => '239329601',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '828899275',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0e',
                        IFLASTCHANGE     => '(1668531324) 193 days, 2:48:33.24',
                        IFINOCTETS       => '330810944',
                        IFINERRORS       => '16887',
                        IFOUTOCTETS      => '1855427971',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:0f',
                        IFLASTCHANGE     => '(1667075555) 192 days, 22:45:55.55',
                        IFINOCTETS       => '107079056',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1133282038',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:10',
                        IFLASTCHANGE     => '(1332165044) 154 days, 4:27:30.44',
                        IFINOCTETS       => '75627900',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '857357031',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:11',
                        IFLASTCHANGE     => '(1399546606) 161 days, 23:37:46.06',
                        IFINOCTETS       => '1569285360',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '209932792',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:12',
                        IFLASTCHANGE     => '(1659597753) 192 days, 1:59:37.53',
                        IFINOCTETS       => '62683816',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1032329852',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:13',
                        IFLASTCHANGE     => '(1660563317) 192 days, 4:40:33.17',
                        IFINOCTETS       => '148292480',
                        IFINERRORS       => '252',
                        IFOUTOCTETS      => '1865203761',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:14',
                        IFLASTCHANGE     => '(1286973610) 148 days, 22:55:36.10',
                        IFINOCTETS       => '1414423',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '37991943',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:15',
                        IFLASTCHANGE     => '(1666644488) 192 days, 21:34:04.88',
                        IFINOCTETS       => '470135831',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2845209002',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:16',
                        IFLASTCHANGE     => '(1539355445) 178 days, 3:59:14.45',
                        IFINOCTETS       => '383001306',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2428516158',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:17',
                        IFLASTCHANGE     => '(4168) 0:00:41.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:18',
                        IFLASTCHANGE     => '(4168) 0:00:41.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:19',
                        IFLASTCHANGE     => '(4168) 0:00:41.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:24:13:ce:d7:1a',
                        IFLASTCHANGE     => '(448584503) 51 days, 22:04:05.03',
                        IFINOCTETS       => '3449371397',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2995445287',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/5',
                                SYSNAME  => 'AP-Switch-51.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.51',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C2960.03.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
            SNMPHOSTNAME => 'CP-P101-37.example.com',
            MAC          => '00:1b:54:d6:39:00',
            MODEL        => 'Catalyst 2960-24TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
            SNMPHOSTNAME => 'CP-P101-37.example.com',
            MAC          => '00:1b:54:d6:39:00',
            MODELSNMP    => 'Networking2177',
            MODEL        => 'Catalyst 2960-24TC',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1113X1PE',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-24TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
                NAME         => 'CP-P101-37.example.com',
                MEMORY       => '4',
                SERIAL       => 'FOC1113X1PE',
                MAC          => '00:1b:54:d6:39:00',
                CPU          => '89',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:40',
                        IFLASTCHANGE     => '(4584) 0:00:45.84',
                        IFINOCTETS       => '2030921664',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '951088659',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:01',
                        IFLASTCHANGE     => '(1657748225) 191 days, 20:51:22.25',
                        IFINOCTETS       => '369925658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '926844080',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:02',
                        IFLASTCHANGE     => '(4140) 0:00:41.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:03',
                        IFLASTCHANGE     => '(1641428469) 189 days, 23:31:24.69',
                        IFINOCTETS       => '393092436',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3227489290',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:04',
                        IFLASTCHANGE     => '(4140) 0:00:41.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:05',
                        IFLASTCHANGE     => '(1668711130) 193 days, 3:18:31.30',
                        IFINOCTETS       => '521485508',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2052899224',
                        IFOUTERRORS      => '73',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:06',
                        IFLASTCHANGE     => '(4140) 0:00:41.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:07',
                        IFLASTCHANGE     => '(1149060288) 132 days, 23:50:02.88',
                        IFINOCTETS       => '152710057',
                        IFINERRORS       => '34',
                        IFOUTOCTETS      => '2698203912',
                        IFOUTERRORS      => '297',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:08',
                        IFLASTCHANGE     => '(1608943026) 186 days, 5:17:10.26',
                        IFINOCTETS       => '188163118',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1553262039',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:09',
                        IFLASTCHANGE     => '(1669071909) 193 days, 4:18:39.09',
                        IFINOCTETS       => '2609670352',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3992264533',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0a',
                        IFLASTCHANGE     => '(1651098591) 191 days, 2:23:05.91',
                        IFINOCTETS       => '49267770',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '654794463',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0b',
                        IFLASTCHANGE     => '(1512173256) 175 days, 0:28:52.56',
                        IFINOCTETS       => '257576986',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4219065024',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0c',
                        IFLASTCHANGE     => '(1512143171) 175 days, 0:23:51.71',
                        IFINOCTETS       => '36205380',
                        IFINERRORS       => '613',
                        IFOUTOCTETS      => '347903192',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IMPRIMANTE',
                                    NUMBER => '55',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0d',
                        IFLASTCHANGE     => '(1634598779) 189 days, 4:33:07.79',
                        IFINOCTETS       => '208833434',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '191680982',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0e',
                        IFLASTCHANGE     => '(4141) 0:00:41.41',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0f',
                        IFLASTCHANGE     => '(1668167389) 193 days, 1:47:53.89',
                        IFINOCTETS       => '212801623',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2383669184',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:10',
                        IFLASTCHANGE     => '(1399398381) 161 days, 23:13:03.81',
                        IFINOCTETS       => '5589',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '631494',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:11',
                        IFLASTCHANGE     => '(1667752600) 193 days, 0:38:46.00',
                        IFINOCTETS       => '1638043019',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '469166891',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:12',
                        IFLASTCHANGE     => '(4141) 0:00:41.41',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:13',
                        IFLASTCHANGE     => '(1660466187) 192 days, 4:24:21.87',
                        IFINOCTETS       => '884179267',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3400637521',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:14',
                        IFLASTCHANGE     => '(1668286829) 193 days, 2:07:48.29',
                        IFINOCTETS       => '359416168',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '756432620',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IMPRIMANTE',
                                    NUMBER => '55',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:15',
                        IFLASTCHANGE     => '(4142) 0:00:41.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:16',
                        IFLASTCHANGE     => '(1546204896) 178 days, 23:00:48.96',
                        IFINOCTETS       => '204828',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2733536359',
                        IFOUTERRORS      => '2257',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:17',
                        IFLASTCHANGE     => '(4142) 0:00:41.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:18',
                        IFLASTCHANGE     => '(182404430) 21 days, 2:40:44.30',
                        IFINOCTETS       => '2724805151',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3155157885',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '64:87:88:b0:45:41',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:19',
                        IFLASTCHANGE     => '(16491) 0:02:44.91',
                        IFINOCTETS       => '3914931489',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2654463940',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'f8:c0:01:c7:85:01',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:1a',
                        IFLASTCHANGE     => '(1366004940) 158 days, 2:27:29.40',
                        IFINOCTETS       => '2925623154',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '2183974366',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/4',
                                SYSNAME  => 'CP-Switch-101.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.101',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-24TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2011 by Cisco Systems, Inc.
Compiled Thu 05-May-11 02:53 by prod_rel_team',
                NAME         => 'CP-P101-37.example.com',
                MEMORY       => '4',
                SERIAL       => 'FOC1113X1PE',
                MAC          => '00:1b:54:d6:39:00',
                CPU          => '89',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:40',
                        IFLASTCHANGE     => '(4584) 0:00:45.84',
                        IFINOCTETS       => '2030921664',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '951088659',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:01',
                        IFLASTCHANGE     => '(1657748225) 191 days, 20:51:22.25',
                        IFINOCTETS       => '369925658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '926844080',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:02',
                        IFLASTCHANGE     => '(4140) 0:00:41.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:03',
                        IFLASTCHANGE     => '(1641428469) 189 days, 23:31:24.69',
                        IFINOCTETS       => '393092436',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3227489290',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:04',
                        IFLASTCHANGE     => '(4140) 0:00:41.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:05',
                        IFLASTCHANGE     => '(1668711130) 193 days, 3:18:31.30',
                        IFINOCTETS       => '521485508',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2052899224',
                        IFOUTERRORS      => '73',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:06',
                        IFLASTCHANGE     => '(4140) 0:00:41.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:07',
                        IFLASTCHANGE     => '(1149060288) 132 days, 23:50:02.88',
                        IFINOCTETS       => '152710057',
                        IFINERRORS       => '34',
                        IFOUTOCTETS      => '2698203912',
                        IFOUTERRORS      => '297',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:08',
                        IFLASTCHANGE     => '(1608943026) 186 days, 5:17:10.26',
                        IFINOCTETS       => '188163118',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1553262039',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:09',
                        IFLASTCHANGE     => '(1669071909) 193 days, 4:18:39.09',
                        IFINOCTETS       => '2609670352',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3992264533',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0a',
                        IFLASTCHANGE     => '(1651098591) 191 days, 2:23:05.91',
                        IFINOCTETS       => '49267770',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '654794463',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0b',
                        IFLASTCHANGE     => '(1512173256) 175 days, 0:28:52.56',
                        IFINOCTETS       => '257576986',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4219065024',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0c',
                        IFLASTCHANGE     => '(1512143171) 175 days, 0:23:51.71',
                        IFINOCTETS       => '36205380',
                        IFINERRORS       => '613',
                        IFOUTOCTETS      => '347903192',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan51',
                                    NUMBER => '55',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0d',
                        IFLASTCHANGE     => '(1634598779) 189 days, 4:33:07.79',
                        IFINOCTETS       => '208833434',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '191680982',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0e',
                        IFLASTCHANGE     => '(4141) 0:00:41.41',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:0f',
                        IFLASTCHANGE     => '(1668167389) 193 days, 1:47:53.89',
                        IFINOCTETS       => '212801623',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2383669184',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:10',
                        IFLASTCHANGE     => '(1399398381) 161 days, 23:13:03.81',
                        IFINOCTETS       => '5589',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '631494',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:11',
                        IFLASTCHANGE     => '(1667752600) 193 days, 0:38:46.00',
                        IFINOCTETS       => '1638043019',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '469166891',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:12',
                        IFLASTCHANGE     => '(4141) 0:00:41.41',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:13',
                        IFLASTCHANGE     => '(1660466187) 192 days, 4:24:21.87',
                        IFINOCTETS       => '884179267',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3400637521',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:14',
                        IFLASTCHANGE     => '(1668286829) 193 days, 2:07:48.29',
                        IFINOCTETS       => '359416168',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '756432620',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan51',
                                    NUMBER => '55',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:15',
                        IFLASTCHANGE     => '(4142) 0:00:41.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:16',
                        IFLASTCHANGE     => '(1546204896) 178 days, 23:00:48.96',
                        IFINOCTETS       => '204828',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2733536359',
                        IFOUTERRORS      => '2257',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:17',
                        IFLASTCHANGE     => '(4142) 0:00:41.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:18',
                        IFLASTCHANGE     => '(182404430) 21 days, 2:40:44.30',
                        IFINOCTETS       => '2724805151',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3155157885',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '64:87:88:b0:45:41',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:19',
                        IFLASTCHANGE     => '(16491) 0:02:44.91',
                        IFINOCTETS       => '3914931489',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2654463940',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'f8:c0:01:c7:85:01',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:54:d6:39:1a',
                        IFLASTCHANGE     => '(1366004940) 158 days, 2:27:29.40',
                        IFINOCTETS       => '2925623154',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '2183974366',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/4',
                                SYSNAME  => 'CP-Switch-101.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.101',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C2960.04.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE1, RELEASE SOFTWARE (fc2)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Mon 06-Apr-09 08:36 by amvarma',
            MAC          => '00:1a:6d:9d:23:00',
            MODEL        => 'Catalyst 2960-48TT',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE1, RELEASE SOFTWARE (fc2)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Mon 06-Apr-09 08:36 by amvarma',
            MAC          => '00:1a:6d:9d:23:00',
            MODELSNMP    => 'Networking1956',
            MODEL        => 'Catalyst 2960-48TT',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1049Z7RN',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TT',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE1, RELEASE SOFTWARE (fc2)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Mon 06-Apr-09 08:36 by amvarma',
                LOCATION     => 'Recherche1-loctecN',
                SERIAL       => 'FOC1049Z7RN',
                MAC          => '00:1a:6d:9d:23:00',
                UPTIME       => '(308478285) 35 days, 16:53:02.85',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:40',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(4144) 0:00:41.44',
                        IFINOCTETS       => '3516',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '615',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:41',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7886) 0:01:18.86',
                        IFINOCTETS       => '2251471785',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '286127141',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'C046A-R131',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:01',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(274486595) 31 days, 18:27:45.95',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '8377',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8039',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFALIAS          => 'C047A-R131',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4356) 0:00:43.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'C057B-R161',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4356) 0:00:43.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFALIAS          => 'C043B-R133',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4356) 0:00:43.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFALIAS          => 'C048B-R157 F.Lupu-Dell-Scale 00:08:74:1e:46:7b',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:05',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(249372923) 28 days, 20:42:09.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1054580',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3806443766',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(299914444) 34 days, 17:05:44.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2096941',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '977213699',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(179157864) 20 days, 17:39:38.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3931513',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2396979049',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8574) 0:01:25.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2366114',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2005431730',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'C057A-R161 B.Pateyron 00:03:93:ac:33:48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(268534034) 31 days, 1:55:40.34',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '381991911',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1003764265',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302884951) 35 days, 1:20:49.51',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '79575793',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '651793413',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'C059A-M.Guezzah 00:11:43:a4:c8:5c',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(235757413) 27 days, 6:52:54.13',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '67899905',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '208408457',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFALIAS          => 'C060A-R163 Lafon',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4559) 0:00:45.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '394681957',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:12',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303482260) 35 days, 3:00:22.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2420463446',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1961681052',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:14',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303271002) 35 days, 2:25:10.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4021716383',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2269332039',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFALIAS          => 'C059B-R163 Mehdi Guezzah Serveur Win',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:15',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302190971) 34 days, 23:25:09.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '211747976',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3802961593',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFALIAS          => 'C71B',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276176642) 31 days, 23:09:26.42',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1509322',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '16797448',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => 'onduleur',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:18',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'Fa0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:19',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'Fa0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301989661) 34 days, 22:51:36.61',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '9565924',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '116408328',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'Fa0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(245765225) 28 days, 10:40:52.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3452382522',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3680075113',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'Fa0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(207446855) 24 days, 0:14:28.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '51170836',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '934210769',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'Fa0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'Fa0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(179376296) 20 days, 18:16:02.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8805389',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '625009670',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'Fa0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(251422216) 29 days, 2:23:42.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '98215557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '48570148',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'Fa0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4358) 0:00:43.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'Fa0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:21',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4358) 0:00:43.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'Fa0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:22',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303975821) 35 days, 4:22:38.21',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1406916349',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1184498155',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'Fa0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFALIAS          => 'conf_inter',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:23',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(296990528) 34 days, 8:58:25.28',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4022754',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '341153770',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'Fa0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:24',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4358) 0:00:43.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'Fa0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:25',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(275058029) 31 days, 20:03:00.29',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '861396',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5073664',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'Fa0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:26',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(308468383) 35 days, 16:51:23.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '305488102',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3020738923',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'Fa0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4358) 0:00:43.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'Fa0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:28',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(257597766) 29 days, 19:32:57.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3485684785',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2816523712',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'Fa0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:29',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301739265) 34 days, 22:09:52.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2106724549',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1169216285',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'Fa0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303457383) 35 days, 2:56:13.83',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '570676480',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1439884782',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'Fa0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(213879972) 24 days, 18:06:39.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12256557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1641139230',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'Fa0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4359) 0:00:43.59',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'Fa0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4359) 0:00:43.59',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'Fa0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(259319200) 30 days, 0:19:52.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1748345',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1092855',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'Fa0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(267746706) 30 days, 23:44:27.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '15102369',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '785002890',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'Fa0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFALIAS          => 'D-h2610-poe-01L1-5026.Interface.26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4872) 0:00:48.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1892565339',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1906464200',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'b4:39:d6:49:5b:a6',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:31',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(14025619) 1 day, 14:57:36.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '174630655',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '839081165',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1b:21:2c:75:79',
                                    '00:1b:21:2c:75:7d',
                                    '00:1b:21:2c:76:65',
                                    '00:1b:21:2c:76:61',
                                    '00:1e:7a:f5:09:47',
                                    'c4:64:13:11:31:81',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:2b:f2:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:32',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4359) 0:00:43.59',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TT',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE1, RELEASE SOFTWARE (fc2)
Copyright (c) 1986-2009 by Cisco Systems, Inc.
Compiled Mon 06-Apr-09 08:36 by amvarma',
                LOCATION     => 'Recherche1-loctecN',
                SERIAL       => 'FOC1049Z7RN',
                MAC          => '00:1a:6d:9d:23:00',
                UPTIME       => '(308478285) 35 days, 16:53:02.85',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:40',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(4144) 0:00:41.44',
                        IFINOCTETS       => '3516',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '615',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:41',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7886) 0:01:18.86',
                        IFINOCTETS       => '2251471785',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '286127141',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'C046A-R131',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:01',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(274486595) 31 days, 18:27:45.95',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '8377',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8039',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFALIAS          => 'C047A-R131',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4356) 0:00:43.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'C057B-R161',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4356) 0:00:43.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFALIAS          => 'C043B-R133',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4356) 0:00:43.56',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFALIAS          => 'C048B-R157 F.Lupu-Dell-Scale 00:08:74:1e:46:7b',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:05',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(249372923) 28 days, 20:42:09.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1054580',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3806443766',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(299914444) 34 days, 17:05:44.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2096941',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '977213699',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(179157864) 20 days, 17:39:38.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3931513',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2396979049',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(8574) 0:01:25.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2366114',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2005431730',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFALIAS          => 'C057A-R161 B.Pateyron 00:03:93:ac:33:48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(268534034) 31 days, 1:55:40.34',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '381991911',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1003764265',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302884951) 35 days, 1:20:49.51',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '79575793',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '651793413',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFALIAS          => 'C059A-M.Guezzah 00:11:43:a4:c8:5c',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(235757413) 27 days, 6:52:54.13',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '67899905',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '208408457',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFALIAS          => 'C060A-R163 Lafon',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4559) 0:00:45.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '394681957',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:12',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303482260) 35 days, 3:00:22.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2420463446',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1961681052',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:14',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303271002) 35 days, 2:25:10.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4021716383',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2269332039',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFALIAS          => 'C059B-R163 Mehdi Guezzah Serveur Win',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:15',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302190971) 34 days, 23:25:09.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '211747976',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3802961593',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFALIAS          => 'C71B',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276176642) 31 days, 23:09:26.42',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1509322',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '16797448',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => 'onduleur',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:18',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'Fa0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:19',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'Fa0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301989661) 34 days, 22:51:36.61',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '9565924',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '116408328',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'Fa0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(245765225) 28 days, 10:40:52.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3452382522',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3680075113',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'Fa0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(207446855) 24 days, 0:14:28.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '51170836',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '934210769',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'Fa0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'Fa0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(179376296) 20 days, 18:16:02.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8805389',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '625009670',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'Fa0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:1f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(251422216) 29 days, 2:23:42.16',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '98215557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '48570148',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'Fa0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4358) 0:00:43.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'Fa0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:21',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4358) 0:00:43.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'Fa0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:22',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303975821) 35 days, 4:22:38.21',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1406916349',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1184498155',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'Fa0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFALIAS          => 'conf_inter',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:23',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(296990528) 34 days, 8:58:25.28',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4022754',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '341153770',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'Fa0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:24',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4358) 0:00:43.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'Fa0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:25',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(275058029) 31 days, 20:03:00.29',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '861396',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5073664',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'Fa0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:26',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(308468383) 35 days, 16:51:23.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '305488102',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3020738923',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'Fa0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4358) 0:00:43.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'Fa0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:28',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(257597766) 29 days, 19:32:57.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3485684785',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2816523712',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'Fa0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:29',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301739265) 34 days, 22:09:52.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2106724549',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1169216285',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'Fa0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303457383) 35 days, 2:56:13.83',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '570676480',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1439884782',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'Fa0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(213879972) 24 days, 18:06:39.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12256557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1641139230',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'Fa0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4359) 0:00:43.59',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'Fa0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4359) 0:00:43.59',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'Fa0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(259319200) 30 days, 0:19:52.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1748345',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1092855',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'Fa0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:2f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(267746706) 30 days, 23:44:27.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '15102369',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '785002890',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'Fa0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFALIAS          => 'D-h2610-poe-01L1-5026.Interface.26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4872) 0:00:48.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1892565339',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1906464200',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'b4:39:d6:49:5b:a6',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:31',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(14025619) 1 day, 14:57:36.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '174630655',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '839081165',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1b:21:2c:75:79',
                                    '00:1b:21:2c:75:7d',
                                    '00:1b:21:2c:76:65',
                                    '00:1b:21:2c:76:61',
                                    '00:1e:7a:f5:09:47',
                                    'c4:64:13:11:31:81',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:2b:f2:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:6d:9d:23:32',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4359) 0:00:43.59',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C2960.05.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(55)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Thu 09-Feb-12 19:11 by prod_rel_team',
            SNMPHOSTNAME => 'c2960-EPCS-BUS.upmf-grenoble.fr',
            MAC          => '00:23:ab:ee:a5:80',
            MODEL        => 'Catalyst 2960-24TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(55)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Thu 09-Feb-12 19:11 by prod_rel_team',
            SNMPHOSTNAME => 'c2960-EPCS-BUS.upmf-grenoble.fr',
            MAC          => '00:23:ab:ee:a5:80',
            MODELSNMP    => 'Networking2414',
            MODEL        => 'Catalyst 2960-24TC',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-24TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(55)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Thu 09-Feb-12 19:11 by prod_rel_team',
                CONTACT      => 'DSI-UPMF',
                NAME         => 'c2960-EPCS-BUS.upmf-grenoble.fr',
                MEMORY       => '6',
                LOCATION     => 'EPCS BU Science',
                SERIAL       => 'FOC1241Y71V',
                IPS          => {
                    IP => [
                        '192.168.41.5',
                    ],
                },
                MAC          => '00:23:ab:ee:a5:80',
                UPTIME       => '(3199666574) 370 days, 7:57:45.74',
                CPU          => '90',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.41.5',
                        MAC              => '00:23:ab:ee:a5:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(12470) 0:02:04.70',
                        IFINOCTETS       => '1831102020',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '452835120',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:81',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3182628609) 368 days, 8:38:06.09',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3198893136',
                        IFINERRORS       => '4',
                        IFOUTOCTETS      => '2203739927',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:82',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1858007511) 215 days, 1:07:55.11',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3782914706',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '563166274',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:83',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3191055028) 369 days, 8:02:30.28',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1388715534',
                        IFINERRORS       => '35',
                        IFOUTOCTETS      => '2642071911',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:84',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198617624) 370 days, 5:02:56.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '490700668',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1007620227',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:85',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2585925143) 299 days, 7:07:31.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3787298571',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1012724965',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:86',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198638098) 370 days, 5:06:20.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2235202255',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3990529391',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:87',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3197464634) 370 days, 1:50:46.34',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '12478633',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3651328826',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:88',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3197309548) 370 days, 1:24:55.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2347372403',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3663108698',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:91:76:7f:f6',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:89',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198813924) 370 days, 5:35:39.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2657299622',
                        IFINERRORS       => '5561',
                        IFOUTOCTETS      => '2966756788',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:8a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3196920693) 370 days, 0:20:06.93',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2448688226',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '3611966297',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '84:2b:2b:b1:ed:68',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:8b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3182520772) 368 days, 8:20:07.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '815073811',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1224520218',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:8c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2392795661) 276 days, 22:39:16.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3862380364',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2814041318',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:02:b6:34:a1:a2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:8d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1858466106) 215 days, 2:24:21.06',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4016665634',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '425265888',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:8e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2540088200) 293 days, 23:48:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2297084715',
                        IFINERRORS       => '309',
                        IFOUTOCTETS      => '673908275',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:8f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3199623649) 370 days, 7:50:36.49',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3243135598',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '3753265179',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:90',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198063490) 370 days, 3:30:34.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1523358754',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1024098233',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:18:8b:dd:b8:ff',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:91',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1857560496) 214 days, 23:53:24.96',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1472338610',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4142159903',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:92',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3197213862) 370 days, 1:08:58.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '443644944',
                        IFINERRORS       => '165',
                        IFOUTOCTETS      => '1636922513',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'e0:db:55:8e:ae:a8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:93',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3059349219) 354 days, 2:11:32.19',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '359553750',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1285612176',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:94',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2795518397) 323 days, 13:19:43.97',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '416484789',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '68643548',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:95',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1849608813) 214 days, 1:48:08.13',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '402076116',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3887163874',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198900476) 370 days, 5:50:04.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1233968432',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '246034158',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd0:67:e5:52:86:81',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => '-> Onduleur',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:97',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(9368) 0:01:33.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2199902160',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4215498285',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'Technique',
                                    NUMBER => '66',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:85:fd:d7:75',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFALIAS          => 'Borne 1142N Hall Rdc',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:98',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(9368) 0:01:33.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '325624267',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '3378263280',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'Nomadisme2',
                                    NUMBER => '9',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet0',
                                SYSNAME  => 'u2-bus-rdc',
                                SYSDESCR => '"Cisco IOS Software, C1140 Software (C1140-K9W8-M), Version 12.4(23c)JA7, RELEASE SOFTWARE (fc1)',
                                IP       => '10.2.9.95',
                                MODEL    => 'cisco AIR-LAP1142N-E-K9   ',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:99',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(9005) 0:01:30.05',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:9a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(9568) 0:01:35.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1367494003',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4041972369',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet1/0/1',
                                SYSNAME  => 'c3750-EPCS-SiMSU.upmf-grenoble.fr',
                                SYSDESCR => '"Cisco IOS Software, C3750 Software (C3750-IPBASEK9-M), Version 12.2(55)SE6, RELEASE SOFTWARE (fc1)',
                                IP       => '192.168.41.13',
                                MODEL    => 'cisco WS-C3750G-12S',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-24TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(55)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Thu 09-Feb-12 19:11 by prod_rel_team',
                CONTACT      => 'DSI-UPMF',
                NAME         => 'c2960-EPCS-BUS.upmf-grenoble.fr',
                MEMORY       => '6',
                LOCATION     => 'EPCS BU Science',
                SERIAL       => 'FOC1241Y71V',
                IPS          => {
                    IP => [
                        '192.168.41.5',
                    ],
                },
                MAC          => '00:23:ab:ee:a5:80',
                UPTIME       => '(3199666574) 370 days, 7:57:45.74',
                CPU          => '90',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.41.5',
                        MAC              => '00:23:ab:ee:a5:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(12470) 0:02:04.70',
                        IFINOCTETS       => '1831102020',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '452835120',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:81',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3182628609) 368 days, 8:38:06.09',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3198893136',
                        IFINERRORS       => '4',
                        IFOUTOCTETS      => '2203739927',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:82',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1858007511) 215 days, 1:07:55.11',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3782914706',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '563166274',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:83',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3191055028) 369 days, 8:02:30.28',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1388715534',
                        IFINERRORS       => '35',
                        IFOUTOCTETS      => '2642071911',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:84',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198617624) 370 days, 5:02:56.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '490700668',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1007620227',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:85',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2585925143) 299 days, 7:07:31.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3787298571',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1012724965',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:86',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198638098) 370 days, 5:06:20.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2235202255',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3990529391',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:87',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3197464634) 370 days, 1:50:46.34',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '12478633',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3651328826',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:88',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3197309548) 370 days, 1:24:55.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2347372403',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3663108698',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:91:76:7f:f6',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:89',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198813924) 370 days, 5:35:39.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2657299622',
                        IFINERRORS       => '5561',
                        IFOUTOCTETS      => '2966756788',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:8a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3196920693) 370 days, 0:20:06.93',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2448688226',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '3611966297',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '84:2b:2b:b1:ed:68',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:8b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3182520772) 368 days, 8:20:07.72',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '815073811',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1224520218',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:8c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2392795661) 276 days, 22:39:16.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3862380364',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2814041318',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:02:b6:34:a1:a2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:8d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1858466106) 215 days, 2:24:21.06',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4016665634',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '425265888',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:8e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2540088200) 293 days, 23:48:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2297084715',
                        IFINERRORS       => '309',
                        IFOUTOCTETS      => '673908275',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:8f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3199623649) 370 days, 7:50:36.49',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3243135598',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '3753265179',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:90',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198063490) 370 days, 3:30:34.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1523358754',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1024098233',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:18:8b:dd:b8:ff',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:91',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1857560496) 214 days, 23:53:24.96',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1472338610',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4142159903',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:92',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3197213862) 370 days, 1:08:58.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '443644944',
                        IFINERRORS       => '165',
                        IFOUTOCTETS      => '1636922513',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'e0:db:55:8e:ae:a8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:93',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3059349219) 354 days, 2:11:32.19',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '359553750',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1285612176',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:94',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2795518397) 323 days, 13:19:43.97',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '416484789',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '68643548',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:95',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1849608813) 214 days, 1:48:08.13',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '402076116',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3887163874',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198900476) 370 days, 5:50:04.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1233968432',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '246034158',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd0:67:e5:52:86:81',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => '-> Onduleur',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:97',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(9368) 0:01:33.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2199902160',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4215498285',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'Technique',
                                    NUMBER => '66',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:85:fd:d7:75',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFALIAS          => 'Borne 1142N Hall Rdc',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:98',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(9368) 0:01:33.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '325624267',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '3378263280',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'Nomadisme2',
                                    NUMBER => '9',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet0',
                                SYSNAME  => 'u2-bus-rdc',
                                SYSDESCR => '"Cisco IOS Software, C1140 Software (C1140-K9W8-M), Version 12.4(23c)JA7, RELEASE SOFTWARE (fc1)',
                                IP       => '10.2.9.95',
                                MODEL    => 'cisco AIR-LAP1142N-E-K9   ',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:99',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(9005) 0:01:30.05',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:ab:ee:a5:9a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(9568) 0:01:35.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1367494003',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4041972369',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet1/0/1',
                                SYSNAME  => 'c3750-EPCS-SiMSU.upmf-grenoble.fr',
                                SYSDESCR => '"Cisco IOS Software, C3750 Software (C3750-IPBASEK9-M), Version 12.2(55)SE6, RELEASE SOFTWARE (fc1)',
                                IP       => '192.168.41.13',
                                MODEL    => 'cisco WS-C3750G-12S',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C2960.07.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(55)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Thu 09-Feb-12 19:11 by prod_rel_team',
            SNMPHOSTNAME => 'c2960-EPCS-Taillees.upmf-grenoble.fr',
            MAC          => '28:93:fe:8f:dd:00',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(55)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Thu 09-Feb-12 19:11 by prod_rel_team',
            SNMPHOSTNAME => 'c2960-EPCS-Taillees.upmf-grenoble.fr',
            MAC          => '28:93:fe:8f:dd:00',
            MODELSNMP    => 'Networking2414',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => undef,
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(55)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Thu 09-Feb-12 19:11 by prod_rel_team',
                CONTACT      => 'DSI-UPMF',
                NAME         => 'c2960-EPCS-Taillees.upmf-grenoble.fr',
                MEMORY       => '6',
                LOCATION     => 'LT EPCS Les Taillees',
                SERIAL       => 'FOC1413V2QF',
                IPS          => {
                    IP => [
                        '192.168.41.3',
                    ],
                },
                MAC          => '28:93:fe:8f:dd:00',
                UPTIME       => '(4283884397) 495 days, 19:40:43.97',
                CPU          => '90',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.41.3',
                        MAC              => '28:93:fe:8f:dd:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(817697724) 94 days, 15:22:57.24',
                        IFINOCTETS       => '803067843',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '730933728',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:01',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2236131549) 258 days, 19:28:35.49',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '313543785',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '291158367',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4238634978) 490 days, 13:59:09.78',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2666961037',
                        IFINERRORS       => '78',
                        IFOUTOCTETS      => '1629002601',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2909166491) 336 days, 17:01:04.91',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '166868',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '538750',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'SAH',
                                    NUMBER => '54',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283416693) 495 days, 18:22:46.93',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1171315503',
                        IFINERRORS       => '4',
                        IFOUTOCTETS      => '2349223155',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'e0:db:55:e4:74:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283128543) 495 days, 17:34:45.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1267189897',
                        IFINERRORS       => '14',
                        IFOUTOCTETS      => '389850287',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:69:ad:96',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(9697) 0:01:36.97',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283741388) 495 days, 19:16:53.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2877704051',
                        IFINERRORS       => '13120',
                        IFOUTOCTETS      => '2574944565',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:b9:e8:82:db',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281082961) 495 days, 11:53:49.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1127178671',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1646783098',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd0:67:e5:43:3e:22',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2390485435) 276 days, 16:14:14.35',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2429540',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '47553944',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2053910494) 237 days, 17:18:24.94',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '122474200',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2096469934',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4042009409) 467 days, 19:48:14.09',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1202000',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7619193',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281241149) 495 days, 12:20:11.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '858388741',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3082242544',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1a:a0:d0:87:07',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:0d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283186698) 495 days, 17:44:26.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '179847605',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '653447366',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:04:00:3d:26:34',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:0e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281163214) 495 days, 12:07:12.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '944503547',
                        IFINERRORS       => '3',
                        IFOUTOCTETS      => '1251160073',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '84:2b:2b:b1:ee:b2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:0f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281055605) 495 days, 11:49:16.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '53543948',
                        IFINERRORS       => '9',
                        IFOUTOCTETS      => '1979698524',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'f0:4d:a2:b6:fc:8e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4057094127) 469 days, 13:42:21.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1276411776',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2344785629',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:04:00:3d:c6:42',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281288256) 495 days, 12:28:02.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4236945779',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1722241397',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '84:2b:2b:b1:e6:ad',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:12',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281099781) 495 days, 11:56:37.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3940026413',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3686953901',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:23:ae:8e:c6:d2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2873711885) 332 days, 14:31:58.85',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3806482229',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1357091899',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:14',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3427720433) 396 days, 17:26:44.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4159917262',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1895719700',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:21:b7:62:e1:38',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:15',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4282659235) 495 days, 16:16:32.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3365776866',
                        IFINERRORS       => '12',
                        IFOUTOCTETS      => '1276853914',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:62:bb:77',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:16',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4280850908) 495 days, 11:15:09.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1558642713',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1813533913',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:24:e8:25:12:bb',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:17',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4111201540) 475 days, 20:00:15.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2709779424',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3561471721',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:73:6e:df:6e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:18',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3866680655) 447 days, 12:46:46.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2742442105',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '593744800',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:91:76:89:b8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'Fa0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:19',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4282944521) 495 days, 17:04:05.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3868224162',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3715955432',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd0:67:e5:43:bc:d2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'Fa0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:1a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283091882) 495 days, 17:28:38.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '124558331',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1484605688',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd0:67:e5:45:b8:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'Fa0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:1b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4264062899) 493 days, 12:37:08.99',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1418190059',
                        IFINERRORS       => '7',
                        IFOUTOCTETS      => '1844373820',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:2b:cb:d7:c5:53',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'Fa0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4280871512) 495 days, 11:18:35.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1697993342',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4086735564',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:0b:97:b0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'Fa0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:1d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4282541241) 495 days, 15:56:52.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4212583692',
                        IFINERRORS       => '82',
                        IFOUTOCTETS      => '2472825409',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '5c:26:0a:29:ab:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'Fa0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:1e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4282281126) 495 days, 15:13:31.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3092337694',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1654120821',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'Fa0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:1f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(9698) 0:01:36.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'SAH',
                                    NUMBER => '54',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'Fa0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(9698) 0:01:36.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'Poubelle',
                                    NUMBER => '211',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'Fa0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:21',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283138206) 495 days, 17:36:22.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1277050834',
                        IFINERRORS       => '3',
                        IFOUTOCTETS      => '3773359497',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:00:3f:cd',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'Fa0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:22',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4276035002) 494 days, 21:52:30.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2876949985',
                        IFINERRORS       => '85808',
                        IFOUTOCTETS      => '716903246',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'Fa0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:23',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283058559) 495 days, 17:23:05.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2360444253',
                        IFINERRORS       => '18262',
                        IFOUTOCTETS      => '1047027080',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'a4:ba:db:b9:a8:99',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'Fa0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:24',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4273563897) 494 days, 15:00:38.97',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '8927268',
                        IFINERRORS       => '4',
                        IFOUTOCTETS      => '247880465',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'Fa0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281391088) 495 days, 12:45:10.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '269815376',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1119302885',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:b9:e3:98:e1',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'Fa0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:26',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1277570437) 147 days, 20:48:24.37',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3677831255',
                        IFINERRORS       => '4',
                        IFOUTOCTETS      => '562894676',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'Fa0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4275681634) 494 days, 20:53:36.34',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2670820214',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '3163911118',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'Fa0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:28',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4275103930) 494 days, 19:17:19.30',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3794463830',
                        IFINERRORS       => '71',
                        IFOUTOCTETS      => '463403809',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'Fa0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:29',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3780459843) 437 days, 13:16:38.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3543238842',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3832872792',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:30:6e:d2:96:d7',
                                    'b8:ca:3a:c4:31:6f',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'Fa0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:2a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4103532871) 474 days, 22:42:08.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '190445355',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '251642046',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:36:46:e0:43',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'Fa0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281018271) 495 days, 11:43:02.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2901610822',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '2741306352',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:16:a6:73',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'Fa0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:2c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4275146615) 494 days, 19:24:26.15',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '432518314',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '911596838',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'Fa0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:2d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4267569395) 493 days, 22:21:33.95',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1958434912',
                        IFINERRORS       => '805',
                        IFOUTOCTETS      => '3203796546',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'Fa0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFALIAS          => '-> AP WiFi 1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:2e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(10003) 0:01:40.03',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3533982611',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1513241820',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'Nomadisme2',
                                    NUMBER => '9',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet0',
                                SYSNAME  => 'u2-taillees-b-1',
                                SYSDESCR => '"Cisco IOS Software, C1140 Software (C1140-K9W8-M), Version 12.4(23c)JA7, RELEASE SOFTWARE (fc1)',
                                IP       => '10.2.9.82',
                                MODEL    => 'cisco AIR-LAP1142N-E-K9   ',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'Fa0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFALIAS          => '-> AP WiFi 2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:2f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(10004) 0:01:40.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3993677431',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1774362429',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'Nomadisme2',
                                    NUMBER => '9',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet0',
                                SYSNAME  => 'u2-taillees-b-2',
                                SYSDESCR => '"Cisco IOS Software, C1140 Software (C1140-K9W8-M), Version 12.4(23c)JA7, RELEASE SOFTWARE (fc1)',
                                IP       => '10.2.9.83',
                                MODEL    => 'cisco AIR-LAP1142N-E-K9   ',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'Fa0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFALIAS          => '-> MGE-EV650-EPCS',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(653902094) 75 days, 16:23:40.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2224585968',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2219504516',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'Technique',
                                    NUMBER => '66',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:85:fd:76:13',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:31',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(9630) 0:01:36.30',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:32',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(817694820) 94 days, 15:22:28.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2670289548',
                        IFINERRORS       => '7',
                        IFOUTOCTETS      => '3093941096',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/48',
                                SYSNAME  => 'c2950-SAH-Taillees.upmf-grenoble.fr',
                                SYSDESCR => '"Cisco Internetwork Operating System Software ',
                                IP       => '192.168.41.74',
                                MODEL    => 'cisco WS-C2950G-48-EI',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(55)SE5, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Thu 09-Feb-12 19:11 by prod_rel_team',
                CONTACT      => 'DSI-UPMF',
                NAME         => 'c2960-EPCS-Taillees.upmf-grenoble.fr',
                MEMORY       => '6',
                LOCATION     => 'LT EPCS Les Taillees',
                SERIAL       => 'FOC1413V2QF',
                IPS          => {
                    IP => [
                        '192.168.41.3',
                    ],
                },
                MAC          => '28:93:fe:8f:dd:00',
                UPTIME       => '(4283884397) 495 days, 19:40:43.97',
                CPU          => '90',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.41.3',
                        MAC              => '28:93:fe:8f:dd:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(817697724) 94 days, 15:22:57.24',
                        IFINOCTETS       => '803067843',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '730933728',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:01',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2236131549) 258 days, 19:28:35.49',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '313543785',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '291158367',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4238634978) 490 days, 13:59:09.78',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2666961037',
                        IFINERRORS       => '78',
                        IFOUTOCTETS      => '1629002601',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2909166491) 336 days, 17:01:04.91',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '166868',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '538750',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'SAH',
                                    NUMBER => '54',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283416693) 495 days, 18:22:46.93',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1171315503',
                        IFINERRORS       => '4',
                        IFOUTOCTETS      => '2349223155',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'e0:db:55:e4:74:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283128543) 495 days, 17:34:45.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1267189897',
                        IFINERRORS       => '14',
                        IFOUTOCTETS      => '389850287',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:69:ad:96',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(9697) 0:01:36.97',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283741388) 495 days, 19:16:53.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2877704051',
                        IFINERRORS       => '13120',
                        IFOUTOCTETS      => '2574944565',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:b9:e8:82:db',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281082961) 495 days, 11:53:49.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1127178671',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1646783098',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd0:67:e5:43:3e:22',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2390485435) 276 days, 16:14:14.35',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2429540',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '47553944',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2053910494) 237 days, 17:18:24.94',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '122474200',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2096469934',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4042009409) 467 days, 19:48:14.09',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1202000',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7619193',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281241149) 495 days, 12:20:11.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '858388741',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3082242544',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1a:a0:d0:87:07',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:0d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283186698) 495 days, 17:44:26.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '179847605',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '653447366',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:04:00:3d:26:34',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:0e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281163214) 495 days, 12:07:12.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '944503547',
                        IFINERRORS       => '3',
                        IFOUTOCTETS      => '1251160073',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '84:2b:2b:b1:ee:b2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:0f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281055605) 495 days, 11:49:16.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '53543948',
                        IFINERRORS       => '9',
                        IFOUTOCTETS      => '1979698524',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'f0:4d:a2:b6:fc:8e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4057094127) 469 days, 13:42:21.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1276411776',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2344785629',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:04:00:3d:c6:42',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281288256) 495 days, 12:28:02.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4236945779',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1722241397',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '84:2b:2b:b1:e6:ad',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:12',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281099781) 495 days, 11:56:37.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3940026413',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3686953901',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:23:ae:8e:c6:d2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2873711885) 332 days, 14:31:58.85',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3806482229',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1357091899',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:14',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3427720433) 396 days, 17:26:44.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4159917262',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1895719700',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:21:b7:62:e1:38',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:15',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4282659235) 495 days, 16:16:32.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3365776866',
                        IFINERRORS       => '12',
                        IFOUTOCTETS      => '1276853914',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:62:bb:77',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:16',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4280850908) 495 days, 11:15:09.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1558642713',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1813533913',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:24:e8:25:12:bb',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:17',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4111201540) 475 days, 20:00:15.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2709779424',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3561471721',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:73:6e:df:6e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:18',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3866680655) 447 days, 12:46:46.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2742442105',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '593744800',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:80:91:76:89:b8',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'Fa0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:19',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4282944521) 495 days, 17:04:05.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3868224162',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3715955432',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd0:67:e5:43:bc:d2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'Fa0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:1a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283091882) 495 days, 17:28:38.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '124558331',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1484605688',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd0:67:e5:45:b8:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'Fa0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:1b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4264062899) 493 days, 12:37:08.99',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1418190059',
                        IFINERRORS       => '7',
                        IFOUTOCTETS      => '1844373820',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:2b:cb:d7:c5:53',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'Fa0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4280871512) 495 days, 11:18:35.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1697993342',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4086735564',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:0b:97:b0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'Fa0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:1d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4282541241) 495 days, 15:56:52.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4212583692',
                        IFINERRORS       => '82',
                        IFOUTOCTETS      => '2472825409',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '5c:26:0a:29:ab:25',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'Fa0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:1e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4282281126) 495 days, 15:13:31.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3092337694',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1654120821',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'Fa0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:1f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(9698) 0:01:36.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'SAH',
                                    NUMBER => '54',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'Fa0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(9698) 0:01:36.98',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'Poubelle',
                                    NUMBER => '211',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'Fa0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:21',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283138206) 495 days, 17:36:22.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1277050834',
                        IFINERRORS       => '3',
                        IFOUTOCTETS      => '3773359497',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:00:3f:cd',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'Fa0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:22',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4276035002) 494 days, 21:52:30.02',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2876949985',
                        IFINERRORS       => '85808',
                        IFOUTOCTETS      => '716903246',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'Fa0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:23',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4283058559) 495 days, 17:23:05.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2360444253',
                        IFINERRORS       => '18262',
                        IFOUTOCTETS      => '1047027080',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'a4:ba:db:b9:a8:99',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'Fa0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:24',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4273563897) 494 days, 15:00:38.97',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '8927268',
                        IFINERRORS       => '4',
                        IFOUTOCTETS      => '247880465',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'Fa0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281391088) 495 days, 12:45:10.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '269815376',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1119302885',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:b9:e3:98:e1',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'Fa0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:26',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1277570437) 147 days, 20:48:24.37',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3677831255',
                        IFINERRORS       => '4',
                        IFOUTOCTETS      => '562894676',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'Fa0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4275681634) 494 days, 20:53:36.34',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2670820214',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '3163911118',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'Fa0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:28',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4275103930) 494 days, 19:17:19.30',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3794463830',
                        IFINERRORS       => '71',
                        IFOUTOCTETS      => '463403809',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'Fa0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:29',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3780459843) 437 days, 13:16:38.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3543238842',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3832872792',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:30:6e:d2:96:d7',
                                    'b8:ca:3a:c4:31:6f',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'Fa0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:2a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4103532871) 474 days, 22:42:08.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '190445355',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '251642046',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:36:46:e0:43',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'Fa0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4281018271) 495 days, 11:43:02.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2901610822',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '2741306352',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:16:a6:73',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'Fa0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:2c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4275146615) 494 days, 19:24:26.15',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '432518314',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '911596838',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'Fa0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:2d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4267569395) 493 days, 22:21:33.95',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '1958434912',
                        IFINERRORS       => '805',
                        IFOUTOCTETS      => '3203796546',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'EPCS',
                                    NUMBER => '187',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'Fa0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFALIAS          => '-> AP WiFi 1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:2e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(10003) 0:01:40.03',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3533982611',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1513241820',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'Nomadisme2',
                                    NUMBER => '9',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet0',
                                SYSNAME  => 'u2-taillees-b-1',
                                SYSDESCR => '"Cisco IOS Software, C1140 Software (C1140-K9W8-M), Version 12.4(23c)JA7, RELEASE SOFTWARE (fc1)',
                                IP       => '10.2.9.82',
                                MODEL    => 'cisco AIR-LAP1142N-E-K9   ',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'Fa0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFALIAS          => '-> AP WiFi 2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:2f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(10004) 0:01:40.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3993677431',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '1774362429',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'Nomadisme2',
                                    NUMBER => '9',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet0',
                                SYSNAME  => 'u2-taillees-b-2',
                                SYSDESCR => '"Cisco IOS Software, C1140 Software (C1140-K9W8-M), Version 12.4(23c)JA7, RELEASE SOFTWARE (fc1)',
                                IP       => '10.2.9.83',
                                MODEL    => 'cisco AIR-LAP1142N-E-K9   ',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'Fa0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFALIAS          => '-> MGE-EV650-EPCS',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(653902094) 75 days, 16:23:40.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2224585968',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2219504516',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'Technique',
                                    NUMBER => '66',
                                },
                            ]
                        },
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:85:fd:76:13',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:31',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(9630) 0:01:36.30',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '28:93:fe:8f:dd:32',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(817694820) 94 days, 15:22:28.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2670289548',
                        IFINERRORS       => '7',
                        IFOUTOCTETS      => '3093941096',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/48',
                                SYSNAME  => 'c2950-SAH-Taillees.upmf-grenoble.fr',
                                SYSDESCR => '"Cisco Internetwork Operating System Software ',
                                IP       => '192.168.41.74',
                                MODEL    => 'cisco WS-C2950G-48-EI',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C2960.08.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'AP-74.example.com',
            MAC          => 'c4:0a:cb:cd:86:00',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'AP-74.example.com',
            MAC          => 'c4:0a:cb:cd:86:00',
            MODELSNMP    => 'Networking2179',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1511W1A2',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
                NAME         => 'AP-74.example.com',
                MEMORY       => '4',
                SERIAL       => 'FOC1511W1A2',
                IPS          => {
                    IP => [
                        '192.168.1.74',
                    ],
                },
                MAC          => 'c4:0a:cb:cd:86:00',
                UPTIME       => '(347543457) 40 days, 5:23:54.57',
                CPU          => '83',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.74',
                        MAC              => 'c4:0a:cb:cd:86:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(33843) 0:05:38.43',
                        IFINOCTETS       => '1474264407',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '328275733',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'P513-AP-T-5018 ',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:01',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4122) 0:00:41.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346931458) 40 days, 3:41:54.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '236588628',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1309670942',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'AP-I-3013-P313b',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346733109) 40 days, 3:08:51.09',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '244400373',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2758132634',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'ECO-AP',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347248129) 40 days, 4:34:41.29',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '306005406',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2237159677',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFALIAS          => 'AP-I-3016-P313b',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346709972) 40 days, 3:04:59.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '341205155',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4244518876',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'ECO-AP',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:06',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(299032702) 34 days, 14:38:47.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '103424675',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1103108996',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347364747) 40 days, 4:54:07.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '384186304',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '680410947',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'ECO-AP',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFALIAS          => 'P503-AP-I-5023',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(304905559) 35 days, 6:57:35.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1711110227',
                        IFOUTERRORS      => '5306391',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFALIAS          => 'AP-I-3023-P305TER',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4122) 0:00:41.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFALIAS          => 'AP-I-xxxx-P316',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(199152305) 23 days, 1:12:03.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '352167261',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '472288711',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'ECO-AP',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4122) 0:00:41.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFALIAS          => 'AP-I-xxxx-P316',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(292879038) 33 days, 21:33:10.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '947341952',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3871739267',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'ECO-AP',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4122) 0:00:41.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFALIAS          => 'P316g-P316',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347014191) 40 days, 3:55:41.91',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '310298783',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3190072208',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'ECO-AP',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:11',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:12',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFALIAS          => 'AP-318B',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:13',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347064484) 40 days, 4:04:04.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '257298363',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '462767851',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'ECO-AP',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFALIAS          => 'AP-I-4012',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:14',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(344231637) 39 days, 20:11:56.37',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '485150014',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2831486943',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFALIAS          => 'AP-318B',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:15',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(19407) 0:03:14.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '80068166',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3115275205',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'ECO-AP',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => 'AP-318g',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:17',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(345462929) 39 days, 23:37:09.29',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '214483908',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1039775044',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'ECO-AP',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:18',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'Fa0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFALIAS          => 'P412 AB-I-4009',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:19',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347389474) 40 days, 4:58:14.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '197928734',
                        IFINERRORS       => '10114',
                        IFOUTOCTETS      => '2278558878',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'Fa0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFALIAS          => 'P033 API-0024',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'Fa0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFALIAS          => 'AP-I-4011',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(17566) 0:02:55.66',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '660664840',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '189899557',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'Fa0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFALIAS          => 'AP-I-4118-A402',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346865571) 40 days, 3:30:55.71',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '533303751',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1170216684',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'Fa0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346295021) 40 days, 1:55:50.21',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '182135404',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1274821872',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'Fa0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFALIAS          => 'P031 API-0027',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'Fa0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(16871) 0:02:48.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '29059300',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '633177844',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'Fa0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFALIAS          => 'AP-I-4104',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(223291471) 25 days, 20:15:14.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '214096311',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '4206248334',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'SPA',
                                    NUMBER => '25',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'Fa0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFALIAS          => 'AP-I-4037-P406BIS',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:21',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320907355) 37 days, 3:24:33.55',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '95132469',
                        IFINERRORS       => '2369',
                        IFOUTOCTETS      => '587991352',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'CREFIGE',
                                    NUMBER => '33',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'Fa0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:22',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347143890) 40 days, 4:17:18.90',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '489015270',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1209925409',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'Fa0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFALIAS          => 'IRIS-CREDEP',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:23',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'Fa0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFALIAS          => 'AP-I-4116',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347141430) 40 days, 4:16:54.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '432349066',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '427746098',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'Fa0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFALIAS          => 'IRIS-CREDEP',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:25',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'Fa0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFALIAS          => 'AP-I-4115 A406',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:26',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(50167) 0:08:21.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '273611216',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3366833064',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'Fa0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFALIAS          => 'IRIS-CREDEP',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(311161429) 36 days, 0:20:14.29',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '50812277',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '523659377',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'Fa0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:28',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'Fa0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:29',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'Fa0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(48708) 0:08:07.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '510737178',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3327711715',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'DADM',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'Fa0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'Fa0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(46296) 0:07:42.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '614324126',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1211817539',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'SPA',
                                    NUMBER => '25',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'Fa0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'RDIS',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'Fa0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFALIAS          => 'IRIS-CREDEP',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'IRIS',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'Fa0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'Fa0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:31',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:32',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(33930) 0:05:39.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2071109510',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '275105132',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/1',
                                SYSNAME  => 'AP-Switch-51.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.51',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
                NAME         => 'AP-74.example.com',
                MEMORY       => '4',
                SERIAL       => 'FOC1511W1A2',
                FIRMWARE     => '15.0(1)SE3',
                IPS          => {
                    IP => [
                        '192.168.1.74',
                    ],
                },
                MAC          => 'c4:0a:cb:cd:86:00',
                UPTIME       => '(347543457) 40 days, 5:23:54.57',
                CPU          => '83',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.74',
                        MAC              => 'c4:0a:cb:cd:86:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(33843) 0:05:38.43',
                        IFINOCTETS       => '1474264407',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '328275733',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFALIAS          => 'P513-AP-T-5018 ',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:01',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4122) 0:00:41.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:02',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346931458) 40 days, 3:41:54.58',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '236588628',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1309670942',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFALIAS          => 'AP-I-3013-P313b',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346733109) 40 days, 3:08:51.09',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '244400373',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2758132634',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan10',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347248129) 40 days, 4:34:41.29',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '306005406',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2237159677',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFALIAS          => 'AP-I-3016-P313b',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346709972) 40 days, 3:04:59.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '341205155',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4244518876',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan10',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:06',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(299032702) 34 days, 14:38:47.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '103424675',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1103108996',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347364747) 40 days, 4:54:07.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '384186304',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '680410947',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan10',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFALIAS          => 'P503-AP-I-5023',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(304905559) 35 days, 6:57:35.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1711110227',
                        IFOUTERRORS      => '5306391',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFALIAS          => 'AP-I-3023-P305TER',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4122) 0:00:41.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFALIAS          => 'AP-I-xxxx-P316',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(199152305) 23 days, 1:12:03.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '352167261',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '472288711',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan10',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4122) 0:00:41.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFALIAS          => 'AP-I-xxxx-P316',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(292879038) 33 days, 21:33:10.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '947341952',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3871739267',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan10',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4122) 0:00:41.22',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFALIAS          => 'P316g-P316',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347014191) 40 days, 3:55:41.91',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '310298783',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3190072208',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan10',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:11',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:12',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFALIAS          => 'AP-318B',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:13',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347064484) 40 days, 4:04:04.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '257298363',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '462767851',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan10',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFALIAS          => 'AP-I-4012',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:14',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(344231637) 39 days, 20:11:56.37',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '485150014',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2831486943',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFALIAS          => 'AP-318B',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:15',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(19407) 0:03:14.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '80068166',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3115275205',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan10',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFALIAS          => 'AP-318g',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:17',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(345462929) 39 days, 23:37:09.29',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '214483908',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1039775044',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan10',
                                    NUMBER => '14',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:18',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'Fa0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFALIAS          => 'P412 AB-I-4009',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:19',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347389474) 40 days, 4:58:14.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '197928734',
                        IFINERRORS       => '10114',
                        IFOUTOCTETS      => '2278558878',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'Fa0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFALIAS          => 'P033 API-0024',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'Fa0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFALIAS          => 'AP-I-4011',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(17566) 0:02:55.66',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '660664840',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '189899557',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'Fa0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFALIAS          => 'AP-I-4118-A402',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346865571) 40 days, 3:30:55.71',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '533303751',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1170216684',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'Fa0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(346295021) 40 days, 1:55:50.21',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '182135404',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1274821872',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'Fa0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFALIAS          => 'P031 API-0027',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'Fa0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:1f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(16871) 0:02:48.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '29059300',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '633177844',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'Fa0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFALIAS          => 'AP-I-4104',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(223291471) 25 days, 20:15:14.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '214096311',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '4206248334',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan21',
                                    NUMBER => '25',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'Fa0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFALIAS          => 'AP-I-4037-P406BIS',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:21',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320907355) 37 days, 3:24:33.55',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '95132469',
                        IFINERRORS       => '2369',
                        IFOUTOCTETS      => '587991352',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan29',
                                    NUMBER => '33',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'Fa0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:22',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347143890) 40 days, 4:17:18.90',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '489015270',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1209925409',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'Fa0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFALIAS          => 'IRIS-CREDEP',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:23',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'Fa0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFALIAS          => 'AP-I-4116',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347141430) 40 days, 4:16:54.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '432349066',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '427746098',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'Fa0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFALIAS          => 'IRIS-CREDEP',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:25',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'Fa0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFALIAS          => 'AP-I-4115 A406',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:26',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(50167) 0:08:21.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '273611216',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3366833064',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'Fa0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFALIAS          => 'IRIS-CREDEP',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:27',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(311161429) 36 days, 0:20:14.29',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '50812277',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '523659377',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'Fa0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:28',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'Fa0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:29',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'Fa0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(48708) 0:08:07.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '510737178',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3327711715',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan26',
                                    NUMBER => '30',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'Fa0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'Fa0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(46296) 0:07:42.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '614324126',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1211817539',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan21',
                                    NUMBER => '25',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'Fa0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan19',
                                    NUMBER => '23',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'Fa0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFALIAS          => 'IRIS-CREDEP',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan12',
                                    NUMBER => '16',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'Fa0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:2f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'Fa0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:30',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:31',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4124) 0:00:41.24',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'c4:0a:cb:cd:86:32',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(33930) 0:05:39.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2071109510',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '275105132',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'FastEthernet0/1',
                                SYSNAME  => 'AP-Switch-51.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960 Software (C2960-LANBASE-M), Version 12.2(46)SE, RELEASE SOFTWARE (fc2)',
                                IP       => '192.168.1.51',
                                MODEL    => 'cisco WS-C2960-48TC-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'cisco/C2960.09.walk' => [
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'CB-C005-208.Dauphine',
            MAC          => '64:d9:89:8d:b1:80',
            MODEL        => 'Catalyst 2960-48TC',
        },
        {
            MANUFACTURER => 'Cisco',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
            SNMPHOSTNAME => 'CB-C005-208.Dauphine',
            MAC          => '64:d9:89:8d:b1:80',
            MODELSNMP    => 'Networking2179',
            MODEL        => 'Catalyst 2960-48TC',
            FIRMWARE     => undef,
            SERIAL       => 'FOC1511W19F',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
                NAME         => 'CB-C005-208.Dauphine',
                MEMORY       => '5',
                SERIAL       => 'FOC1511W19F',
                MAC          => '64:d9:89:8d:b1:80',
                CPU          => '89',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:c0',
                        IFLASTCHANGE     => '(595775969) 68 days, 22:55:59.69',
                        IFINOCTETS       => '2847919715',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2431876662',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:81',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:82',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:83',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:84',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:85',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:86',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:87',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:88',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:89',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8a',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8b',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8c',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8d',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8e',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8f',
                        IFLASTCHANGE     => '(1629636421) 188 days, 14:46:04.21',
                        IFINOCTETS       => '158358580',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '2542256749',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'fondation-assoc-exclusif',
                                    NUMBER => '49',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:90',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:91',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:92',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:93',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:94',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:95',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:96',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:97',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:98',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'Fa0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:99',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'Fa0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9a',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'Fa0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9b',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'Fa0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9c',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'Fa0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9d',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'Fa0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9e',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'Fa0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9f',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'Fa0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a0',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'Fa0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a1',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'fondation-assoc-exclusif',
                                    NUMBER => '49',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'Fa0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a2',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'Fa0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a3',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'Fa0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a4',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'Fa0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a5',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'Fa0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a6',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'Fa0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a7',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'Fa0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a8',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'Fa0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a9',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10042',
                        IFNAME           => 'Fa0/42',
                        IFDESCR          => 'FastEthernet0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:aa',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10043',
                        IFNAME           => 'Fa0/43',
                        IFDESCR          => 'FastEthernet0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:ab',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10044',
                        IFNAME           => 'Fa0/44',
                        IFDESCR          => 'FastEthernet0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:ac',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10045',
                        IFNAME           => 'Fa0/45',
                        IFDESCR          => 'FastEthernet0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:ad',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10046',
                        IFNAME           => 'Fa0/46',
                        IFDESCR          => 'FastEthernet0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:ae',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10047',
                        IFNAME           => 'Fa0/47',
                        IFDESCR          => 'FastEthernet0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:af',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10048',
                        IFNAME           => 'Fa0/48',
                        IFDESCR          => 'FastEthernet0/48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:b0',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'eduspot-lan',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10101',
                        IFNAME           => 'Gi0/1',
                        IFDESCR          => 'GigabitEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:b1',
                        IFLASTCHANGE     => '(595776056) 68 days, 22:56:00.56',
                        IFINOCTETS       => '627337006',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2755039325',
                        IFOUTERRORS      => '0',
                        TRUNK            => '1',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => 'GigabitEthernet1/0/23',
                                SYSNAME  => 'CB-C005-202.example.com',
                                SYSDESCR => '"Cisco IOS Software, C2960S Software (C2960S-UNIVERSALK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1)',
                                IP       => '192.168.1.202',
                                MODEL    => 'cisco WS-C2960S-24TD-L',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10102',
                        IFNAME           => 'Gi0/2',
                        IFDESCR          => 'GigabitEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:b2',
                        IFLASTCHANGE     => '(4256) 0:00:42.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                    },
                    {
                        IFNUMBER         => '10501',
                        IFNAME           => 'Nu0',
                        IFDESCR          => 'Null0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Cisco',
                TYPE         => 'NETWORKING',
                MODEL        => 'Catalyst 2960-48TC',
                COMMENTS     => 'Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(1)SE3, RELEASE SOFTWARE (fc1)
Technical Support: http://www.cisco.com/techsupport
Copyright (c) 1986-2012 by Cisco Systems, Inc.
Compiled Wed 30-May-12 14:26 by prod_rel_team',
                NAME         => 'CB-C005-208.Dauphine',
                MEMORY       => '5',
                SERIAL       => 'FOC1511W19F',
                FIRMWARE     => '15.0(1)SE3',
                MAC          => '64:d9:89:8d:b1:80',
                CPU          => '89',
                RAM          => '64',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'Vl1',
                        IFDESCR          => 'Vlan1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:c0',
                        IFLASTCHANGE     => '(595775969) 68 days, 22:55:59.69',
                        IFINOCTETS       => '2847919715',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2431876662',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10001',
                        IFNAME           => 'Fa0/1',
                        IFDESCR          => 'FastEthernet0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:81',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10002',
                        IFNAME           => 'Fa0/2',
                        IFDESCR          => 'FastEthernet0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:82',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10003',
                        IFNAME           => 'Fa0/3',
                        IFDESCR          => 'FastEthernet0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:83',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10004',
                        IFNAME           => 'Fa0/4',
                        IFDESCR          => 'FastEthernet0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:84',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10005',
                        IFNAME           => 'Fa0/5',
                        IFDESCR          => 'FastEthernet0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:85',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10006',
                        IFNAME           => 'Fa0/6',
                        IFDESCR          => 'FastEthernet0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:86',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10007',
                        IFNAME           => 'Fa0/7',
                        IFDESCR          => 'FastEthernet0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:87',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10008',
                        IFNAME           => 'Fa0/8',
                        IFDESCR          => 'FastEthernet0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:88',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10009',
                        IFNAME           => 'Fa0/9',
                        IFDESCR          => 'FastEthernet0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:89',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10010',
                        IFNAME           => 'Fa0/10',
                        IFDESCR          => 'FastEthernet0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8a',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10011',
                        IFNAME           => 'Fa0/11',
                        IFDESCR          => 'FastEthernet0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8b',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10012',
                        IFNAME           => 'Fa0/12',
                        IFDESCR          => 'FastEthernet0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8c',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10013',
                        IFNAME           => 'Fa0/13',
                        IFDESCR          => 'FastEthernet0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8d',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10014',
                        IFNAME           => 'Fa0/14',
                        IFDESCR          => 'FastEthernet0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8e',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10015',
                        IFNAME           => 'Fa0/15',
                        IFDESCR          => 'FastEthernet0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:8f',
                        IFLASTCHANGE     => '(1629636421) 188 days, 14:46:04.21',
                        IFINOCTETS       => '158358580',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '2542256749',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan45',
                                    NUMBER => '49',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10016',
                        IFNAME           => 'Fa0/16',
                        IFDESCR          => 'FastEthernet0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:90',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10017',
                        IFNAME           => 'Fa0/17',
                        IFDESCR          => 'FastEthernet0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:91',
                        IFLASTCHANGE     => '(4253) 0:00:42.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10018',
                        IFNAME           => 'Fa0/18',
                        IFDESCR          => 'FastEthernet0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:92',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10019',
                        IFNAME           => 'Fa0/19',
                        IFDESCR          => 'FastEthernet0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:93',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10020',
                        IFNAME           => 'Fa0/20',
                        IFDESCR          => 'FastEthernet0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:94',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10021',
                        IFNAME           => 'Fa0/21',
                        IFDESCR          => 'FastEthernet0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:95',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10022',
                        IFNAME           => 'Fa0/22',
                        IFDESCR          => 'FastEthernet0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:96',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10023',
                        IFNAME           => 'Fa0/23',
                        IFDESCR          => 'FastEthernet0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:97',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10024',
                        IFNAME           => 'Fa0/24',
                        IFDESCR          => 'FastEthernet0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:98',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10025',
                        IFNAME           => 'Fa0/25',
                        IFDESCR          => 'FastEthernet0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:99',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10026',
                        IFNAME           => 'Fa0/26',
                        IFDESCR          => 'FastEthernet0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9a',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10027',
                        IFNAME           => 'Fa0/27',
                        IFDESCR          => 'FastEthernet0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9b',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10028',
                        IFNAME           => 'Fa0/28',
                        IFDESCR          => 'FastEthernet0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9c',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10029',
                        IFNAME           => 'Fa0/29',
                        IFDESCR          => 'FastEthernet0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9d',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10030',
                        IFNAME           => 'Fa0/30',
                        IFDESCR          => 'FastEthernet0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9e',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10031',
                        IFNAME           => 'Fa0/31',
                        IFDESCR          => 'FastEthernet0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:9f',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10032',
                        IFNAME           => 'Fa0/32',
                        IFDESCR          => 'FastEthernet0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a0',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10033',
                        IFNAME           => 'Fa0/33',
                        IFDESCR          => 'FastEthernet0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a1',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan45',
                                    NUMBER => '49',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10034',
                        IFNAME           => 'Fa0/34',
                        IFDESCR          => 'FastEthernet0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a2',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10035',
                        IFNAME           => 'Fa0/35',
                        IFDESCR          => 'FastEthernet0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a3',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10036',
                        IFNAME           => 'Fa0/36',
                        IFDESCR          => 'FastEthernet0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a4',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10037',
                        IFNAME           => 'Fa0/37',
                        IFDESCR          => 'FastEthernet0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a5',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10038',
                        IFNAME           => 'Fa0/38',
                        IFDESCR          => 'FastEthernet0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a6',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10039',
                        IFNAME           => 'Fa0/39',
                        IFDESCR          => 'FastEthernet0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a7',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10040',
                        IFNAME           => 'Fa0/40',
                        IFDESCR          => 'FastEthernet0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a8',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                        TRUNK            => '0',
                        VLANS          => {
                            VLAN => [
                                {
                                    NAME   => 'vlan3',
                                    NUMBER => '7',
                                },
                            ]
                        },
                    },
                    {
                        IFNUMBER         => '10041',
                        IFNAME           => 'Fa0/41',
                        IFDESCR          => 'FastEthernet0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '64:d9:89:8d:b1:a9',
                        IFLASTCHANGE     => '(4255) 0:00:42.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                  