use Test::More;
BEGIN {
    eval { require Want; 1 }
        or plan skip_all => "lvalue accessors require the Want module (which could not be loaded)";
}

use Dios { accessors => 'lval' };

plan tests => 7;

my $NAME = 'Damian';

class Base1 {
    method basic { return 'basic' }
}

class Base2 {
    method more_basic { return 'more basic' }
}

class Demo is Base1 is Base2 {
    has Str $.name is required;

    method foo ($this: Str $newname, Int|Undef :$other) {
        ::is $name, $NAME => 'Name correct';

        $name = 'Other';
        ::is $this->name, 'Other' => 'Assignment to name correct';

        return 1;
    }
}

my $obj = Demo->new({ name => $NAME });

::is $obj->basic, 'basic'           => 'Inherited Base1 correctly';
::is $obj->more_basic, 'more basic' => 'Inherited Base2 correctly';

::is $obj->foo('me'), 1  => 'Called foo() correctly';
::is $obj->name, 'Other' => 'Retained updated name correctly';

::ok !defined eval{ $obj->name = 'etc'; 1; } => 'Failed to set, as expected';

done_testing;

