#pragma once
#include <panda/lib/memory.h>

namespace xs { namespace lib {

using panda::lib::MemoryPool;
using panda::lib::ObjectAllocator;
using panda::lib::AllocatedObject;
using panda::lib::StaticMemoryPool;

class MyObject : public AllocatedObject<MyObject, false> {
public:
    int a;
    MyObject () : a(0) {}
};

class MyObjectThr : public AllocatedObject<MyObject, true> {
public:
    int a;
    MyObjectThr () : a(0) {}
};

class MyObjectDyn : public MyObject {
public:
    int b;
    MyObjectDyn () : b(0) {}
};

class MyObjectDynThr : public MyObjectThr {
public:
    int b;
    MyObjectDynThr () : b(0) {}
};

#ifdef _WIN32
inline DWORD WINAPI test_on_thread_start (LPVOID lpParameter) {
#else
inline void* test_on_thread_start (void* arg) {
#endif
    static const int cnt = 10000;
    uint64_t ret = 0;
    for (int i = 0; i < cnt; ++i) {
        void* mem = ObjectAllocator::threaded_instance()->alloc(16);
        ret += (uint64_t) mem;
        ObjectAllocator::threaded_instance()->dealloc(mem, 16);
        mem = StaticMemoryPool<16>::threaded_instance()->alloc();
        ret += (uint64_t) mem;
        StaticMemoryPool<16>::threaded_instance()->dealloc(mem);
    }
    return 0;
}

}}
