use strict;

use charnames qw(:full);
use Unicode::Semantics qw(us);

my %tests;  # char => lc(char)
binmode STDOUT, ':utf8';

while (defined($_ = readline *DATA)) {
    if (m[^U\+(\w+)]) {
        my $hcp = $1;
        $tests{ chr hex $hcp } = join "", map chr hex, readline(*DATA) =~ /U\+(\w+)/g;
    }
}

print "1..128\n";
my $i;

for my $cp (128..255) {
    my $char = chr $cp;
    us($char);
    my $lc = lc $char;
    if (exists $tests{$char}) {
        print +($lc eq $tests{$char} ? "ok " : "not ok "), ++$i, 
            " # lc('$char') eq '$lc'\n";
    } else {
        print +($lc eq $char ? "ok " : "not ok "), ++$i, 
            " # lc('$char') same as $char itself\n";
    }
}

__DATA__
U+00c0 LATIN CAPITAL LETTER A WITH GRAVE
U+00e0 LATIN SMALL LETTER A WITH GRAVE

U+00c1 LATIN CAPITAL LETTER A WITH ACUTE
U+00e1 LATIN SMALL LETTER A WITH ACUTE

U+00c2 LATIN CAPITAL LETTER A WITH CIRCUMFLEX
U+00e2 LATIN SMALL LETTER A WITH CIRCUMFLEX

U+00c3 LATIN CAPITAL LETTER A WITH TILDE
U+00e3 LATIN SMALL LETTER A WITH TILDE

U+00c4 LATIN CAPITAL LETTER A WITH DIAERESIS
U+00e4 LATIN SMALL LETTER A WITH DIAERESIS

U+00c5 LATIN CAPITAL LETTER A WITH RING ABOVE
U+00e5 LATIN SMALL LETTER A WITH RING ABOVE

U+00c6 LATIN CAPITAL LETTER AE
U+00e6 LATIN SMALL LETTER AE

U+00c7 LATIN CAPITAL LETTER C WITH CEDILLA
U+00e7 LATIN SMALL LETTER C WITH CEDILLA

U+00c8 LATIN CAPITAL LETTER E WITH GRAVE
U+00e8 LATIN SMALL LETTER E WITH GRAVE

U+00c9 LATIN CAPITAL LETTER E WITH ACUTE
U+00e9 LATIN SMALL LETTER E WITH ACUTE

U+00ca LATIN CAPITAL LETTER E WITH CIRCUMFLEX
U+00ea LATIN SMALL LETTER E WITH CIRCUMFLEX

U+00cb LATIN CAPITAL LETTER E WITH DIAERESIS
U+00eb LATIN SMALL LETTER E WITH DIAERESIS

U+00cc LATIN CAPITAL LETTER I WITH GRAVE
U+00ec LATIN SMALL LETTER I WITH GRAVE

U+00cd LATIN CAPITAL LETTER I WITH ACUTE
U+00ed LATIN SMALL LETTER I WITH ACUTE

U+00ce LATIN CAPITAL LETTER I WITH CIRCUMFLEX
U+00ee LATIN SMALL LETTER I WITH CIRCUMFLEX

U+00cf LATIN CAPITAL LETTER I WITH DIAERESIS
U+00ef LATIN SMALL LETTER I WITH DIAERESIS

U+00d0 LATIN CAPITAL LETTER ETH
U+00f0 LATIN SMALL LETTER ETH

U+00d1 LATIN CAPITAL LETTER N WITH TILDE
U+00f1 LATIN SMALL LETTER N WITH TILDE

U+00d2 LATIN CAPITAL LETTER O WITH GRAVE
U+00f2 LATIN SMALL LETTER O WITH GRAVE

U+00d3 LATIN CAPITAL LETTER O WITH ACUTE
U+00f3 LATIN SMALL LETTER O WITH ACUTE

U+00d4 LATIN CAPITAL LETTER O WITH CIRCUMFLEX
U+00f4 LATIN SMALL LETTER O WITH CIRCUMFLEX

U+00d5 LATIN CAPITAL LETTER O WITH TILDE
U+00f5 LATIN SMALL LETTER O WITH TILDE

U+00d6 LATIN CAPITAL LETTER O WITH DIAERESIS
U+00f6 LATIN SMALL LETTER O WITH DIAERESIS

U+00d8 LATIN CAPITAL LETTER O WITH STROKE
U+00f8 LATIN SMALL LETTER O WITH STROKE

U+00d9 LATIN CAPITAL LETTER U WITH GRAVE
U+00f9 LATIN SMALL LETTER U WITH GRAVE

U+00da LATIN CAPITAL LETTER U WITH ACUTE
U+00fa LATIN SMALL LETTER U WITH ACUTE

U+00db LATIN CAPITAL LETTER U WITH CIRCUMFLEX
U+00fb LATIN SMALL LETTER U WITH CIRCUMFLEX

U+00dc LATIN CAPITAL LETTER U WITH DIAERESIS
U+00fc LATIN SMALL LETTER U WITH DIAERESIS

U+00dd LATIN CAPITAL LETTER Y WITH ACUTE
U+00fd LATIN SMALL LETTER Y WITH ACUTE

U+00de LATIN CAPITAL LETTER THORN
U+00fe LATIN SMALL LETTER THORN
