#!/usr/bin/perl

use Test::More qw(no_plan);
use Graph::SocialMap;
use Graph::Writer::GraphViz;
use IO::All;

my $relation = {
    1357 => [qw/Marry Rose Autrijus/],
    3579 => [qw/Marry Peacock/],
    2468 => [qw/Joan/],
    4680 => [qw/Rose Joan/],
    OSSF => [qw/Gugod Autrijus/],
    GGYY => [qw/Gugod Autrijus Joan Peacock/],
    1234 => [qw/Tifa Dora Charlee Angie/],
    5555 => [qw/A B C D E F G H I J K/],
};

my $gsm = sm(-relation => $relation);
my $writer = Graph::Writer::GraphViz->new(-format=>'dot');
$writer->write_graph($gsm->type2,'t/graphtest1.dot');
my $tmp = io('t/graphtest1.dot');
my $d2 = $tmp->slurp;
my $d1;
{
    local $/ = undef;
    $d1 = <DATA>;
}

ok($d1 eq $d2);
$tmp->unlink;

ok($gsm->dos('Marry','Autrijus') == 1);

my $alldos = $gsm->all_dos;
ok($alldos->{Marry}->{Autrijus} == 1);
ok($alldos->{Marry}->{Joan} == 2);

__DATA__
digraph test {
	graph [ratio=fill];
	node [label="\N", color=black];
	edge [color=black];
	graph [bb="0,0,8283,124"];
	G [label=G, pos="27,98", width="0.75", height="0.50"];
	C [label=C, pos="99,98", width="0.75", height="0.50"];
	Tifa [label=Tifa, pos="171,98", width="0.75", height="0.50"];
	Marry [label=Marry, pos="251,98", width="0.97", height="0.50"];
	Joan [label=Joan, pos="333,98", width="0.81", height="0.50"];
	Dora [label=Dora, pos="410,98", width="0.83", height="0.50"];
	Rose [label=Rose, pos="487,98", width="0.81", height="0.50"];
	Gugod [label=Gugod, pos="570,98", width="1.00", height="0.50"];
	I [label=I, pos="651,98", width="0.75", height="0.50"];
	B [label=B, pos="723,98", width="0.75", height="0.50"];
	Peacock [label=Peacock, pos="808,98", width="1.11", height="0.50"];
	E [label=E, pos="893,98", width="0.75", height="0.50"];
	H [label=H, pos="965,98", width="0.75", height="0.50"];
	Angie [label=Angie, pos="1044,98", width="0.94", height="0.50"];
	J [label=J, pos="1123,98", width="0.75", height="0.50"];
	K [label=K, pos="1195,98", width="0.75", height="0.50"];
	D [label=D, pos="1267,98", width="0.75", height="0.50"];
	Autrijus [label=Autrijus, pos="1354,98", width="1.17", height="0.50"];
	Charlee [label=Charlee, pos="1453,98", width="1.08", height="0.50"];
	F [label=F, pos="1537,98", width="0.75", height="0.50"];
	A [label=A, pos="1609,98", width="0.75", height="0.50"];
	node1 [label="<port0>B|<port1>I", shape=record, pos="1681,98", rects="1654,80,1684,116 1684,80,1708,116", width="0.75", height="0.50"];
	node2 [label="<port0>C|<port1>J", shape=record, pos="1681,26", rects="1654,8,1683,44 1683,8,1708,44", width="0.75", height="0.50"];
	node3 [label="<port0>K|<port1>D", shape=record, pos="1773,98", rects="1746,80,1773,116 1773,80,1800,116", width="0.75", height="0.50"];
	node4 [label="<port0>Gugod|<port1>Joan", shape=record, pos="1773,26", rects="1726,8,1781,44 1781,8,1821,44", width="1.31", height="0.50"];
	node5 [label="<port0>Autrijus|<port1>Marry", shape=record, pos="1877,98", rects="1818,80,1884,116 1884,80,1937,116", width="1.64", height="0.50"];
	node6 [label="<port0>D|<port1>F", shape=record, pos="1877,26", rects="1850,8,1878,44 1878,8,1904,44", width="0.75", height="0.50"];
	node7 [label="<port0>C|<port1>B", shape=record, pos="1981,98", rects="1954,80,1981,116 1981,80,2008,116", width="0.75", height="0.50"];
	node8 [label="<port0>Tifa|<port1>Dora", shape=record, pos="1981,26", rects="1942,8,1979,44 1979,8,2021,44", width="1.08", height="0.50"];
	node9 [label="<port0>I|<port1>H", shape=record, pos="2065,98", rects="2038,80,2061,116 2061,80,2092,116", width="0.75", height="0.50"];
	node10 [label="<port0>E|<port1>H", shape=record, pos="2065,26", rects="2038,8,2064,44 2064,8,2092,44", width="0.75", height="0.50"];
	node11 [label="<port0>Autrijus|<port1>Gugod", shape=record, pos="2170,98", rects="2110,80,2176,116 2176,80,2231,116", width="1.67", height="0.50"];
	node12 [label="<port0>K|<port1>H", shape=record, pos="2170,26", rects="2143,8,2170,44 2170,8,2197,44", width="0.75", height="0.50"];
	node13 [label="<port0>I|<port1>J", shape=record, pos="2275,98", rects="2248,80,2274,116 2274,80,2302,116", width="0.75", height="0.50"];
	node14 [label="<port0>D|<port1>E", shape=record, pos="2275,26", rects="2248,8,2276,44 2276,8,2302,44", width="0.75", height="0.50"];
	node15 [label="<port0>Rose|<port1>Joan", shape=record, pos="2360,98", rects="2320,80,2361,116 2361,80,2401,116", width="1.11", height="0.50"];
	node16 [label="<port0>B|<port1>A", shape=record, pos="2360,26", rects="2333,8,2359,44 2359,8,2387,44", width="0.75", height="0.50"];
	node17 [label="<port0>E|<port1>K", shape=record, pos="2445,98", rects="2418,80,2443,116 2443,80,2472,116", width="0.75", height="0.50"];
	node18 [label="<port0>J|<port1>E", shape=record, pos="2445,26", rects="2418,8,2443,44 2443,8,2472,44", width="0.75", height="0.50"];
	node19 [label="<port0>G|<port1>E", shape=record, pos="2517,98", rects="2490,80,2518,116 2518,80,2544,116", width="0.75", height="0.50"];
	node20 [label="<port0>E|<port1>J", shape=record, pos="2517,26", rects="2490,8,2519,44 2519,8,2544,44", width="0.75", height="0.50"];
	node21 [label="<port0>E|<port1>I", shape=record, pos="2589,98", rects="2562,80,2591,116 2591,80,2616,116", width="0.75", height="0.50"];
	node22 [label="<port0>J|<port1>C", shape=record, pos="2589,26", rects="2562,8,2586,44 2586,8,2616,44", width="0.75", height="0.50"];
	node23 [label="<port0>C|<port1>E", shape=record, pos="2661,98", rects="2634,80,2661,116 2661,80,2688,116", width="0.75", height="0.50"];
	node24 [label="<port0>D|<port1>G", shape=record, pos="2661,26", rects="2634,8,2661,44 2661,8,2688,44", width="0.75", height="0.50"];
	node25 [label="<port0>K|<port1>I", shape=record, pos="2733,98", rects="2706,80,2737,116 2737,80,2760,116", width="0.75", height="0.50"];
	node26 [label="<port0>D|<port1>A", shape=record, pos="2733,26", rects="2706,8,2732,44 2732,8,2760,44", width="0.75", height="0.50"];
	node27 [label="<port0>Autrijus|<port1>Rose", shape=record, pos="2831,98", rects="2778,80,2844,116 2844,80,2885,116", width="1.47", height="0.50"];
	node28 [label="<port0>Dora|<port1>Charlee", shape=record, pos="2831,26", rects="2780,8,2822,44 2822,8,2882,44", width="1.42", height="0.50"];
	node29 [label="<port0>H|<port1>A", shape=record, pos="2929,98", rects="2902,80,2928,116 2928,80,2956,116", width="0.75", height="0.50"];
	node30 [label="<port0>A|<port1>G", shape=record, pos="2929,26", rects="2902,8,2929,44 2929,8,2956,44", width="0.75", height="0.50"];
	node31 [label="<port0>E|<port1>C", shape=record, pos="3001,98", rects="2974,80,3000,116 3000,80,3028,116", width="0.75", height="0.50"];
	node32 [label="<port0>F|<port1>H", shape=record, pos="3001,26", rects="2974,8,2999,44 2999,8,3028,44", width="0.75", height="0.50"];
	node33 [label="<port0>Tifa|<port1>Angie", shape=record, pos="3089,98", rects="3046,80,3083,116 3083,80,3133,116", width="1.19", height="0.50"];
	node34 [label="<port0>J|<port1>B", shape=record, pos="3089,26", rects="3062,8,3086,44 3086,8,3116,44", width="0.75", height="0.50"];
	node35 [label="<port0>E|<port1>G", shape=record, pos="3177,98", rects="3150,80,3176,116 3176,80,3204,116", width="0.75", height="0.50"];
	node36 [label="<port0>G|<port1>F", shape=record, pos="3177,26", rects="3150,8,3178,44 3178,8,3204,44", width="0.75", height="0.50"];
	node37 [label="<port0>D|<port1>I", shape=record, pos="3275,98", rects="3248,80,3278,116 3278,80,3302,116", width="0.75", height="0.50"];
	node38 [label="<port0>Rose|<port1>Autrijus", shape=record, pos="3275,26", rects="3222,8,3263,44 3263,8,3329,44", width="1.47", height="0.50"];
	node39 [label="<port0>Rose|<port1>Marry", shape=record, pos="3373,98", rects="3326,80,3367,116 3367,80,3420,116", width="1.31", height="0.50"];
	node40 [label="<port0>J|<port1>H", shape=record, pos="3373,26", rects="3346,8,3370,44 3370,8,3400,44", width="0.75", height="0.50"];
	node41 [label="<port0>B|<port1>K", shape=record, pos="3465,98", rects="3438,80,3464,116 3464,80,3492,116", width="0.75", height="0.50"];
	node42 [label="<port0>F|<port1>G", shape=record, pos="3465,26", rects="3438,8,3463,44 3463,8,3492,44", width="0.75", height="0.50"];
	node43 [label="<port0>K|<port1>E", shape=record, pos="3537,98", rects="3510,80,3538,116 3538,80,3564,116", width="0.75", height="0.50"];
	node44 [label="<port0>I|<port1>K", shape=record, pos="3537,26", rects="3510,8,3533,44 3533,8,3564,44", width="0.75", height="0.50"];
	node45 [label="<port0>I|<port1>G", shape=record, pos="3640,98", rects="3613,80,3636,116 3636,80,3667,116", width="0.75", height="0.50"];
	node46 [label="<port0>Peacock|<port1>Marry", shape=record, pos="3640,26", rects="3582,8,3645,44 3645,8,3698,44", width="1.61", height="0.50"];
	node47 [label="<port0>H|<port1>C", shape=record, pos="3743,98", rects="3716,80,3743,116 3743,80,3770,116", width="0.75", height="0.50"];
	node48 [label="<port0>B|<port1>C", shape=record, pos="3743,26", rects="3716,8,3743,44 3743,8,3770,44", width="0.75", height="0.50"];
	node49 [label="<port0>G|<port1>A", shape=record, pos="3815,98", rects="3788,80,3814,116 3814,80,3842,116", width="0.75", height="0.50"];
	node50 [label="<port0>D|<port1>C", shape=record, pos="3815,26", rects="3788,8,3815,44 3815,8,3842,44", width="0.75", height="0.50"];
	node51 [label="<port0>E|<port1>D", shape=record, pos="3887,98", rects="3860,80,3886,116 3886,80,3914,116", width="0.75", height="0.50"];
	node52 [label="<port0>B|<port1>G", shape=record, pos="3887,26", rects="3860,8,3886,44 3886,8,3914,44", width="0.75", height="0.50"];
	node53 [label="<port0>F|<port1>C", shape=record, pos="3959,98", rects="3932,80,3958,116 3958,80,3986,116", width="0.75", height="0.50"];
	node54 [label="<port0>C|<port1>G", shape=record, pos="3959,26", rects="3932,8,3958,44 3958,8,3986,44", width="0.75", height="0.50"];
	node55 [label="<port0>J|<port1>G", shape=record, pos="4031,98", rects="4004,80,4028,116 4028,80,4058,116", width="0.75", height="0.50"];
	node56 [label="<port0>H|<port1>E", shape=record, pos="4031,26", rects="4004,8,4032,44 4032,8,4058,44", width="0.75", height="0.50"];
	node57 [label="<port0>H|<port1>I", shape=record, pos="4119,98", rects="4092,80,4122,116 4122,80,4146,116", width="0.75", height="0.50"];
	node58 [label="<port0>Angie|<port1>Tifa", shape=record, pos="4119,26", rects="4076,8,4126,44 4126,8,4163,44", width="1.19", height="0.50"];
	node59 [label="<port0>G|<port1>K", shape=record, pos="4207,98", rects="4180,80,4206,116 4206,80,4234,116", width="0.75", height="0.50"];
	node60 [label="<port0>J|<port1>F", shape=record, pos="4207,26", rects="4180,8,4205,44 4205,8,4234,44", width="0.75", height="0.50"];
	node61 [label="<port0>Peacock|<port1>Joan", shape=record, pos="4303,98", rects="4252,80,4315,116 4315,80,4355,116", width="1.42", height="0.50"];
	node62 [label="<port0>H|<port1>K", shape=record, pos="4303,26", rects="4276,8,4302,44 4302,8,4330,44", width="0.75", height="0.50"];
	node63 [label="<port0>A|<port1>E", shape=record, pos="4399,98", rects="4372,80,4400,116 4400,80,4426,116", width="0.75", height="0.50"];
	node64 [label="<port0>H|<port1>B", shape=record, pos="4399,26", rects="4372,8,4399,44 4399,8,4426,44", width="0.75", height="0.50"];
	node65 [label="<port0>C|<port1>K", shape=record, pos="4504,98", rects="4477,80,4503,116 4503,80,4531,116", width="0.75", height="0.50"];
	node66 [label="<port0>Gugod|<port1>Autrijus", shape=record, pos="4504,26", rects="4444,8,4499,44 4499,8,4565,44", width="1.67", height="0.50"];
	node67 [label="<port0>H|<port1>J", shape=record, pos="4609,98", rects="4582,80,4612,116 4612,80,4636,116", width="0.75", height="0.50"];
	node68 [label="<port0>G|<port1>I", shape=record, pos="4609,26", rects="4582,8,4612,44 4612,8,4636,44", width="0.75", height="0.50"];
	node69 [label="<port0>H|<port1>G", shape=record, pos="4681,98", rects="4654,80,4681,116 4681,80,4708,116", width="0.75", height="0.50"];
	node70 [label="<port0>E|<port1>F", shape=record, pos="4681,26", rects="4654,8,4681,44 4681,8,4708,44", width="0.75", height="0.50"];
	node71 [label="<port0>F|<port1>K", shape=record, pos="4774,98", rects="4747,80,4772,116 4772,80,4801,116", width="0.75", height="0.50"];
	node72 [label="<port0>Charlee|<port1>Tifa", shape=record, pos="4774,26", rects="4726,8,4786,44 4786,8,4823,44", width="1.33", height="0.50"];
	node73 [label="<port0>Autrijus|<port1>Joan", shape=record, pos="4872,98", rects="4819,80,4885,116 4885,80,4925,116", width="1.47", height="0.50"];
	node74 [label="<port0>J|<port1>I", shape=record, pos="4872,26", rects="4845,8,4872,44 4872,8,4899,44", width="0.75", height="0.50"];
	node75 [label="<port0>B|<port1>H", shape=record, pos="4970,98", rects="4943,80,4969,116 4969,80,4997,116", width="0.75", height="0.50"];
	node76 [label="<port0>C|<port1>F", shape=record, pos="4970,26", rects="4943,8,4971,44 4971,8,4997,44", width="0.75", height="0.50"];
	node77 [label="<port0>A|<port1>J", shape=record, pos="5042,98", rects="5015,80,5045,116 5045,80,5069,116", width="0.75", height="0.50"];
	node78 [label="<port0>K|<port1>J", shape=record, pos="5042,26", rects="5015,8,5045,44 5045,8,5069,44", width="0.75", height="0.50"];
	node79 [label="<port0>K|<port1>B", shape=record, pos="5146,98", rects="5119,80,5147,116 5147,80,5173,116", width="0.75", height="0.50"];
	node80 [label="<port0>Gugod|<port1>Peacock", shape=record, pos="5146,26", rects="5087,8,5142,44 5142,8,5205,44", width="1.64", height="0.50"];
	node81 [label="<port0>I|<port1>A", shape=record, pos="5262,98", rects="5235,80,5258,116 5258,80,5289,116", width="0.75", height="0.50"];
	node82 [label="<port0>Dora|<port1>Tifa", shape=record, pos="5262,26", rects="5223,8,5265,44 5265,8,5302,44", width="1.08", height="0.50"];
	node83 [label="<port0>F|<port1>A", shape=record, pos="5346,98", rects="5319,80,5344,116 5344,80,5373,116", width="0.75", height="0.50"];
	node84 [label="<port0>G|<port1>C", shape=record, pos="5346,26", rects="5319,8,5346,44 5346,8,5373,44", width="0.75", height="0.50"];
	node85 [label="<port0>G|<port1>H", shape=record, pos="5418,98", rects="5391,80,5418,116 5418,80,5445,116", width="0.75", height="0.50"];
	node86 [label="<port0>B|<port1>E", shape=record, pos="5418,26", rects="5391,8,5418,44 5418,8,5445,44", width="0.75", height="0.50"];
	node87 [label="<port0>Angie|<port1>Charlee", shape=record, pos="5518,98", rects="5463,80,5513,116 5513,80,5573,116", width="1.53", height="0.50"];
	node88 [label="<port0>G|<port1>D", shape=record, pos="5518,26", rects="5491,8,5518,44 5518,8,5545,44", width="0.75", height="0.50"];
	node89 [label="<port0>Joan|<port1>Rose", shape=record, pos="5631,98", rects="5591,80,5631,116 5631,80,5672,116", width="1.11", height="0.50"];
	node90 [label="<port0>C|<port1>D", shape=record, pos="5631,26", rects="5604,8,5630,44 5630,8,5658,44", width="0.75", height="0.50"];
	node91 [label="<port0>D|<port1>J", shape=record, pos="5716,98", rects="5689,80,5719,116 5719,80,5743,116", width="0.75", height="0.50"];
	node92 [label="<port0>I|<port1>E", shape=record, pos="5716,26", rects="5689,8,5713,44 5713,8,5743,44", width="0.75", height="0.50"];
	node93 [label="<port0>Dora|<port1>Angie", shape=record, pos="5807,98", rects="5761,80,5803,116 5803,80,5853,116", width="1.28", height="0.50"];
	node94 [label="<port0>A|<port1>I", shape=record, pos="5807,26", rects="5780,8,5811,44 5811,8,5834,44", width="0.75", height="0.50"];
	node95 [label="<port0>Joan|<port1>Autrijus", shape=record, pos="5924,98", rects="5871,80,5911,116 5911,80,5977,116", width="1.47", height="0.50"];
	node96 [label="<port0>F|<port1>B", shape=record, pos="5924,26", rects="5897,8,5923,44 5923,8,5951,44", width="0.75", height="0.50"];
	node97 [label="<port0>A|<port1>C", shape=record, pos="6022,98", rects="5995,80,6023,116 6023,80,6049,116", width="0.75", height="0.50"];
	node98 [label="<port0>J|<port1>A", shape=record, pos="6022,26", rects="5995,8,6018,44 6018,8,6049,44", width="0.75", height="0.50"];
	node99 [label="<port0>Marry|<port1>Peacock", shape=record, pos="6125,98", rects="6067,80,6120,116 6120,80,6183,116", width="1.61", height="0.50"];
	node100 [label="<port0>Tifa|<port1>Charlee", shape=record, pos="6125,26", rects="6077,8,6114,44 6114,8,6174,44", width="1.33", height="0.50"];
	node101 [label="<port0>F|<port1>E", shape=record, pos="6238,98", rects="6211,80,6237,116 6237,80,6265,116", width="0.75", height="0.50"];
	node102 [label="<port0>Joan|<port1>Gugod", shape=record, pos="6238,26", rects="6191,8,6231,44 6231,8,6286,44", width="1.31", height="0.50"];
	node103 [label="<port0>I|<port1>B", shape=record, pos="6330,98", rects="6303,80,6327,116 6327,80,6357,116", width="0.75", height="0.50"];
	node104 [label="<port0>E|<port1>B", shape=record, pos="6330,26", rects="6303,8,6329,44 6329,8,6357,44", width="0.75", height="0.50"];
	node105 [label="<port0>Angie|<port1>Dora", shape=record, pos="6421,98", rects="6375,80,6425,116 6425,80,6467,116", width="1.28", height="0.50"];
	node106 [label="<port0>K|<port1>C", shape=record, pos="6421,26", rects="6394,8,6422,44 6422,8,6448,44", width="0.75", height="0.50"];
	node107 [label="<port0>D|<port1>B", shape=record, pos="6512,98", rects="6485,80,6512,116 6512,80,6539,116", width="0.75", height="0.50"];
	node108 [label="<port0>B|<port1>D", shape=record, pos="6512,26", rects="6485,8,6511,44 6511,8,6539,44", width="0.75", height="0.50"];
	node109 [label="<port0>F|<port1>I", shape=record, pos="6584,98", rects="6557,80,6586,116 6586,80,6611,116", width="0.75", height="0.50"];
	node110 [label="<port0>K|<port1>G", shape=record, pos="6584,26", rects="6557,8,6584,44 6584,8,6611,44", width="0.75", height="0.50"];
	node111 [label="<port0>A|<port1>K", shape=record, pos="6676,98", rects="6649,80,6676,116 6676,80,6703,116", width="0.75", height="0.50"];
	node112 [label="<port0>Marry|<port1>Rose", shape=record, pos="6676,26", rects="6629,8,6682,44 6682,8,6723,44", width="1.31", height="0.50"];
	node113 [label="<port0>Peacock|<port1>Gugod", shape=record, pos="6780,98", rects="6721,80,6784,116 6784,80,6839,116", width="1.64", height="0.50"];
	node114 [label="<port0>C|<port1>H", shape=record, pos="6780,26", rects="6753,8,6779,44 6779,8,6807,44", width="0.75", height="0.50"];
	node115 [label="<port0>A|<port1>H", shape=record, pos="6884,98", rects="6857,80,6884,116 6884,80,6911,116", width="0.75", height="0.50"];
	node116 [label="<port0>K|<port1>A", shape=record, pos="6884,26", rects="6857,8,6884,44 6884,8,6911,44", width="0.75", height="0.50"];
	node117 [label="<port0>C|<port1>I", shape=record, pos="6956,98", rects="6929,80,6959,116 6959,80,6983,116", width="0.75", height="0.50"];
	node118 [label="<port0>J|<port1>D", shape=record, pos="6956,26", rects="6929,8,6953,44 6953,8,6983,44", width="0.75", height="0.50"];
	node119 [label="<port0>B|<port1>F", shape=record, pos="7052,98", rects="7025,80,7053,116 7053,80,7079,116", width="0.75", height="0.50"];
	node120 [label="<port0>Charlee|<port1>Dora", shape=record, pos="7052,26", rects="7001,8,7061,44 7061,8,7103,44", width="1.42", height="0.50"];
	node121 [label="<port0>K|<port1>F", shape=record, pos="7148,98", rects="7121,80,7150,116 7150,80,7175,116", width="0.75", height="0.50"];
	node122 [label="<port0>A|<port1>B", shape=record, pos="7148,26", rects="7121,8,7149,44 7149,8,7175,44", width="0.75", height="0.50"];
	node123 [label="<port0>F|<port1>J", shape=record, pos="7220,98", rects="7193,80,7221,116 7221,80,7247,116", width="0.75", height="0.50"];
	node124 [label="<port0>C|<port1>A", shape=record, pos="7220,26", rects="7193,8,7219,44 7219,8,7247,44", width="0.75", height="0.50"];
	node125 [label="<port0>G|<port1>J", shape=record, pos="7292,98", rects="7265,80,7295,116 7295,80,7319,116", width="0.75", height="0.50"];
	node126 [label="<port0>I|<port1>C", shape=record, pos="7292,26", rects="7265,8,7289,44 7289,8,7319,44", width="0.75", height="0.50"];
	node127 [label="<port0>Charlee|<port1>Angie", shape=record, pos="7392,98", rects="7337,80,7397,116 7397,80,7447,116", width="1.53", height="0.50"];
	node128 [label="<port0>E|<port1>A", shape=record, pos="7392,26", rects="7365,8,7390,44 7390,8,7419,44", width="0.75", height="0.50"];
	node129 [label="<port0>H|<port1>F", shape=record, pos="7492,98", rects="7465,80,7493,116 7493,80,7519,116", width="0.75", height="0.50"];
	node130 [label="<port0>A|<port1>D", shape=record, pos="7492,26", rects="7465,8,7492,44 7492,8,7519,44", width="0.75", height="0.50"];
	node131 [label="<port0>I|<port1>F", shape=record, pos="7564,98", rects="7537,80,7562,116 7562,80,7591,116", width="0.75", height="0.50"];
	node132 [label="<port0>D|<port1>H", shape=record, pos="7564,26", rects="7537,8,7564,44 7564,8,7591,44", width="0.75", height="0.50"];
	node133 [label="<port0>A|<port1>F", shape=record, pos="7660,98", rects="7633,80,7662,116 7662,80,7687,116", width="0.75", height="0.50"];
	node134 [label="<port0>Joan|<port1>Peacock", shape=record, pos="7660,26", rects="7609,8,7649,44 7649,8,7712,44", width="1.42", height="0.50"];
	node135 [label="<port0>D|<port1>K", shape=record, pos="7756,98", rects="7729,80,7755,116 7755,80,7783,116", width="0.75", height="0.50"];
	node136 [label="<port0>J|<port1>K", shape=record, pos="7756,26", rects="7729,8,7752,44 7752,8,7783,44", width="0.75", height="0.50"];
	node137 [label="<port0>G|<port1>B", shape=record, pos="7865,98", rects="7838,80,7865,116 7865,80,7892,116", width="0.75", height="0.50"];
	node138 [label="<port0>Autrijus|<port1>Peacock", shape=record, pos="7865,26", rects="7801,8,7867,44 7867,8,7930,44", width="1.78", height="0.50"];
	node139 [label="<port0>B|<port1>J", shape=record, pos="8011,98", rects="7984,80,8013,116 8013,80,8038,116", width="0.75", height="0.50"];
	node140 [label="<port0>Peacock|<port1>Autrijus", shape=record, pos="8011,26", rects="7947,8,8010,44 8010,8,8076,44", width="1.78", height="0.50"];
	node141 [label="<port0>F|<port1>D", shape=record, pos="8120,98", rects="8093,80,8118,116 8118,80,8147,116", width="0.75", height="0.50"];
	node142 [label="<port0>H|<port1>D", shape=record, pos="8120,26", rects="8093,8,8120,44 8120,8,8147,44", width="0.75", height="0.50"];
	node143 [label="<port0>I|<port1>D", shape=record, pos="8224,98", rects="8197,80,8220,116 8220,80,8251,116", width="0.75", height="0.50"];
	node144 [label="<port0>Marry|<port1>Autrijus", shape=record, pos="8224,26", rects="8165,8,8218,44 8218,8,8284,44", width="1.64", height="0.50"];
	node1 -> node2 [pos="e,1681,44 1681,80 1681,72 1681,63 1681,54"];
	node3 -> node4 [pos="e,1773,44 1773,80 1773,72 1773,63 1773,54"];
	node5 -> node6 [pos="e,1877,44 1877,80 1877,72 1877,63 1877,54"];
	node7 -> node8 [pos="e,1981,44 1981,80 1981,72 1981,63 1981,54"];
	node9 -> node10 [pos="e,2065,44 2065,80 2065,72 2065,63 2065,54"];
	node11 -> node12 [pos="e,2170,44 2170,80 2170,72 2170,63 2170,54"];
	node13 -> node14 [pos="e,2275,44 2275,80 2275,72 2275,63 2275,54"];
	node15 -> node16 [pos="e,2360,44 2360,80 2360,72 2360,63 2360,54"];
	node17 -> node18 [pos="e,2445,44 2445,80 2445,72 2445,63 2445,54"];
	node19 -> node20 [pos="e,2517,44 2517,80 2517,72 2517,63 2517,54"];
	node21 -> node22 [pos="e,2589,44 2589,80 2589,72 2589,63 2589,54"];
	node23 -> node24 [pos="e,2661,44 2661,80 2661,72 2661,63 2661,54"];
	node25 -> node26 [pos="e,2733,44 2733,80 2733,72 2733,63 2733,54"];
	node27 -> node28 [pos="e,2831,44 2831,80 2831,72 2831,63 2831,54"];
	node29 -> node30 [pos="e,2929,44 2929,80 2929,72 2929,63 2929,54"];
	node31 -> node32 [pos="e,3001,44 3001,80 3001,72 3001,63 3001,54"];
	node33 -> node34 [pos="e,3089,44 3089,80 3089,72 3089,63 3089,54"];
	node35 -> node36 [pos="e,3177,44 3177,80 3177,72 3177,63 3177,54"];
	node37 -> node38 [pos="e,3275,44 3275,80 3275,72 3275,63 3275,54"];
	node39 -> node40 [pos="e,3373,44 3373,80 3373,72 3373,63 3373,54"];
	node41 -> node42 [pos="e,3465,44 3465,80 3465,72 3465,63 3465,54"];
	node43 -> node44 [pos="e,3537,44 3537,80 3537,72 3537,63 3537,54"];
	node45 -> node46 [pos="e,3640,44 3640,80 3640,72 3640,63 3640,54"];
	node47 -> node48 [pos="e,3743,44 3743,80 3743,72 3743,63 3743,54"];
	node49 -> node50 [pos="e,3815,44 3815,80 3815,72 3815,63 3815,54"];
	node51 -> node52 [pos="e,3887,44 3887,80 3887,72 3887,63 3887,54"];
	node53 -> node54 [pos="e,3959,44 3959,80 3959,72 3959,63 3959,54"];
	node55 -> node56 [pos="e,4031,44 4031,80 4031,72 4031,63 4031,54"];
	node57 -> node58 [pos="e,4119,44 4119,80 4119,72 4119,63 4119,54"];
	node59 -> node60 [pos="e,4207,44 4207,80 4207,72 4207,63 4207,54"];
	node61 -> node62 [pos="e,4303,44 4303,80 4303,72 4303,63 4303,54"];
	node63 -> node64 [pos="e,4399,44 4399,80 4399,72 4399,63 4399,54"];
	node65 -> node66 [pos="e,4504,44 4504,80 4504,72 4504,63 4504,54"];
	node67 -> node68 [pos="e,4609,44 4609,80 4609,72 4609,63 4609,54"];
	node69 -> node70 [pos="e,4681,44 4681,80 4681,72 4681,63 4681,54"];
	node71 -> node72 [pos="e,4774,44 4774,80 4774,72 4774,63 4774,54"];
	node73 -> node74 [pos="e,4872,44 4872,80 4872,72 4872,63 4872,54"];
	node75 -> node76 [pos="e,4970,44 4970,80 4970,72 4970,63 4970,54"];
	node77 -> node78 [pos="e,5042,44 5042,80 5042,72 5042,63 5042,54"];
	node79 -> node80 [pos="e,5146,44 5146,80 5146,72 5146,63 5146,54"];
	node81 -> node82 [pos="e,5262,44 5262,80 5262,72 5262,63 5262,54"];
	node83 -> node84 [pos="e,5346,44 5346,80 5346,72 5346,63 5346,54"];
	node85 -> node86 [pos="e,5418,44 5418,80 5418,72 5418,63 5418,54"];
	node87 -> node88 [pos="e,5518,44 5518,80 5518,72 5518,63 5518,54"];
	node89 -> node90 [pos="e,5631,44 5631,80 5631,72 5631,63 5631,54"];
	node91 -> node92 [pos="e,5716,44 5716,80 5716,72 5716,63 5716,54"];
	node93 -> node94 [pos="e,5807,44 5807,80 5807,72 5807,63 5807,54"];
	node95 -> node96 [pos="e,5924,44 5924,80 5924,72 5924,63 5924,54"];
	node97 -> node98 [pos="e,6022,44 6022,80 6022,72 6022,63 6022,54"];
	node99 -> node100 [pos="e,6125,44 6125,80 6125,72 6125,63 6125,54"];
	node101 -> node102 [pos="e,6238,44 6238,80 6238,72 6238,63 6238,54"];
	node103 -> node104 [pos="e,6330,44 6330,80 6330,72 6330,63 6330,54"];
	node105 -> node106 [pos="e,6421,44 6421,80 6421,72 6421,63 6421,54"];
	node107 -> node108 [pos="e,6512,44 6512,80 6512,72 6512,63 6512,54"];
	node109 -> node110 [pos="e,6584,44 6584,80 6584,72 6584,63 6584,54"];
	node111 -> node112 [pos="e,6676,44 6676,80 6676,72 6676,63 6676,54"];
	node113 -> node114 [pos="e,6780,44 6780,80 6780,72 6780,63 6780,54"];
	node115 -> node116 [pos="e,6884,44 6884,80 6884,72 6884,63 6884,54"];
	node117 -> node118 [pos="e,6956,44 6956,80 6956,72 6956,63 6956,54"];
	node119 -> node120 [pos="e,7052,44 7052,80 7052,72 7052,63 7052,54"];
	node121 -> node122 [pos="e,7148,44 7148,80 7148,72 7148,63 7148,54"];
	node123 -> node124 [pos="e,7220,44 7220,80 7220,72 7220,63 7220,54"];
	node125 -> node126 [pos="e,7292,44 7292,80 7292,72 7292,63 7292,54"];
	node127 -> node128 [pos="e,7392,44 7392,80 7392,72 7392,63 7392,54"];
	node129 -> node130 [pos="e,7492,44 7492,80 7492,72 7492,63 7492,54"];
	node131 -> node132 [pos="e,7564,44 7564,80 7564,72 7564,63 7564,54"];
	node133 -> node134 [pos="e,7660,44 7660,80 7660,72 7660,63 7660,54"];
	node135 -> node136 [pos="e,7756,44 7756,80 7756,72 7756,63 7756,54"];
	node137 -> node138 [pos="e,7865,44 7865,80 7865,72 7865,63 7865,54"];
	node139 -> node140 [pos="e,8011,44 8011,80 8011,72 8011,63 8011,54"];
	node141 -> node142 [pos="e,8120,44 8120,80 8120,72 8120,63 8120,54"];
	node143 -> node144 [pos="e,8224,44 8224,80 8224,72 8224,63 8224,54"];
}
