# Copyright (C) 2001-2004 Daniel Berrange <dan@berrange.com>
#
# $Id: Config-Record.spec.PL,v 1.6 2005/03/09 21:52:34 dan Exp $

use strict;

die unless (scalar @ARGV == 1);

unless (do 'lib/Config/Record.pm')
  {
    if ($@) { die $@ };
    die "lib/Config/Record.pm: $!";
  }
		
local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$Config::Record::VERSION/g;

open SPEC, ">$ARGV[0]" or die "$!";
print SPEC $_;
close SPEC;
__DATA__
# Automatically generated by Config-Record.spec.PL

%define perlsitearch %(perl -e 'use Config; print $Config{installsitearch}')
%define perlsitelib %(perl -e 'use Config; print $Config{installsitelib}')
%define perlsiteprefix %(perl -e 'use Config; print $Config{siteprefix}')
%define perlsiteman3 %{perlsiteprefix}/share/man/man3
%define perlversion %(perl -e 'use Config; print $Config{version}')

%define appname Config-Record

Summary: Config::Record - Simple configuration records
Name: perl-%{appname}
Version: @VERSION@
Release: 1
Copyright: GPL
Group: Applications/Internet
Source: %{appname}-%{version}.tar.gz
BuildRoot: /var/tmp/%{appname}-%{version}-root
BuildArchitectures: noarch
Requires: perl >= %{perlversion}

%description
Config::Record provides a module for loading configuration
records. It supports scalar, array and hash parameters nested
to an arbitrary depth.
 
%prep
%setup -q -n %{appname}-%{version}


%build
perl Makefile.PL PREFIX=$RPM_BUILD_ROOT/usr
make


%install
rm -rf $RPM_BUILD_ROOT
make install INSTALLSITEMAN3DIR=$RPM_BUILD_ROOT%{perlsiteman3}
find $RPM_BUILD_ROOT%{perlsitearch} -name perllocal.pod -exec rm -f {} \;

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%doc AUTHORS
%doc LICENSE
%doc README
%{perlsiteman3}/*
%{perlsitelib}/Config/Record.pm
%{perlsitelib}/Config/Record.pod
%{perlsitearch}/auto/Config/Record/
