#include <xs/xs.h>
#include <xs/lib/merge.h>

static OP* pp_sassign (pTHX) {
    dSP;
    SV* left = *SP; SV* right = *(SP-1);

    if (PL_op->op_private & OPpASSIGN_BACKWARDS) {
        SV*const temp = left;
        left = right; right = temp;
    }
    
    if (SvROK(left) && SvROK(right) && SvTYPE(SvRV(left)) == SvTYPE(SvRV(right)) && SvTYPE(SvRV(left)) == SVt_PVHV) {
        xs::lib::merge(left, right);
        POPs; SETs(left);
        return NORMAL;
    }
    
    return PL_ppaddr[PL_op->op_type](aTHX);
}

MODULE = Panda::Config::Perl                PACKAGE = Panda::Config::Perl
PROTOTYPES: DISABLE

void tune_ops (CV* sub) {
    if (!sub) croak("tune_ops: panic - no CV");
    for (OP* op = CvSTART(sub); op; op = op->op_next)
        if (op->op_type == OP_SASSIGN)
            op->op_ppaddr = pp_sassign;
}