
package Paws::ApiGateway::GetAuthorizer;
  use Moose;
  has AuthorizerId => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'authorizer_id', required => 1);
  has RestApiId => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'restapi_id', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'GetAuthorizer');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/restapis/{restapi_id}/authorizers/{authorizer_id}');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'GET');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::ApiGateway::Authorizer');
1;

### main pod documentation begin ###

=head1 NAME

Paws::ApiGateway::GetAuthorizer - Arguments for method GetAuthorizer on L<Paws::ApiGateway>

=head1 DESCRIPTION

This class represents the parameters used for calling the method GetAuthorizer on the
L<Amazon API Gateway|Paws::ApiGateway> service. Use the attributes of this class
as arguments to method GetAuthorizer.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to GetAuthorizer.

=head1 SYNOPSIS

    my $apigateway = Paws->service('ApiGateway');
    my $Authorizer = $apigateway->GetAuthorizer(
      AuthorizerId => 'MyString',
      RestApiId    => 'MyString',

    );

    # Results:
    my $AuthType              = $Authorizer->AuthType;
    my $AuthorizerCredentials = $Authorizer->AuthorizerCredentials;
    my $AuthorizerResultTtlInSeconds =
      $Authorizer->AuthorizerResultTtlInSeconds;
    my $AuthorizerUri  = $Authorizer->AuthorizerUri;
    my $Id             = $Authorizer->Id;
    my $IdentitySource = $Authorizer->IdentitySource;
    my $IdentityValidationExpression =
      $Authorizer->IdentityValidationExpression;
    my $Name         = $Authorizer->Name;
    my $ProviderARNs = $Authorizer->ProviderARNs;
    my $Type         = $Authorizer->Type;

    # Returns a L<Paws::ApiGateway::Authorizer> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://aws.amazon.com/documentation/apigateway/>

=head1 ATTRIBUTES


=head2 B<REQUIRED> AuthorizerId => Str

[Required] The identifier of the Authorizer resource.



=head2 B<REQUIRED> RestApiId => Str

[Required] The string identifier of the associated RestApi.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method GetAuthorizer in L<Paws::ApiGateway>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

