package Paws::Glue::Trigger;
  use Moose;
  has Actions => (is => 'ro', isa => 'ArrayRef[Paws::Glue::Action]');
  has Description => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has Predicate => (is => 'ro', isa => 'Paws::Glue::Predicate');
  has Schedule => (is => 'ro', isa => 'Str');
  has State => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::Trigger

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::Trigger object:

  $service_obj->Method(Att1 => { Actions => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::Trigger object:

  $result = $service_obj->Method(...);
  $result->Att1->Actions

=head1 DESCRIPTION

Information about a specific trigger.

=head1 ATTRIBUTES


=head2 Actions => ArrayRef[L<Paws::Glue::Action>]

  The actions initiated by this trigger.


=head2 Description => Str

  A description of this trigger.


=head2 Id => Str

  The trigger ID.


=head2 Name => Str

  Name of the trigger.


=head2 Predicate => L<Paws::Glue::Predicate>

  The predicate of this trigger.


=head2 Schedule => Str

  A cron schedule expression.


=head2 State => Str

  The current state of the trigger.


=head2 Type => Str

  The type of trigger that this is.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

