
#
# Copyright (C) 2002  Sam Horrocks
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

package SpeedyMake::mod_speedycgi;

use strict;
use ExtUtils::MakeMaker;
use vars qw(@ISA);

require '../src/SpeedyMake.pl';
@ISA = 'SpeedyMake';

sub inc {'apache'}
sub main_file_full {'mod_speedycgi'}
sub my_name_full {shift->main_file_full}
sub mod_speedycgi_out {'mod_speedycgi.so'}
sub mod_speedycgi_target {'mod_speedycgi.so'}
sub clean_files_extra {}
sub mod_speedycgi_cmds {'../src/mod_speedycgi_cmds.c'}
sub debug_opts {
    return shift->devel ? "'-Wc,${SpeedyMake::OPTIMIZE}'" : undef;
}

sub write_makefile { my $class = shift;
    printf "Writing Makefile for %s\n", $class->my_name_full;
    $class->make_speedy_h;
    my $mm = MM->new({$class->mm_params});

    open(F, '>Makefile');

    foreach my $x (
	[qw(SRC_CFILES src_files_c)],
	[qw(OFILES src_files_o)],
	[qw(C_FILE_CLEAN clean_files_c)],
	[qw(CHECK_SYMS check_syms_def)],
	[qw(DEF extra_defines)],
	[qw(DEBUG debug_opts)],
	[qw(SHARED_OBJ_TARGET mod_speedycgi_target)],
	[qw(SHARED_OBJ_REAL mod_speedycgi_out)],
	[qw(CLEAN_EXTRA clean_files_extra)],
	[qw(MOD_SPEEDYCGI_CMDS mod_speedycgi_cmds)],
    )
    {
	my($def, $method) = @$x;
	printf F "${def}=%s\n\n", join(' ', $class->$method());
    }

    print F join("\n\n",
	"##\n## Generated by Makefile.PL\n##",
	$mm->constants,
	$mm->tools_other,
	'all: mod_speedycgi.so',
	$class->symlink_c_files,
	$class->optdefs_cmds,
	$mm->test,
	$class->testing_postamble,
	''
    );

    if ($class->mod_speedycgi_out ne 'mod_speedycgi.so') {
	printf F "\nmod_speedycgi.so: %s\n\t\$(CP) %s mod_speedycgi.so\n\n",
	    $class->mod_speedycgi_target, $class->mod_speedycgi_out;
    }

    open(F2, '../mod_speedycgi/Makefile.tmpl');
    print F <F2>;
    close(F2);

    close(F);
}

$main::do_not_write_makefile || SpeedyMake::mod_speedycgi->init->write_makefile;
