use strict;
BEGIN { $^W = 1 }

use Test::More tests => 42;
use DateTime::Calendar::Christian;

#########################

sub test_dates {
    my $r = DateTime->new( year => 1752, month => 9, day => 14 );
    foreach my $test ( @_ )
    {
        my @args = @{ $test->[0] };
        my @results = @{ $test->[1] };

        my $dt = DateTime::Calendar::Christian->new(
                                year  => $args[0],
                                month => $args[1],
                                day   => $args[2],
                                reform_date => $r,
                              );

        my ($year, $week) = $dt->week();

        is( "$year-W$week", "$results[0]-W$results[1]", "woy @args" );
    }
}

# The week_number algorithm is different from the one in DateTime.pm, so
# I include all its tests here. As there are no dates before 1752 here,
# results should be the same.

my @tests = ( [ [ 1964, 12, 31 ], [ 1964, 53 ] ],
              [ [ 1965,  1,  1 ], [ 1964, 53 ] ],
              [ [ 1971,  9,  7 ], [ 1971, 36 ] ],
              [ [ 1971, 10, 25 ], [ 1971, 43 ] ],
              [ [ 1995,  1,  1 ], [ 1994, 52 ] ],
              [ [ 1995, 11, 18 ], [ 1995, 46 ] ],
              [ [ 1995, 12, 31 ], [ 1995, 52 ] ],
              [ [ 1996, 12, 31 ], [ 1997,  1 ] ],
              [ [ 2001,  4, 28 ], [ 2001, 17 ] ],
              [ [ 2001,  8,  2 ], [ 2001, 31 ] ],
              [ [ 2001,  9, 11 ], [ 2001, 37 ] ],
              [ [ 2002, 12, 25 ], [ 2002, 52 ] ],
              [ [ 2002, 12, 31 ], [ 2003,  1 ] ],
              [ [ 2003,  1,  1 ], [ 2003,  1 ] ],
              [ [ 2003, 12, 31 ], [ 2004,  1 ] ],
              [ [ 2004,  1,  1 ], [ 2004,  1 ] ],
              [ [ 2004, 12, 31 ], [ 2004, 53 ] ],
              [ [ 2005,  1,  1 ], [ 2004, 53 ] ],
              [ [ 2005, 12, 31 ], [ 2005, 52 ] ],
              [ [ 2006,  1,  1 ], [ 2005, 52 ] ],
              [ [ 2006, 12, 31 ], [ 2006, 52 ] ],
              [ [ 2007,  1,  1 ], [ 2007,  1 ] ],
              [ [ 2007, 12, 31 ], [ 2008,  1 ] ],
              [ [ 2008,  1,  1 ], [ 2008,  1 ] ],
              [ [ 2008, 12, 31 ], [ 2009,  1 ] ],
              [ [ 2009,  1,  1 ], [ 2009,  1 ] ],
            );

test_dates( @tests );

@tests = ( [ [ 1751, 12, 29 ], [ 1751, 52 ] ],
           [ [ 1751, 12, 30 ], [ 1752,  1 ] ],
           [ [ 1752,  1,  1 ], [ 1752,  1 ] ],
           [ [ 1752,  1,  5 ], [ 1752,  1 ] ],
           [ [ 1752,  1,  6 ], [ 1752,  2 ] ],
           [ [ 1752,  8, 30 ], [ 1752, 35 ] ],
           [ [ 1752,  8, 31 ], [ 1752, 36 ] ],
           [ [ 1752,  9,  2 ], [ 1752, 36 ] ],
           [ [ 1752,  9, 14 ], [ 1752, 36 ] ],
           [ [ 1752,  9, 17 ], [ 1752, 36 ] ],
           [ [ 1752,  9, 18 ], [ 1752, 37 ] ],
           [ [ 1752, 10, 26 ], [ 1752, 42 ] ],
           [ [ 1752, 12, 24 ], [ 1752, 50 ] ],
           [ [ 1752, 12, 25 ], [ 1752, 51 ] ],
           [ [ 1752, 12, 31 ], [ 1752, 51 ] ],
           [ [ 1753,  1,  1 ], [ 1753,  1 ] ],
        );

test_dates( @tests );
