/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.property;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.util.StringUtil;

public class PropertyUtil {
    public static final String[] servicePropertyList = new String[]{"derby.engineType", "derby.database.noAutoBoot", "derby.storage.tempDirectory", "encryptionProvider", "encryptionAlgorithm", "restoreFrom", "logDevice", "derby.storage.logArchiveMode"};
    public static final int SET_IN_JVM = 0;
    public static final int SET_IN_DATABASE = 1;
    public static final int SET_IN_APPLICATION = 2;
    public static final int NOT_SET = -1;

    static int whereSet(String string, Dictionary dictionary) {
        boolean bl = PropertyUtil.isDBOnly(dictionary);
        if (!bl && Monitor.getMonitor().getJVMProperty(string) != null) {
            return 0;
        }
        if (dictionary != null && dictionary.get(string) != null) {
            return 1;
        }
        if (!bl && PropertyUtil.getSystemProperty(string) != null) {
            return 2;
        }
        return -1;
    }

    public static boolean isDBOnly(Dictionary dictionary) {
        if (dictionary == null) {
            return false;
        }
        String string = (String)dictionary.get("derby.database.propertiesOnly");
        boolean bl = Boolean.valueOf(string != null ? string.trim() : string);
        return bl;
    }

    public static boolean isDBOnly(Properties properties) {
        if (properties == null) {
            return false;
        }
        String string = properties.getProperty("derby.database.propertiesOnly");
        boolean bl = Boolean.valueOf(string != null ? string.trim() : string);
        return bl;
    }

    public static String getSystemProperty(String string) {
        return PropertyUtil.getSystemProperty(string, null);
    }

    public static String getSystemProperty(String string, String string2) {
        Properties properties;
        ModuleFactory moduleFactory = Monitor.getMonitorLite();
        String string3 = moduleFactory.getJVMProperty(string);
        if (string3 == null && (properties = moduleFactory.getApplicationProperties()) != null) {
            string3 = properties.getProperty(string);
        }
        return string3 == null ? string2 : string3;
    }

    public static String getPropertyFromSet(Properties properties, String string) {
        boolean bl = properties != null ? PropertyUtil.isDBOnly(properties) : false;
        return PropertyUtil.getPropertyFromSet(bl, properties, string);
    }

    public static Serializable getPropertyFromSet(Dictionary dictionary, String string) {
        boolean bl = dictionary != null ? PropertyUtil.isDBOnly(dictionary) : false;
        return PropertyUtil.getPropertyFromSet(bl, dictionary, string);
    }

    public static Serializable getPropertyFromSet(boolean bl, Dictionary dictionary, String string) {
        if (dictionary != null) {
            Object object;
            if (!bl && (object = Monitor.getMonitor().getJVMProperty(string)) != null) {
                return object;
            }
            object = (Serializable)dictionary.get(string);
            if (object != null) {
                return object;
            }
            if (bl) {
                return null;
            }
        }
        return PropertyUtil.getSystemProperty(string);
    }

    public static String getPropertyFromSet(boolean bl, Properties properties, String string) {
        if (properties != null) {
            String string2;
            if (!bl && (string2 = Monitor.getMonitor().getJVMProperty(string)) != null) {
                return string2;
            }
            string2 = properties.getProperty(string);
            if (string2 != null) {
                return string2;
            }
            if (bl) {
                return null;
            }
        }
        return PropertyUtil.getSystemProperty(string);
    }

    public static String getDatabaseProperty(PersistentSet persistentSet, String string) throws StandardException {
        if (persistentSet == null) {
            return null;
        }
        Serializable serializable = persistentSet.getProperty(string);
        if (serializable == null) {
            return null;
        }
        return serializable.toString();
    }

    public static String getServiceProperty(PersistentSet persistentSet, String string, String string2) throws StandardException {
        String string3 = PropertyUtil.getDatabaseProperty(persistentSet, "derby.database.propertiesOnly");
        boolean bl = Boolean.valueOf(string3 != null ? string3.trim() : string3);
        if (!bl && (string3 = Monitor.getMonitor().getJVMProperty(string)) != null) {
            return string3;
        }
        string3 = PropertyUtil.getDatabaseProperty(persistentSet, string);
        if (string3 != null) {
            return string3;
        }
        if (bl) {
            return string2;
        }
        return PropertyUtil.getSystemProperty(string, string2);
    }

    public static String getServiceProperty(PersistentSet persistentSet, String string) throws StandardException {
        return PropertyUtil.getServiceProperty(persistentSet, string, null);
    }

    public static boolean getSystemBoolean(String string) {
        String string2 = PropertyUtil.getSystemProperty(string);
        return Boolean.valueOf(string2 != null ? string2.trim() : string2);
    }

    public static boolean getServiceBoolean(PersistentSet persistentSet, String string, boolean bl) throws StandardException {
        String string2 = PropertyUtil.getServiceProperty(persistentSet, string);
        return PropertyUtil.booleanProperty(string, (Serializable)((Object)string2), bl);
    }

    public static int getSystemInt(String string, int n, int n2, int n3) {
        return PropertyUtil.handleInt(PropertyUtil.getSystemProperty(string), n, n2, n3);
    }

    public static int getServiceInt(PersistentSet persistentSet, String string, int n, int n2, int n3) throws StandardException {
        return PropertyUtil.handleInt(PropertyUtil.getServiceProperty(persistentSet, string), n, n2, n3);
    }

    public static int getServiceInt(PersistentSet persistentSet, Properties properties, String string, int n, int n2, int n3) throws StandardException {
        String string2 = null;
        if (properties != null) {
            string2 = properties.getProperty(string);
        }
        if (string2 == null) {
            string2 = PropertyUtil.getServiceProperty(persistentSet, string);
        }
        return PropertyUtil.handleInt(string2, n, n2, n3);
    }

    public static int getSystemInt(String string, int n) {
        return PropertyUtil.getSystemInt(string, 0, Integer.MAX_VALUE, n);
    }

    public static int handleInt(String string, int n, int n2, int n3) {
        if (string == null) {
            return n3;
        }
        try {
            int n4 = Integer.parseInt(string);
            if (n4 >= n && n4 <= n2) {
                return n4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n3;
    }

    public static boolean booleanProperty(String string, Serializable serializable, boolean bl) throws StandardException {
        if (serializable == null) {
            return bl;
        }
        String string2 = ((String)((Object)serializable)).trim();
        if (StringUtil.SQLToLowerCase(string2).equals("true")) {
            return true;
        }
        if (StringUtil.SQLToLowerCase(string2).equals("false")) {
            return false;
        }
        throw StandardException.newException("XCY00.S", string, (Object)string2);
    }

    public static int intPropertyValue(String string, Serializable serializable, int n, int n2, int n3) throws StandardException {
        if (serializable == null) {
            return n3;
        }
        String string2 = ((String)((Object)serializable)).trim();
        try {
            int n4 = Integer.parseInt(string2);
            if (n4 < n || n4 > n2) {
                throw StandardException.newException("XCY00.S", string, (Object)string2);
            }
            return n4;
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("XCY00.S", string, (Object)string2);
        }
    }

    public static boolean isServiceProperty(String string) {
        for (int i = 0; i < servicePropertyList.length; ++i) {
            if (!string.equals(servicePropertyList[i])) continue;
            return true;
        }
        return false;
    }
}

