## HOW TO CONTRIBUTE

Thank you for considering contributing to this distribution.  This file
contains instructions that will help you work with the source code.

These instructions are based on dagolden's

    https://raw.githubusercontent.com/dagolden/Capture-Tiny/master/CONTRIBUTING

Where they're helpful, he gets the credit.

The distribution is managed with Dist::Zilla.  This means than many of the
usual files you might expect are not in the repository, but are generated at
release time (e.g. Makefile.PL).

Generally, **you do not need Dist::Zilla to contribute patches**.  You do need
Dist::Zilla to create a tarball and/or install from the repository.  See below
for guidance.

### Getting dependencies

See the included `cpanfile` file for a list of dependencies.  If you have
App::cpanminus 1.6 or later installed, you can use `cpanm` to satisfy
dependencies like this:

    $ cpanm --installdeps .

Otherwise, you can install Module::CPANfile 1.0002 or later and then satisfy
dependencies with the regular `cpan` client and `cpanfile-dump`:

    $ cpan `cpanfile-dump`

### Building the libraries

    $ perl ./Build.PL
    $ perl ./Build

### Running tests

You can run tests directly using the `prove` tool:

    $ prove -lb
    $ prove -lbv t/basic.t

`prove` should be sufficient for you to test any patches you have. I
use `prove` for 99% of my testing during development.

### Code style and tidying

Please try to match any existing coding style.  If there is a `.perltidyrc`
file, please install Perl::Tidy and use perltidy before submitting patches.

If there is a `tidyall.ini` file, you can also install Code::TidyAll and run
`tidyall` on a file or `tidyall -a` to tidy all files.

### Patching documentation

Much of the documentation Pod is generated at release time.

If you would like to submit a documentation edit, please limit yourself to the
documentation you see.

If you see typos or documentation issues in the generated docs, please
email or open a bug ticket instead of patching.

### Installing from the repository

If you want to install directly from the repository, you need to have
Dist::Zilla installed (see below).  If this is a burden to you, I welcome
patches against a CPAN tarball instead of the repository.

### Installing and using Dist::Zilla

Dist::Zilla is a very powerful authoring tool, optimized for maintaining a
large number of distributions with a high degree of automation, but it has a
large dependency chain, a bit of a learning curve and requires a number of
author-specific plugins.

To install it from CPAN, I recommend one of the following approaches for
the quickest installation:

    # using CPAN.pm, but bypassing non-functional pod tests
    $ cpan TAP::Harness::Restricted
    $ PERL_MM_USE_DEFAULT=1 HARNESS_CLASS=TAP::Harness::Restricted cpan Dist::Zilla

    # using cpanm, bypassing *all* tests
    $ cpanm -n Dist::Zilla

In either case, it's probably going to take about 10 minutes.  Go for a walk,
go get a cup of your favorite beverage, take a bathroom break, or whatever.
When you get back, Dist::Zilla should be ready for you.

Then you need to install any plugins specific to this distribution:

    $ cpan `dzil authordeps`
    $ dzil authordeps | cpanm

If you haven't already installed the prerequisites, you'll need to
install them now:

    $ cpan `dzil listdeps`
    $ dzil listdeps | cpanm

Once installed, here are some dzil commands you might try:

    $ dzil build
    $ dzil test
    $ dzil xtest

To install from the repository, use:

    $ dzil install

You can learn more about Dist::Zilla at http://dzil.org/

### Credits

