/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.latex3;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.latex3.ClistCommand;
import com.dickimawbooks.texparserlib.latex.latex3.L3StorageCommand;
import com.dickimawbooks.texparserlib.latex.latex3.PropertyCommand;
import com.dickimawbooks.texparserlib.latex.latex3.SequenceCommand;
import com.dickimawbooks.texparserlib.latex.latex3.TokenListCommand;
import java.io.IOException;

public class ClearL3Object
extends ControlSequence {
    protected boolean global = false;
    protected char suffix = (char)78;

    public ClearL3Object(String string) {
        this(string, string.contains("_gclear:"), string.charAt(string.length() - 1));
    }

    public ClearL3Object(String string, boolean bl, char c) {
        super(string);
        this.global = bl;
        this.suffix = c;
    }

    @Override
    public Object clone() {
        return new ClearL3Object(this.getName(), this.global, this.suffix);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        ControlSequence controlSequence;
        String string;
        if (this.suffix == 'c') {
            string = this.popLabelString(teXParser, teXObjectList);
            controlSequence = teXParser.getControlSequence(string);
        } else {
            controlSequence = this.popControlSequence(teXParser, teXObjectList);
            string = controlSequence.getName();
        }
        if (controlSequence instanceof L3StorageCommand) {
            L3StorageCommand l3StorageCommand = (L3StorageCommand)((Object)controlSequence);
            if (!this.global) {
                l3StorageCommand = (L3StorageCommand)controlSequence.clone();
            }
            l3StorageCommand.clear();
            teXParser.putControlSequence(!this.global, (ControlSequence)((Object)l3StorageCommand));
        } else if (this.name.startsWith("tl_")) {
            teXParser.putControlSequence(!this.global, new TokenListCommand(string));
        } else if (this.name.startsWith("seq_")) {
            teXParser.putControlSequence(!this.global, new SequenceCommand(string));
        } else if (this.name.startsWith("clist_")) {
            teXParser.putControlSequence(!this.global, new ClistCommand(string));
        } else if (this.name.startsWith("prop_")) {
            teXParser.putControlSequence(!this.global, new PropertyCommand(string));
        } else {
            teXParser.putControlSequence(!this.global, new GenericCommand(true, string));
        }
    }
}

