/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.memoryview;

import com.oracle.graal.python.builtins.objects.memoryview.BufferLifecycleManager;
import com.oracle.graal.python.builtins.objects.memoryview.NativeBufferLifecycleManager;
import com.oracle.graal.python.builtins.objects.memoryview.NativeBufferReference;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.memoryview.SimpleBufferReference;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;

abstract class BufferReference
extends AsyncHandler.SharedFinalizer.FinalizableReference {
    public BufferReference(PMemoryView referent, BufferLifecycleManager bufferLifecycleManager, AsyncHandler.SharedFinalizer sharedFinalizer) {
        super(referent, bufferLifecycleManager, sharedFinalizer);
        assert (bufferLifecycleManager != null);
        bufferLifecycleManager.incrementExports();
    }

    public BufferLifecycleManager getLifecycleManager() {
        return (BufferLifecycleManager)this.getReference();
    }

    protected abstract AsyncHandler.AsyncAction callback();

    @Override
    public AsyncHandler.AsyncAction release() {
        BufferLifecycleManager buffer = this.getLifecycleManager();
        if (buffer.decrementExports() == 0) {
            return this.callback();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static BufferReference createNativeBufferReference(PMemoryView referent, BufferLifecycleManager bufferLifecycleManager, PythonContext context) {
        return new NativeBufferReference(referent, bufferLifecycleManager, context.getSharedFinalizer());
    }

    @CompilerDirectives.TruffleBoundary
    public static BufferReference createSimpleBufferReference(PMemoryView referent, BufferLifecycleManager bufferLifecycleManager, PythonContext context) {
        return new SimpleBufferReference(referent, bufferLifecycleManager, context.getSharedFinalizer());
    }

    public static BufferReference createBufferReference(PMemoryView referent, BufferLifecycleManager bufferLifecycleManager, PythonContext context) {
        if (bufferLifecycleManager instanceof NativeBufferLifecycleManager) {
            return BufferReference.createNativeBufferReference(referent, bufferLifecycleManager, context);
        }
        return BufferReference.createSimpleBufferReference(referent, bufferLifecycleManager, context);
    }
}

