/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.impl;

import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.HttpProcessor;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.RequestConformance;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.RequestConnControl;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.RequestContent;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.RequestExpectContinue;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.RequestTE;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.RequestValidateHost;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.ResponseConformance;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.ResponseConnControl;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.ResponseContent;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.ResponseDate;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.ResponseServer;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.TextUtils;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.VersionInfo;

public final class HttpProcessors {
    private static final String SOFTWARE = "Apache-HttpCore";

    public static HttpProcessorBuilder customServer(String serverInfo) {
        return HttpProcessorBuilder.create().addAll(ResponseConformance.INSTANCE, ResponseDate.INSTANCE, new ResponseServer(!TextUtils.isBlank(serverInfo) ? serverInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "org.opensearch.notifications.core.repackage.org.apache.hc.core5", HttpProcessors.class)), ResponseContent.INSTANCE, ResponseConnControl.INSTANCE).addAll(RequestValidateHost.INSTANCE, RequestConformance.INSTANCE);
    }

    public static HttpProcessor server(String serverInfo) {
        return HttpProcessors.customServer(serverInfo).build();
    }

    public static HttpProcessor server() {
        return HttpProcessors.customServer(null).build();
    }

    public static HttpProcessorBuilder customClient(String agentInfo) {
        return HttpProcessorBuilder.create().addAll(RequestTargetHost.INSTANCE, RequestContent.INSTANCE, RequestConnControl.INSTANCE, new RequestUserAgent(!TextUtils.isBlank(agentInfo) ? agentInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "org.opensearch.notifications.core.repackage.org.apache.hc.core5", HttpProcessors.class)), RequestExpectContinue.INSTANCE);
    }

    public static HttpProcessorBuilder strictClient(String agentInfo) {
        return HttpProcessorBuilder.create().addAll(RequestTargetHost.INSTANCE, RequestContent.INSTANCE, RequestConnControl.INSTANCE, RequestTE.INSTANCE, new RequestUserAgent(!TextUtils.isBlank(agentInfo) ? agentInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "org.opensearch.notifications.core.repackage.org.apache.hc.core5", HttpProcessors.class)), RequestExpectContinue.INSTANCE);
    }

    public static HttpProcessorBuilder customClient(String agentInfo, boolean strict) {
        return strict ? HttpProcessors.strictClient(agentInfo) : HttpProcessors.customClient(agentInfo);
    }

    public static HttpProcessor client(String agentInfo) {
        return HttpProcessors.client(agentInfo, false);
    }

    public static HttpProcessor client() {
        return HttpProcessors.client(null);
    }

    public static HttpProcessor client(String agentInfo, boolean strict) {
        return HttpProcessors.customClient(agentInfo, strict).build();
    }

    public static HttpProcessor clientStrict() {
        return HttpProcessors.customClient(null, true).build();
    }

    public static HttpProcessor clientStrict(String agentInfo) {
        return HttpProcessors.customClient(agentInfo, true).build();
    }
}

