/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.ml;

import java.util.Map;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.model.MLModelConfig;
import org.opensearch.ml.common.model.RemoteModelConfig;
import org.opensearch.ml.common.model.TextEmbeddingModelConfig;

public class AsymmetricModelDetector {
    public static boolean isAsymmetricModel(MLModel model) {
        if (model == null) {
            return false;
        }
        MLModelConfig modelConfig = model.getModelConfig();
        if (modelConfig == null) {
            return false;
        }
        if (modelConfig instanceof TextEmbeddingModelConfig) {
            TextEmbeddingModelConfig textEmbeddingModelConfig = (TextEmbeddingModelConfig)modelConfig;
            return AsymmetricModelDetector.isAsymmetricLocalModel(textEmbeddingModelConfig);
        }
        if (modelConfig instanceof RemoteModelConfig) {
            RemoteModelConfig remoteModelConfig = (RemoteModelConfig)modelConfig;
            return AsymmetricModelDetector.isAsymmetricRemoteModel(remoteModelConfig);
        }
        return false;
    }

    private static boolean isAsymmetricLocalModel(TextEmbeddingModelConfig config) {
        return config.getPassagePrefix() != null || config.getQueryPrefix() != null;
    }

    private static boolean isAsymmetricRemoteModel(RemoteModelConfig remoteConfig) {
        Map additionalConfig = remoteConfig.getAdditionalConfig();
        if (additionalConfig != null) {
            Object isAsymmetric = additionalConfig.get("is_asymmetric");
            if (isAsymmetric instanceof Boolean && ((Boolean)isAsymmetric).booleanValue()) {
                return true;
            }
            if (additionalConfig.containsKey("query_prefix") || additionalConfig.containsKey("passage_prefix")) {
                return true;
            }
        }
        return false;
    }
}

