/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import java.util.Objects;
import java.util.logging.Logger;
import org.tribuo.VariableInfo;

public abstract class SkeletalVariableInfo
implements VariableInfo {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = Logger.getLogger(SkeletalVariableInfo.class.getName());
    protected final String name;
    protected int count;

    protected SkeletalVariableInfo(String name) {
        this.name = name;
    }

    protected SkeletalVariableInfo(String name, int count) {
        this.name = name;
        this.count = count;
    }

    protected void observe(double value) {
        ++this.count;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    public String toString() {
        return "Feature(name=" + this.name + ",count=" + this.count + ")";
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + this.name.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SkeletalVariableInfo other = (SkeletalVariableInfo)obj;
        return Objects.equals(this.name, other.name);
    }
}

