"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = translate;
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function translate(server, service, openSearchServiceSetup) {
  server.post({
    path: '/api/sql_console/translatesql',
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.translateSQL(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: '/api/sql_console/translateppl',
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.translatePPL(context, request);
    return response.ok({
      body: retVal
    });
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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