"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorePlugin = void 0;
var _capabilities_provider = require("./capabilities_provider");
var _saved_objects = require("./saved_objects");
var _explore_ui_settings = require("./explore_ui_settings");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class ExplorePlugin {
  // @ts-ignore
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core) {
    this.logger.debug('explore: Setup');
    core.capabilities.registerProvider(_capabilities_provider.capabilitiesProvider);

    // Register default explore capabilities
    core.capabilities.registerProvider(() => ({
      explore: {
        discoverTracesEnabled: false,
        discoverMetricsEnabled: false
      }
    }));

    // Register dynamic capabilities switcher for feature flags
    // This will override the defaults with values from DynamicConfigService
    core.capabilities.registerSwitcher(async (request, capabilities) => {
      try {
        var _config$discoverTrace, _config$discoverTrace2, _config$discoverMetri, _config$discoverMetri2;
        const dynamicConfigServiceStart = await core.dynamicConfigService.getStartService();
        const client = dynamicConfigServiceStart.getClient();
        const store = dynamicConfigServiceStart.getAsyncLocalStore();
        const config = await client.getConfig({
          name: 'explore'
        }, {
          asyncLocalStorageContext: store
        });
        return {
          ...capabilities,
          explore: {
            ...(capabilities.explore || {}),
            discoverTracesEnabled: (_config$discoverTrace = (_config$discoverTrace2 = config.discoverTraces) === null || _config$discoverTrace2 === void 0 ? void 0 : _config$discoverTrace2.enabled) !== null && _config$discoverTrace !== void 0 ? _config$discoverTrace : false,
            discoverMetricsEnabled: (_config$discoverMetri = (_config$discoverMetri2 = config.discoverMetrics) === null || _config$discoverMetri2 === void 0 ? void 0 : _config$discoverMetri2.enabled) !== null && _config$discoverMetri !== void 0 ? _config$discoverMetri : false
          }
        };
      } catch (error) {
        this.logger.error('Failed to load explore dynamic config, using defaults', error);
        // Keep defaults from provider (false for both flags)
        return capabilities;
      }
    });
    core.capabilities.registerSwitcher(async (request, capabilites) => {
      return await core.security.readonlyService().hideForReadonly(request, capabilites, {
        discover: {
          createShortUrl: false,
          save: false,
          saveQuery: false
        }
      });
    });
    // core.uiSettings.register(uiSettings);
    core.uiSettings.register(_explore_ui_settings.exploreUiSettings);
    core.savedObjects.registerType(_saved_objects.exploreSavedObjectType);
    return {};
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.ExplorePlugin = ExplorePlugin;