// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
export class HKDFError extends Error {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, HKDFError.prototype);
    }
}
export class KeyLengthError extends HKDFError {
    name = 'KeyLengthError';
    constructor(maxLength, algorithm) {
        super('Can not derive keys larger than ' +
            maxLength +
            ' for algorithm:' +
            algorithm);
        Object.setPrototypeOf(this, KeyLengthError.prototype);
    }
}
export class UnsupportedAlgorithm extends HKDFError {
    name = 'UnsupportedAlgorithm';
    constructor(algorithm) {
        super('Hash algorithm: ' + algorithm + ' is not an implemented algorithm');
        Object.setPrototypeOf(this, UnsupportedAlgorithm.prototype);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXJyb3JzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2Vycm9ycy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxvRUFBb0U7QUFDcEUsc0NBQXNDO0FBRXRDLE1BQU0sT0FBTyxTQUFVLFNBQVEsS0FBSztJQUNsQyxZQUFZLE9BQWdCO1FBQzFCLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQTtRQUNkLE1BQU0sQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLFNBQVMsQ0FBQyxTQUFTLENBQUMsQ0FBQTtJQUNsRCxDQUFDO0NBQ0Y7QUFFRCxNQUFNLE9BQU8sY0FBZSxTQUFRLFNBQVM7SUFDcEMsSUFBSSxHQUFHLGdCQUFnQixDQUFBO0lBQzlCLFlBQVksU0FBaUIsRUFBRSxTQUFpQjtRQUM5QyxLQUFLLENBQ0gsa0NBQWtDO1lBQ2hDLFNBQVM7WUFDVCxpQkFBaUI7WUFDakIsU0FBUyxDQUNaLENBQUE7UUFDRCxNQUFNLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRSxjQUFjLENBQUMsU0FBUyxDQUFDLENBQUE7SUFDdkQsQ0FBQztDQUNGO0FBRUQsTUFBTSxPQUFPLG9CQUFxQixTQUFRLFNBQVM7SUFDMUMsSUFBSSxHQUFHLHNCQUFzQixDQUFBO0lBQ3BDLFlBQVksU0FBaUI7UUFDM0IsS0FBSyxDQUFDLGtCQUFrQixHQUFHLFNBQVMsR0FBRyxrQ0FBa0MsQ0FBQyxDQUFBO1FBQzFFLE1BQU0sQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLG9CQUFvQixDQUFDLFNBQVMsQ0FBQyxDQUFBO0lBQzdELENBQUM7Q0FDRiJ9