/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.actionv2;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.alerting.modelv2.MonitorV2;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lorg/opensearch/alerting/actionv2/ExecuteMonitorV2Request;", "Lorg/opensearch/action/ActionRequest;", "dryrun", "", "manual", "monitorV2Id", "", "monitorV2", "Lorg/opensearch/alerting/modelv2/MonitorV2;", "requestEnd", "Lorg/opensearch/common/unit/TimeValue;", "<init>", "(ZZLjava/lang/String;Lorg/opensearch/alerting/modelv2/MonitorV2;Lorg/opensearch/common/unit/TimeValue;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getDryrun", "()Z", "getManual", "getMonitorV2Id", "()Ljava/lang/String;", "getMonitorV2", "()Lorg/opensearch/alerting/modelv2/MonitorV2;", "getRequestEnd", "()Lorg/opensearch/common/unit/TimeValue;", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "opensearch-alerting"})
public final class ExecuteMonitorV2Request
extends ActionRequest {
    private final boolean dryrun;
    private final boolean manual;
    @Nullable
    private final String monitorV2Id;
    @Nullable
    private final MonitorV2 monitorV2;
    @NotNull
    private final TimeValue requestEnd;

    public final boolean getDryrun() {
        return this.dryrun;
    }

    public final boolean getManual() {
        return this.manual;
    }

    @Nullable
    public final String getMonitorV2Id() {
        return this.monitorV2Id;
    }

    @Nullable
    public final MonitorV2 getMonitorV2() {
        return this.monitorV2;
    }

    @NotNull
    public final TimeValue getRequestEnd() {
        return this.requestEnd;
    }

    public ExecuteMonitorV2Request(boolean dryrun, boolean manual, @Nullable String monitorV2Id, @Nullable MonitorV2 monitorV2, @NotNull TimeValue requestEnd) {
        Intrinsics.checkNotNullParameter((Object)requestEnd, (String)"requestEnd");
        this.dryrun = dryrun;
        this.manual = manual;
        this.monitorV2Id = monitorV2Id;
        this.monitorV2 = monitorV2;
        this.requestEnd = requestEnd;
    }

    public ExecuteMonitorV2Request(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        boolean bl = sin.readBoolean();
        boolean bl2 = sin.readBoolean();
        String string = sin.readOptionalString();
        MonitorV2 monitorV2 = sin.readBoolean() ? MonitorV2.Companion.readFrom(sin) : null;
        TimeValue timeValue = sin.readTimeValue();
        Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"readTimeValue(...)");
        this(bl, bl2, string, monitorV2, timeValue);
    }

    @Nullable
    public ActionRequestValidationException validate() {
        return this.monitorV2 == null && this.monitorV2Id == null ? ValidateActions.addValidationError((String)"Neither a monitor ID nor monitor object was supplied", null) : null;
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeBoolean(this.dryrun);
        out.writeBoolean(this.manual);
        out.writeOptionalString(this.monitorV2Id);
        if (this.monitorV2 != null) {
            out.writeBoolean(true);
            MonitorV2.Companion.writeTo(out, this.monitorV2);
        } else {
            out.writeBoolean(false);
        }
        out.writeTimeValue(this.requestEnd);
    }
}

