/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.opensearch.common.Numbers;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.index.fielddata.AbstractBinaryDocValues;
import org.opensearch.index.fielddata.AbstractNumericDocValues;
import org.opensearch.index.fielddata.AbstractSortedDocValues;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.LongToSortedNumericUnsignedLongValues;
import org.opensearch.index.fielddata.NumericDoubleValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.index.fielddata.SortedNumericUnsignedLongValues;

@PublicApi(since="1.0.0")
public sealed class MultiValueMode
extends Enum<MultiValueMode>
implements Writeable {
    public static final /* enum */ MultiValueMode SUM = new MultiValueMode(){

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            int count = values.docValueCount();
            long total = 0L;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return total;
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int totalCount = 0;
            long totalValue = 0L;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int index = 0; index < docCount; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += docCount;
                }
                doc = docItr.nextDoc();
            }
            return totalCount > 0 ? totalValue : missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            int count = values.docValueCount();
            double total = 0.0;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return total;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int totalCount = 0;
            double totalValue = 0.0;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int index = 0; index < docCount; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += docCount;
                }
                doc = docItr.nextDoc();
            }
            return totalCount > 0 ? totalValue : missingValue;
        }

        @Override
        protected long pick(SortedNumericUnsignedLongValues values) throws IOException {
            int count = values.docValueCount();
            long total = 0L;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return total;
        }

        @Override
        protected long pick(SortedNumericUnsignedLongValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int totalCount = 0;
            long totalValue = 0L;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int index = 0; index < docCount; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += docCount;
                }
                doc = docItr.nextDoc();
            }
            return totalCount > 0 ? totalValue : missingValue;
        }
    };
    public static final /* enum */ MultiValueMode AVG = new MultiValueMode(){

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            int count = values.docValueCount();
            long total = 0L;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return count > 1 ? Math.round((double)total / (double)count) : total;
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int totalCount = 0;
            long totalValue = 0L;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int index = 0; index < docCount; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += docCount;
                }
                doc = docItr.nextDoc();
            }
            if (totalCount < 1) {
                return missingValue;
            }
            return totalCount > 1 ? Math.round((double)totalValue / (double)totalCount) : totalValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            int count = values.docValueCount();
            double total = 0.0;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return total / (double)count;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int totalCount = 0;
            double totalValue = 0.0;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int index = 0; index < docCount; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += docCount;
                }
                doc = docItr.nextDoc();
            }
            if (totalCount < 1) {
                return missingValue;
            }
            return totalValue / (double)totalCount;
        }

        @Override
        protected long pick(SortedNumericUnsignedLongValues values) throws IOException {
            int count = values.docValueCount();
            long total = 0L;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return count > 1 ? MultiValueMode.divideUnsignedAndRoundUp(total, count) : total;
        }

        @Override
        protected long pick(SortedNumericUnsignedLongValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int totalCount = 0;
            long totalValue = 0L;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int index = 0; index < docCount; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += docCount;
                }
                doc = docItr.nextDoc();
            }
            if (totalCount < 1) {
                return missingValue;
            }
            return totalCount > 1 ? MultiValueMode.divideUnsignedAndRoundUp(totalValue, totalCount) : totalValue;
        }
    };
    public static final /* enum */ MultiValueMode MEDIAN = new MultiValueMode(){

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < (count - 1) / 2; ++i) {
                values.nextValue();
            }
            if (count % 2 == 0) {
                return Math.round(((double)values.nextValue() + (double)values.nextValue()) / 2.0);
            }
            return values.nextValue();
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < (count - 1) / 2; ++i) {
                values.nextValue();
            }
            if (count % 2 == 0) {
                return (values.nextValue() + values.nextValue()) / 2.0;
            }
            return values.nextValue();
        }

        @Override
        protected long pick(SortedNumericUnsignedLongValues values) throws IOException {
            int count = values.docValueCount();
            long firstValue = values.nextValue();
            if (count == 1) {
                return firstValue;
            }
            if (count == 2) {
                long total = firstValue + values.nextValue();
                return (total >>> 1) + (total & 1L);
            }
            if (firstValue >= 0L) {
                for (int i = 1; i < (count - 1) / 2; ++i) {
                    values.nextValue();
                }
                if (count % 2 == 0) {
                    long total = values.nextValue() + values.nextValue();
                    return (total >>> 1) + (total & 1L);
                }
                return values.nextValue();
            }
            long[] docValues = new long[count];
            docValues[0] = firstValue;
            int firstPositiveIndex = 0;
            for (int i = 1; i < count; ++i) {
                docValues[i] = values.nextValue();
                if (docValues[i] < 0L || firstPositiveIndex != 0) continue;
                firstPositiveIndex = i;
            }
            int mid = ((count - 1) / 2 + firstPositiveIndex) % count;
            if (count % 2 == 0) {
                long total = docValues[mid] + docValues[(mid + 1) % count];
                return (total >>> 1) + (total & 1L);
            }
            return docValues[mid];
        }
    };
    public static final /* enum */ MultiValueMode MIN = new MultiValueMode(){

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            return values.nextValue();
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            boolean hasValue = false;
            long minValue = Long.MAX_VALUE;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    minValue = Math.min(minValue, values.nextValue());
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? minValue : missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            return values.nextValue();
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            boolean hasValue = false;
            double minValue = Double.POSITIVE_INFINITY;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    minValue = Math.min(minValue, values.nextValue());
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? minValue : missingValue;
        }

        @Override
        protected BytesRef pick(SortedBinaryDocValues values) throws IOException {
            return values.nextValue();
        }

        @Override
        protected BytesRef pick(BinaryDocValues values, BytesRefBuilder builder, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            BytesRefBuilder bytesRefBuilder = null;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    BytesRef innerValue = values.binaryValue();
                    if (bytesRefBuilder == null) {
                        builder.copyBytes(innerValue);
                        bytesRefBuilder = builder;
                    } else {
                        BytesRef min;
                        BytesRef bytesRef = min = bytesRefBuilder.get().compareTo(innerValue) <= 0 ? bytesRefBuilder.get() : innerValue;
                        if (min == innerValue) {
                            bytesRefBuilder.copyBytes(min);
                        }
                    }
                }
                doc = docItr.nextDoc();
            }
            return bytesRefBuilder == null ? null : bytesRefBuilder.get();
        }

        @Override
        protected int pick(SortedSetDocValues values) throws IOException {
            return Math.toIntExact(values.nextOrd());
        }

        @Override
        protected int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int ord = Integer.MAX_VALUE;
            boolean hasValue = false;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int innerOrd = values.ordValue();
                    ord = Math.min(ord, innerOrd);
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? ord : -1;
        }

        @Override
        protected long pick(SortedNumericUnsignedLongValues values) throws IOException {
            int count = values.docValueCount();
            long min = values.nextValue();
            if (count == 1 || min > 0L) {
                return min;
            }
            for (int i = 1; i < count; ++i) {
                long val = values.nextValue();
                if (val < 0L) continue;
                return val;
            }
            return min;
        }

        @Override
        protected long pick(SortedNumericUnsignedLongValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            boolean hasValue = false;
            long minValue = Numbers.MAX_UNSIGNED_LONG_VALUE_AS_LONG;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    long docMin = this.pick(values);
                    minValue = Long.compareUnsigned(docMin, minValue) < 0 ? docMin : minValue;
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? minValue : missingValue;
        }
    };
    public static final /* enum */ MultiValueMode MAX = new MultiValueMode(){

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < count - 1; ++i) {
                values.nextValue();
            }
            return values.nextValue();
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            boolean hasValue = false;
            long maxValue = Long.MIN_VALUE;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int i = 0; i < docCount - 1; ++i) {
                        values.nextValue();
                    }
                    maxValue = Math.max(maxValue, values.nextValue());
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? maxValue : missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < count - 1; ++i) {
                values.nextValue();
            }
            return values.nextValue();
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            boolean hasValue = false;
            double maxValue = Double.NEGATIVE_INFINITY;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    int docCount = values.docValueCount();
                    for (int i = 0; i < docCount - 1; ++i) {
                        values.nextValue();
                    }
                    maxValue = Math.max(maxValue, values.nextValue());
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? maxValue : missingValue;
        }

        @Override
        protected BytesRef pick(SortedBinaryDocValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < count - 1; ++i) {
                values.nextValue();
            }
            return values.nextValue();
        }

        @Override
        protected BytesRef pick(BinaryDocValues values, BytesRefBuilder builder, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            BytesRefBuilder bytesRefBuilder = null;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    BytesRef innerValue = values.binaryValue();
                    if (bytesRefBuilder == null) {
                        builder.copyBytes(innerValue);
                        bytesRefBuilder = builder;
                    } else {
                        BytesRef max;
                        BytesRef bytesRef = max = bytesRefBuilder.get().compareTo(innerValue) > 0 ? bytesRefBuilder.get() : innerValue;
                        if (max == innerValue) {
                            bytesRefBuilder.copyBytes(max);
                        }
                    }
                }
                doc = docItr.nextDoc();
            }
            return bytesRefBuilder == null ? null : bytesRefBuilder.get();
        }

        @Override
        protected int pick(SortedSetDocValues values) throws IOException {
            long ord;
            long maxOrd = -1L;
            int count = values.docValueCount();
            while (count-- > 0 && (ord = values.nextOrd()) != Integer.MAX_VALUE) {
                maxOrd = ord;
            }
            return Math.toIntExact(maxOrd);
        }

        @Override
        protected int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            int ord = -1;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    ord = Math.max(ord, values.ordValue());
                }
                doc = docItr.nextDoc();
            }
            return ord;
        }

        @Override
        protected long pick(SortedNumericUnsignedLongValues values) throws IOException {
            int count = values.docValueCount();
            long max = values.nextValue();
            for (int i = 1; i < count; ++i) {
                long val = values.nextValue();
                if (max < 0L && val >= 0L) {
                    return max;
                }
                max = val;
            }
            return max;
        }

        @Override
        protected long pick(SortedNumericUnsignedLongValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
            boolean hasValue = false;
            long maxValue = Numbers.MIN_UNSIGNED_LONG_VALUE_AS_LONG;
            int count = 0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    if (++count > maxChildren) break;
                    long docMax = this.pick(values);
                    maxValue = Long.compareUnsigned(maxValue, docMax) < 0 ? docMax : maxValue;
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? maxValue : missingValue;
        }
    };
    private static final /* synthetic */ MultiValueMode[] $VALUES;

    public static MultiValueMode[] values() {
        return (MultiValueMode[])$VALUES.clone();
    }

    public static MultiValueMode valueOf(String name) {
        return Enum.valueOf(MultiValueMode.class, name);
    }

    public static MultiValueMode fromString(String sortMode) {
        try {
            return MultiValueMode.valueOf(sortMode.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal sort mode: " + sortMode);
        }
    }

    public NumericDocValues select(final SortedNumericDocValues values) {
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton != null) {
            return singleton;
        }
        return new AbstractNumericDocValues(){
            private long value;

            public boolean advanceExact(int target) throws IOException {
                if (values.advanceExact(target)) {
                    this.value = MultiValueMode.this.pick(values);
                    return true;
                }
                return false;
            }

            public int docID() {
                return values.docID();
            }

            public long longValue() throws IOException {
                return this.value;
            }
        };
    }

    protected long pick(SortedNumericDocValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf((Object)this));
    }

    public NumericDocValues select(final SortedNumericDocValues values, final long missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs, int maxDoc, final int maxChildren) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return FieldData.replaceMissing(DocValues.emptyNumeric(), missingValue);
        }
        return new AbstractNumericDocValues(){
            int lastSeenParentDoc = -1;
            long lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                if (parentDoc == 0) {
                    this.lastEmittedValue = missingValue;
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = MultiValueMode.this.pick(values, missingValue, childDocs, firstChildDoc, parentDoc, maxChildren);
                return true;
            }

            public int docID() {
                return this.lastSeenParentDoc;
            }

            public long longValue() {
                return this.lastEmittedValue;
            }
        };
    }

    protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf((Object)this));
    }

    public NumericDoubleValues select(final SortedNumericDoubleValues values) {
        NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            return singleton;
        }
        return new NumericDoubleValues(){
            private double value;

            public boolean advanceExact(int target) throws IOException {
                if (values.advanceExact(target)) {
                    this.value = MultiValueMode.this.pick(values);
                    return true;
                }
                return false;
            }

            public double doubleValue() throws IOException {
                return this.value;
            }

            @Override
            public int advance(int target) throws IOException {
                return values.advance(target);
            }
        };
    }

    protected double pick(SortedNumericDoubleValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf((Object)this));
    }

    public NumericDoubleValues select(final SortedNumericDoubleValues values, final double missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs, int maxDoc, final int maxChildren) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return FieldData.replaceMissing(FieldData.emptyNumericDouble(), missingValue);
        }
        return new NumericDoubleValues(){
            int lastSeenParentDoc = 0;
            double lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = MultiValueMode.this.pick(values, missingValue, childDocs, firstChildDoc, parentDoc, maxChildren);
                return true;
            }

            public double doubleValue() throws IOException {
                return this.lastEmittedValue;
            }

            @Override
            public int advance(int target) throws IOException {
                return values.advance(target);
            }
        };
    }

    protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf((Object)this));
    }

    public BinaryDocValues select(final SortedBinaryDocValues values, final BytesRef missingValue) {
        final BinaryDocValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            if (missingValue == null) {
                return singleton;
            }
            return new AbstractBinaryDocValues(this){
                private BytesRef value;

                public boolean advanceExact(int target) throws IOException {
                    this.value = singleton.advanceExact(target) ? singleton.binaryValue() : missingValue;
                    return true;
                }

                public BytesRef binaryValue() throws IOException {
                    return this.value;
                }
            };
        }
        return new AbstractBinaryDocValues(){
            private BytesRef value;

            public boolean advanceExact(int target) throws IOException {
                if (values.advanceExact(target)) {
                    this.value = MultiValueMode.this.pick(values);
                    return true;
                }
                this.value = missingValue;
                return missingValue != null;
            }

            public BytesRef binaryValue() throws IOException {
                return this.value;
            }
        };
    }

    protected BytesRef pick(SortedBinaryDocValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf((Object)this));
    }

    public BinaryDocValues select(SortedBinaryDocValues values, final BytesRef missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs, int maxDoc, final int maxChildren) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return this.select(FieldData.emptySortedBinary(), missingValue);
        }
        final BinaryDocValues selectedValues = this.select(values, null);
        return new AbstractBinaryDocValues(){
            final BytesRefBuilder builder = new BytesRefBuilder();
            int lastSeenParentDoc = 0;
            BytesRef lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming root docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = MultiValueMode.this.pick(selectedValues, this.builder, childDocs, firstChildDoc, parentDoc, maxChildren);
                if (this.lastEmittedValue == null) {
                    this.lastEmittedValue = missingValue;
                }
                return true;
            }

            public BytesRef binaryValue() throws IOException {
                return this.lastEmittedValue;
            }
        };
    }

    protected BytesRef pick(BinaryDocValues values, BytesRefBuilder builder, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf((Object)this));
    }

    public SortedDocValues select(final SortedSetDocValues values) {
        if (values.getValueCount() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("fields containing more than 2147483646 unique terms are unsupported");
        }
        SortedDocValues singleton = DocValues.unwrapSingleton((SortedSetDocValues)values);
        if (singleton != null) {
            return singleton;
        }
        return new AbstractSortedDocValues(){
            int ord;

            public boolean advanceExact(int target) throws IOException {
                if (values.advanceExact(target)) {
                    this.ord = MultiValueMode.this.pick(values);
                    return true;
                }
                this.ord = -1;
                return false;
            }

            public int docID() {
                return values.docID();
            }

            public int ordValue() {
                assert (this.ord != -1);
                return this.ord;
            }

            public BytesRef lookupOrd(int ord) throws IOException {
                return values.lookupOrd((long)ord);
            }

            public int getValueCount() {
                return (int)values.getValueCount();
            }
        };
    }

    protected int pick(SortedSetDocValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf((Object)this));
    }

    public SortedDocValues select(SortedSetDocValues values, final BitSet parentDocs, final DocIdSetIterator childDocs, final int maxChildren) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return this.select(DocValues.emptySortedSet());
        }
        final SortedDocValues selectedValues = this.select(values);
        return new AbstractSortedDocValues(){
            int docID = -1;
            int lastSeenParentDoc = 0;
            int lastEmittedOrd = -1;

            public BytesRef lookupOrd(int ord) throws IOException {
                return selectedValues.lookupOrd(ord);
            }

            public int getValueCount() {
                return selectedValues.getValueCount();
            }

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming root docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return this.lastEmittedOrd != -1;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.docID = this.lastSeenParentDoc = parentDoc;
                this.lastEmittedOrd = MultiValueMode.this.pick(selectedValues, childDocs, firstChildDoc, parentDoc, maxChildren);
                return this.lastEmittedOrd != -1;
            }

            public int docID() {
                return this.docID;
            }

            public int ordValue() {
                return this.lastEmittedOrd;
            }
        };
    }

    protected int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf((Object)this));
    }

    public NumericDocValues select(final SortedNumericUnsignedLongValues values) {
        NumericDocValues singleton;
        SortedNumericDocValues sortedNumericDocValues = null;
        if (values instanceof LongToSortedNumericUnsignedLongValues) {
            LongToSortedNumericUnsignedLongValues longValues = (LongToSortedNumericUnsignedLongValues)values;
            sortedNumericDocValues = longValues.getNumericUnsignedLongValues();
        }
        if ((singleton = DocValues.unwrapSingleton(sortedNumericDocValues)) != null) {
            return singleton;
        }
        return new AbstractNumericDocValues(){
            private long value;

            public boolean advanceExact(int target) throws IOException {
                if (values.advanceExact(target)) {
                    this.value = MultiValueMode.this.pick(values);
                    return true;
                }
                return false;
            }

            public int docID() {
                return values.docID();
            }

            public long longValue() throws IOException {
                return this.value;
            }
        };
    }

    protected long pick(SortedNumericUnsignedLongValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf((Object)this));
    }

    public NumericDocValues select(final SortedNumericUnsignedLongValues values, final long missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs, int maxDoc, final int maxChildren) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return FieldData.replaceMissing(DocValues.emptyNumeric(), missingValue);
        }
        return new AbstractNumericDocValues(){
            int lastSeenParentDoc = -1;
            long lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                if (parentDoc == 0) {
                    this.lastEmittedValue = missingValue;
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = MultiValueMode.this.pick(values, missingValue, childDocs, firstChildDoc, parentDoc, maxChildren);
                return true;
            }

            public int docID() {
                return this.lastSeenParentDoc;
            }

            public long longValue() {
                return this.lastEmittedValue;
            }
        };
    }

    protected long pick(SortedNumericUnsignedLongValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + String.valueOf((Object)this));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this);
    }

    public static MultiValueMode readMultiValueModeFrom(StreamInput in) throws IOException {
        return (MultiValueMode)in.readEnum(MultiValueMode.class);
    }

    private static long divideUnsignedAndRoundUp(long dividend, long divisor) {
        assert (divisor > 0L);
        long q = (dividend >>> 1) / divisor << 1;
        long r = dividend - q * divisor;
        long quotient = q + ((r | r - divisor ^ 0xFFFFFFFFFFFFFFFFL) >>> 63);
        long rem = r - ((r - divisor ^ 0xFFFFFFFFFFFFFFFFL) >> 63 & divisor);
        return quotient + Math.round((double)rem / (double)divisor);
    }

    private static /* synthetic */ MultiValueMode[] $values() {
        return new MultiValueMode[]{SUM, AVG, MEDIAN, MIN, MAX};
    }

    static {
        $VALUES = MultiValueMode.$values();
    }
}

