/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.KnownCompatibleBeanArchiveBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class KnownCompatibleBeanArchives {
    private final Set<Key> keys;

    KnownCompatibleBeanArchives(List<KnownCompatibleBeanArchiveBuildItem> list) {
        HashSet<Key> keys = new HashSet<Key>();
        for (KnownCompatibleBeanArchiveBuildItem item : list) {
            keys.add(new Key(item.groupId, item.artifactId, item.classifier));
        }
        this.keys = keys;
    }

    boolean isKnownCompatible(ApplicationArchive archive) {
        ArtifactKey artifact = archive.getKey();
        if (artifact == null) {
            return false;
        }
        return this.keys.contains(new Key(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier()));
    }

    private static class Key {
        final String groupId;
        final String artifactId;
        final String classifier;

        Key(String groupId, String artifactId, String classifier) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.classifier = classifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.groupId, key.groupId) && Objects.equals(this.artifactId, key.artifactId) && Objects.equals(this.classifier, key.classifier);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId, this.classifier);
        }
    }
}

