/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.spi;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.hibernate.FlushMode;
import org.hibernate.Incubating;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.StandardStatementCreator;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.sql.results.spi.ScrollableResultsConsumer;

@Incubating
public interface JdbcSelectExecutor {
    public <T, R> T executeQuery(JdbcOperationQuerySelect var1, JdbcParameterBindings var2, ExecutionContext var3, RowTransformer<R> var4, Class<R> var5, StatementCreator var6, ResultsConsumer<T, R> var7);

    default public <T, R> T executeQuery(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, int resultCountEstimate, ResultsConsumer<T, R> resultsConsumer) {
        return this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, domainResultType, resultCountEstimate, StandardStatementCreator.getStatementCreator(null), resultsConsumer);
    }

    default public <T, R> T executeQuery(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, int resultCountEstimate, StatementCreator statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        return this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, domainResultType, statementCreator, resultsConsumer);
    }

    default public <R> List<R> list(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, ListResultsConsumer.UniqueSemantic uniqueSemantic) {
        return this.list(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, null, uniqueSemantic);
    }

    default public <R> List<R> list(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> requestedJavaType, ListResultsConsumer.UniqueSemantic uniqueSemantic) {
        return this.list(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, requestedJavaType, uniqueSemantic, -1);
    }

    default public <R> List<R> list(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> requestedJavaType, ListResultsConsumer.UniqueSemantic uniqueSemantic, int resultCountEstimate) {
        return (List)this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, requestedJavaType, resultCountEstimate, ListResultsConsumer.instance(uniqueSemantic));
    }

    default public <R> ScrollableResultsImplementor<R> scroll(JdbcOperationQuerySelect jdbcSelect, ScrollMode scrollMode, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        return this.scroll(jdbcSelect, scrollMode, jdbcParameterBindings, executionContext, rowTransformer, -1);
    }

    default public <R> ScrollableResultsImplementor<R> scroll(JdbcOperationQuerySelect jdbcSelect, ScrollMode scrollMode, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, int resultCountEstimate) {
        return (ScrollableResultsImplementor)this.executeQuery(jdbcSelect, jdbcParameterBindings, this.getScrollContext(executionContext), rowTransformer, null, resultCountEstimate, StandardStatementCreator.getStatementCreator(scrollMode), ScrollableResultsConsumer.instance());
    }

    private ExecutionContext getScrollContext(ExecutionContext context) {
        QueryOptions options = context.getQueryOptions();
        class ScrollableExecutionContext
        extends BaseExecutionContext
        implements QueryOptions {
            private final Integer timeout;
            private final FlushMode flushMode;
            private final Boolean readOnly;
            private final AppliedGraph appliedGraph;
            private final TupleTransformer<?> tupleTransformer;
            private final ResultListTransformer<?> resultListTransformer;
            private final Boolean resultCachingEnabled;
            private final CacheRetrieveMode cacheRetrieveMode;
            private final CacheStoreMode cacheStoreMode;
            private final String resultCacheRegionName;
            private final LockOptions lockOptions;
            private final String comment;
            private final List<String> databaseHints;
            private final Integer fetchSize;
            private final Limit limit;
            private final ExecutionContext context;

            public ScrollableExecutionContext(Integer timeout, FlushMode flushMode, Boolean readOnly, AppliedGraph appliedGraph, TupleTransformer<?> tupleTransformer, ResultListTransformer<?> resultListTransformer, Boolean resultCachingEnabled, CacheRetrieveMode cacheRetrieveMode, CacheStoreMode cacheStoreMode, String resultCacheRegionName, LockOptions lockOptions, String comment, List<String> databaseHints, Integer fetchSize, Limit limit, ExecutionContext context) {
                super(context.getSession());
                this.timeout = timeout;
                this.flushMode = flushMode;
                this.readOnly = readOnly;
                this.appliedGraph = appliedGraph;
                this.tupleTransformer = tupleTransformer;
                this.resultListTransformer = resultListTransformer;
                this.resultCachingEnabled = resultCachingEnabled;
                this.cacheRetrieveMode = cacheRetrieveMode;
                this.cacheStoreMode = cacheStoreMode;
                this.resultCacheRegionName = resultCacheRegionName;
                this.lockOptions = lockOptions;
                this.comment = comment;
                this.databaseHints = databaseHints;
                this.fetchSize = fetchSize;
                this.limit = limit;
                this.context = context;
            }

            @Override
            public boolean isScrollResult() {
                return true;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return this;
            }

            @Override
            public Integer getTimeout() {
                return this.timeout;
            }

            @Override
            public FlushMode getFlushMode() {
                return this.flushMode;
            }

            @Override
            public Boolean isReadOnly() {
                return this.readOnly;
            }

            @Override
            public AppliedGraph getAppliedGraph() {
                return this.appliedGraph;
            }

            @Override
            public TupleTransformer<?> getTupleTransformer() {
                return this.tupleTransformer;
            }

            @Override
            public ResultListTransformer<?> getResultListTransformer() {
                return this.resultListTransformer;
            }

            @Override
            public Boolean isResultCachingEnabled() {
                return this.resultCachingEnabled;
            }

            @Override
            public Boolean getQueryPlanCachingEnabled() {
                return null;
            }

            @Override
            public CacheRetrieveMode getCacheRetrieveMode() {
                return this.cacheRetrieveMode;
            }

            @Override
            public CacheStoreMode getCacheStoreMode() {
                return this.cacheStoreMode;
            }

            @Override
            public String getResultCacheRegionName() {
                return this.resultCacheRegionName;
            }

            @Override
            public LockOptions getLockOptions() {
                return this.lockOptions;
            }

            @Override
            public String getComment() {
                return this.comment;
            }

            @Override
            public List<String> getDatabaseHints() {
                return this.databaseHints;
            }

            @Override
            public Integer getFetchSize() {
                return this.fetchSize;
            }

            @Override
            public Limit getLimit() {
                return this.limit;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return this.context.getQueryParameterBindings();
            }

            @Override
            public Callback getCallback() {
                return this.context.getCallback();
            }

            @Override
            public boolean hasCallbackActions() {
                return this.context.hasCallbackActions();
            }

            @Override
            public Set<String> getEnabledFetchProfiles() {
                return null;
            }

            @Override
            public Set<String> getDisabledFetchProfiles() {
                return null;
            }
        }
        return new ScrollableExecutionContext(options.getTimeout(), options.getFlushMode(), options.isReadOnly() == null ? context.getSession().getPersistenceContext().isDefaultReadOnly() : options.isReadOnly().booleanValue(), options.getAppliedGraph(), options.getTupleTransformer(), options.getResultListTransformer(), options.isResultCachingEnabled(), options.getCacheRetrieveMode(), options.getCacheStoreMode(), options.getResultCacheRegionName(), options.getLockOptions(), options.getComment(), options.getDatabaseHints(), options.getFetchSize(), options.getLimit(), context);
    }

    @FunctionalInterface
    public static interface StatementCreator {
        public PreparedStatement createStatement(ExecutionContext var1, String var2) throws SQLException;
    }
}

