/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorType;
import org.apache.kafka.connect.runtime.rest.entities.PluginInfo;

public record ConnectorStateInfo(@JsonProperty String name, @JsonProperty ConnectorState connector, @JsonProperty List<TaskState> tasks, @JsonProperty ConnectorType type) {

    public static class ConnectorState
    extends AbstractState {
        @JsonCreator
        public ConnectorState(@JsonProperty(value="state") String state, @JsonProperty(value="worker_id") String worker, @JsonProperty(value="msg") String msg, @JsonProperty(value="version") String version) {
            super(state, worker, msg, version);
        }
    }

    public static class TaskState
    extends AbstractState
    implements Comparable<TaskState> {
        private final int id;

        @JsonCreator
        public TaskState(@JsonProperty(value="id") int id, @JsonProperty(value="state") String state, @JsonProperty(value="worker_id") String worker, @JsonProperty(value="msg") String msg, @JsonProperty(value="version") String version) {
            super(state, worker, msg, version);
            this.id = id;
        }

        @JsonProperty
        public int id() {
            return this.id;
        }

        @Override
        public int compareTo(TaskState that) {
            return Integer.compare(this.id, that.id);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskState)) {
                return false;
            }
            TaskState other = (TaskState)o;
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    public static abstract class AbstractState {
        private final String state;
        private final String trace;
        private final String workerId;
        private final String version;

        public AbstractState(String state, String workerId, String trace, String version) {
            this.state = state;
            this.workerId = workerId;
            this.trace = trace;
            this.version = version;
        }

        @JsonProperty
        public String state() {
            return this.state;
        }

        @JsonProperty(value="worker_id")
        public String workerId() {
            return this.workerId;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public String trace() {
            return this.trace;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=PluginInfo.NoVersionFilter.class)
        public String version() {
            return this.version;
        }
    }
}

