/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public abstract class Handler {
    private static final int offValue = Level.OFF.intValue();
    private final LogManager manager = LogManager.getLogManager();
    private volatile Filter filter;
    private volatile Formatter formatter;
    private volatile Level logLevel = Level.ALL;
    private volatile ErrorManager errorManager = new ErrorManager();
    private volatile String encoding;
    boolean sealed = true;

    protected Handler() {
    }

    public abstract void publish(LogRecord var1);

    public abstract void flush();

    public abstract void close() throws SecurityException;

    public synchronized void setFormatter(Formatter formatter) throws SecurityException {
        this.checkPermission();
        formatter.getClass();
        this.formatter = formatter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public synchronized void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        this.checkPermission();
        if (string != null) {
            try {
                if (!Charset.isSupported(string)) {
                    throw new UnsupportedEncodingException(string);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw new UnsupportedEncodingException(string);
            }
        }
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public synchronized void setFilter(Filter filter) throws SecurityException {
        this.checkPermission();
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public synchronized void setErrorManager(ErrorManager errorManager) {
        this.checkPermission();
        if (errorManager == null) {
            throw new NullPointerException();
        }
        this.errorManager = errorManager;
    }

    public ErrorManager getErrorManager() {
        this.checkPermission();
        return this.errorManager;
    }

    protected void reportError(String string, Exception exception, int n) {
        try {
            this.errorManager.error(string, exception, n);
        }
        catch (Exception exception2) {
            System.err.println("Handler.reportError caught:");
            exception2.printStackTrace();
        }
    }

    public synchronized void setLevel(Level level) throws SecurityException {
        if (level == null) {
            throw new NullPointerException();
        }
        this.checkPermission();
        this.logLevel = level;
    }

    public Level getLevel() {
        return this.logLevel;
    }

    public boolean isLoggable(LogRecord logRecord) {
        int n = this.getLevel().intValue();
        if (logRecord.getLevel().intValue() < n || n == offValue) {
            return false;
        }
        Filter filter = this.getFilter();
        if (filter == null) {
            return true;
        }
        return filter.isLoggable(logRecord);
    }

    void checkPermission() throws SecurityException {
        if (this.sealed) {
            this.manager.checkPermission();
        }
    }
}

