/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class SyntheticRepository
implements Repository {
    private static HashMap _instances = new HashMap();
    private HashMap _loadedClasses = new HashMap();

    private SyntheticRepository() {
    }

    public static SyntheticRepository getInstance() {
        return new SyntheticRepository();
    }

    @Override
    public void storeClass(JavaClass clazz) {
        this._loadedClasses.put(clazz.getClassName(), clazz);
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass clazz) {
        this._loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public JavaClass findClass(String className) {
        return (JavaClass)this._loadedClasses.get(className);
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        if (className == null || className.equals("")) {
            throw new IllegalArgumentException("Invalid class name " + className);
        }
        className = className.replace('/', '.');
        IOException e = new IOException("Couldn't find: " + className + ".class");
        throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e.toString());
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        String className = clazz.getName();
        String name = className;
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(i + 1);
        }
        return this.loadClass(clazz.getResourceAsStream(name + ".class"), className);
    }

    private JavaClass loadClass(InputStream is, String className) throws ClassNotFoundException {
        JavaClass clazz = this.findClass(className);
        if (clazz != null) {
            return clazz;
        }
        try {
            if (is != null) {
                ClassParser parser = new ClassParser(is, className);
                clazz = parser.parse();
                this.storeClass(clazz);
                return clazz;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e.toString());
        }
        throw new ClassNotFoundException("SyntheticRepository could not load " + className);
    }

    @Override
    public void clear() {
        this._loadedClasses.clear();
    }
}

