/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.output.TerminalCaretModel;
import org.jetbrains.plugins.terminal.block.output.TerminalEventDispatcher;
import org.jetbrains.plugins.terminal.block.output.TerminalEventsHandler;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputEditorInputMethodSupport;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a0\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a(\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0000\u00a8\u0006\u0013"}, d2={"setupKeyEventDispatcher", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "eventsHandler", "Lorg/jetbrains/plugins/terminal/block/output/TerminalEventsHandler;", "disposable", "Lcom/intellij/openapi/Disposable;", "setupMouseListener", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "model", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel;", "setupInputMethodSupport", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "caretModel", "Lorg/jetbrains/plugins/terminal/block/output/TerminalCaretModel;", "parentDisposable", "intellij.terminal"})
public final class TerminalEventDispatcherKt {
    public static final void setupKeyEventDispatcher(@NotNull EditorEx editor, @NotNull TerminalEventsHandler eventsHandler, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)eventsHandler, (String)"eventsHandler");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        TerminalEventDispatcher eventDispatcher2 = new TerminalEventDispatcher(editor, disposable, eventsHandler){
            final /* synthetic */ TerminalEventsHandler $eventsHandler;
            {
                this.$eventsHandler = $eventsHandler;
                super($editor, $disposable);
            }

            protected void handleKeyEvent(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getID() == 400) {
                    this.$eventsHandler.keyTyped(e);
                } else if (e.getID() == 401) {
                    this.$eventsHandler.keyPressed(e);
                }
            }
        };
        editor.addFocusListener(new FocusChangeListener(eventDispatcher2){
            final /* synthetic */ TerminalEventDispatcher $eventDispatcher;
            {
                this.$eventDispatcher = $eventDispatcher;
            }

            public void focusGained(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                List<AnAction> actionsToSkip = TerminalEventDispatcher.Companion.getActionsToSkip();
                this.$eventDispatcher.register(actionsToSkip);
            }

            public void focusLost(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.$eventDispatcher.unregister();
            }
        }, disposable);
    }

    public static final void setupMouseListener(@NotNull EditorEx editor, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalModel model, @NotNull TerminalEventsHandler eventsHandler, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)eventsHandler, (String)"eventsHandler");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        editor.addEditorMouseListener(new EditorMouseListener(settings, eventsHandler, model){
            final /* synthetic */ JBTerminalSystemSettingsProviderBase $settings;
            final /* synthetic */ TerminalEventsHandler $eventsHandler;
            final /* synthetic */ TerminalModel $model;
            {
                this.$settings = $settings;
                this.$eventsHandler = $eventsHandler;
                this.$model = $model;
            }

            public void mousePressed(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$settings.enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                    if (TerminalEventDispatcherKt.access$setupMouseListener$isRemoteMouseAction(this.$model, mouseEvent)) {
                        LogicalPosition logicalPosition = event.getLogicalPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
                        LogicalPosition p = logicalPosition;
                        int n = p.column;
                        int n2 = p.line + TerminalEventDispatcherKt.access$setupMouseListener$historyLinesCount(this.$model);
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
                        this.$eventsHandler.mousePressed(n, n2, mouseEvent2);
                    }
                }
            }

            public void mouseReleased(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$settings.enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                    if (TerminalEventDispatcherKt.access$setupMouseListener$isRemoteMouseAction(this.$model, mouseEvent)) {
                        LogicalPosition logicalPosition = event.getLogicalPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
                        LogicalPosition p = logicalPosition;
                        int n = p.column;
                        int n2 = p.line + TerminalEventDispatcherKt.access$setupMouseListener$historyLinesCount(this.$model);
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
                        this.$eventsHandler.mouseReleased(n, n2, mouseEvent2);
                    }
                }
            }
        }, disposable);
        editor.addEditorMouseMotionListener(new EditorMouseMotionListener(settings, eventsHandler, model){
            final /* synthetic */ JBTerminalSystemSettingsProviderBase $settings;
            final /* synthetic */ TerminalEventsHandler $eventsHandler;
            final /* synthetic */ TerminalModel $model;
            {
                this.$settings = $settings;
                this.$eventsHandler = $eventsHandler;
                this.$model = $model;
            }

            public void mouseMoved(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$settings.enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                    if (TerminalEventDispatcherKt.access$setupMouseListener$isRemoteMouseAction(this.$model, mouseEvent)) {
                        LogicalPosition logicalPosition = event.getLogicalPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
                        LogicalPosition p = logicalPosition;
                        int n = p.column;
                        int n2 = p.line + TerminalEventDispatcherKt.access$setupMouseListener$historyLinesCount(this.$model);
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
                        this.$eventsHandler.mouseMoved(n, n2, mouseEvent2);
                    }
                }
            }

            public void mouseDragged(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$settings.enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                    if (TerminalEventDispatcherKt.access$setupMouseListener$isRemoteMouseAction(this.$model, mouseEvent)) {
                        LogicalPosition logicalPosition = event.getLogicalPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
                        LogicalPosition p = logicalPosition;
                        int n = p.column;
                        int n2 = p.line + TerminalEventDispatcherKt.access$setupMouseListener$historyLinesCount(this.$model);
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
                        this.$eventsHandler.mouseDragged(n, n2, mouseEvent2);
                    }
                }
            }
        }, disposable);
        MouseWheelListener mouseWheelListener = arg_0 -> TerminalEventDispatcherKt.setupMouseListener$lambda$0(editor, eventsHandler, model, arg_0);
        editor.getScrollPane().addMouseWheelListener(mouseWheelListener);
        Disposer.register((Disposable)disposable, () -> TerminalEventDispatcherKt.setupMouseListener$lambda$1(editor, mouseWheelListener));
    }

    public static final void setupInputMethodSupport(@NotNull EditorEx editor, @NotNull BlockTerminalSession session2, @NotNull TerminalCaretModel caretModel, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)caretModel, (String)"caretModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        CoroutineScope coroutineScope = TerminalCoroutineKt.terminalApplicationScope();
        String string = TerminalOutputEditorInputMethodSupport.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        CoroutineScope coroutineScope2 = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)string, null, (boolean)false, (int)6, null);
        Disposer.register((Disposable)parentDisposable, () -> TerminalEventDispatcherKt.setupInputMethodSupport$lambda$0(coroutineScope2));
        new TerminalOutputEditorInputMethodSupport(editor, coroutineScope2, (Function0<? extends LogicalPosition>)((Function0)() -> TerminalEventDispatcherKt.setupInputMethodSupport$lambda$1(caretModel)), null, (Function1<? super String, Unit>)((Function1)arg_0 -> TerminalEventDispatcherKt.setupInputMethodSupport$lambda$2(session2, arg_0)));
    }

    private static final boolean setupMouseListener$isRemoteMouseAction(TerminalModel $model, MouseEvent e) {
        return $model.getMouseMode() != MouseMode.MOUSE_REPORTING_NONE && !e.isShiftDown();
    }

    private static final int setupMouseListener$historyLinesCount(TerminalModel $model) {
        return $model.getUseAlternateBuffer() ? 0 : $model.getHistoryLinesCount();
    }

    private static final void setupMouseListener$lambda$0(EditorEx $editor, TerminalEventsHandler $eventsHandler, TerminalModel $model, MouseWheelEvent event) {
        LogicalPosition logicalPosition = $editor.xyToLogicalPosition(event.getPoint());
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
        LogicalPosition p = logicalPosition;
        int n = p.column;
        int n2 = p.line + TerminalEventDispatcherKt.setupMouseListener$historyLinesCount($model);
        Intrinsics.checkNotNull((Object)event);
        $eventsHandler.mouseWheelMoved(n, n2, event);
    }

    private static final void setupMouseListener$lambda$1(EditorEx $editor, MouseWheelListener $mouseWheelListener) {
        $editor.getScrollPane().removeMouseWheelListener($mouseWheelListener);
    }

    private static final void setupInputMethodSupport$lambda$0(CoroutineScope $coroutineScope) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)$coroutineScope, (String)"Terminal is disposed (Experimental 2024)", null, (int)2, null);
    }

    private static final LogicalPosition setupInputMethodSupport$lambda$1(TerminalCaretModel $caretModel) {
        return $caretModel.getCaretPosition();
    }

    private static final Unit setupInputMethodSupport$lambda$2(BlockTerminalSession $session, String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $session.getTerminalOutputStream().sendString(text, true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$setupMouseListener$isRemoteMouseAction(TerminalModel $model, MouseEvent e) {
        return TerminalEventDispatcherKt.setupMouseListener$isRemoteMouseAction($model, e);
    }

    public static final /* synthetic */ int access$setupMouseListener$historyLinesCount(TerminalModel $model) {
        return TerminalEventDispatcherKt.setupMouseListener$historyLinesCount($model);
    }
}

