/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ConditionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public final class DFAType {
    public static final DFAType NULL_DFA_TYPE = new DFAType(null);
    @Nullable
    private final PsiType primary;
    private final List<Mixin> mixins = new ArrayList<Mixin>();

    private DFAType(@Nullable PsiType primary) {
        this.primary = primary;
    }

    @Contract(pure=true)
    @NotNull
    public DFAType withNewMixin(@Nullable PsiType mixin, @Nullable ConditionInstruction instruction) {
        if (mixin == null) {
            DFAType dFAType = this;
            if (dFAType == null) {
                DFAType.$$$reportNull$$$0(0);
            }
            return dFAType;
        }
        Mixin newMixin = new Mixin(mixin, instruction, instruction != null && instruction.isNegated());
        if (this.mixins.contains(newMixin)) {
            DFAType dFAType = this;
            if (dFAType == null) {
                DFAType.$$$reportNull$$$0(1);
            }
            return dFAType;
        }
        DFAType newDfaType = new DFAType(this.primary);
        newDfaType.mixins.addAll(this.mixins);
        newDfaType.mixins.add(newMixin);
        DFAType dFAType = newDfaType;
        if (dFAType == null) {
            DFAType.$$$reportNull$$$0(2);
        }
        return dFAType;
    }

    @Contract(pure=true)
    @NotNull
    public DFAType withNegated(@NotNull NegatingGotoInstruction negation) {
        if (negation == null) {
            DFAType.$$$reportNull$$$0(3);
        }
        if (this.mixins.isEmpty()) {
            DFAType dFAType = this;
            if (dFAType == null) {
                DFAType.$$$reportNull$$$0(4);
            }
            return dFAType;
        }
        Set<ConditionInstruction> conditionsToNegate = negation.getCondition().getDependentConditions();
        if (ContainerUtil.and(this.mixins, mixin -> !conditionsToNegate.contains(mixin.myCondition))) {
            DFAType dFAType = this;
            if (dFAType == null) {
                DFAType.$$$reportNull$$$0(5);
            }
            return dFAType;
        }
        DFAType result2 = this.copy();
        ListIterator<Mixin> iterator2 = result2.mixins.listIterator();
        while (iterator2.hasNext()) {
            Mixin mixin2 = iterator2.next();
            if (!conditionsToNegate.contains(mixin2.myCondition)) continue;
            iterator2.set(mixin2.negate());
        }
        DFAType dFAType = result2;
        if (dFAType == null) {
            DFAType.$$$reportNull$$$0(6);
        }
        return dFAType;
    }

    @Contract(pure=true)
    @NotNull
    public static DFAType merge(DFAType t1, DFAType t2, PsiManager manager) {
        if (t1.equals(t2)) {
            DFAType dFAType = t1;
            if (dFAType == null) {
                DFAType.$$$reportNull$$$0(7);
            }
            return dFAType;
        }
        if (DFAType.dominates(t1, t2)) {
            DFAType dFAType = t1;
            if (dFAType == null) {
                DFAType.$$$reportNull$$$0(8);
            }
            return dFAType;
        }
        if (DFAType.dominates(t2, t1)) {
            DFAType dFAType = t2;
            if (dFAType == null) {
                DFAType.$$$reportNull$$$0(9);
            }
            return dFAType;
        }
        PsiType primary = TypesUtil.getLeastUpperBoundNullable(t1.primary, t2.primary, manager);
        PsiType type1 = DFAType.reduce(t1.mixins);
        PsiType type2 = DFAType.reduce(t2.mixins);
        if (type1 != null && type2 != null) {
            DFAType dFAType = DFAType.create(primary).withNewMixin(GenericsUtil.getLeastUpperBound((PsiType)type1, (PsiType)type2, (PsiManager)manager), null);
            if (dFAType == null) {
                DFAType.$$$reportNull$$$0(10);
            }
            return dFAType;
        }
        return DFAType.create(primary);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DFAType)) {
            return false;
        }
        DFAType other = (DFAType)obj;
        if (!DFAType.eq(this.primary, other.primary)) {
            return false;
        }
        if (this.mixins.size() != other.mixins.size()) {
            return false;
        }
        for (Mixin mixin1 : this.mixins) {
            boolean contains = false;
            for (Mixin mixin2 : other.mixins) {
                if (!mixin1.equals(mixin2)) continue;
                contains = mixin1.myNegated == mixin2.myNegated;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public PsiType getResultType() {
        if (this.mixins.isEmpty()) {
            return this.primary;
        }
        ArrayList<PsiType> types = new ArrayList<PsiType>();
        if (this.primary != null) {
            types.add(this.primary);
        }
        for (Mixin mixin : this.mixins) {
            if (mixin.myNegated || mixin.myType.equals(PsiTypes.nullType())) continue;
            types.add(mixin.myType);
        }
        if (types.isEmpty()) {
            return null;
        }
        return PsiIntersectionType.createIntersection((PsiType[])types.toArray(PsiType.createArray((int)types.size())));
    }

    @NotNull
    public static DFAType create(@Nullable PsiType type) {
        return type == null ? NULL_DFA_TYPE : new DFAType(type);
    }

    private static boolean eq(PsiType t1, PsiType t2) {
        return t1 == t2 || Comparing.equal((Object)TypeConversionUtil.erasure((PsiType)t1), (Object)TypeConversionUtil.erasure((PsiType)t2));
    }

    public static boolean dominates(DFAType dominating, DFAType dominated) {
        boolean primaryDominating;
        boolean bl = primaryDominating = dominated.primary == null || dominated.primary == PsiTypes.nullType() || dominated.primary == dominating.primary;
        if (!primaryDominating) {
            return false;
        }
        return dominating.mixins.isEmpty() || dominated.mixins == dominating.mixins;
    }

    private static PsiType reduce(List<Mixin> mixins) {
        List types = mixins.stream().filter(it -> !it.myNegated).map(it -> it.myType).collect(Collectors.toList());
        return types.isEmpty() ? null : PsiIntersectionType.createIntersection(types);
    }

    @Contract(value="-> new")
    @NotNull
    private DFAType copy() {
        DFAType type = new DFAType(this.primary);
        type.mixins.addAll(this.mixins);
        DFAType dFAType = type;
        if (dFAType == null) {
            DFAType.$$$reportNull$$$0(11);
        }
        return dFAType;
    }

    public String toString() {
        return "{" + String.valueOf(this.primary) + " : " + String.valueOf(this.mixins) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "negation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withNewMixin";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withNegated";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withNegated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    private static final class Mixin {
        @NotNull
        private final PsiType myType;
        @Nullable
        private final ConditionInstruction myCondition;
        private final boolean myNegated;

        private Mixin(@NotNull PsiType type, @Nullable ConditionInstruction condition, boolean negated) {
            if (type == null) {
                Mixin.$$$reportNull$$$0(0);
            }
            this.myType = type;
            this.myCondition = condition;
            this.myNegated = negated;
        }

        private Mixin negate() {
            return new Mixin(this.myType, this.myCondition, !this.myNegated);
        }

        public String toString() {
            return (this.myNegated ? "!" : "") + String.valueOf(this.myType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Mixin mixin = (Mixin)o;
            if (!this.myType.equals(mixin.myType)) {
                return false;
            }
            return Objects.equals(this.myCondition, mixin.myCondition);
        }

        public int hashCode() {
            int result2 = this.myType.hashCode();
            result2 = 31 * result2 + (this.myCondition != null ? this.myCondition.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAType$Mixin", "<init>"));
        }
    }
}

