/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ConnectorImpl;
import com.jetbrains.jdi.VirtualMachineManagerImpl;
import com.sun.jdi.InternalException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

abstract class AbstractLauncher
extends ConnectorImpl
implements LaunchingConnector {
    ThreadGroup grp = Thread.currentThread().getThreadGroup();

    @Override
    public abstract VirtualMachine launch(Map<String, ? extends Connector.Argument> var1) throws IOException, IllegalConnectorArgumentsException, VMStartException;

    @Override
    public abstract String name();

    @Override
    public abstract String description();

    AbstractLauncher() {
        ThreadGroup parent;
        while ((parent = this.grp.getParent()) != null) {
            this.grp = parent;
        }
    }

    String[] tokenizeCommand(String command2, char quote) {
        String quoteStr = String.valueOf(quote);
        StringTokenizer tokenizer = new StringTokenizer(command2, quote + " \t\r\n\f", true);
        Object quoted = null;
        String pending = null;
        ArrayList<Object> tokenList = new ArrayList<Object>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (quoted != null) {
                if (token.equals(quoteStr)) {
                    tokenList.add(quoted);
                    quoted = null;
                    continue;
                }
                quoted = quoted + token;
                continue;
            }
            if (pending != null) {
                if (token.equals(quoteStr)) {
                    quoted = pending;
                } else if (token.length() == 1 && Character.isWhitespace(token.charAt(0))) {
                    tokenList.add(pending);
                } else {
                    throw new InternalException("Unexpected token: " + token);
                }
                pending = null;
                continue;
            }
            if (token.equals(quoteStr)) {
                quoted = "";
                continue;
            }
            if (token.length() == 1 && Character.isWhitespace(token.charAt(0))) continue;
            pending = token;
        }
        if (pending != null) {
            tokenList.add(pending);
        }
        if (quoted != null) {
            tokenList.add(quoted);
        }
        String[] tokenArray2 = new String[tokenList.size()];
        for (int i2 = 0; i2 < tokenList.size(); ++i2) {
            tokenArray2[i2] = (String)tokenList.get(i2);
        }
        return tokenArray2;
    }

    protected VirtualMachine launch(String[] commandArray, String address, TransportService.ListenKey listenKey, TransportService ts) throws IOException, VMStartException {
        Helper helper = new Helper(commandArray, address, listenKey, ts);
        helper.launchAndAccept();
        VirtualMachineManagerImpl manager = VirtualMachineManagerImpl.virtualMachineManager();
        return manager.createVirtualMachine(helper.connection(), helper.process());
    }

    private class Helper {
        private final String address;
        private final TransportService.ListenKey listenKey;
        private final TransportService ts;
        private final String[] commandArray;
        private Process process = null;
        private Connection connection = null;
        private IOException acceptException = null;
        private boolean exited = false;

        Helper(String[] commandArray, String address, TransportService.ListenKey listenKey, TransportService ts) {
            this.commandArray = commandArray;
            this.address = address;
            this.listenKey = listenKey;
            this.ts = ts;
        }

        String commandString() {
            Object str = "";
            for (int i2 = 0; i2 < this.commandArray.length; ++i2) {
                if (i2 > 0) {
                    str = (String)str + " ";
                }
                str = (String)str + this.commandArray[i2];
            }
            return str;
        }

        synchronized void launchAndAccept() throws IOException, VMStartException {
            this.process = Runtime.getRuntime().exec(this.commandArray);
            Thread acceptingThread = this.acceptConnection();
            Thread monitoringThread = this.monitorTarget();
            try {
                while (this.connection == null && this.acceptException == null && !this.exited) {
                    this.wait();
                }
                if (this.exited) {
                    throw new VMStartException("VM initialization failed for: " + this.commandString(), this.process);
                }
                if (this.acceptException != null) {
                    throw this.acceptException;
                }
            }
            catch (InterruptedException e2) {
                throw new InterruptedIOException("Interrupted during accept");
            }
            finally {
                acceptingThread.interrupt();
                monitoringThread.interrupt();
            }
        }

        Process process() {
            return this.process;
        }

        Connection connection() {
            return this.connection;
        }

        synchronized void notifyOfExit() {
            this.exited = true;
            this.notify();
        }

        synchronized void notifyOfConnection(Connection connection) {
            this.connection = connection;
            this.notify();
        }

        synchronized void notifyOfAcceptException(IOException acceptException) {
            this.acceptException = acceptException;
            this.notify();
        }

        Thread monitorTarget() {
            Thread thread = new Thread(AbstractLauncher.this.grp, "launched target monitor"){

                @Override
                public void run() {
                    try {
                        Helper.this.process.waitFor();
                        Helper.this.notifyOfExit();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            return thread;
        }

        Thread acceptConnection() {
            Thread thread = new Thread(AbstractLauncher.this.grp, "connection acceptor"){

                @Override
                public void run() {
                    try {
                        Connection connection = Helper.this.ts.accept(Helper.this.listenKey, 0L, 0L);
                        Helper.this.notifyOfConnection(connection);
                    }
                    catch (InterruptedIOException connection) {
                    }
                    catch (IOException e2) {
                        Helper.this.notifyOfAcceptException(e2);
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            return thread;
        }
    }
}

