#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.1
visibility:           public
id:                   hOpenPGP-2.10.1-4hvvElW2dtcJ0DrexVGcWh
key:                  hOpenPGP-2.10.1-4hvvElW2dtcJ0DrexVGcWh
license:              MIT
copyright:            2012-2025  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  51090308107935d8470290a8578bd038
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Codec.Encryption.OpenPGP.Version Data.Conduit.OpenPGP.Compression
    Data.Conduit.OpenPGP.Decrypt Data.Conduit.OpenPGP.Filter
    Data.Conduit.OpenPGP.Keyring Data.Conduit.OpenPGP.Keyring.Instances
    Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs Paths_hOpenPGP

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hOpenPGP-2.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.1-4hvvElW2dtcJ0DrexVGcWh
depends:
    aeson-2.1.2.1-KAplhvfLEdp6k37mi9zTZA
    asn1-encoding-0.9.6-65YxMp5s6gF6iIu44XaraU
    attoparsec-0.14.4-ARFIPKVHAQdH6rZ1P31wQY base-4.18.2.1
    base16-bytestring-1.0.2.0-6dMnLpvCfjZITVAVfsWwso
    bifunctors-5.6.2-8n7c3k1VnsqINOpTGehIgH binary-0.8.9.1
    binary-conduit-1.3.1-DuBhQ9tkY6H9ROzUT3OrzX bytestring-0.11.5.3
    bz2-1.0.1.1-CcmEfdCHcUO3FpycYUewQh
    conduit-1.3.6.1-9Ano6zkKE8Q3t2Yg7Ibwss
    conduit-extra-1.3.8-B6Eb1ypzIORHRjCExezdNC containers-0.6.7
    crypto-cipher-types-0.0.9-KR6SDml7aC01N7sg8RBO5C
    crypton-1.0.4-15CSq8PrPPY2dmnZbUXwmg
    errors-2.3.0-AdNJnu6uPuQ88GjFtyyGik
    hashable-1.4.7.0-9Up8LPJnqTG92zCMBiHaIh
    incremental-parser-0.5.1-K2sz1OqlpU2JjwqOaUveO4
    ixset-typed-0.5.1.0-7E5f1hWnTerGJjKdQkag3R
    lens-5.3.3-ATynRreA1Nv2YBaKYxJYCc
    memory-0.18.0-6zo36PbRecTK4fqbBnx0f5
    monad-loops-0.4.3-LG7facWXNYz9W52syv7lz8
    nettle-0.3.1.1-DuwdlQIRX7hBXjJiv7OWDZ
    network-uri-2.6.4.2-3zCbFVr23iA8AOO7Y4yAP5
    openpgp-asciiarmor-0.1.2-InF5TVYCiKDAlJViNrWhpG
    prettyprinter-1.7.1-3RIfAGP8Xsr2KtHw8aT8ed
    resourcet-1.2.6-JmCxdoDVdAFAYoX7rfTvi0
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8 text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-8XUEctZKps57K6Zw5siYoh
    transformers-0.6.1.0 unliftio-core-0.2.1.0-6sOpIonHj8t5wIbPhWbPHY
    unordered-containers-0.2.20.1-CjV5euINhym8dGoasHPURS
    zlib-0.7.0.0-3sNzZhB7apLBR7uUC6lcC

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

