import { StatementPosition, TokenType } from '../types.js';
import { SELECT, WITH, AS, WHERE, BY, GROUP, FROM, AND, ORDER, DESC, ASC } from './language.js';
import '@grafana/data';
import '@grafana/ui';

function initStatementPositionResolvers() {
  return [
    {
      id: StatementPosition.SelectKeyword,
      name: StatementPosition.SelectKeyword,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => Boolean(
        currentToken === null || currentToken.isWhiteSpace() && currentToken.previous === null || currentToken.is(TokenType.Keyword, SELECT) || currentToken.is(TokenType.Keyword, SELECT) && currentToken.previous === null || previousIsSlash || currentToken.isIdentifier() && (previousIsSlash || (currentToken == null ? undefined : currentToken.previous) === null) || currentToken.isIdentifier() && SELECT.startsWith(currentToken.value.toLowerCase())
      )
    },
    {
      id: StatementPosition.WithKeyword,
      name: StatementPosition.WithKeyword,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => Boolean(
        currentToken === null || currentToken.isWhiteSpace() && currentToken.previous === null || currentToken.is(TokenType.Keyword, WITH) && currentToken.previous === null || currentToken.isIdentifier() && WITH.toLowerCase().startsWith(currentToken.value.toLowerCase())
      )
    },
    {
      id: StatementPosition.AfterSelectKeyword,
      name: StatementPosition.AfterSelectKeyword,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => Boolean((previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.value.toLowerCase()) === SELECT)
    },
    {
      id: StatementPosition.AfterSelectArguments,
      name: StatementPosition.AfterSelectArguments,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        return Boolean((previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === SELECT && (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.value) === ",");
      }
    },
    {
      id: StatementPosition.AfterSelectFuncFirstArgument,
      name: StatementPosition.AfterSelectFuncFirstArgument,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        return Boolean(
          ((previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === SELECT || (previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === AS) && ((previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Parenthesis, "(")) || (currentToken == null ? undefined : currentToken.is(TokenType.Parenthesis, "()")))
        );
      }
    },
    {
      id: StatementPosition.AfterWhereFunctionArgument,
      name: StatementPosition.AfterWhereFunctionArgument,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        return Boolean(
          (previousKeyword == null ? undefined : previousKeyword.is(TokenType.Keyword, WHERE)) && ((previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Parenthesis, "(")) || (currentToken == null ? undefined : currentToken.is(TokenType.Parenthesis, "()")))
        );
      }
    },
    {
      id: StatementPosition.AfterGroupBy,
      name: StatementPosition.AfterGroupBy,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        var _a;
        return Boolean(
          (previousKeyword == null ? undefined : previousKeyword.is(TokenType.Keyword, BY)) && ((_a = previousKeyword == null ? undefined : previousKeyword.getPreviousKeyword()) == null ? undefined : _a.is(TokenType.Keyword, GROUP)) && ((previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isIdentifier()) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isDoubleQuotedString()) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Parenthesis, ")")) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Parenthesis, "()")))
        );
      }
    },
    {
      id: StatementPosition.SelectAlias,
      name: StatementPosition.SelectAlias,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        if ((previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.value) === "," && (previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === AS) {
          return true;
        }
        return false;
      }
    },
    {
      id: StatementPosition.FromKeyword,
      name: StatementPosition.FromKeyword,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        return Boolean(
          (previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === SELECT && (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.value) !== "," || ((currentToken == null ? undefined : currentToken.isKeyword()) || (currentToken == null ? undefined : currentToken.isIdentifier())) && FROM.toLowerCase().startsWith(currentToken.value.toLowerCase())
        );
      }
    },
    {
      id: StatementPosition.AfterFromKeyword,
      name: StatementPosition.AfterFromKeyword,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => Boolean(!(currentToken == null ? undefined : currentToken.value.includes(".")) && (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.value.toLowerCase()) === FROM)
    },
    {
      id: StatementPosition.AfterSchema,
      name: StatementPosition.AfterSchema,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        if ((currentToken == null ? undefined : currentToken.isWhiteSpace()) && (currentToken == null ? undefined : currentToken.next)) {
          currentToken = currentToken == null ? undefined : currentToken.previous;
          previousNonWhiteSpace = currentToken.getPreviousNonWhiteSpaceToken();
        }
        return Boolean(
          (currentToken == null ? undefined : currentToken.isIdentifier()) && (currentToken == null ? undefined : currentToken.value.endsWith(".")) && (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.value.toLowerCase()) === FROM
        );
      }
    },
    {
      id: StatementPosition.AfterFrom,
      name: StatementPosition.AfterFrom,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => Boolean(
        (previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === FROM && (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isDoubleQuotedString()) || (previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === FROM && (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isIdentifier()) || (previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === FROM && (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isVariable())
        //  cloudwatch specific
        // (previousKeyword?.value === SCHEMA && previousNonWhiteSpace?.is(TokenType.Parenthesis, ')'))
      )
    },
    {
      id: StatementPosition.AfterTable,
      name: StatementPosition.AfterTable,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        return Boolean(
          (previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === FROM && ((previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isVariable()) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.value) !== "" && (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.value.toLowerCase()) !== FROM)
        );
      }
    },
    {
      id: StatementPosition.WhereKeyword,
      name: StatementPosition.WhereKeyword,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => Boolean(
        (previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === WHERE && ((previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isKeyword()) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Parenthesis, "(")) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Operator, AND)))
      )
    },
    {
      id: StatementPosition.WhereComparisonOperator,
      name: StatementPosition.WhereComparisonOperator,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        var _a;
        return Boolean(
          (previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === WHERE && !((_a = previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.getPreviousNonWhiteSpaceToken()) == null ? undefined : _a.isOperator()) && !(currentToken == null ? undefined : currentToken.is(TokenType.Delimiter, ".")) && !(currentToken == null ? undefined : currentToken.isParenthesis()) && ((previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isIdentifier()) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isDoubleQuotedString()))
        );
      }
    },
    {
      id: StatementPosition.WhereValue,
      name: StatementPosition.WhereValue,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => Boolean((previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === WHERE && (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isOperator()))
    },
    {
      id: StatementPosition.AfterWhereValue,
      name: StatementPosition.AfterWhereValue,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        var _a, _b, _c;
        return Boolean(
          (previousKeyword == null ? undefined : previousKeyword.value.toLowerCase()) === WHERE && ((previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Operator, "and")) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Operator, "or")) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isString()) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isNumber()) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Parenthesis, ")")) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Parenthesis, "()")) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.isTemplateVariable()) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.IdentifierQuote)) && ((_a = previousNonWhiteSpace.getPreviousNonWhiteSpaceToken()) == null ? undefined : _a.is(TokenType.Identifier)) && ((_c = (_b = previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.getPreviousNonWhiteSpaceToken()) == null ? undefined : _b.getPreviousNonWhiteSpaceToken()) == null ? undefined : _c.is(TokenType.IdentifierQuote)))
        );
      }
    },
    {
      id: StatementPosition.AfterGroupByKeywords,
      name: StatementPosition.AfterGroupByKeywords,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        var _a;
        return Boolean(
          (previousKeyword == null ? undefined : previousKeyword.is(TokenType.Keyword, BY)) && ((_a = previousKeyword == null ? undefined : previousKeyword.getPreviousKeyword()) == null ? undefined : _a.is(TokenType.Keyword, GROUP)) && ((previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Keyword, BY)) || (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Delimiter, ",")))
        );
      }
    },
    {
      id: StatementPosition.AfterGroupByFunctionArgument,
      name: StatementPosition.AfterGroupByFunctionArgument,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        var _a;
        return Boolean(
          (previousKeyword == null ? undefined : previousKeyword.is(TokenType.Keyword, BY)) && ((_a = previousKeyword == null ? undefined : previousKeyword.getPreviousKeyword()) == null ? undefined : _a.is(TokenType.Keyword, GROUP)) && ((previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Parenthesis, "(")) || (currentToken == null ? undefined : currentToken.is(TokenType.Parenthesis, "()")))
        );
      }
    },
    {
      id: StatementPosition.AfterOrderByKeywords,
      name: StatementPosition.AfterOrderByKeywords,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        var _a;
        return Boolean(
          (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Keyword, BY)) && ((_a = previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.getPreviousKeyword()) == null ? undefined : _a.is(TokenType.Keyword, ORDER))
        );
      }
    },
    {
      id: StatementPosition.AfterOrderByFunction,
      name: StatementPosition.AfterOrderByFunction,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        var _a, _b;
        return Boolean(
          (previousKeyword == null ? undefined : previousKeyword.is(TokenType.Keyword, BY)) && ((_a = previousKeyword == null ? undefined : previousKeyword.getPreviousKeyword()) == null ? undefined : _a.is(TokenType.Keyword, ORDER)) && (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Parenthesis)) && ((_b = previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.getPreviousNonWhiteSpaceToken()) == null ? undefined : _b.is(TokenType.Function))
        );
      }
    },
    {
      id: StatementPosition.AfterOrderByDirection,
      name: StatementPosition.AfterOrderByDirection,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => Boolean((previousKeyword == null ? undefined : previousKeyword.is(TokenType.Keyword, DESC)) || (previousKeyword == null ? undefined : previousKeyword.is(TokenType.Keyword, ASC)))
    },
    {
      id: StatementPosition.AfterIsOperator,
      name: StatementPosition.AfterIsOperator,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        return Boolean(previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Operator, "IS"));
      }
    },
    {
      id: StatementPosition.AfterIsNotOperator,
      name: StatementPosition.AfterIsNotOperator,
      resolve: (currentToken, previousKeyword, previousNonWhiteSpace, previousIsSlash) => {
        var _a;
        return Boolean(
          (previousNonWhiteSpace == null ? undefined : previousNonWhiteSpace.is(TokenType.Operator, "NOT")) && ((_a = previousNonWhiteSpace.getPreviousNonWhiteSpaceToken()) == null ? undefined : _a.is(TokenType.Operator, "IS"))
        );
      }
    }
  ];
}

export { initStatementPositionResolvers };
//# sourceMappingURL=statementPositionResolversRegistry.js.map
