/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.daemon.serialization;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.tooling.internal.provider.serialization.ClientOwnedClassLoaderSpec;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderFactory;

public class DaemonSidePayloadClassLoaderFactory
implements PayloadClassLoaderFactory {
    private final PayloadClassLoaderFactory delegate;
    private final CachedClasspathTransformer cachedClasspathTransformer;

    public DaemonSidePayloadClassLoaderFactory(PayloadClassLoaderFactory delegate, CachedClasspathTransformer cachedClasspathTransformer) {
        this.delegate = delegate;
        this.cachedClasspathTransformer = cachedClasspathTransformer;
    }

    public ClassLoader getClassLoaderFor(ClassLoaderSpec spec, List<? extends ClassLoader> parents) {
        if (spec instanceof ClientOwnedClassLoaderSpec) {
            ClientOwnedClassLoaderSpec clientSpec = (ClientOwnedClassLoaderSpec)spec;
            return this.createClassLoaderForClassPath("client-owned-daemon-payload-loader", parents, this.urls(clientSpec.getClasspath()));
        }
        if (spec instanceof VisitableURLClassLoader.Spec) {
            VisitableURLClassLoader.Spec urlSpec = (VisitableURLClassLoader.Spec)spec;
            return this.createClassLoaderForClassPath(urlSpec.getName() + "-daemon-payload-loader", parents, urlSpec.getClasspath());
        }
        return this.delegate.getClassLoaderFor(spec, parents);
    }

    private List<URL> urls(List<URI> classpath) {
        ArrayList<URL> urls = new ArrayList<URL>(classpath.size());
        for (URI uri : classpath) {
            try {
                urls.add(uri.toURL());
            }
            catch (MalformedURLException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        return urls;
    }

    private ClassLoader createClassLoaderForClassPath(String name, List<? extends ClassLoader> parents, List<URL> classpath) {
        if (parents.size() != 1) {
            throw new IllegalStateException("Expected exactly one parent ClassLoader");
        }
        Collection cachedClassPathUrls = this.cachedClasspathTransformer.copyingTransform(classpath);
        return new VisitableURLClassLoader(name, parents.get(0), cachedClassPathUrls);
    }
}

