/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.resolver;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.kotlin.dsl.resolver.FetchParameters;
import org.gradle.kotlin.dsl.resolver.GradleInstallation;
import org.gradle.kotlin.dsl.resolver.KotlinBuildScriptModelRequest;
import org.gradle.kotlin.dsl.support.IOKt;
import org.gradle.kotlin.dsl.support.KotlinScriptType;
import org.gradle.kotlin.dsl.support.KotlinScriptTypeKt;
import org.gradle.kotlin.dsl.tooling.models.KotlinBuildScriptModel;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u001a.\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fH\u0007\u001a/\u0010\u0011\u001a\u00020\u0012*\u00020\n2!\u0010\u0013\u001a\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003j\u0002`\u0014\u00a2\u0006\u0002\b\u0007H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0012H\u0002\u001a8\u0010\u001e\u001a&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00050\u0005 \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004*\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0012H\u0002\u001a\u001a\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a$\u0010#\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\fH\u0000*:\b\u0000\u0010\u0002\"\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\b\u00072\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\b\u0007\u00a8\u0006&"}, d2={"newCorrelationId", "", "ModelBuilderCustomization", "Lkotlin/Function1;", "Lorg/gradle/tooling/ModelBuilder;", "Lorg/gradle/kotlin/dsl/tooling/models/KotlinBuildScriptModel;", "", "Lkotlin/ExtensionFunctionType;", "fetchKotlinBuildScriptModelFor", "request", "Lorg/gradle/kotlin/dsl/resolver/KotlinBuildScriptModelRequest;", "importedProjectDir", "Ljava/io/File;", "scriptFile", "connectorForProject", "Ljava/util/function/Function;", "Lorg/gradle/tooling/GradleConnector;", "toFetchParametersWith", "Lorg/gradle/kotlin/dsl/resolver/FetchParameters;", "modelBuilderCustomization", "Lorg/gradle/kotlin/dsl/resolver/ModelBuilderCustomization;", "connectorFor", "useGradleFrom", "gradleInstallation", "Lorg/gradle/kotlin/dsl/resolver/GradleInstallation;", "parameters", "fetchKotlinBuildScriptModelFrom", "projectDir", "connectionForProjectDir", "Lorg/gradle/tooling/ProjectConnection;", "modelBuilderFor", "kotlin.jvm.PlatformType", "buildSrcProjectDirOf", "hasProjectDependentClassPath", "", "projectRootOf", "importedProjectRoot", "stopAt", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nKotlinBuildScriptModelRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBuildScriptModelRequest.kt\norg/gradle/kotlin/dsl/resolver/KotlinBuildScriptModelRequestKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1#2:240\n*E\n"})
public final class KotlinBuildScriptModelRequestKt {
    @NotNull
    public static final String newCorrelationId() {
        return String.valueOf(System.nanoTime());
    }

    @NotNull
    public static final KotlinBuildScriptModel fetchKotlinBuildScriptModelFor(@NotNull KotlinBuildScriptModelRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFor(KotlinBuildScriptModelRequestKt.toFetchParametersWith(request, (Function1<? super ModelBuilder<KotlinBuildScriptModel>, Unit>)((Function1)arg_0 -> KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFor$lambda$0(request, arg_0))));
    }

    @VisibleForTesting
    @NotNull
    public static final KotlinBuildScriptModel fetchKotlinBuildScriptModelFor(@NotNull File importedProjectDir, @Nullable File scriptFile, @NotNull Function<File, GradleConnector> connectorForProject) {
        Intrinsics.checkNotNullParameter((Object)importedProjectDir, (String)"importedProjectDir");
        Intrinsics.checkNotNullParameter(connectorForProject, (String)"connectorForProject");
        return KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFor(new FetchParameters(importedProjectDir, scriptFile, connectorForProject, null, null, null, null, null, 248, null));
    }

    private static final FetchParameters toFetchParametersWith(KotlinBuildScriptModelRequest $this$toFetchParametersWith, Function1<? super ModelBuilder<KotlinBuildScriptModel>, Unit> modelBuilderCustomization) {
        return new FetchParameters($this$toFetchParametersWith.getProjectDir(), $this$toFetchParametersWith.getScriptFile(), new Function($this$toFetchParametersWith){
            final /* synthetic */ KotlinBuildScriptModelRequest $this_toFetchParametersWith;
            {
                this.$this_toFetchParametersWith = $receiver;
            }

            public final GradleConnector apply(File projectDir) {
                Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
                return KotlinBuildScriptModelRequestKt.access$connectorFor(this.$this_toFetchParametersWith).forProjectDirectory(projectDir);
            }
        }, $this$toFetchParametersWith.getOptions(), $this$toFetchParametersWith.getJvmOptions(), $this$toFetchParametersWith.getEnvironmentVariables(), $this$toFetchParametersWith.getCorrelationId(), modelBuilderCustomization);
    }

    private static final GradleConnector connectorFor(KotlinBuildScriptModelRequest request) {
        GradleConnector gradleConnector = GradleConnector.newConnector();
        Intrinsics.checkNotNullExpressionValue((Object)gradleConnector, (String)"newConnector(...)");
        GradleConnector gradleConnector2 = KotlinBuildScriptModelRequestKt.useGradleFrom(gradleConnector, request.getGradleInstallation()).useGradleUserHomeDir(request.getGradleUserHome());
        Intrinsics.checkNotNullExpressionValue((Object)gradleConnector2, (String)"useGradleUserHomeDir(...)");
        return gradleConnector2;
    }

    private static final GradleConnector useGradleFrom(GradleConnector $this$useGradleFrom, GradleInstallation gradleInstallation) {
        GradleConnector gradleConnector;
        GradleInstallation $this$useGradleFrom_u24lambda_u240 = gradleInstallation;
        boolean bl = false;
        GradleInstallation gradleInstallation2 = $this$useGradleFrom_u24lambda_u240;
        if (gradleInstallation2 instanceof GradleInstallation.Local) {
            gradleConnector = $this$useGradleFrom.useInstallation(((GradleInstallation.Local)$this$useGradleFrom_u24lambda_u240).getDir());
        } else if (gradleInstallation2 instanceof GradleInstallation.Remote) {
            gradleConnector = $this$useGradleFrom.useDistribution(((GradleInstallation.Remote)$this$useGradleFrom_u24lambda_u240).getUri());
        } else if (gradleInstallation2 instanceof GradleInstallation.Version) {
            gradleConnector = $this$useGradleFrom.useGradleVersion(((GradleInstallation.Version)$this$useGradleFrom_u24lambda_u240).getNumber());
        } else if (gradleInstallation2 instanceof GradleInstallation.Embedded) {
            DefaultGradleConnector defaultGradleConnector;
            Intrinsics.checkNotNull((Object)$this$useGradleFrom, (String)"null cannot be cast to non-null type org.gradle.tooling.internal.consumer.DefaultGradleConnector");
            DefaultGradleConnector $this$useGradleFrom_u24lambda_u240_u240 = defaultGradleConnector = (DefaultGradleConnector)$this$useGradleFrom;
            boolean bl2 = false;
            $this$useGradleFrom_u24lambda_u240_u240.embedded(true);
            $this$useGradleFrom_u24lambda_u240_u240.useClasspathDistribution();
            gradleConnector = (GradleConnector)defaultGradleConnector;
        } else if (Intrinsics.areEqual((Object)gradleInstallation2, (Object)GradleInstallation.Wrapper.INSTANCE)) {
            gradleConnector = $this$useGradleFrom.useBuildDistribution();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intrinsics.checkNotNullExpressionValue((Object)gradleConnector, (String)"run(...)");
        return gradleConnector;
    }

    private static final KotlinBuildScriptModel fetchKotlinBuildScriptModelFor(FetchParameters parameters) {
        File externalProjectRoot;
        File effectiveProjectDir;
        KotlinBuildScriptModel scriptModel;
        File projectDir = parameters.getImportedProjectDir();
        File file = parameters.getScriptFile();
        if (file == null) {
            return KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFrom(projectDir, parameters);
        }
        File scriptFile = file;
        File file2 = KotlinBuildScriptModelRequestKt.buildSrcProjectDirOf(scriptFile, projectDir);
        if (file2 == null) {
            file2 = projectDir;
        }
        if ((scriptModel = KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFrom(effectiveProjectDir = file2, parameters)).getEnclosingScriptProjectDir() == null && KotlinBuildScriptModelRequestKt.hasProjectDependentClassPath(scriptFile) && !Intrinsics.areEqual((Object)(externalProjectRoot = KotlinBuildScriptModelRequestKt.projectRootOf$default(scriptFile, projectDir, null, 4, null)), (Object)projectDir)) {
            return KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFrom(externalProjectRoot, parameters);
        }
        return scriptModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final KotlinBuildScriptModel fetchKotlinBuildScriptModelFrom(File projectDir, FetchParameters parameters) {
        KotlinBuildScriptModel kotlinBuildScriptModel;
        boolean bl = false;
        try (ProjectConnection connection = KotlinBuildScriptModelRequestKt.connectionForProjectDir(projectDir, parameters);){
            kotlinBuildScriptModel = KotlinBuildScriptModelRequestKt.modelBuilderFor(connection, parameters);
            parameters.getModelBuilderCustomization().invoke(kotlinBuildScriptModel);
            kotlinBuildScriptModel = (KotlinBuildScriptModel)kotlinBuildScriptModel.get();
        }
        KotlinBuildScriptModel kotlinBuildScriptModel2 = kotlinBuildScriptModel;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinBuildScriptModel2, (String)"let(...)");
        return kotlinBuildScriptModel2;
    }

    private static final ProjectConnection connectionForProjectDir(File projectDir, FetchParameters parameters) {
        ProjectConnection projectConnection = parameters.getConnectorForProject().apply(projectDir).connect();
        Intrinsics.checkNotNullExpressionValue((Object)projectConnection, (String)"connect(...)");
        return projectConnection;
    }

    /*
     * WARNING - void declaration
     */
    private static final ModelBuilder<KotlinBuildScriptModel> modelBuilderFor(ProjectConnection $this$modelBuilderFor, FetchParameters parameters) {
        void it;
        String[] stringArray;
        ModelBuilder modelBuilder;
        ModelBuilder $this$modelBuilderFor_u24lambda_u240 = modelBuilder = $this$modelBuilderFor.model(KotlinBuildScriptModel.class);
        boolean bl = false;
        String[] stringArray2 = stringArray = parameters.getEnvironmentVariables();
        ModelBuilder modelBuilder2 = $this$modelBuilderFor_u24lambda_u240;
        boolean bl2 = false;
        modelBuilder2.setEnvironmentVariables(Boolean.valueOf(!it.isEmpty()) != false ? stringArray : null);
        $this$modelBuilderFor_u24lambda_u240.setJvmArguments((Iterable)CollectionsKt.plus((Collection)parameters.getJvmOptions(), (Object)"-Dorg.gradle.kotlin.dsl.provider.mode=classpath"));
        stringArray = new String[]{"prepareKotlinBuildScriptModel"};
        $this$modelBuilderFor_u24lambda_u240.forTasks(stringArray);
        List arguments = CollectionsKt.toMutableList((Collection)parameters.getOptions());
        ((Collection)arguments).add("-Porg.gradle.kotlin.dsl.provider.cid=" + parameters.getCorrelationId());
        File file = parameters.getScriptFile();
        if (file != null) {
            File it2 = file;
            boolean bl3 = false;
            ((Collection)arguments).add("-Porg.gradle.kotlin.dsl.provider.script=" + it2.getCanonicalPath());
        }
        $this$modelBuilderFor_u24lambda_u240.withArguments((Iterable)arguments);
        return modelBuilder;
    }

    private static final File buildSrcProjectDirOf(File scriptFile, File importedProjectDir) {
        File file;
        File buildSrc = file = FilesKt.resolve((File)importedProjectDir, (String)"buildSrc");
        boolean bl = false;
        return buildSrc.isDirectory() && IOKt.isParentOf(buildSrc, scriptFile) ? file : null;
    }

    private static final boolean hasProjectDependentClassPath(File scriptFile) {
        KotlinScriptType kotlinScriptType = KotlinScriptTypeKt.kotlinScriptTypeFor(scriptFile);
        return (kotlinScriptType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[kotlinScriptType.ordinal()]) != 1;
    }

    @NotNull
    public static final File projectRootOf(@NotNull File scriptFile, @NotNull File importedProjectRoot, @Nullable File stopAt) {
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter((Object)importedProjectRoot, (String)"importedProjectRoot");
        File file = scriptFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        return KotlinBuildScriptModelRequestKt.projectRootOf$test(importedProjectRoot, stopAt, scriptFile, file);
    }

    public static /* synthetic */ File projectRootOf$default(File file, File file2, File file3, int n, Object object) {
        if ((n & 4) != 0) {
            file3 = null;
        }
        return KotlinBuildScriptModelRequestKt.projectRootOf(file, file2, file3);
    }

    private static final Unit fetchKotlinBuildScriptModelFor$lambda$0(KotlinBuildScriptModelRequest $request, ModelBuilder $this$toFetchParametersWith) {
        Intrinsics.checkNotNullParameter((Object)$this$toFetchParametersWith, (String)"$this$toFetchParametersWith");
        $this$toFetchParametersWith.setJavaHome($request.getJavaHome());
        return Unit.INSTANCE;
    }

    private static final boolean projectRootOf$isProjectRoot(File dir) {
        return new File(dir, "settings.gradle.kts").isFile() || new File(dir, "settings.gradle").isFile() || Intrinsics.areEqual((Object)dir.getName(), (Object)"buildSrc");
    }

    private static final File projectRootOf$test(File $importedProjectRoot, File $stopAt, File $scriptFile, File dir) {
        File file;
        while (true) {
            if (Intrinsics.areEqual((Object)dir, (Object)$importedProjectRoot)) {
                file = $importedProjectRoot;
                break;
            }
            if (KotlinBuildScriptModelRequestKt.projectRootOf$isProjectRoot(dir)) {
                file = dir;
                break;
            }
            File parentDir = dir.getParentFile();
            if (parentDir == null || Intrinsics.areEqual((Object)parentDir, (Object)dir) || Intrinsics.areEqual((Object)parentDir, (Object)$stopAt)) {
                File file2 = $scriptFile.getParentFile();
                file = file2;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
                break;
            }
            dir = parentDir;
        }
        return file;
    }

    public static final /* synthetic */ GradleConnector access$connectorFor(KotlinBuildScriptModelRequest request) {
        return KotlinBuildScriptModelRequestKt.connectorFor(request);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinScriptType.values().length];
            try {
                nArray[KotlinScriptType.INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

