/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.LayoutDecorator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.picking.ShapePickSupport;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VertexMouseInfo;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.graph.viewer.shape.GraphLoopShape;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class GraphViewerUtils {
    public static final String GRAPH_DECORATOR_THREAD_POOL_NAME = "Graph Decorator";
    public static final String GRAPH_BUILDER_THREAD_POOL_NAME = "Graph Builder";
    public static final double INTERACTION_ZOOM_THRESHOLD = 0.2;
    public static final double PAINT_ZOOM_THRESHOLD = 0.1;
    private static final int UNSCALED_EDGE_PICK_SIZE = 10;
    private static final float EDGE_LOOP_RADIUS = 1.0f;
    private static final float BEZIER_CONTROL_POINT = (float)(4.0 * (StrictMath.sqrt(2.0) - 1.0) / 3.0) * 1.0f;
    public static final int EDGE_ROW_SPACING = 25;
    public static final int EDGE_COLUMN_SPACING = 25;
    public static final int EXTRA_LAYOUT_ROW_SPACING = 50;
    public static final int EXTRA_LAYOUT_ROW_SPACING_CONDENSED = 25;
    public static final int EXTRA_LAYOUT_COLUMN_SPACING = 50;
    public static final int EXTRA_LAYOUT_COLUMN_SPACING_CONDENSED = 10;

    public static <V, E> Point translatePointFromViewSpaceToVertexRelativeSpace(VisualizationServer<V, E> viewer, Point startPoint) {
        double y;
        double x;
        GraphElementAccessor pickSupport = viewer.getPickSupport();
        PickedState pickedVertexState = viewer.getPickedVertexState();
        if (pickSupport == null || pickedVertexState == null) {
            return null;
        }
        Layout layoutModel = viewer.getGraphLayout();
        Object vertex = pickSupport.getVertex(layoutModel, x = startPoint.getX(), y = startPoint.getY());
        if (vertex == null) {
            return null;
        }
        return GraphViewerUtils.translatePointFromViewSpaceToVertexRelativeSpace(viewer, startPoint, vertex);
    }

    public static <V, E> Point translatePointFromViewSpaceToVertexRelativeSpace(VisualizationServer<V, E> viewer, Point startPoint, V vertex) {
        Point graphSpaceClickPoint = GraphViewerUtils.translatePointFromViewSpaceToGraphSpace(startPoint, viewer);
        Point vertexUpperLeftCornerInGraphSpace = GraphViewerUtils.getVertexUpperLeftCornerInGraphSpace(viewer, vertex);
        return new Point(graphSpaceClickPoint.x - vertexUpperLeftCornerInGraphSpace.x, graphSpaceClickPoint.y - vertexUpperLeftCornerInGraphSpace.y);
    }

    public static <V, E> Point getVertexUpperLeftCornerInLayoutSpace(VisualizationServer<V, E> viewer, V vertex) {
        Point vertexCenterInLayoutSpace = GraphViewerUtils.getVertexCenterPointInLayoutSpace(viewer, vertex);
        RenderContext renderContext = viewer.getRenderContext();
        Shape shape = (Shape)renderContext.getVertexShapeTransformer().apply(vertex);
        Rectangle shapeBounds = shape.getBounds();
        Point vertexUpperLeftPointRelativeToVertexCenter = shapeBounds.getLocation();
        return new Point(vertexCenterInLayoutSpace.x + vertexUpperLeftPointRelativeToVertexCenter.x, vertexCenterInLayoutSpace.y + vertexUpperLeftPointRelativeToVertexCenter.y);
    }

    public static <V, E> Point getVertexUpperLeftCornerInViewSpace(VisualizationServer<V, E> viewer, V vertex) {
        Point vertexGraphSpaceLocation = GraphViewerUtils.getVertexUpperLeftCornerInGraphSpace(viewer, vertex);
        return GraphViewerUtils.translatePointFromGraphSpaceToViewSpace(vertexGraphSpaceLocation, viewer);
    }

    public static <V, E> Rectangle getVertexBoundsInViewSpace(VisualizationServer<V, E> viewer, V vertex) {
        RenderContext renderContext = viewer.getRenderContext();
        Shape vertexGraphSpaceShape = (Shape)renderContext.getVertexShapeTransformer().apply(vertex);
        Rectangle vertexBounds = vertexGraphSpaceShape.getBounds();
        Point vertexViewSpaceLocation = GraphViewerUtils.getVertexUpperLeftCornerInViewSpace(viewer, vertex);
        Shape vertexViewSpaceShape = GraphViewerUtils.translateShapeFromGraphSpaceToViewSpace(vertexBounds, viewer);
        Rectangle vertexViewBounds = vertexViewSpaceShape.getBounds();
        vertexViewBounds.setLocation(vertexViewSpaceLocation);
        return vertexViewBounds;
    }

    public static <V, E> Rectangle getVertexBoundsInGraphSpace(VisualizationServer<V, E> viewer, V vertex) {
        RenderContext renderContext = viewer.getRenderContext();
        Shape vertexGraphSpaceShape = (Shape)renderContext.getVertexShapeTransformer().apply(vertex);
        Rectangle vertexBounds = vertexGraphSpaceShape.getBounds();
        Point vertexGraphSpaceLocation = GraphViewerUtils.getVertexUpperLeftCornerInGraphSpace(viewer, vertex);
        vertexBounds.setLocation(vertexGraphSpaceLocation);
        return vertexBounds;
    }

    public static <V, E> Rectangle getVertexBoundsInLayoutSpace(VisualizationServer<V, E> viewer, V vertex) {
        RenderContext renderContext = viewer.getRenderContext();
        Shape vertexGraphSpaceShape = (Shape)renderContext.getVertexShapeTransformer().apply(vertex);
        Rectangle vertexGraphSpaceBounds = vertexGraphSpaceShape.getBounds();
        Shape vertexLayoutSpaceShape = GraphViewerUtils.translateShapeFromGraphSpaceToLayoutSpace(vertexGraphSpaceBounds, viewer);
        Rectangle vertexLayoutSpaceBounds = vertexLayoutSpaceShape.getBounds();
        Point vertexLayoutSpaceLocation = GraphViewerUtils.getVertexUpperLeftCornerInLayoutSpace(viewer, vertex);
        vertexLayoutSpaceBounds.setLocation(vertexLayoutSpaceLocation);
        return vertexLayoutSpaceBounds;
    }

    private static <V, E> Shape translateShapeFromGraphSpaceToLayoutSpace(Shape shapeInGraphSpace, VisualizationServer<V, E> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        return transformer.inverseTransform(Layer.LAYOUT, shapeInGraphSpace);
    }

    public static <V extends VisualVertex, E extends VisualEdge<V>> VertexMouseInfo<V, E> convertMouseEventToVertexMouseEvent(GraphViewer<V, E> viewer, MouseEvent mouseEvent) {
        double y;
        double x;
        GraphElementAccessor pickSupport = viewer.getPickSupport();
        if (pickSupport == null) {
            return null;
        }
        Point screenClickPoint = mouseEvent.getPoint();
        Layout layoutModel = viewer.getGraphLayout();
        VisualVertex vertex = (VisualVertex)pickSupport.getVertex(layoutModel, x = screenClickPoint.getX(), y = screenClickPoint.getY());
        if (vertex == null) {
            return null;
        }
        Point vertexUpperLeftRelativePoint = GraphViewerUtils.translatePointFromViewSpaceToVertexRelativeSpace(viewer, mouseEvent.getPoint());
        VertexMouseInfo<VisualVertex, E> info = viewer.createVertexMouseInfo(mouseEvent, vertex, vertexUpperLeftRelativePoint);
        return info;
    }

    public static <V, E> Point getVertexUpperLeftCornerInGraphSpace(VisualizationServer<V, E> viewer, V vertex) {
        Point layoutPoint = GraphViewerUtils.getVertexUpperLeftCornerInLayoutSpace(viewer, vertex);
        return GraphViewerUtils.translatePointFromLayoutSpaceToGraphSpace(layoutPoint, viewer);
    }

    public static <V, E> Point translatePointFromLayoutSpaceToGraphSpace(Point2D pointInLayoutSpace, VisualizationServer<V, E> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        Point2D transformedPoint = transformer.transform(Layer.LAYOUT, pointInLayoutSpace);
        return new Point((int)transformedPoint.getX(), (int)transformedPoint.getY());
    }

    public static <V, E> Point translatePointFromLayoutSpaceToViewSpace(Point2D pointInLayoutSpace, VisualizationServer<V, E> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        Point2D transformedPoint = transformer.transform(pointInLayoutSpace);
        return new Point((int)transformedPoint.getX(), (int)transformedPoint.getY());
    }

    public static <V, E> Point translatePointFromViewSpaceToGraphSpace(Point2D pointInViewSpace, VisualizationServer<V, E> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        Point2D transformedPoint = transformer.inverseTransform(Layer.VIEW, pointInViewSpace);
        return new Point((int)transformedPoint.getX(), (int)transformedPoint.getY());
    }

    public static <V, E> Point translatePointFromViewSpaceToLayoutSpace(Point2D pointInViewSpace, VisualizationServer<V, E> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        Point2D transformedPoint = transformer.inverseTransform(pointInViewSpace);
        return new Point((int)transformedPoint.getX(), (int)transformedPoint.getY());
    }

    public static <V, E> Point translatePointFromGraphSpaceToViewSpace(Point2D pointInGraphSpace, VisualizationServer<V, E> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        Point2D transformedPoint = transformer.transform(Layer.VIEW, pointInGraphSpace);
        return new Point((int)transformedPoint.getX(), (int)transformedPoint.getY());
    }

    public static <V, E> Point translatePointFromGraphSpaceToLayoutSpace(Point2D pointInGraphSpace, VisualizationServer<V, E> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        Point2D transformedPoint = transformer.inverseTransform(Layer.LAYOUT, pointInGraphSpace);
        return new Point((int)transformedPoint.getX(), (int)transformedPoint.getY());
    }

    public static <V, E> Shape translateShapeFromLayoutSpaceToViewSpace(Shape shape, VisualizationServer<V, E> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        return transformer.transform(shape);
    }

    public static <V, E> Shape translateShapeFromLayoutSpaceToGraphSpace(Shape shape, VisualizationServer<V, E> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        return transformer.transform(Layer.LAYOUT, shape);
    }

    public static <V, E> Shape translateShapeFromViewSpaceToLayoutSpace(Shape shape, VisualizationServer<V, E> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        return transformer.inverseTransform(shape);
    }

    private static <V, E> Shape translateShapeFromGraphSpaceToViewSpace(Shape shapeInGraphSpace, VisualizationServer<V, E> viewer) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        return transformer.transform(Layer.VIEW, shapeInGraphSpace);
    }

    private static <V, E> Point getVertexCenterPointInLayoutSpace(VisualizationServer<V, E> viewer, V vertex) {
        Layout layout = viewer.getGraphLayout();
        Point2D vertexCenter = (Point2D)layout.apply(vertex);
        return new Point((int)vertexCenter.getX(), (int)vertexCenter.getY());
    }

    public static <V, E> Rectangle translateRectangleFromVertexRelativeSpaceToViewSpace(VisualizationServer<V, E> viewer, V vertex, Rectangle rectangle) {
        Point locationInViewSpace = GraphViewerUtils.translatePointFromVertexRelativeSpaceToViewSpace(viewer, vertex, rectangle.getLocation());
        Shape transformedShape = GraphViewerUtils.translateShapeFromGraphSpaceToViewSpace(rectangle, viewer);
        Rectangle newBounds = transformedShape.getBounds();
        newBounds.setLocation(locationInViewSpace);
        return newBounds;
    }

    public static <V, E> Rectangle translateRectangleFromLayoutSpaceToViewSpace(VisualizationServer<V, E> viewer, Rectangle rectangle) {
        Point locationInViewSpace = GraphViewerUtils.translatePointFromLayoutSpaceToViewSpace(rectangle.getLocation(), viewer);
        Shape transformedShape = GraphViewerUtils.translateShapeFromLayoutSpaceToViewSpace(rectangle, viewer);
        Rectangle newBounds = transformedShape.getBounds();
        newBounds.setLocation(locationInViewSpace);
        return newBounds;
    }

    public static <V, E> V getVertexFromPointInViewSpace(VisualizationServer<V, E> viewer, Point point) {
        GraphElementAccessor pickSupport = viewer.getPickSupport();
        if (pickSupport == null) {
            return null;
        }
        Layout layout = viewer.getGraphLayout();
        return (V)pickSupport.getVertex(layout, point.getX(), point.getY());
    }

    public static <V, E> Point getPointInViewSpaceForVertex(VisualizationServer<V, E> viewer, V vertex) {
        Point vertexUpperLeftCornerInGraphSpace = GraphViewerUtils.getVertexUpperLeftCornerInGraphSpace(viewer, vertex);
        return GraphViewerUtils.translatePointFromGraphSpaceToViewSpace(vertexUpperLeftCornerInGraphSpace, viewer);
    }

    public static <V, E> Point translatePointFromVertexRelativeSpaceToViewSpace(VisualizationServer<V, E> viewer, V vertex, Point startPoint) {
        Point vertexUpperLeftCornerInGraphSpace = GraphViewerUtils.getVertexUpperLeftCornerInGraphSpace(viewer, vertex);
        int relativeX = vertexUpperLeftCornerInGraphSpace.x + startPoint.x;
        int relativeY = vertexUpperLeftCornerInGraphSpace.y + startPoint.y;
        Point pointInGraphSpace = new Point(relativeX, relativeY);
        return GraphViewerUtils.translatePointFromGraphSpaceToViewSpace(pointInGraphSpace, viewer);
    }

    public static <V, E> E getEdgeFromPointInViewSpace(VisualizationServer<V, E> viewer, Point point) {
        GraphElementAccessor pickSupport = viewer.getPickSupport();
        if (pickSupport == null) {
            return null;
        }
        Layout layout = viewer.getGraphLayout();
        return (E)pickSupport.getEdge(layout, point.getX(), point.getY());
    }

    public static Double getScaleRatioToFitInDimension(Dimension currentSize, Dimension targetSize) {
        if (currentSize.width < targetSize.width && currentSize.height < targetSize.height) {
            return 1.0;
        }
        if (currentSize.width > targetSize.width || currentSize.height > targetSize.height) {
            return GraphViewerUtils.zoomOutRatio(currentSize, targetSize);
        }
        return null;
    }

    private static Double zoomOutRatio(Dimension currentSize, Dimension targetSize) {
        Double widthRatio = (double)targetSize.width / (double)currentSize.width;
        Double heightRatio = (double)targetSize.height / (double)currentSize.height;
        return widthRatio < heightRatio ? widthRatio : heightRatio;
    }

    public static <V, E> void setGraphScale(VisualizationServer<V, E> viewer, double scale) {
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = renderContext.getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(Layer.VIEW);
        viewTransformer.setScale(scale, scale, (Point2D)new Point(0, 0));
    }

    public static <V, E> void adjustEdgePickSizeForZoom(VisualizationServer<V, E> viewer) {
        GraphElementAccessor pickSupport = viewer.getPickSupport();
        if (!(pickSupport instanceof ShapePickSupport)) {
            return;
        }
        ShapePickSupport shapePickSupport = (ShapePickSupport)pickSupport;
        Double graphScale = GraphViewerUtils.getGraphScale(viewer);
        float adjustedPickSize = (float)(10.0 / graphScale);
        shapePickSupport.setPickSize(adjustedPickSize);
    }

    public static <V extends VisualVertex> List<V> createCollectionWithZOrderBySelection(Collection<V> vertices) {
        LinkedList<VisualVertex> list = new LinkedList<VisualVertex>();
        LinkedList<VisualVertex> selectedList = new LinkedList<VisualVertex>();
        for (VisualVertex vertex : vertices) {
            double emphasis = vertex.getEmphasis();
            if (vertex.isSelected() || emphasis != 0.0) {
                selectedList.add(vertex);
                continue;
            }
            list.add(vertex);
        }
        list.addAll(selectedList);
        return list;
    }

    public static Shape createHollowEgdeLoop() {
        return GraphViewerUtils.doCreateHollowEgdeLoop().getShape();
    }

    private static GraphLoopShape doCreateHollowEgdeLoop() {
        GeneralPath path = new GeneralPath();
        float r = 1.0f;
        float k = BEZIER_CONTROL_POINT;
        path.moveTo(0.0f, -r);
        path.curveTo(-k, -r, -r, -k, -r, 0.0f);
        path.curveTo(-r, k, -k, r, 0.0f, r);
        path.curveTo(k, r, r, k, r, 0.0f);
        path.curveTo(r, -k, k, -r, 0.0f, -r);
        path.curveTo(k, -r, r, -k, r, 0.0f);
        path.curveTo(r, k, k, r, 0.0f, r);
        path.curveTo(-k, r, -r, k, -r, 0.0f);
        path.curveTo(-r, -k, -k, -r, 0.0f, -r);
        return new GraphLoopShape(path, r);
    }

    public static Shape createHollowEgdeLoopInGraphSpace(Shape vertexShape, double x, double y) {
        GraphLoopShape fgLoopShape = GraphViewerUtils.doCreateHollowEgdeLoop();
        Shape edgeShape = fgLoopShape.getShape();
        return GraphViewerUtils.createEgdeLoopInGraphSpace(edgeShape, vertexShape, x, y);
    }

    public static Shape createEgdeLoopInGraphSpace(Shape vertexShape, double x, double y) {
        GeneralPath path = new GeneralPath();
        float r = 1.0f;
        float k = BEZIER_CONTROL_POINT;
        path.reset();
        path.moveTo(0.0f, -r);
        path.curveTo(-k, -r, -r, -k, -r, 0.0f);
        path.curveTo(-r, k, -k, r, 0.0f, r);
        path.curveTo(k, r, r, k, r, 0.0f);
        path.curveTo(r, -k, k, -r, 0.0f, -r);
        return GraphViewerUtils.createEgdeLoopInGraphSpace(path, vertexShape, x, y);
    }

    public static Shape createEgdeLoopInGraphSpace(Shape edgeLoopShape, Shape vertexShape, double x, double y) {
        Rectangle2D b = vertexShape.getBounds2D();
        double vWidth = b.getWidth();
        double vHeight = b.getHeight();
        double scale = 0.2;
        double radius = vHeight * scale;
        double diameter = radius * 2.0;
        double hiddenAmount = diameter * 0.3;
        double halfVertex = vWidth / 2.0;
        double vertexEndX = x + halfVertex;
        double edgeX = vertexEndX + radius - hiddenAmount;
        AffineTransform xform = AffineTransform.getTranslateInstance(edgeX, y);
        xform.scale(radius, radius);
        return xform.createTransformedShape(edgeLoopShape);
    }

    public static <V, E> Shape getEdgeShapeInGraphSpace(VisualizationServer<V, E> viewer, E e) {
        Layout layout = viewer.getGraphLayout();
        Pair pair = layout.getGraph().getEndpoints(e);
        Object startVertex = pair.getFirst();
        Object endVertex = pair.getSecond();
        Point2D startVertexCenter = GraphViewerUtils.getVertexCenterPointInGraphSpace(viewer, startVertex);
        if (startVertexCenter == null) {
            return null;
        }
        Point2D endVertexCenter = GraphViewerUtils.getVertexCenterPointInGraphSpace(viewer, endVertex);
        if (endVertexCenter == null) {
            return null;
        }
        boolean isLoop = startVertex.equals(endVertex);
        double startX = (float)startVertexCenter.getX();
        double startY = (float)startVertexCenter.getY();
        double endX = (float)endVertexCenter.getX();
        double endY = (float)endVertexCenter.getY();
        RenderContext renderContext = viewer.getRenderContext();
        AffineTransform xform = AffineTransform.getTranslateInstance(startX, startY);
        Shape edgeShape = (Shape)renderContext.getEdgeShapeTransformer().apply(e);
        return xform.createTransformedShape(edgeShape);
    }

    private static <V> Shape getVertexShapeForEdge(V v, Function<? super V, Shape> vertexShaper) {
        if (vertexShaper instanceof VisualGraphVertexShapeTransformer && v instanceof VisualVertex) {
            VisualVertex vv = (VisualVertex)v;
            return ((VisualGraphVertexShapeTransformer)vertexShaper).transformToCompactShape(vv);
        }
        return (Shape)vertexShaper.apply(v);
    }

    private static <V, E> Point2D getVertexCenterPointInGraphSpace(VisualizationServer<V, E> viewer, V vertex) {
        Layout layout = viewer.getGraphLayout();
        RenderContext renderContext = viewer.getRenderContext();
        MultiLayerTransformer transformer = renderContext.getMultiLayerTransformer();
        Point2D vertex1CenterInLayoutSpace = (Point2D)layout.apply(vertex);
        return transformer.transform(Layer.LAYOUT, vertex1CenterInLayoutSpace);
    }

    public static <V, E> Point2D getVertexCenterPointInViewSpace(VisualizationServer<V, E> viewer, V v) {
        Layout layout = viewer.getGraphLayout();
        Point2D centerInLayoutSpace = (Point2D)layout.apply(v);
        Point viewSpacePoint = GraphViewerUtils.translatePointFromLayoutSpaceToViewSpace(centerInLayoutSpace, viewer);
        return viewSpacePoint;
    }

    public static <V, E> Point2D.Double getVertexOffsetFromLayoutCenter(VisualizationServer<V, E> viewer, V vertex) {
        Point vertexPoint = GraphViewerUtils.getVertexCenterPointInLayoutSpace(viewer, vertex);
        return GraphViewerUtils.getOffsetFromCenterInLayoutSpace(viewer, vertexPoint);
    }

    public static <V, E> Point2D.Double getVertexOffsetFromLayoutCenterTop(VisualizationServer<V, E> viewer, V vertex) {
        return GraphViewerUtils.getVertexOffsetFromCenterTopInLayoutSpace(viewer, vertex);
    }

    public static <V, E> Point2D.Double getOffsetFromCenterForPointInViewSpace(VisualizationServer<V, E> viewer, Point2D point) {
        Point pointInLayoutSpace = GraphViewerUtils.translatePointFromViewSpaceToLayoutSpace(point, viewer);
        return GraphViewerUtils.getOffsetFromCenterInLayoutSpace(viewer, pointInLayoutSpace);
    }

    public static <V, E> Point2D.Double getOffsetFromCenterInLayoutSpace(VisualizationServer<V, E> viewer, Point pointInLayoutSpace) {
        Point2D viewCenter = viewer.getCenter();
        Point layoutCenterInLayoutSpace = GraphViewerUtils.translatePointFromViewSpaceToLayoutSpace(viewCenter, viewer);
        double offsetX = layoutCenterInLayoutSpace.getX() - pointInLayoutSpace.getX();
        double offsetY = layoutCenterInLayoutSpace.getY() - pointInLayoutSpace.getY();
        return new Point2D.Double(offsetX, offsetY);
    }

    private static <V, E> Point2D.Double getVertexOffsetFromCenterTopInLayoutSpace(VisualizationServer<V, E> viewer, V vertex) {
        Rectangle vertexBoundsInViewSpace = GraphViewerUtils.getVertexBoundsInViewSpace(viewer, vertex);
        Point vertexLocationInViewSpace = vertexBoundsInViewSpace.getLocation();
        double centerX = vertexLocationInViewSpace.getX() + (double)((int)vertexBoundsInViewSpace.getWidth() >> 1);
        vertexLocationInViewSpace.setLocation(centerX, vertexLocationInViewSpace.getY());
        Point2D viewCenter = viewer.getCenter();
        int yWithPadding = 10;
        viewCenter.setLocation(viewCenter.getX(), yWithPadding);
        Point vertexPointInLayoutSpace = GraphViewerUtils.translatePointFromViewSpaceToLayoutSpace(vertexLocationInViewSpace, viewer);
        Point layoutCenterInLayoutSpace = GraphViewerUtils.translatePointFromViewSpaceToLayoutSpace(viewCenter, viewer);
        double offsetX = layoutCenterInLayoutSpace.getX() - vertexPointInLayoutSpace.getX();
        double offsetY = layoutCenterInLayoutSpace.getY() - vertexPointInLayoutSpace.getY();
        return new Point2D.Double(offsetX, offsetY);
    }

    public static <V, E> Double getGraphScale(VisualizationServer<V, E> vv) {
        RenderContext context = vv.getRenderContext();
        MultiLayerTransformer transformer = context.getMultiLayerTransformer();
        MutableTransformer layoutTransformer = transformer.getTransformer(Layer.LAYOUT);
        MutableTransformer viewTransformer = transformer.getTransformer(Layer.VIEW);
        double modelScale = layoutTransformer.getScale();
        double viewScale = viewTransformer.getScale();
        return modelScale * viewScale;
    }

    public static <V, E> boolean isScaledPastVertexInteractionThreshold(VisualizationServer<V, E> viewer) {
        double scale = GraphViewerUtils.getGraphScale(viewer);
        return scale < 0.2;
    }

    public static <V extends VisualVertex, E extends VisualEdge<V>> Point getGraphCenterInLayoutSpace(VisualizationServer<V, E> viewer) {
        Rectangle graphBounds = GraphViewerUtils.getTotalGraphSizeInLayoutSpace(viewer);
        return new Point((int)graphBounds.getCenterX(), (int)graphBounds.getCenterY());
    }

    public static <V extends VisualVertex, E extends VisualEdge<V>> Rectangle getTotalGraphSizeInLayoutSpace(VisualizationServer<V, E> viewer) {
        Layout layout = viewer.getGraphLayout();
        Graph theGraph = layout.getGraph();
        Collection vertices = theGraph.getVertices();
        Collection edges = theGraph.getEdges();
        Function<V, Rectangle> vertexToBounds = GraphViewerUtils.createVertexToBoundsTransformer(viewer);
        if (!GraphViewerUtils.layoutUsesEdgeArticulations(layout)) {
            Rectangle bounds = GraphViewerUtils.getBoundsForVerticesInLayoutSpace(vertices, vertexToBounds);
            return bounds;
        }
        Function edgeToArticulations = e -> e.getArticulationPoints();
        return GraphViewerUtils.getTotalGraphSizeInLayoutSpace(vertices, edges, vertexToBounds, edgeToArticulations);
    }

    private static <V extends VisualVertex, E extends VisualEdge<V>> Function<V, Rectangle> createVertexToBoundsTransformer(VisualizationServer<V, E> viewer) {
        RenderContext context = viewer.getRenderContext();
        Function shapeTransformer = context.getVertexShapeTransformer();
        Layout layout = viewer.getGraphLayout();
        Function transformer = v -> {
            Shape s = (Shape)shapeTransformer.apply(v);
            Rectangle bounds = s.getBounds();
            Point2D p = (Point2D)layout.apply(v);
            bounds.setLocation(new Point((int)p.getX(), (int)p.getY()));
            return bounds;
        };
        return transformer;
    }

    public static <V extends VisualVertex, E extends VisualEdge<V>> Rectangle getTotalGraphSizeInLayoutSpace(Collection<V> vertices, Collection<E> edges, Function<V, Rectangle> vertexToBounds, Function<E, List<Point2D>> edgeToArticulations) {
        Rectangle vertexBounds = GraphViewerUtils.getBoundsForVerticesInLayoutSpace(vertices, vertexToBounds);
        double largestX = vertexBounds.x + vertexBounds.width;
        double largestY = vertexBounds.y + vertexBounds.height;
        double smallestX = vertexBounds.x;
        double smallestY = vertexBounds.y;
        for (VisualEdge e : edges) {
            List articulationPoints = (List)edgeToArticulations.apply((Object)e);
            for (Point2D point : articulationPoints) {
                double vertexX = point.getX();
                double vertexY = point.getY();
                double componentMinX = vertexX - 25.0;
                double componentMinY = vertexY - 25.0;
                double componentMaxX = vertexX + 25.0;
                double componentMaxY = vertexY + 25.0;
                smallestX = Math.min(componentMinX, smallestX);
                smallestY = Math.min(componentMinY, smallestY);
                largestX = Math.max(componentMaxX, largestX);
                largestY = Math.max(componentMaxY, largestY);
            }
        }
        int width = (int)(largestX - smallestX);
        int height = (int)(largestY - smallestY);
        return new Rectangle((int)smallestX, (int)smallestY, width, height);
    }

    public static <V, E> Rectangle getBoundsForVerticesInLayoutSpace(VisualizationServer<V, E> viewer, Collection<V> vertices) {
        Layout layout = viewer.getGraphLayout();
        RenderContext renderContext = viewer.getRenderContext();
        Function shapeTransformer = renderContext.getVertexShapeTransformer();
        Function transformer = v -> {
            Shape shape = (Shape)shapeTransformer.apply(v);
            Rectangle bounds = shape.getBounds();
            Point2D point = (Point2D)layout.apply(v);
            bounds.setLocation(new Point((int)point.getX(), (int)point.getY()));
            return bounds;
        };
        return GraphViewerUtils.getBoundsForVerticesInLayoutSpace(vertices, transformer);
    }

    public static <V, E> Rectangle getBoundsForVerticesInLayoutSpace(Collection<V> vertices, Function<V, Rectangle> vertexToBounds) {
        if (vertices.isEmpty()) {
            throw new IllegalStateException("No vertices for which to find bounds!");
        }
        double largestX = 0.0;
        double largestY = 0.0;
        double smallestX = 2.147483647E9;
        double smallestY = 2.147483647E9;
        for (V v : vertices) {
            Rectangle bounds = (Rectangle)vertexToBounds.apply(v);
            int halfWidth = bounds.width >> 1;
            int halfHeight = bounds.height >> 1;
            double vertexX = bounds.getX();
            double vertexY = bounds.getY();
            double componentMinX = vertexX - (double)halfWidth;
            double componentMinY = vertexY - (double)halfHeight;
            double componentMaxX = vertexX + (double)halfWidth;
            double componentMaxY = vertexY + (double)halfHeight;
            smallestX = Math.min(componentMinX, smallestX);
            smallestY = Math.min(componentMinY, smallestY);
            largestX = Math.max(componentMaxX, largestX);
            largestY = Math.max(componentMaxY, largestY);
        }
        int width = (int)(largestX - smallestX);
        int height = (int)(largestY - smallestY);
        return new Rectangle((int)smallestX, (int)smallestY, width, height);
    }

    public static void addPaddingToRectangle(int padding, Rectangle rectangle) {
        rectangle.x -= padding;
        rectangle.y -= padding;
        rectangle.width += padding * 2;
        rectangle.height += padding * 2;
    }

    public static <V extends VisualVertex, E extends VisualEdge<V>> boolean layoutUsesEdgeArticulations(Layout<V, E> graphLayout) {
        VisualGraphLayout<V, E> layout = GraphViewerUtils.getVisualGraphLayout(graphLayout);
        if (layout == null) {
            return false;
        }
        return layout.usesEdgeArticulations();
    }

    public static <V extends VisualVertex, E extends VisualEdge<V>> VisualGraphLayout<V, E> getVisualGraphLayout(Layout<V, E> graphLayout) {
        Layout layout = graphLayout;
        while (layout instanceof LayoutDecorator) {
            layout = ((LayoutDecorator)layout).getDelegate();
        }
        if (!(layout instanceof VisualGraphLayout)) {
            return null;
        }
        return (VisualGraphLayout)layout;
    }

    public static <V extends VisualVertex, E extends VisualEdge<V>> Collection<V> getVerticesOfHoveredEdges(Graph<V, E> graph) {
        return GraphViewerUtils.getVerticesOfSelectedOrHoveredEdges(graph, true);
    }

    public static <V extends VisualVertex, E extends VisualEdge<V>> Collection<V> getVerticesOfSelectedEdges(Graph<V, E> graph) {
        return GraphViewerUtils.getVerticesOfSelectedOrHoveredEdges(graph, false);
    }

    private static <V extends VisualVertex, E extends VisualEdge<V>> Collection<V> getVerticesOfSelectedOrHoveredEdges(Graph<V, E> graph, boolean useHover) {
        LinkedList result = new LinkedList();
        Collection edges = graph.getEdges();
        LinkedList<VisualEdge> filteredEdges = new LinkedList<VisualEdge>();
        if (useHover) {
            for (VisualEdge edge : edges) {
                if (!edge.isInHoveredVertexPath()) continue;
                filteredEdges.add(edge);
            }
        } else {
            for (VisualEdge edge : edges) {
                if (!edge.isSelected()) continue;
                filteredEdges.add(edge);
            }
        }
        Set vertices = GraphAlgorithms.toVertices(filteredEdges);
        result.addAll(vertices);
        return result;
    }
}

