/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class SwiftNativeDemangler {
    private String nativeDemanglerPath;
    private boolean standaloneDemanglerBinary;

    public SwiftNativeDemangler(File swiftDir) throws IOException {
        List<String> demanglerNames = List.of("swift-demangle", "swift");
        IOException ioe = null;
        Iterator<String> iterator = demanglerNames.iterator();
        while (iterator.hasNext()) {
            String demanglerName;
            this.nativeDemanglerPath = demanglerName = iterator.next();
            if (swiftDir != null) {
                this.nativeDemanglerPath = String.valueOf(swiftDir) + File.separator + this.nativeDemanglerPath;
            }
            try {
                int exitCode = new ProcessBuilder(List.of(this.nativeDemanglerPath, "--version")).start().waitFor();
                if (exitCode == 0) {
                    ioe = null;
                    this.standaloneDemanglerBinary = new File(this.nativeDemanglerPath).getName().contains("-demangle");
                    break;
                }
                ioe = new IOException("Native Swift demangler exited with code: " + exitCode);
            }
            catch (IOException e) {
                ioe = e;
            }
            catch (InterruptedException e) {
                ioe = new IOException(e);
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public SwiftNativeDemangledOutput demangle(String mangled) throws IOException {
        ArrayList<String> demanglerArgs = new ArrayList<String>();
        demanglerArgs.add("--compact");
        demanglerArgs.add("--expand");
        try (BufferedReader reader = this.demangle(mangled, demanglerArgs);){
            String demangled = null;
            ArrayList<String> treeLines = new ArrayList<String>();
            String line = reader.readLine().trim();
            if (!line.startsWith("Demangling for")) {
                throw new IOException("Unexpected output: " + line);
            }
            while ((line = reader.readLine()) != null && !line.startsWith("<<NULL>>")) {
                if (line.isBlank() || treeLines.isEmpty() && !line.trim().startsWith("kind")) continue;
                if (!treeLines.isEmpty() && !line.startsWith(" ")) {
                    demangled = line;
                    break;
                }
                treeLines.add(line);
            }
            SwiftNativeDemangledOutput swiftNativeDemangledOutput = new SwiftNativeDemangledOutput(demangled, treeLines);
            return swiftNativeDemangledOutput;
        }
    }

    private BufferedReader demangle(String mangled, List<String> options) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.nativeDemanglerPath);
        if (!this.standaloneDemanglerBinary) {
            command.add("demangle");
        }
        command.addAll(options);
        command.add(mangled);
        Process p = new ProcessBuilder(command).redirectErrorStream(true).start();
        return new BufferedReader(new InputStreamReader(p.getInputStream()));
    }

    public record SwiftNativeDemangledOutput(String demangled, List<String> tree) {
        @Override
        public String toString() {
            return "%s\n%s".formatted(this.demangled != null ? this.demangled : "<NULL>", this.tree.stream().collect(Collectors.joining("\n")));
        }
    }
}

