/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.debug.DataSym32;
import ghidra.app.util.bin.format.pe.debug.DataSym32_new;
import ghidra.app.util.bin.format.pe.debug.DebugSymbol;
import ghidra.app.util.bin.format.pe.debug.S_ALIGN;
import ghidra.app.util.bin.format.pe.debug.S_BLOCK32;
import ghidra.app.util.bin.format.pe.debug.S_BPREL32_NEW;
import ghidra.app.util.bin.format.pe.debug.S_COMPILE;
import ghidra.app.util.bin.format.pe.debug.S_CONSTANT32;
import ghidra.app.util.bin.format.pe.debug.S_DATAREF;
import ghidra.app.util.bin.format.pe.debug.S_END;
import ghidra.app.util.bin.format.pe.debug.S_GDATA32_NEW;
import ghidra.app.util.bin.format.pe.debug.S_GPROC32_NEW;
import ghidra.app.util.bin.format.pe.debug.S_LABEL32;
import ghidra.app.util.bin.format.pe.debug.S_LDATA32_NEW;
import ghidra.app.util.bin.format.pe.debug.S_OBJNAME;
import ghidra.app.util.bin.format.pe.debug.S_PROCREF;
import ghidra.app.util.bin.format.pe.debug.S_UDT32_NEW;
import ghidra.app.util.bin.format.pe.debug.UnknownSymbol;
import java.io.IOException;

public class DebugSymbolSelector {
    public static DebugSymbol selectSymbol(BinaryReader reader, int ptr) throws IOException {
        short length = reader.readShort(ptr);
        short type = reader.readShort(ptr += 2);
        ptr += 2;
        if (length == 0 || type < 0) {
            return null;
        }
        switch (type) {
            case 513: 
            case 514: 
            case 515: {
                return new DataSym32(length, type, reader, ptr);
            }
            case 4105: {
                return new DataSym32_new(length, type, reader, ptr);
            }
            case 1024: 
            case 1027: {
                return new S_PROCREF(length, type, reader, ptr);
            }
            case 1025: {
                return new S_DATAREF(length, type, reader, ptr);
            }
            case 1026: {
                return new S_ALIGN(length, type, reader, ptr);
            }
            case 4099: {
                return new S_UDT32_NEW(length, type, reader, ptr);
            }
            case 4103: {
                return new S_LDATA32_NEW(length, type, reader, ptr);
            }
            case 4106: 
            case 4107: {
                return new S_GPROC32_NEW(length, type, reader, ptr);
            }
            case 4102: {
                return new S_BPREL32_NEW(length, type, reader, ptr);
            }
            case 6: {
                return new S_END(length, type, reader, ptr);
            }
            case 519: {
                return new S_BLOCK32(length, type);
            }
            case 1: {
                return new S_COMPILE(length, type);
            }
            case 9: {
                return new S_OBJNAME(length, type, reader, ptr);
            }
            case 4098: {
                return new S_CONSTANT32(length, type, reader, ptr);
            }
            case 4104: {
                return new S_GDATA32_NEW(length, type, reader, ptr);
            }
            case 521: {
                return new S_LABEL32(length, type, reader, ptr);
            }
        }
        return new UnknownSymbol(length, type, reader, ptr);
    }
}

