/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.program.database.mem.FileBytes;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class FileBytesProvider
implements ByteProvider {
    private final FileBytes fileBytes;

    public FileBytesProvider(FileBytes fileBytes) {
        this.fileBytes = fileBytes;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getName() {
        return this.fileBytes.getFilename();
    }

    @Override
    public String getAbsolutePath() {
        return null;
    }

    @Override
    public long length() {
        return this.fileBytes.getSize();
    }

    @Override
    public boolean isValidIndex(long index) {
        return 0L <= index && index < this.length();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public byte readByte(long index) throws IOException {
        try {
            return this.fileBytes.getOriginalByte(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("unsupported length");
        }
        if (index < 0L) {
            throw new IllegalArgumentException("invalid index");
        }
        long len = this.length();
        long lastIndex = index + length - 1L;
        if (index >= len || lastIndex >= this.length()) {
            throw new EOFException();
        }
        byte[] bytes = new byte[(int)length];
        try {
            this.fileBytes.getOriginalBytes(index, bytes);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
        return bytes;
    }

    @Override
    public InputStream getInputStream(long index) throws IOException {
        if (index < 0L) {
            throw new IllegalArgumentException("invalid index");
        }
        if (index >= this.length()) {
            throw new EOFException();
        }
        return new FileBytesProviderInputStream(index);
    }

    private class FileBytesProviderInputStream
    extends InputStream {
        private long initialOffset;
        private long offset;

        FileBytesProviderInputStream(long offset) {
            if (offset < 0L) {
                throw new IllegalArgumentException("Negative offset: " + offset);
            }
            this.offset = offset;
            this.initialOffset = offset;
        }

        @Override
        public int read() throws IOException {
            if (this.offset >= FileBytesProvider.this.length()) {
                return -1;
            }
            byte b = FileBytesProvider.this.readByte(this.offset);
            ++this.offset;
            return b & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (off < 0 || off >= b.length) {
                throw new IllegalArgumentException("Array index out of range: " + off);
            }
            long fileBytesLen = FileBytesProvider.this.length();
            if (this.offset >= fileBytesLen) {
                return -1;
            }
            long limit = fileBytesLen - this.offset;
            if ((long)len > limit) {
                len = (int)limit;
            }
            byte[] bytes = new byte[len];
            int count = FileBytesProvider.this.fileBytes.getOriginalBytes(this.offset, bytes);
            System.arraycopy(bytes, 0, b, off, count);
            this.offset += (long)count;
            return count;
        }

        @Override
        public int available() {
            long avail = FileBytesProvider.this.length() - this.offset;
            return avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.offset = this.initialOffset;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

