/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import java.io.Serializable;

class Mark
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int START = 1;
    static final int END = 2;
    static final int SINGLE = 3;
    private static final Object[] emptyArray = new Object[0];
    Object obj;
    int type;

    Mark(Object obj, int type) {
        this.obj = obj;
        this.type = type;
    }

    void add(Object addObj) {
        Object[] bigArr;
        if (this.contains(addObj)) {
            return;
        }
        if (this.obj instanceof Object[]) {
            Object[] extArr = (Object[])this.obj;
            bigArr = new Object[extArr.length + 1];
            System.arraycopy(extArr, 0, bigArr, 0, extArr.length);
            bigArr[extArr.length] = addObj;
        } else {
            bigArr = new Object[]{this.obj, addObj};
        }
        this.obj = bigArr;
    }

    boolean contains(Object testObj) {
        if (this.obj == null) {
            return false;
        }
        if (this.obj.equals(testObj)) {
            return true;
        }
        if (this.obj instanceof Object[]) {
            Object[] objArray = (Object[])this.obj;
            for (int i = 0; i < objArray.length; ++i) {
                if (!objArray[i].equals(testObj)) continue;
                return true;
            }
        }
        return false;
    }

    boolean containsSameObjects(Mark mark) {
        if (this.obj == mark) {
            return true;
        }
        if (this.obj == null || mark.obj == null) {
            return false;
        }
        if (this.obj.equals(mark.obj)) {
            return true;
        }
        if (this.obj instanceof Object[] && mark.obj instanceof Object[]) {
            Object[] array1 = (Object[])this.obj;
            Object[] array2 = (Object[])mark.obj;
            if (array1.length == array2.length) {
                for (int i = 0; i < array1.length; ++i) {
                    if (array1[i].equals(array2[i])) continue;
                    return false;
                }
                return true;
            }
        } else {
            if (this.obj instanceof Object[]) {
                Object[] array = (Object[])this.obj;
                return array.length == 1 && array[0].equals(mark.obj);
            }
            if (mark.obj instanceof Object[]) {
                Object[] array = (Object[])mark.obj;
                return array.length == 1 && array[0].equals(this.obj);
            }
        }
        return false;
    }

    boolean isEmpty() {
        if (this.obj == null) {
            return true;
        }
        return this.obj instanceof Object[] && ((Object[])this.obj).length == 0;
    }

    void remove(Object removeObj) {
        if (this.obj == null) {
            return;
        }
        if (this.obj.equals(removeObj)) {
            this.obj = null;
            return;
        }
        if (this.obj instanceof Object[]) {
            Object[] objArray = (Object[])this.obj;
            for (int i = 0; i < objArray.length; ++i) {
                if (!objArray[i].equals(removeObj)) continue;
                Object[] newArray = new Object[objArray.length - 1];
                int pos = 0;
                for (int j = 0; j < objArray.length; ++j) {
                    if (j == i) continue;
                    newArray[pos++] = objArray[j];
                }
                this.obj = newArray;
            }
        }
    }

    Object[] getObj() {
        if (this.obj instanceof Object[]) {
            return (Object[])this.obj;
        }
        if (this.obj == null) {
            return emptyArray;
        }
        Object[] objarray = new Object[]{this.obj};
        return objarray;
    }
}

