/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.csjc.structelements;

import org.catacombae.csjc.structelements.FieldType;
import org.catacombae.csjc.structelements.StringRepresentableField;

public class ASCIIStringField
extends StringRepresentableField {
    private final byte[] fieldData;

    public ASCIIStringField(byte[] fieldData) {
        super("Char[" + fieldData.length + "]", FieldType.ASCIISTRING);
        this.fieldData = fieldData;
    }

    public String validateStringValue(String s) {
        char[] sArray = s.toCharArray();
        byte[] asciiArray = new byte[sArray.length];
        for (int i = 0; i < asciiArray.length; ++i) {
            char curChar = sArray[i];
            if (curChar < '\u0000' || curChar > '\u007f') {
                return "Invalid ASCII character at position " + i;
            }
            asciiArray[i] = (byte)curChar;
        }
        return this.validate(asciiArray);
    }

    private String validate(byte[] data) {
        if (data.length != this.fieldData.length) {
            return "Invalid length for string. Was: " + data.length + " Should be: " + this.fieldData.length;
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] >= 0 && data[i] <= 127) continue;
            return "Invalid ASCII character at position " + i;
        }
        return null;
    }

    public String getValueAsString() {
        int[] codepoints = new int[this.fieldData.length];
        for (int i = 0; i < codepoints.length; ++i) {
            int cp = this.fieldData[i] & 0x7F;
            if (cp != this.fieldData[i]) {
                cp = 63;
            }
            codepoints[i] = cp;
        }
        return new String(codepoints, 0, codepoints.length);
    }

    public void setStringValue(String value) throws IllegalArgumentException {
        byte[] asciiChars;
        String validateMsg = this.validateStringValue(value);
        if (validateMsg == null) {
            char[] valueArray = value.toCharArray();
            if (valueArray.length != this.fieldData.length) {
                throw new RuntimeException("You should not see this.");
            }
            asciiChars = new byte[this.fieldData.length];
            for (int i = 0; i < asciiChars.length; ++i) {
                asciiChars[i] = (byte)(valueArray[i] & 0x7F);
            }
        } else {
            throw new IllegalArgumentException("Invalid string value! Message: " + validateMsg);
        }
        System.arraycopy(asciiChars, 0, this.fieldData, 0, this.fieldData.length);
    }
}

