/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.memory.ChatMemory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLEditorKit;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.SetBooleanPropertyAction;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IFreeplaneAction;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.JAutoCheckBoxMenuItem;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.html.ScaledEditorKit;
import org.freeplane.core.ui.textchanger.TranslatedElement;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.text.TextController;
import org.freeplane.plugin.ai.chat.AIChatMessageStyleSettings;
import org.freeplane.plugin.ai.chat.AIChatService;
import org.freeplane.plugin.ai.chat.AIChatServiceFactory;
import org.freeplane.plugin.ai.chat.AIModelCatalog;
import org.freeplane.plugin.ai.chat.AIModelSelection;
import org.freeplane.plugin.ai.chat.AIModelSelectionController;
import org.freeplane.plugin.ai.chat.AIProviderConfiguration;
import org.freeplane.plugin.ai.chat.AssistantProfileChatMemory;
import org.freeplane.plugin.ai.chat.AssistantProfilePaneBuilder;
import org.freeplane.plugin.ai.chat.AssistantProfileSelectionModel;
import org.freeplane.plugin.ai.chat.AssistantProfileSelectionSync;
import org.freeplane.plugin.ai.chat.ChatDisplaySettings;
import org.freeplane.plugin.ai.chat.ChatHistoryHyperlinkHandler;
import org.freeplane.plugin.ai.chat.ChatMemoryHistoryRenderer;
import org.freeplane.plugin.ai.chat.ChatMemoryRenderEntry;
import org.freeplane.plugin.ai.chat.ChatMemorySettings;
import org.freeplane.plugin.ai.chat.ChatMessageHistory;
import org.freeplane.plugin.ai.chat.ChatMessageRenderer;
import org.freeplane.plugin.ai.chat.ChatMessageStyleApplier;
import org.freeplane.plugin.ai.chat.ChatMessageTransferHandler;
import org.freeplane.plugin.ai.chat.ChatRequestFlow;
import org.freeplane.plugin.ai.chat.ChatTokenCounterMode;
import org.freeplane.plugin.ai.chat.ChatTokenCounterSettings;
import org.freeplane.plugin.ai.chat.ChatTokenUsageTracker;
import org.freeplane.plugin.ai.chat.ChatUsageTotals;
import org.freeplane.plugin.ai.chat.LiveChatController;
import org.freeplane.plugin.ai.maps.AvailableMaps;
import org.freeplane.plugin.ai.maps.ControllerMapModelProvider;
import org.freeplane.plugin.ai.tools.AIToolSetBuilder;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummaryHandler;

public class AIChatPanel
extends JPanel {
    private static final int TOP_BAR_HORIZONTAL_GAP = 2;
    private static final long serialVersionUID = 1L;
    private final JEditorPane messageHistoryPane;
    private final HTMLEditorKit messageHistoryEditorKit;
    private final JScrollPane scrollPane;
    private final JTextArea inputArea;
    private final JButton undoButton;
    private final JButton redoButton;
    private final JButton sendButton;
    private final Icon sendIcon;
    private final Icon stopIcon;
    private final Icon preferencesIcon;
    private final Icon assistantProfileIcon;
    private String sendTooltipText;
    private String cancelTooltipText;
    private String undoTooltipText;
    private String redoTooltipText;
    private String preferencesTooltipText;
    private String noProviderConfiguredText;
    private AIChatService chatService;
    private final JPopupMenu menuPopup;
    private final AIProviderConfiguration configuration;
    private final ChatDisplaySettings chatDisplaySettings;
    private final AIModelSelectionController modelSelectionController;
    private ChatMemory chatMemory;
    private final ChatTokenUsageTracker chatTokenUsageTracker;
    private final JLabel tokenUsageLabel;
    private final ChatMessageRenderer messageRenderer;
    private final ChatMessageHistory messageHistory;
    private final ChatMemoryHistoryRenderer chatMemoryHistoryRenderer;
    private final AvailableMaps availableMaps;
    private final DateTimeFormatter chatNameFormatter;
    private final LiveChatController liveChatController;
    private final ChatRequestFlow chatRequestFlow;
    private final AssistantProfileSelectionSync assistantProfileSelectionSync;
    private final AssistantProfilePaneBuilder assistantProfilePaneBuilder;

    public AIChatPanel() {
        this.setLayout(new BorderLayout());
        this.messageHistoryPane = new JEditorPane();
        this.messageHistoryPane.setContentType("text/html");
        this.messageHistoryEditorKit = ScaledEditorKit.create();
        this.messageHistoryPane.setEditorKit(this.messageHistoryEditorKit);
        this.messageHistoryPane.setEditable(false);
        this.messageHistoryPane.setOpaque(true);
        this.messageHistoryPane.setBackground(Color.WHITE);
        this.inputArea = new JTextArea(3, 20);
        this.inputArea.setLineWrap(true);
        this.inputArea.setWrapStyleWord(true);
        this.applyChatMessageStyles();
        this.resetMessageHistory();
        this.messageHistory = new ChatMessageHistory(this.messageHistoryPane, this.messageHistoryEditorKit);
        this.messageHistoryPane.setTransferHandler(new ChatMessageTransferHandler(this.messageHistoryPane, this.messageHistory));
        this.messageHistoryPane.setDragEnabled(true);
        this.messageHistoryPane.addHyperlinkListener(new ChatHistoryHyperlinkHandler(ChatHistoryHyperlinkHandler.defaultLinkControllerAdapter()).createListener());
        this.configureEmptyHistoryFocusTransfer();
        this.scrollPane = new JScrollPane(this.messageHistoryPane);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.undoButton = new JButton("\u21b6");
        this.redoButton = new JButton("\u21b7");
        this.sendButton = new JButton();
        this.sendButton.setIcon(ResourceController.getResourceController().getImageIcon("/images/ai_send_arrow_up.svg?useAccentColor=true"));
        this.sendIcon = this.sendButton.getIcon();
        this.stopIcon = ResourceController.getResourceController().getImageIcon("/images/ai_stop.svg?useAccentColor=true");
        this.preferencesIcon = ResourceController.getResourceController().getImageIcon("/images/generic_settings.svg?useAccentColor=true");
        this.assistantProfileIcon = ResourceController.getResourceController().getImageIcon("/images/EggheadCB.svg?useAccentColor=true");
        Dimension sendButtonSize = this.sendButton.getPreferredSize();
        Dimension sideButtonSize = new Dimension(sendButtonSize.width, Math.max(1, sendButtonSize.height / 2));
        Dimension tallSendButtonSize = new Dimension(sendButtonSize.width, sideButtonSize.height * 2);
        this.sendButton.setPreferredSize(tallSendButtonSize);
        this.sendButton.setMinimumSize(tallSendButtonSize);
        this.sendButton.setMaximumSize(tallSendButtonSize);
        this.undoButton.setPreferredSize(sideButtonSize);
        this.undoButton.setMinimumSize(sideButtonSize);
        this.undoButton.setMaximumSize(sideButtonSize);
        this.redoButton.setPreferredSize(sideButtonSize);
        this.redoButton.setMinimumSize(sideButtonSize);
        this.redoButton.setMaximumSize(sideButtonSize);
        this.menuPopup = this.buildMenuPopup();
        this.configuration = new AIProviderConfiguration();
        this.chatDisplaySettings = new ChatDisplaySettings();
        this.modelSelectionController = new AIModelSelectionController(this.configuration, new AIModelCatalog(this.configuration));
        this.modelSelectionController.setModelSelectionChangeListener(modelDescriptor -> {
            this.chatService = null;
        });
        AssistantProfileSelectionModel assistantProfileSelectionModel = new AssistantProfileSelectionModel();
        this.chatMemory = this.createChatMemory();
        this.tokenUsageLabel = new JLabel();
        this.tokenUsageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        this.chatTokenUsageTracker = new ChatTokenUsageTracker(this::updateTokenUsageLabel);
        this.messageRenderer = new ChatMessageRenderer();
        this.chatMemoryHistoryRenderer = new ChatMemoryHistoryRenderer(this.messageHistory, this.messageRenderer);
        this.availableMaps = new AvailableMaps(new ControllerMapModelProvider());
        this.chatNameFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        this.liveChatController = new LiveChatController(this, this.availableMaps, this.requireTextController(), this.chatNameFormatter, this::activateSession, this.chatTokenUsageTracker::snapshotState);
        this.assistantProfileSelectionSync = new AssistantProfileSelectionSync(assistantProfileSelectionModel, this.liveChatController);
        this.assistantProfileSelectionSync.setChatMemory(this.chatMemory);
        this.assistantProfileSelectionSync.setProfileMessageConsumer(this::appendProfileMessage);
        this.assistantProfilePaneBuilder = new AssistantProfilePaneBuilder(assistantProfileSelectionModel, this.assistantProfileSelectionSync, this.assistantProfileIcon);
        this.chatRequestFlow = new ChatRequestFlow(new ChatRequestFlow.RequestCallbacks(){

            @Override
            public void onRequestStarted() {
                AIChatPanel.this.inputArea.setEditable(false);
                AIChatPanel.this.setSendButtonStopState();
                AIChatPanel.this.updateUndoRedoButtonState();
            }

            @Override
            public void onRequestFinished() {
                AIChatPanel.this.liveChatController.synchronizeTranscriptWithMemory();
                AIChatPanel.this.updateInputState();
            }

            @Override
            public void onUserTextRestored(String userText) {
                AIChatPanel.this.inputArea.setText(userText == null ? "" : userText);
                AIChatPanel.this.inputArea.setCaretPosition(AIChatPanel.this.inputArea.getText().length());
            }

            @Override
            public void onRequestFailed(String userText, String errorMessage) {
                AIChatPanel.this.appendFailureMessages(userText, errorMessage);
            }

            @Override
            public void onAssistantResponse(String text) {
                AIChatPanel.this.appendChatMessage(text, ChatMessageCategory.ASSISTANT);
                this.refreshTokenCounters();
            }

            @Override
            public void onAssistantError(String text) {
            }

            @Override
            public int snapshotMemorySize() {
                return AIChatPanel.this.getMemorySize();
            }

            @Override
            public void truncateMemoryToSize(int size) {
                AIChatPanel.this.truncateMemoryToSize(size);
            }

            @Override
            public void synchronizeTranscriptWithMemory() {
                AIChatPanel.this.liveChatController.synchronizeTranscriptWithMemory();
            }

            @Override
            public void rebuildHistoryFromTranscript() {
                AIChatPanel.this.rebuildHistoryFromMemory();
            }

            @Override
            public boolean evictOldestTurn() {
                AssistantProfileChatMemory memory = AIChatPanel.this.activeAssistantProfileChatMemory();
                return memory != null && memory.evictOldestTurn();
            }

            @Override
            public void onPostResponseEviction() {
                AIChatPanel.this.liveChatController.synchronizeTranscriptWithMemory();
                AIChatPanel.this.rebuildHistoryFromMemory();
                AIChatPanel.this.updateInputState();
            }

            @Override
            public void refreshTokenCounters() {
                AIChatPanel.this.refreshTokenCounters();
            }

            @Override
            public boolean isToolCallHistoryVisible() {
                return AIChatPanel.this.chatDisplaySettings.isToolCallHistoryVisible();
            }

            @Override
            public void onToolSummaryAppended(ChatMemoryRenderEntry entry) {
                AIChatPanel.this.appendHistoryEntry(entry);
            }
        }, this.chatTokenUsageTracker);
        this.chatRequestFlow.updateChatMemory(this.activeAssistantProfileChatMemory());
        this.liveChatController.initialize(this.chatMemory);
        this.assistantProfilePaneBuilder.initialize();
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.add((Component)new JScrollPane(this.inputArea), "Center");
        JPanel actionButtonsPanel = new JPanel(new BorderLayout(4, 0));
        JPanel undoRedoPanel = new JPanel(new GridLayout(2, 1, 0, 2));
        undoRedoPanel.add(this.undoButton);
        undoRedoPanel.add(this.redoButton);
        actionButtonsPanel.add((Component)this.sendButton, "West");
        actionButtonsPanel.add((Component)undoRedoPanel, "East");
        inputPanel.add((Component)actionButtonsPanel, "East");
        JPanel inputContainer = new JPanel(new BorderLayout());
        inputContainer.add((Component)this.assistantProfilePaneBuilder.buildPanel(), "North");
        inputContainer.add((Component)inputPanel, "Center");
        JPanel tokenUsagePanel = new JPanel(new BorderLayout());
        tokenUsagePanel.add((Component)this.tokenUsageLabel, "East");
        inputContainer.add((Component)tokenUsagePanel, "South");
        JPanel topBarContainer = this.buildTopBarPanel();
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)inputContainer, "South");
        this.add((Component)topBarContainer, "North");
        this.sendButton.addActionListener(event -> {
            if (this.isRequestActive()) {
                this.cancelActiveRequest();
            } else if (!this.isProviderConfigured()) {
                this.openPreferences();
            } else {
                this.sendMessage();
            }
        });
        this.undoButton.addActionListener(event -> this.undoLastTurn());
        this.redoButton.addActionListener(event -> this.redoLastTurn());
        int shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        KeyStroke sendKeyStroke = KeyStroke.getKeyStroke(10, shortcutMask);
        KeyStroke undoKeyStroke = KeyStroke.getKeyStroke(38, shortcutMask);
        KeyStroke redoKeyStroke = KeyStroke.getKeyStroke(40, shortcutMask);
        this.sendTooltipText = TextUtils.format((String)"ai_chat_send.tooltip", (Object[])new Object[]{MenuUtils.formatKeyStroke((KeyStroke)sendKeyStroke)});
        KeyStroke cancelKeyStroke = KeyStroke.getKeyStroke(27, 0);
        this.cancelTooltipText = TextUtils.format((String)"ai_chat_cancel.tooltip", (Object[])new Object[]{MenuUtils.formatKeyStroke((KeyStroke)cancelKeyStroke)});
        this.undoTooltipText = TextUtils.getText((String)"simplyhtml.undoLabel") + " (" + MenuUtils.formatKeyStroke((KeyStroke)undoKeyStroke) + ")";
        this.redoTooltipText = TextUtils.getText((String)"simplyhtml.redoLabel") + " (" + MenuUtils.formatKeyStroke((KeyStroke)redoKeyStroke) + ")";
        this.preferencesTooltipText = TextUtils.getText((String)"preferences");
        this.noProviderConfiguredText = TextUtils.getText((String)"ai_chat_no_provider_configured");
        this.sendButton.setToolTipText(this.sendTooltipText);
        this.undoButton.setToolTipText(this.undoTooltipText);
        this.redoButton.setToolTipText(this.redoTooltipText);
        this.messageHistoryPane.getInputMap().put(KeyStroke.getKeyStroke(65, shortcutMask), "selectAllMessages");
        this.messageHistoryPane.getActionMap().put("selectAllMessages", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AIChatPanel.this.messageHistoryPane.selectAll();
            }
        });
        this.inputArea.getInputMap().put(sendKeyStroke, "sendMessage");
        this.inputArea.getInputMap().put(undoKeyStroke, "undoTurn");
        this.inputArea.getInputMap().put(redoKeyStroke, "redoTurn");
        this.inputArea.getActionMap().put("sendMessage", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (AIChatPanel.this.isRequestActive()) {
                    AIChatPanel.this.cancelActiveRequest();
                } else {
                    if (!AIChatPanel.this.isProviderConfigured()) {
                        return;
                    }
                    AIChatPanel.this.sendMessage();
                }
            }
        });
        inputContainer.getInputMap(1).put(cancelKeyStroke, "cancelRequest");
        inputContainer.getInputMap(1).put(undoKeyStroke, "undoTurn");
        inputContainer.getInputMap(1).put(redoKeyStroke, "redoTurn");
        inputContainer.getActionMap().put("cancelRequest", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AIChatPanel.this.cancelActiveRequest();
            }
        });
        inputContainer.getActionMap().put("undoTurn", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AIChatPanel.this.undoLastTurn();
            }
        });
        inputContainer.getActionMap().put("redoTurn", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AIChatPanel.this.redoLastTurn();
            }
        });
        this.modelSelectionController.loadInitialModelSelectionList();
        this.registerProviderConfigurationListener();
        this.registerModelSelectionRefreshListener();
        this.registerTokenCounterModeListener();
        this.registerChatFontScalingListener();
        this.refreshTokenCounterMode();
        this.updateInputState();
    }

    private JPanel buildTopBarPanel() {
        JPanel topBar = new JPanel(new BorderLayout(2, 0));
        JButton menuButton = new JButton("\u2261");
        TranslatedElementFactory.createTooltip((JComponent)menuButton, (String)"preferences");
        menuButton.addActionListener(event -> this.menuPopup.show(menuButton, 0, menuButton.getHeight()));
        topBar.add((Component)menuButton, "West");
        topBar.add(this.modelSelectionController.getModelSelectionComboBox(), "Center");
        JPanel rightButtons = new JPanel(new FlowLayout(0, 2, 0));
        String historyIconPath = "/images/ai_history.svg?useAccentColor=true";
        JButton chatsButton = TranslatedElementFactory.createButtonWithIcon((String)historyIconPath, (String)"ai_chat_chats");
        chatsButton.addActionListener(event -> {
            this.cancelActiveRequest();
            this.liveChatController.openLiveChats();
        });
        rightButtons.add(chatsButton);
        String clearIconPath = "/images/ai_new_chat.svg?useAccentColor=true";
        JButton newChatButton = TranslatedElementFactory.createButtonWithIcon((String)clearIconPath, (String)"ai_chat_new_chat");
        newChatButton.addActionListener(event -> {
            this.cancelActiveRequest();
            this.liveChatController.startNewChat();
        });
        rightButtons.add(newChatButton);
        topBar.add((Component)rightButtons, "East");
        return topBar;
    }

    private JPopupMenu buildMenuPopup() {
        JPopupMenu menuPopup = new JPopupMenu();
        AbstractAction openPreferencesAction = new AbstractAction("Preferences"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AIChatPanel.this.openPreferences();
            }
        };
        JMenuItem preferencesMenuItem = TranslatedElementFactory.createMenuItem((Action)openPreferencesAction, (String)"preferences");
        preferencesMenuItem.setIcon(this.preferencesIcon);
        menuPopup.add(preferencesMenuItem);
        AbstractAction manageProfilesAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                AIChatPanel.this.assistantProfilePaneBuilder.openAssistantProfileManager();
            }
        };
        JMenuItem manageProfilesMenuItem = TranslatedElementFactory.createMenuItem((Action)manageProfilesAction, (String)"ai_chat_manage_profiles");
        manageProfilesMenuItem.setIcon(this.assistantProfileIcon);
        menuPopup.add(manageProfilesMenuItem);
        this.addAiEditsMenuItems(menuPopup);
        return menuPopup;
    }

    private void addAiEditsMenuItems(JPopupMenu menuPopup) {
        if (Controller.getCurrentModeController() == null) {
            return;
        }
        AFreeplaneAction clearMapAction = Controller.getCurrentModeController().getAction("ClearAiMarkersInMapAction");
        AFreeplaneAction clearSelectionAction = Controller.getCurrentModeController().getAction("ClearAiMarkersInSelectionAction");
        AFreeplaneAction showIconAction = Controller.getCurrentModeController().getAction(SetBooleanPropertyAction.actionKey((String)"ai_edits_state_icon_visible"));
        if (clearMapAction == null && clearSelectionAction == null && showIconAction == null) {
            return;
        }
        menuPopup.addSeparator();
        this.addMenuItem(menuPopup, clearMapAction);
        this.addMenuItem(menuPopup, clearSelectionAction);
        this.addToggleMenuItem(menuPopup, showIconAction);
    }

    private void addMenuItem(JPopupMenu menuPopup, AFreeplaneAction action) {
        if (action == null) {
            return;
        }
        menuPopup.add(TranslatedElementFactory.createMenuItem((Action)action, (String)action.getTextKey()));
    }

    private void addToggleMenuItem(JPopupMenu menuPopup, AFreeplaneAction action) {
        if (action == null) {
            return;
        }
        String labelKey = action.getTextKey();
        JAutoCheckBoxMenuItem menuItem = new JAutoCheckBoxMenuItem((IFreeplaneAction)action);
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)menuItem, (String)TextUtils.getRawText((String)labelKey));
        TranslatedElement.TEXT.setKey((JComponent)menuItem, labelKey);
        TranslatedElementFactory.createTooltip((JComponent)menuItem, (String)action.getTooltipKey());
        menuPopup.add((JMenuItem)menuItem);
    }

    private void openPreferences() {
        Controller controller = Controller.getCurrentController();
        MModeController modeController = (MModeController)controller.getModeController("MindMap");
        modeController.showPreferences("plugins", "ai");
    }

    private void registerModelSelectionRefreshListener() {
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (!AIChatPanel.this.isModelSelectionRefreshProperty(propertyName)) {
                    return;
                }
                SwingUtilities.invokeLater(() -> AIChatPanel.this.modelSelectionController.loadInitialModelSelectionList());
            }
        });
    }

    private void registerProviderConfigurationListener() {
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (!AIChatPanel.this.isProviderConfigurationProperty(propertyName)) {
                    return;
                }
                SwingUtilities.invokeLater(() -> AIChatPanel.this.updateInputState());
            }
        });
    }

    private void registerTokenCounterModeListener() {
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (!"ai_chat_token_counter_mode".equals(propertyName)) {
                    return;
                }
                SwingUtilities.invokeLater(() -> AIChatPanel.this.refreshTokenCounterMode());
            }
        });
    }

    private void registerChatFontScalingListener() {
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (!"ai_chat_font_scaling".equals(propertyName)) {
                    return;
                }
                SwingUtilities.invokeLater(() -> AIChatPanel.this.refreshChatMessageStyles());
            }
        });
    }

    private void refreshChatMessageStyles() {
        this.applyChatMessageStyles();
        this.rebuildHistoryFromMemory();
    }

    private void applyChatMessageStyles() {
        AIChatMessageStyleSettings aiChatMessageStyleSettings = new AIChatMessageStyleSettings();
        Font font = this.inputArea.getFont();
        float baseFontSize = font != null ? font.getSize2D() / UITools.FONT_SCALE_FACTOR : 10.0f;
        new ChatMessageStyleApplier().apply(this.messageHistoryPane, this.messageHistoryEditorKit, baseFontSize, aiChatMessageStyleSettings.getChatFontScaling());
    }

    private boolean isModelSelectionRefreshProperty(String propertyName) {
        return "ai_openrouter_model_allowlist".equals(propertyName) || "ai_gemini_model_list".equals(propertyName) || "ai_ollama_model_allowlist".equals(propertyName) || "ai_provider_name".equals(propertyName) || "ai_model_name".equals(propertyName) || "ai_selected_model".equals(propertyName) || "ai_openrouter_key".equals(propertyName) || "ai_openrouter_service_address".equals(propertyName) || "ai_gemini_key".equals(propertyName) || "ai_gemini_service_address".equals(propertyName) || "ai_ollama_api_key".equals(propertyName) || "ai_ollama_service_address".equals(propertyName);
    }

    private boolean isProviderConfigurationProperty(String propertyName) {
        return "ai_openrouter_key".equals(propertyName) || "ai_gemini_key".equals(propertyName) || "ai_ollama_service_address".equals(propertyName);
    }

    private void sendMessage() {
        String userMessage = this.inputArea.getText().trim();
        if (userMessage.isEmpty()) {
            return;
        }
        this.chatRequestFlow.beginRequest(userMessage);
        this.assistantProfileSelectionSync.maybeInjectBeforeUserMessage();
        this.chatRequestFlow.captureChatSnapshot();
        this.appendChatMessage(userMessage, ChatMessageCategory.USER);
        this.chatRequestFlow.refreshTokenCounters();
        this.liveChatController.updateSessionNameFromFirstUserMessage(userMessage);
        this.inputArea.setText("");
        this.ensureChatService();
        if (this.chatService == null) {
            this.chatRequestFlow.restoreChatSnapshot();
            return;
        }
        this.chatRequestFlow.submitRequest(this.chatService);
    }

    private boolean isRequestActive() {
        return this.chatRequestFlow.isRequestActive();
    }

    private void cancelActiveRequest() {
        this.chatRequestFlow.cancelActiveRequest();
    }

    private AssistantProfileChatMemory activeAssistantProfileChatMemory() {
        if (this.chatMemory instanceof AssistantProfileChatMemory) {
            return (AssistantProfileChatMemory)this.chatMemory;
        }
        return null;
    }

    private void setSendButtonStopState() {
        this.sendButton.setText(null);
        this.sendButton.setIcon(this.stopIcon);
        this.sendButton.setToolTipText(this.cancelTooltipText);
    }

    private void setSendButtonSendState() {
        this.sendButton.setText(null);
        this.sendButton.setIcon(this.sendIcon);
        this.sendButton.setToolTipText(this.sendTooltipText);
    }

    private void setSendButtonPreferencesState() {
        this.sendButton.setText(null);
        this.sendButton.setIcon(this.preferencesIcon);
        this.sendButton.setToolTipText(this.preferencesTooltipText);
    }

    private void updateInputState() {
        if (this.isRequestActive()) {
            this.updateUndoRedoButtonState();
            return;
        }
        if (this.isProviderConfigured()) {
            this.setProviderReadyState();
        } else {
            this.setNoProviderState();
        }
        this.updateUndoRedoButtonState();
    }

    private void configureEmptyHistoryFocusTransfer() {
        this.messageHistoryPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                if (AIChatPanel.this.messageHistory.size() != 0) {
                    return;
                }
                SwingUtilities.invokeLater(AIChatPanel.this.inputArea::requestFocusInWindow);
            }
        });
    }

    private void setProviderReadyState() {
        this.inputArea.setEditable(true);
        if (this.noProviderConfiguredText != null && this.noProviderConfiguredText.equals(this.inputArea.getText())) {
            this.inputArea.setText("");
        }
        this.setSendButtonSendState();
    }

    private void setNoProviderState() {
        this.inputArea.setEditable(false);
        this.inputArea.setText(this.noProviderConfiguredText);
        this.inputArea.setCaretPosition(0);
        this.setSendButtonPreferencesState();
    }

    private boolean isProviderConfigured() {
        return this.isNonEmptyText(this.configuration.getOpenRouterKey()) || this.isNonEmptyText(this.configuration.getGeminiKey()) || this.configuration.hasOllamaServiceAddress();
    }

    private boolean isNonEmptyText(String value) {
        return value != null && !value.trim().isEmpty();
    }

    private void ensureChatService() {
        if (this.chatService != null) {
            return;
        }
        AIModelSelection selection = AIModelSelection.fromSelectionValue(this.configuration.getSelectedModelValue());
        if (selection == null) {
            this.appendChatMessage("Missing AI model selection.", ChatMessageCategory.ASSISTANT);
            return;
        }
        String providerName = selection.getProviderName();
        if ("openrouter".equalsIgnoreCase(providerName)) {
            if (this.configuration.getOpenRouterKey() == null || this.configuration.getOpenRouterKey().isEmpty()) {
                this.appendChatMessage("Missing OpenRouter key setting.", ChatMessageCategory.ASSISTANT);
                return;
            }
        } else if ("gemini".equalsIgnoreCase(providerName)) {
            if (this.configuration.getGeminiKey() == null || this.configuration.getGeminiKey().isEmpty()) {
                this.appendChatMessage("Missing Gemini key setting.", ChatMessageCategory.ASSISTANT);
                return;
            }
        } else if ("ollama".equalsIgnoreCase(providerName)) {
            if (!this.configuration.hasOllamaServiceAddress()) {
                this.appendChatMessage("Missing Ollama service address setting.", ChatMessageCategory.ASSISTANT);
                return;
            }
        } else {
            this.appendChatMessage("Unknown AI provider selection.", ChatMessageCategory.ASSISTANT);
            return;
        }
        this.chatService = AIChatServiceFactory.createService(new AIToolSetBuilder().toolCallSummaryHandler(this.chatRequestFlow::onToolCallSummary).availableMaps(this.availableMaps).mapAccessListener(this.liveChatController.mapAccessListener()).build(), this.chatMemory, this.chatTokenUsageTracker, this.chatRequestFlow::onToolCallSummary, this.chatRequestFlow.cancellationSupplier(), this.chatRequestFlow::onProviderUsage);
    }

    private void appendChatMessage(String text, ChatMessageCategory category) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.appendChatMessageInternal(text, category);
        } else {
            SwingUtilities.invokeLater(() -> this.appendChatMessageInternal(text, category));
        }
    }

    private void appendChatMessageInternal(String text, ChatMessageCategory category) {
        if (text == null || category == null) {
            return;
        }
        String messageText = this.messageRenderer.renderMessage(text, category == ChatMessageCategory.ASSISTANT);
        this.messageHistory.appendMessage(text, messageText, category.getStyleClassName());
        if (category == ChatMessageCategory.USER) {
            this.liveChatController.recordUserMessage(text);
        } else if (category == ChatMessageCategory.ASSISTANT) {
            this.liveChatController.recordAssistantMessage(text);
        }
    }

    private void appendProfileMessage(String profileName) {
        String normalizedName = profileName == null ? "" : profileName.trim();
        String messageText = normalizedName.isEmpty() ? TextUtils.getText((String)"ai_chat_profile_label") : TextUtils.format((String)"ai_chat_profile_message", (Object[])new Object[]{normalizedName});
        this.appendChatMessage(messageText, ChatMessageCategory.PROFILE);
    }

    private void appendFailureMessages(String userText, String errorMessage) {
        String normalizedUserMessage;
        String string = normalizedUserMessage = userText == null ? "" : userText.trim();
        if (!normalizedUserMessage.isEmpty()) {
            this.appendTransientMessage(normalizedUserMessage, ChatMessageCategory.SYSTEM, false);
        }
        String normalizedErrorMessage = errorMessage == null ? "" : errorMessage.trim();
        Object errorNotice = normalizedErrorMessage.isEmpty() ? "Request failed. Check model availability, account balance, or provider settings." : "Request failed: " + normalizedErrorMessage;
        this.appendFailureNotice((String)errorNotice);
    }

    private void appendTransientMessage(String sourceText, ChatMessageCategory category, boolean renderAsAssistant) {
        if (sourceText == null || category == null) {
            return;
        }
        String renderedText = this.messageRenderer.renderMessage(sourceText, renderAsAssistant);
        this.messageHistory.appendMessage(sourceText, renderedText, category.getStyleClassName());
    }

    private void appendFailureNotice(String sourceText) {
        if (sourceText == null) {
            return;
        }
        String renderedText = this.messageRenderer.renderFailureMessage(sourceText);
        this.messageHistory.appendMessage(sourceText, renderedText, ChatMessageCategory.ERROR.getStyleClassName());
    }

    public ToolCallSummaryHandler toolCallSummaryHandler() {
        return this.chatRequestFlow::onToolCallSummary;
    }

    public void persistCurrentChatIfNeeded() {
        this.liveChatController.persistCurrentSessionIfNeeded();
    }

    private void resetMessageHistory() {
        this.messageHistoryPane.setText("<html><body></body></html>");
        this.messageHistoryPane.setCaretPosition(0);
    }

    private void updateTokenUsageLabel(ChatUsageTotals totals) {
        SwingUtilities.invokeLater(() -> {
            this.tokenUsageLabel.setVisible(totals.isVisible());
            this.tokenUsageLabel.setText(totals.formatStatusLine());
        });
    }

    private void activateSession(ChatMemory sessionChatMemory, boolean fromTranscriptRestore) {
        this.chatMemory = sessionChatMemory;
        this.chatService = null;
        this.chatTokenUsageTracker.restoreState(this.liveChatController.getCurrentTokenUsageState());
        this.chatRequestFlow.updateChatMemory(this.activeAssistantProfileChatMemory());
        this.assistantProfileSelectionSync.setChatMemory(this.chatMemory);
        this.assistantProfilePaneBuilder.syncSelection(fromTranscriptRestore);
        this.chatRequestFlow.resetRequestState();
        this.rebuildHistoryFromMemory();
        this.refreshTokenCounters();
        this.updateInputState();
    }

    private void updateUndoRedoButtonState() {
        boolean enabled = !this.isRequestActive();
        this.undoButton.setEnabled(enabled && this.liveChatController.canUndo());
        this.redoButton.setEnabled(enabled && this.liveChatController.canRedo());
    }

    private void undoLastTurn() {
        if (this.isRequestActive()) {
            return;
        }
        boolean canUndo = this.liveChatController.canUndo();
        String userMessage = this.liveChatController.undoLastTurn();
        if (canUndo) {
            this.chatTokenUsageTracker.undoLastResponse();
        }
        if (!this.liveChatController.canRedo() && userMessage.isEmpty()) {
            this.updateUndoRedoButtonState();
            return;
        }
        this.rebuildHistoryFromMemory();
        this.refreshTokenCounters();
        this.inputArea.setText(userMessage);
        this.inputArea.setCaretPosition(this.inputArea.getText().length());
        this.updateInputState();
    }

    private void redoLastTurn() {
        if (this.isRequestActive()) {
            return;
        }
        if (!this.liveChatController.canRedo()) {
            this.updateUndoRedoButtonState();
            return;
        }
        this.liveChatController.redoLastTurn();
        this.chatTokenUsageTracker.redoLastResponse();
        this.rebuildHistoryFromMemory();
        this.refreshTokenCounters();
        this.inputArea.setText("");
        this.inputArea.setCaretPosition(0);
        this.updateInputState();
    }

    private int getMemorySize() {
        AssistantProfileChatMemory memory = this.activeAssistantProfileChatMemory();
        if (memory != null) {
            return memory.conversationMessageCount();
        }
        if (this.chatMemory == null) {
            return 0;
        }
        return this.chatMemory.messages().size();
    }

    private void truncateMemoryToSize(int size) {
        AssistantProfileChatMemory memory = this.activeAssistantProfileChatMemory();
        if (memory != null) {
            memory.truncateConversationMessagesTo(size);
            return;
        }
        if (this.chatMemory == null) {
            return;
        }
        List current = this.chatMemory.messages();
        int targetSize = Math.max(0, Math.min(size, current.size()));
        if (targetSize == current.size()) {
            return;
        }
        this.chatMemory.clear();
        for (int index = 0; index < targetSize; ++index) {
            ChatMessage message = (ChatMessage)current.get(index);
            if (message == null) continue;
            this.chatMemory.add(message);
        }
    }

    private void rebuildHistoryFromMemory() {
        this.chatMemoryHistoryRenderer.rebuildFromMessages(this.historyMessages());
    }

    private void appendHistoryEntry(ChatMemoryRenderEntry entry) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.chatMemoryHistoryRenderer.appendEntry(entry);
        } else {
            SwingUtilities.invokeLater(() -> this.chatMemoryHistoryRenderer.appendEntry(entry));
        }
    }

    private List<ChatMemoryRenderEntry> historyMessages() {
        AssistantProfileChatMemory memory = this.activeAssistantProfileChatMemory();
        if (memory != null) {
            return memory.panelConversationRenderEntries();
        }
        if (this.chatMemory == null) {
            return Collections.emptyList();
        }
        List messages = this.chatMemory.messages();
        ArrayList<ChatMemoryRenderEntry> entries = new ArrayList<ChatMemoryRenderEntry>();
        for (int index = 0; index < messages.size(); ++index) {
            entries.add(ChatMemoryRenderEntry.forMessage((ChatMessage)messages.get(index)));
        }
        return entries;
    }

    private ChatMemory createChatMemory() {
        ChatMemorySettings chatMemorySettings = new ChatMemorySettings();
        return AssistantProfileChatMemory.builder().dynamicMaxTokens(ignored -> chatMemorySettings.getMaximumTokenCount()).tokenEstimatorModelNameProvider(this::currentModelNameForTokenEstimator).build();
    }

    private void refreshTokenCounterMode() {
        ChatTokenCounterMode counterMode = new ChatTokenCounterSettings().getCounterMode();
        this.chatTokenUsageTracker.setCounterMode(counterMode, this.tokenCounterModeLabel(counterMode));
        this.refreshTokenCounters();
    }

    private String tokenCounterModeLabel(ChatTokenCounterMode counterMode) {
        if (counterMode == null) {
            return null;
        }
        String key = "OptionPanel.ai_chat_token_counter_mode." + counterMode.getPreferenceValue();
        return TextUtils.getOptionalText((String)key);
    }

    private void refreshTokenCounters() {
        this.chatTokenUsageTracker.refreshTotals(this.activeAssistantProfileChatMemory(), TextUtils.getOptionalText((String)"ai_chat_token_counter.input"), TextUtils.getOptionalText((String)"ai_chat_token_counter.output"));
    }

    private String currentModelNameForTokenEstimator() {
        AIModelSelection selection = AIModelSelection.fromSelectionValue(this.configuration.getSelectedModelValue());
        if (selection == null) {
            return null;
        }
        return selection.getModelName();
    }

    private TextController requireTextController() {
        ModeController modeController = Controller.getCurrentModeController();
        if (modeController == null) {
            throw new IllegalStateException("Current mode controller is not available.");
        }
        TextController textController = (TextController)modeController.getExtension(TextController.class);
        if (textController == null) {
            throw new IllegalStateException("Text controller is not available.");
        }
        return textController;
    }

    private static enum ChatMessageCategory {
        USER("message-user"),
        ASSISTANT("message-assistant"),
        TOOL_CALL("message-tool"),
        MCP_CALL("message-mcp-call"),
        PROFILE("message-profile"),
        ERROR("message-error"),
        SYSTEM("message-system");

        private final String styleClassName;

        private ChatMessageCategory(String styleClassName) {
            this.styleClassName = styleClassName;
        }

        String getStyleClassName() {
            return this.styleClassName;
        }
    }
}

