/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.commandsearch;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.IPropertyControlCreator;
import org.freeplane.core.resources.components.OptionPanelBuilder;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.commandsearch.PreferencesItem;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;

public class PreferencesIndexer {
    private final List<StructurePathEntry> path;
    private final List<PreferencesItem> prefs = new LinkedList<PreferencesItem>();

    public PreferencesIndexer() {
        this.path = new ArrayList<StructurePathEntry>(2);
        this.load();
    }

    public List<PreferencesItem> getPrefs() {
        return this.prefs;
    }

    private void load() {
        Controller controller = Controller.getCurrentController();
        MModeController modeController = (MModeController)controller.getModeController("MindMap");
        OptionPanelBuilder optionPanelBuilder = modeController.getOptionPanelBuilder();
        DefaultMutableTreeNode node = optionPanelBuilder.getRoot();
        this.load(node, 0);
    }

    public void load(TreeNode parent, int level) {
        Enumeration<? extends TreeNode> children = parent.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            IPropertyControlCreator userObject = (IPropertyControlCreator)child.getUserObject();
            if (userObject != null) {
                String propertyName = userObject.getPropertyName();
                String translatedText = HtmlUtils.htmlToPlain(userObject.getTranslatedText());
                if (!propertyName.isEmpty()) {
                    if (ResourceController.getResourceController().getBooleanProperty(propertyName + ".hide")) continue;
                    String tooltipText = HtmlUtils.htmlToPlain(userObject.getTranslatedTooltipText());
                    if (this.path.isEmpty()) continue;
                    StructurePathEntry currentTab = this.path.get(0);
                    String currentTabTranslated = currentTab.getLabel();
                    if (this.path.size() > 1) {
                        StructurePathEntry currentSeparator = this.path.get(1);
                        String currentSeparatorTranslated = currentSeparator.getLabel();
                        if (parent.getChildCount() < 20) {
                            String prefPath = currentSeparatorTranslated + "->" + translatedText;
                            this.prefs.add(new PreferencesItem(currentTab.getIdentifier(), currentTabTranslated, propertyName, prefPath, tooltipText));
                        } else {
                            this.prefs.add(new PreferencesItem(currentTab.getIdentifier(), currentTabTranslated, propertyName, translatedText, tooltipText));
                        }
                    } else {
                        this.prefs.add(new PreferencesItem(currentTab.getIdentifier(), currentTabTranslated, propertyName, translatedText, tooltipText));
                    }
                } else {
                    String structureIdentifier = userObject.getStructureIdentifier();
                    this.path.add(new StructurePathEntry(structureIdentifier, translatedText));
                }
                if (level < 2) {
                    this.load(child, level + 1);
                }
                if (!propertyName.isEmpty() || this.path.isEmpty()) continue;
                this.path.remove(this.path.size() - 1);
                continue;
            }
            this.load(child, level);
        }
    }

    private static /* synthetic */ String lambda$new$0(PreferencesItem x) {
        return x.getDisplayedText();
    }

    private static class StructurePathEntry {
        private final String identifier;
        private final String label;

        StructurePathEntry(String identifier, String label) {
            this.identifier = identifier;
            this.label = label != null ? label : identifier;
        }

        String getIdentifier() {
            return this.identifier;
        }

        String getLabel() {
            return this.label;
        }
    }
}

