/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;

@API(status=API.Status.STABLE, since="1.10")
public interface ResourceLock
extends AutoCloseable {
    public ResourceLock acquire() throws InterruptedException;

    public void release();

    @Override
    default public void close() {
        this.release();
    }

    public List<ExclusiveResource> getResources();

    public boolean isExclusive();

    default public boolean isCompatible(ResourceLock other) {
        boolean isGlobalReadLock;
        List<ExclusiveResource> ownResources = this.getResources();
        List<ExclusiveResource> otherResources = other.getResources();
        if (ownResources.isEmpty() || otherResources.isEmpty()) {
            return true;
        }
        boolean bl = isGlobalReadLock = ownResources.size() == 1 && ExclusiveResource.GLOBAL_READ.equals(ownResources.get(0));
        if (!isGlobalReadLock && other.isExclusive() || this.isExclusive()) {
            return false;
        }
        Optional<ExclusiveResource> potentiallyDeadlockCausingAdditionalResource = otherResources.stream().filter(resource -> !ownResources.contains(resource)).findFirst().filter(resource -> ExclusiveResource.COMPARATOR.compare((ExclusiveResource)resource, (ExclusiveResource)ownResources.get(ownResources.size() - 1)) < 0);
        return !potentiallyDeadlockCausingAdditionalResource.isPresent();
    }
}

