# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "billing profile reservation list",
)
class List(AAZCommand):
    """List the reservations for a billing profile and the roll up counts of reservations group by provisioning state.
    """

    _aaz_info = {
        "version": "2020-05-01",
        "resources": [
            ["mgmt-plane", "/providers/microsoft.billing/billingaccounts/{}/billingprofiles/{}/reservations", "2020-05-01"],
        ]
    }

    AZ_SUPPORT_PAGINATION = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_paging(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.billing_account_name = AAZStrArg(
            options=["--billing-account-name"],
            help="The ID that uniquely identifies a billing account.",
            required=True,
        )
        _args_schema.billing_profile_name = AAZStrArg(
            options=["--billing-profile-name"],
            help="The ID that uniquely identifies a billing profile.",
            required=True,
        )
        _args_schema.filter = AAZStrArg(
            options=["--filter"],
            help="May be used to filter by reservation properties. The filter supports 'eq', 'or', and 'and'. It does not currently support 'ne', 'gt', 'le', 'ge', or 'not'.",
        )
        _args_schema.orderby = AAZStrArg(
            options=["--orderby"],
            help="May be used to sort order by reservation properties.",
        )
        _args_schema.refresh_summary = AAZStrArg(
            options=["--refresh-summary"],
            help="To indicate whether to refresh the roll up counts of the reservations group by provisioning state",
        )
        _args_schema.selected_state = AAZStrArg(
            options=["--selected-state"],
            help="The selected provisioning state",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.ReservationsListByBillingProfile(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance.value, client_flatten=True)
        next_link = self.deserialize_output(self.ctx.vars.instance.next_link)
        return result, next_link

    class ReservationsListByBillingProfile(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/reservations",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "billingAccountName", self.ctx.args.billing_account_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "billingProfileName", self.ctx.args.billing_profile_name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "$filter", self.ctx.args.filter,
                ),
                **self.serialize_query_param(
                    "$orderby", self.ctx.args.orderby,
                ),
                **self.serialize_query_param(
                    "refreshSummary", self.ctx.args.refresh_summary,
                ),
                **self.serialize_query_param(
                    "selectedState", self.ctx.args.selected_state,
                ),
                **self.serialize_query_param(
                    "api-version", "2020-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
                flags={"read_only": True},
            )
            _schema_on_200.summary = AAZObjectType()
            _schema_on_200.value = AAZListType(
                flags={"read_only": True},
            )

            summary = cls._schema_on_200.summary
            summary.cancelled_count = AAZFloatType(
                serialized_name="cancelledCount",
                flags={"read_only": True},
            )
            summary.expired_count = AAZFloatType(
                serialized_name="expiredCount",
                flags={"read_only": True},
            )
            summary.expiring_count = AAZFloatType(
                serialized_name="expiringCount",
                flags={"read_only": True},
            )
            summary.failed_count = AAZFloatType(
                serialized_name="failedCount",
                flags={"read_only": True},
            )
            summary.pending_count = AAZFloatType(
                serialized_name="pendingCount",
                flags={"read_only": True},
            )
            summary.succeeded_count = AAZFloatType(
                serialized_name="succeededCount",
                flags={"read_only": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.location = AAZStrType(
                flags={"read_only": True},
            )
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.sku = AAZObjectType()
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.applied_scope_type = AAZStrType(
                serialized_name="appliedScopeType",
                flags={"read_only": True},
            )
            properties.applied_scopes = AAZListType(
                serialized_name="appliedScopes",
            )
            properties.display_name = AAZStrType(
                serialized_name="displayName",
                flags={"read_only": True},
            )
            properties.display_provisioning_state = AAZStrType(
                serialized_name="displayProvisioningState",
                flags={"read_only": True},
            )
            properties.effective_date_time = AAZStrType(
                serialized_name="effectiveDateTime",
                flags={"read_only": True},
            )
            properties.expiry_date = AAZStrType(
                serialized_name="expiryDate",
                flags={"read_only": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.provisioning_sub_state = AAZStrType(
                serialized_name="provisioningSubState",
                flags={"read_only": True},
            )
            properties.quantity = AAZFloatType(
                flags={"read_only": True},
            )
            properties.renew = AAZBoolType(
                flags={"read_only": True},
            )
            properties.renew_source = AAZStrType(
                serialized_name="renewSource",
                flags={"read_only": True},
            )
            properties.reserved_resource_type = AAZStrType(
                serialized_name="reservedResourceType",
                flags={"read_only": True},
            )
            properties.sku_description = AAZStrType(
                serialized_name="skuDescription",
                flags={"read_only": True},
            )
            properties.term = AAZStrType(
                flags={"read_only": True},
            )
            properties.user_friendly_applied_scope_type = AAZStrType(
                serialized_name="userFriendlyAppliedScopeType",
                flags={"read_only": True},
            )
            properties.user_friendly_renew_state = AAZStrType(
                serialized_name="userFriendlyRenewState",
                flags={"read_only": True},
            )
            properties.utilization = AAZObjectType(
                flags={"read_only": True},
            )

            applied_scopes = cls._schema_on_200.value.Element.properties.applied_scopes
            applied_scopes.Element = AAZStrType(
                flags={"read_only": True},
            )

            utilization = cls._schema_on_200.value.Element.properties.utilization
            utilization.aggregates = AAZListType()
            utilization.trend = AAZStrType(
                flags={"read_only": True},
            )

            aggregates = cls._schema_on_200.value.Element.properties.utilization.aggregates
            aggregates.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.utilization.aggregates.Element
            _element.grain = AAZFloatType(
                flags={"read_only": True},
            )
            _element.grain_unit = AAZStrType(
                serialized_name="grainUnit",
                flags={"read_only": True},
            )
            _element.value = AAZFloatType(
                flags={"read_only": True},
            )
            _element.value_unit = AAZStrType(
                serialized_name="valueUnit",
                flags={"read_only": True},
            )

            sku = cls._schema_on_200.value.Element.sku
            sku.name = AAZStrType(
                flags={"read_only": True},
            )

            return cls._schema_on_200


class _ListHelper:
    """Helper class for List"""


__all__ = ["List"]
