# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Update(AAZCommand):
    """Update sharing profile of a gallery.
    """

    _aaz_info = {
        "version": "2023-07-03",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/galleries/{}/share", "2023-07-03"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.gallery_name = AAZStrArg(
            options=["-r", "--gallery-name"],
            help="The name of the Shared Image Gallery.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "SharingUpdate"

        _args_schema = cls._args_schema
        _args_schema.groups = AAZListArg(
            options=["--groups"],
            arg_group="SharingUpdate",
            help="A list of sharing profile groups.",
        )
        _args_schema.operation_type = AAZStrArg(
            options=["--operation-type"],
            arg_group="SharingUpdate",
            help="Specify the operation type of gallery sharing update. Possible values are: Add, Remove, Reset, EnableCommunity.",
            required=True,
            enum={"Add": "Add", "EnableCommunity": "EnableCommunity", "Remove": "Remove", "Reset": "Reset"},
        )

        groups = cls._args_schema.groups
        groups.Element = AAZObjectArg()

        _element = cls._args_schema.groups.Element
        _element.ids = AAZListArg(
            options=["ids"],
            help="A list of subscription/tenant ids the gallery is aimed to be shared to.",
        )
        _element.type = AAZStrArg(
            options=["type"],
            help="This property allows you to specify the type of sharing group. Possible values are: **Subscriptions,** **AADTenants.**",
            enum={"AADTenants": "AADTenants", "Subscriptions": "Subscriptions"},
        )

        ids = cls._args_schema.groups.Element.ids
        ids.Element = AAZStrArg()
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.GallerySharingProfileUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class GallerySharingProfileUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/share",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "galleryName", self.ctx.args.gallery_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-07-03",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("groups", AAZListType, ".groups")
            _builder.set_prop("operationType", AAZStrType, ".operation_type", typ_kwargs={"flags": {"required": True}})

            groups = _builder.get(".groups")
            if groups is not None:
                groups.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".groups[]")
            if _elements is not None:
                _elements.set_prop("ids", AAZListType, ".ids")
                _elements.set_prop("type", AAZStrType, ".type")

            ids = _builder.get(".groups[].ids")
            if ids is not None:
                ids.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_sharing_update_read(cls._schema_on_200)

            return cls._schema_on_200


class _UpdateHelper:
    """Helper class for Update"""

    _schema_sharing_update_read = None

    @classmethod
    def _build_schema_sharing_update_read(cls, _schema):
        if cls._schema_sharing_update_read is not None:
            _schema.groups = cls._schema_sharing_update_read.groups
            _schema.operation_type = cls._schema_sharing_update_read.operation_type
            return

        cls._schema_sharing_update_read = _schema_sharing_update_read = AAZObjectType()

        sharing_update_read = _schema_sharing_update_read
        sharing_update_read.groups = AAZListType()
        sharing_update_read.operation_type = AAZStrType(
            serialized_name="operationType",
            flags={"required": True},
        )

        groups = _schema_sharing_update_read.groups
        groups.Element = AAZObjectType()

        _element = _schema_sharing_update_read.groups.Element
        _element.ids = AAZListType()
        _element.type = AAZStrType()

        ids = _schema_sharing_update_read.groups.Element.ids
        ids.Element = AAZStrType()

        _schema.groups = cls._schema_sharing_update_read.groups
        _schema.operation_type = cls._schema_sharing_update_read.operation_type


__all__ = ["Update"]
